/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import java.io.Serializable;
import java.util.function.DoubleFunction;
import java.util.function.DoubleSupplier;
import thunderheadeng.util.theUtil;

public class SpeedModifier
implements Serializable,
Comparable<SpeedModifier> {
    static final long serialVersionUID = 1L;
    public static final double CUTOFF_FACTOR = 0.01;
    public static final double CUTOFF_LIMIT = 0.011899999999999999;
    public static final SpeedModifier IDENTITY = new SpeedModifier(Type.FACTOR, 1.0);
    public final Type type;
    public final double value;
    private final double d_distFactor;

    public SpeedModifier(Type type, double value) {
        this.type = type;
        this.value = value;
        DoubleSupplier calcDistFactorHack = () -> {
            switch (type.ordinal()) {
                case 1: {
                    return 1.0 / Math.max(value, 0.01);
                }
                case 0: {
                    return 1.0;
                }
                case 2: {
                    return 1.19 / Math.min(1.19, Math.max(value, 0.011899999999999999));
                }
            }
            assert (false);
            return 1.0;
        };
        this.d_distFactor = calcDistFactorHack.getAsDouble();
    }

    public int hashCode() {
        return 0x523F33FA ^ this.type.hashCode() + theUtil.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SpeedModifier && ((SpeedModifier)obj).type == this.type && ((SpeedModifier)obj).value == this.value;
    }

    public double getAbsoluteSpeed(double occSpeed, boolean walkOnMovingTerrain) {
        return this.getRelativeSpeed(occSpeed, walkOnMovingTerrain) + this.getTerrainSpeed();
    }

    public double getRelativeSpeed(double occSpeed, boolean walkOnMovingTerrain) {
        switch (this.type.ordinal()) {
            case 0: {
                return walkOnMovingTerrain || this.value == 0.0 ? occSpeed : 0.0;
            }
            case 1: {
                return this.value * occSpeed;
            }
            case 2: {
                return Math.min(occSpeed, this.value);
            }
        }
        assert (false);
        return occSpeed;
    }

    public double getSpeedFactor(boolean walkOnMovingTerrain) {
        switch (this.type.ordinal()) {
            case 0: {
                return walkOnMovingTerrain || this.value == 0.0 ? 1.0 : 0.0;
            }
            case 1: {
                return this.value;
            }
            case 2: {
                return 1.0;
            }
        }
        assert (false);
        return 1.0;
    }

    public double getMaxSpeed() {
        switch (this.type.ordinal()) {
            case 0: 
            case 1: {
                return Double.POSITIVE_INFINITY;
            }
            case 2: {
                return this.value;
            }
        }
        assert (false);
        return Double.POSITIVE_INFINITY;
    }

    public double getTerrainSpeed() {
        switch (this.type.ordinal()) {
            case 0: {
                return this.value;
            }
            case 1: 
            case 2: {
                return 0.0;
            }
        }
        assert (false);
        return 0.0;
    }

    public boolean allowsMovement(boolean walkOnMovingTerrain) {
        return !this.isBlocking();
    }

    public boolean isBlocking() {
        switch (this.type.ordinal()) {
            case 0: {
                return false;
            }
            case 1: {
                return this.value <= 0.01;
            }
            case 2: {
                return this.value <= 0.011899999999999999;
            }
        }
        assert (false);
        return false;
    }

    public boolean isImpeding() {
        return this.isImpeding(Double.POSITIVE_INFINITY);
    }

    public boolean isImpeding(double maxVel) {
        switch (this.type.ordinal()) {
            case 0: {
                return false;
            }
            case 1: {
                return this.value < 1.0;
            }
            case 2: {
                return this.value < maxVel;
            }
        }
        assert (false);
        return false;
    }

    private double getMinVal() {
        switch (this.type.ordinal()) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return 0.01;
            }
            case 2: {
                return 0.011899999999999999;
            }
        }
        assert (false);
        return 0.0;
    }

    public SpeedModifier clampToCutoff() {
        double minVal = this.getMinVal();
        return this.value < minVal ? new SpeedModifier(this.type, minVal) : this;
    }

    @Override
    public int compareTo(SpeedModifier o) {
        int result = this.type.compareTo(o.type);
        if (result != 0) {
            return result;
        }
        switch (this.type.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return Double.compare(this.value, o.value);
            }
        }
        assert (false);
        return -1;
    }

    public double getDistanceFactorHACK() {
        return this.d_distFactor;
    }

    public String toString() {
        return this.type.format.apply(this.value);
    }

    public static enum Type {
        CONSTANT(false, value -> String.format("Constant=%g m/s", value)),
        FACTOR(true, value -> String.format("Factor=%g", value)),
        LIMIT(true, value -> String.format("Limit=%g m/s", value));

        public final boolean isLimiting;
        public final DoubleFunction<String> format;

        private Type(boolean isLimiting, DoubleFunction<String> format) {
            this.isLimiting = isLimiting;
            this.format = format;
        }
    }
}

