/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.Occupant;
import inferno.data2.StepDir;
import inferno.data2.Tri;
import inferno.data2.value.IFunction1d;
import inferno.sim.KnownFuncs;
import java.io.Serializable;
import java.util.Objects;
import javax.vecmath.Vector3d;
import thunderheadeng.util.theUtil;

public class SlopeSpeed
implements Serializable {
    static final long serialVersionUID = 1L;
    public final IFunction1d upSpeed;
    public final IFunction1d upFundamental;
    public final IFunction1d downSpeed;
    public final IFunction1d downFundamental;

    public SlopeSpeed(IFunction1d upSpeed, IFunction1d upFundamental, IFunction1d downSpeed, IFunction1d downFundamental) {
        this.upFundamental = upFundamental;
        this.upSpeed = upSpeed;
        this.downFundamental = downFundamental;
        this.downSpeed = downSpeed;
    }

    public int hashCode() {
        return 0xF1238FA ^ Objects.hash(this.upSpeed, this.upFundamental, this.downSpeed, this.downFundamental);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SlopeSpeed && ((SlopeSpeed)obj).upSpeed.equals(this.upSpeed) && ((SlopeSpeed)obj).downSpeed.equals(this.downSpeed) && ((SlopeSpeed)obj).upFundamental.equals(this.upFundamental) && ((SlopeSpeed)obj).downFundamental.equals(this.downFundamental);
    }

    public SlopeSpeed modify(boolean speed, boolean up, IFunction1d func) {
        if (speed && up) {
            return new SlopeSpeed(func, this.upFundamental, this.downSpeed, this.downFundamental);
        }
        if (speed && !up) {
            return new SlopeSpeed(this.upSpeed, this.upFundamental, func, this.downFundamental);
        }
        if (!speed && up) {
            return new SlopeSpeed(this.upSpeed, func, this.downSpeed, this.downFundamental);
        }
        if (!speed && !up) {
            return new SlopeSpeed(this.upSpeed, this.upFundamental, this.downSpeed, func);
        }
        assert (false);
        return null;
    }

    public boolean isUniform() {
        return this.upSpeed == this.downSpeed && this.upFundamental == this.downFundamental;
    }

    public StepDir getStepDir(Occupant occ, Tri tri, Vector3d travelDir) {
        if (this.isUniform()) {
            return StepDir.UP;
        }
        travelDir = SlopeSpeed.getTravelDir(occ, travelDir);
        Vector3d triNormal = tri.normal;
        double dot = travelDir.x * triNormal.x + travelDir.y * triNormal.y;
        return theUtil.le0(dot, 1.0E-6) ? StepDir.UP : StepDir.DOWN;
    }

    public double getSlopeSpeedFactor(Occupant occ, Tri tri, StepDir sdir) {
        double slope = KnownFuncs.getTerrainSlope(tri);
        return this.getSlopeSpeedFactor(occ, slope, sdir);
    }

    public double getSlopeSpeedFactor(Occupant occ, double slope, StepDir sdir) {
        IFunction1d frac = sdir == StepDir.UP ? this.upSpeed : this.downSpeed;
        return KnownFuncs.getSlopedSpeedFactor(frac, slope);
    }

    public double getFundamentalSpeedFactor(Occupant occ, StepDir sdir, double density) {
        IFunction1d frac = sdir == StepDir.UP ? this.upFundamental : this.downFundamental;
        return frac.get(density);
    }

    private static Vector3d getTravelDir(Occupant occ, Vector3d dir) {
        if (dir != null) {
            return dir;
        }
        if (occ.vel.lengthSquared() > 0.0) {
            return occ.vel;
        }
        return occ.orient;
    }
}

