/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.Tag;
import java.util.EnumSet;
import java.util.function.Supplier;

public enum PredefTag {
    FINISHED("finished", false),
    EXITED("exited", true),
    REPORT_REFUGE_REACHED("report_refuge_reached", true),
    REPORT_WAITING_UNTIL_END("report_wait_until_end", true),
    REMOVED("removed", true);

    public final String name;
    public final Supplier<Tag> newTag;
    public final boolean isCompleted;

    private PredefTag(String name, boolean isCompleted) {
        this(name, name, isCompleted);
    }

    private PredefTag(String name, String desc, boolean isCompleted) {
        this(name, () -> new Tag(name, desc, EnumSet.of(Tag.Options.PREDEFINED)), isCompleted);
    }

    private PredefTag(String name, Supplier<Tag> newTag, boolean isCompleted) {
        this.name = name;
        this.newTag = newTag;
        this.isCompleted = isCompleted;
    }

    public boolean is(Tag tag) {
        return tag.isPredefined() && tag.name.equals(this.name);
    }
}

