/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ABoundedHistory;
import inferno.sim.OccAgent;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.util.theUtil;

public class PathSpeedHistory
extends ABoundedHistory<Double> {
    static final long serialVersionUID = 1L;

    public PathSpeedHistory(double maxTimeHint, double maxFreq) {
        super(maxTimeHint, maxFreq);
    }

    public PathSpeedHistory(int size, double maxFreq) {
        super(size, maxFreq);
    }

    public void record(double t, OccAgent agent, Vector3d currVel) {
        double lenSq;
        Vector3d seekDir = GeomConstants.VEC3D_ZERO;
        IParametric3D seekCurve = agent.getSeekCurve();
        if (seekCurve != null && theUtil.gt0(lenSq = (seekDir = seekCurve.getTangent(0.0)).dot(seekDir), 1.0E-6)) {
            seekDir.scale(1.0 / Math.sqrt(lenSq));
        }
        this.record(t, seekDir, currVel);
    }

    public void record(double t, Vector3d seekDir, Vector3d currVel) {
        double speed = currVel.dot(seekDir);
        this.record(t, speed);
    }

    @Override
    protected boolean canAddEntry(ABoundedHistory.Entry<Double> currEntry, double t, Double newVal) {
        return !theUtil.eq((Double)currEntry.val, newVal, 0.001);
    }

    @Override
    protected Double combine(Double v1, Double v2) {
        return v2;
    }

    public double getAverage(double tCurr, double tLen) {
        if (this.isEmpty()) {
            return 0.0;
        }
        double tBegin = tCurr - tLen;
        int beginEntryIx = this.findEntry(tBegin, true);
        if (beginEntryIx == -1) {
            beginEntryIx = 0;
        }
        int endEntryIx = this.getCount();
        tBegin = Math.max(tBegin, this.getEntry((int)beginEntryIx).t);
        tLen = tCurr - tBegin;
        double dist = 0.0;
        for (int m = beginEntryIx; m < endEntryIx; ++m) {
            double t2;
            ABoundedHistory.Entry entry1 = this.getEntry(m);
            double t1 = Math.max(entry1.t, tBegin);
            if (m < endEntryIx - 1) {
                ABoundedHistory.Entry entry2 = this.getEntry(m + 1);
                t2 = entry2.t;
            } else {
                t2 = tCurr;
            }
            assert (t2 >= t1);
            double dt = t2 - t1;
            dist += (Double)entry1.val * dt;
        }
        return dist / tLen;
    }
}

