/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.OccTarget;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.mtproc.MTProcessor;

public class OccTargets
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<OccTarget> d_targets = new ArrayList<OccTarget>();
    private final Set<OccTarget> d_toResolve = new LinkedIdentityHashSet<OccTarget>();
    private final Set<OccTarget> d_canceled = new LinkedIdentityHashSet<OccTarget>();
    private final Map<Integer, List<OccTarget>> d_reservedTargets = new HashMap<Integer, List<OccTarget>>();
    private final Map<ReservationType, Map<Integer, Set<OccTarget>>> d_requestedTargets = new EnumMap<ReservationType, Map<Integer, Set<OccTarget>>>(ReservationType.class);
    private transient MTProcessor d_processor;

    public void add(OccTarget target) {
        this.d_targets.add(target);
    }

    public void initTargets() {
        Collections.sort(this.d_targets, (t1, t2) -> Double.compare(t1.priority, t2.priority));
    }

    public List<OccTarget> getAll() {
        return Collections.unmodifiableList(this.d_targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestReservation(KB kb, OccAgent agent, OccTarget target, double dist, ReservationType type) {
        if (target.requestReservation(kb, agent, dist)) {
            Set<OccTarget> set = this.d_toResolve;
            synchronized (set) {
                boolean reservedWithDiffType = this.d_requestedTargets.entrySet().stream().filter(entry -> entry.getKey() != type && ((Map)entry.getValue()).getOrDefault(agent.getId(), Collections.emptySet()).contains(target)).findAny().isPresent();
                if (!reservedWithDiffType) {
                    this.d_toResolve.add(target);
                    this.d_requestedTargets.computeIfAbsent(type, t -> new HashMap()).computeIfAbsent(agent.getId(), id -> new LinkedIdentityHashSet()).add(target);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelReservation(KB kb, OccAgent agent, OccTarget target) {
        if (target.cancelReservation(kb, agent)) {
            Set<OccTarget> set = this.d_toResolve;
            synchronized (set) {
                for (Map<Integer, Set<OccTarget>> m : this.d_requestedTargets.values()) {
                    Set<OccTarget> reqLocs = m.get(agent.getId());
                    if (reqLocs == null) continue;
                    reqLocs.remove(target);
                    if (!reqLocs.isEmpty()) continue;
                    m.remove(agent.getId());
                }
                this.d_toResolve.add(target);
                this.d_canceled.add(target);
            }
            return true;
        }
        return false;
    }

    public void resolveReservations(KB kb) throws ExecutionException {
        if (this.d_toResolve.isEmpty()) {
            return;
        }
        if (this.d_processor == null) {
            this.d_processor = new MTProcessor(Engine.getNumProcThreads(), MTProcessor.Schedule.GUIDED, kb.getThreadPool());
        }
        for (OccTarget occTarget : this.d_canceled) {
            List locs;
            int rocc = occTarget.getReservedOcc();
            if (rocc == -1 || (locs = this.d_reservedTargets.getOrDefault(rocc, Collections.emptyList())).isEmpty()) continue;
            locs.remove(occTarget);
        }
        for (Map.Entry entry : this.d_requestedTargets.entrySet()) {
            if (!((ReservationType)((Object)entry.getKey())).keepOne) continue;
            Map occReqMap = (Map)entry.getValue();
            IdentityHashSet remainingTargets = new IdentityHashSet();
            occReqMap.values().stream().filter(s -> s.size() > 1).forEach(remainingTargets::addAll);
            if (remainingTargets.isEmpty()) continue;
            LinkedIdentityHashMap<OccTarget, List> targetOccs = new LinkedIdentityHashMap<OccTarget, List>();
            while (!occReqMap.isEmpty() && !remainingTargets.isEmpty()) {
                targetOccs.clear();
                Iterator it = occReqMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry occ = it.next();
                    Integer occId = (Integer)occ.getKey();
                    Set targets = (Set)occReqMap.get(occId);
                    OccTarget target = null;
                    Iterator targIt = targets.iterator();
                    while (targIt.hasNext()) {
                        OccTarget t2 = (OccTarget)targIt.next();
                        targIt.remove();
                        if (!remainingTargets.contains(t2)) continue;
                        target = t2;
                        break;
                    }
                    if (target == null) {
                        it.remove();
                        continue;
                    }
                    targetOccs.computeIfAbsent(target, t -> new ArrayList()).add(occId);
                }
                for (Map.Entry targetEntry : targetOccs.entrySet()) {
                    OccTarget target = (OccTarget)targetEntry.getKey();
                    List occs = (List)targetEntry.getValue();
                    remainingTargets.remove(target);
                    Integer winner = (Integer)occs.stream().min((occ1, occ2) -> target.compare((int)occ1, (int)occ2)).get();
                    target.setWinner(kb, winner);
                    occReqMap.remove(winner);
                }
            }
        }
        this.d_processor.process(new ArrayList<OccTarget>(this.d_toResolve), (obj, tix, ix) -> obj.resolveReservations(kb));
        this.d_requestedTargets.clear();
        ArrayList<List> locsToSort = new ArrayList<List>();
        for (OccTarget target : this.d_toResolve) {
            List locs;
            int rocc = target.getReservedOcc();
            if (rocc == -1 || (locs = this.d_reservedTargets.computeIfAbsent(rocc, id -> new ArrayList(2))).contains(target)) continue;
            locs.add(target);
            if (locs.size() <= 1) continue;
            locsToSort.add(locs);
        }
        for (List locs : locsToSort) {
            Collections.sort(locs, (l1, l2) -> Integer.compare(l1.id, l2.id));
        }
        this.d_toResolve.clear();
        this.d_canceled.clear();
    }

    public List<OccTarget> getReservations(OccAgent agent) {
        return Collections.unmodifiableList(this.d_reservedTargets.getOrDefault(agent.getId(), Collections.emptyList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelReservations(KB kb, OccAgent agent, boolean includeAccepted, boolean includeRequests) {
        List<OccTarget> targets;
        boolean result = false;
        if (includeAccepted && !(targets = this.getReservations(agent)).isEmpty()) {
            result = true;
            for (OccTarget occTarget : targets) {
                this.cancelReservation(kb, agent, occTarget);
            }
        }
        if (includeRequests) {
            Set<OccTarget> set = this.d_toResolve;
            synchronized (set) {
                for (Map map : this.d_requestedTargets.values()) {
                    Set requests = (Set)map.get(agent.getId());
                    if (requests == null) continue;
                    result = true;
                    for (OccTarget request : new ArrayList(requests)) {
                        this.cancelReservation(kb, agent, request);
                    }
                }
            }
        }
        return result;
    }

    public static enum ReservationType {
        SINGLE(true),
        ALL(false);

        public final boolean keepOne;

        private ReservationType(boolean keepOne) {
            this.keepOne = keepOne;
        }
    }
}

