/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.TriPoint;
import inferno.data2.seekarea.PointSeekArea;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.vecmath.Vector3d;
import thunderheadeng.util.Pair;

public class OccTarget
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int id;
    public final String name;
    public final TriPoint location;
    public final Vector3d orient;
    public final double priority;
    private Map<Integer, Double> d_reservations = new LinkedHashMap<Integer, Double>();
    private int d_chosenOcc = -1;
    private int d_nReserveConflicts = 0;
    private double d_reserveTime;
    private boolean d_cancelReservation = false;

    public OccTarget(int id, String name, TriPoint loc, Vector3d orient, double priority) {
        this.id = id;
        this.name = name;
        this.location = loc;
        this.orient = orient;
        this.priority = priority;
    }

    public PointSeekArea asSeekArea() {
        return new PointSeekArea(this.location, 0.5, this.orient, 0);
    }

    public boolean isOpen() {
        return this.d_chosenOcc == -1;
    }

    public boolean isReserved() {
        return this.d_chosenOcc != -1;
    }

    public boolean isReserved(OccAgent agent) {
        return this.d_chosenOcc == agent.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean requestReservation(KB kb, OccAgent agent, double dist) {
        if (!this.isOpen()) {
            return false;
        }
        Map<Integer, Double> map = this.d_reservations;
        synchronized (map) {
            this.d_reservations.put(agent.getId(), dist);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cancelReservation(KB kb, OccAgent agent) {
        if (agent.getId() == this.d_chosenOcc) {
            OccTarget occTarget = this;
            synchronized (occTarget) {
                this.d_cancelReservation = true;
            }
            return true;
        }
        if (this.isOpen()) {
            Map<Integer, Double> map = this.d_reservations;
            synchronized (map) {
                return this.d_reservations.remove(agent.getId()) != null;
            }
        }
        return false;
    }

    protected boolean isCanceled() {
        return this.d_cancelReservation;
    }

    protected void resolveReservations(KB kb) {
        this.fulfillCancellation(kb);
        if (this.d_reservations.isEmpty()) {
            return;
        }
        Pair bestEntry = this.d_reservations.entrySet().stream().map(e -> new Pair<Integer, Double>((Integer)e.getKey(), (Double)e.getValue())).min(OccTarget::compareEntries).get();
        this.setWinner(kb, (Integer)bestEntry.v1);
    }

    private void fulfillCancellation(KB kb) {
        if (this.d_cancelReservation) {
            this.d_cancelReservation = false;
            this.d_chosenOcc = -1;
            this.d_reserveTime = kb.getCurrentSimTime();
            this.d_nReserveConflicts = 0;
        }
    }

    protected boolean setWinner(KB kb, Integer choice) {
        this.fulfillCancellation(kb);
        Double dist = this.d_reservations.get(choice);
        assert (dist != null);
        if (dist == null) {
            return false;
        }
        this.d_chosenOcc = choice;
        if (!this.d_reservations.isEmpty()) {
            this.d_nReserveConflicts = this.d_reservations.size() - 1;
            this.d_reservations = new LinkedHashMap<Integer, Double>();
            this.d_reserveTime = kb.getCurrentSimTime();
        } else {
            this.d_nReserveConflicts = 0;
        }
        return true;
    }

    private static int compareEntries(Pair<Integer, Double> e1, Pair<Integer, Double> e2) {
        return OccTarget.compareEntries((Integer)e1.v1, (Double)e1.v2, (Integer)e2.v1, (Double)e2.v2);
    }

    private static int compareEntries(int occ1, double dist1, int occ2, double dist2) {
        int comp = Double.compare(dist1, dist2);
        if (comp != 0) {
            return comp;
        }
        return Integer.compare(occ1, occ2);
    }

    protected int compare(int occ1, int occ2) {
        Double dist1 = this.d_reservations.get(occ1);
        Double dist2 = this.d_reservations.get(occ2);
        assert (dist1 != null && dist2 != null);
        if (dist1 == null && dist2 == null) {
            return Integer.compare(occ1, occ2);
        }
        if (dist1 == null) {
            return 1;
        }
        if (dist2 == null) {
            return -1;
        }
        return OccTarget.compareEntries(occ1, dist1, occ2, dist2);
    }

    public int getReservedOcc() {
        return this.d_chosenOcc;
    }

    public int getNumReserveConflicts() {
        return this.d_nReserveConflicts;
    }

    public double getLastResolveTime() {
        return this.d_reserveTime;
    }

    public String toString() {
        return this.name;
    }
}

