/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.Occupant;
import inferno.geom.Inter;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class OccLocator
extends RTree<OccAgent>
implements Serializable {
    private static final long serialVersionUID = -2774551795712987515L;
    private static final double NUM_PREDICT_TIMESTEPS = 20.0;
    private final double d_crossoverFactor = 0.63;
    private double d_lastUpdateTime = -1.7976931348623157E308;

    public void insert(OccAgent occ, double dt) {
        this.insert(OccLocator.getFuzzyBounds(occ, dt), occ);
    }

    public void update(OccAgent occ, double dt) {
        this.remove(occ);
        this.insert(occ, dt);
    }

    public void update(Collection<OccAgent> agents, double t, double dt) {
        if (t == this.d_lastUpdateTime) {
            return;
        }
        this.d_lastUpdateTime = t;
        int crossover = (int)((double)agents.size() * 0.63);
        Collection<OccAgent> updateAgents = this.getUpdateAgents(agents, dt, crossover);
        if (updateAgents.size() > crossover) {
            this.clear();
            for (OccAgent occ : agents) {
                this.insert(occ, dt);
            }
        } else {
            for (OccAgent occ : updateAgents) {
                this.remove(occ);
                this.insert(occ, dt);
            }
        }
    }

    private Collection<OccAgent> getUpdateAgents(Collection<OccAgent> agents, double dt, int maxCount) {
        if (this.isEmpty()) {
            return agents;
        }
        ArrayList<OccAgent> updateAgents = new ArrayList<OccAgent>(agents.size());
        for (OccAgent occ : agents) {
            if (!this.needsUpdate(occ)) continue;
            updateAgents.add(occ);
            if (updateAgents.size() <= maxCount) continue;
            break;
        }
        return updateAgents;
    }

    private boolean needsUpdate(OccAgent agent) {
        AABox oldBounds = (AABox)this.getBounds(agent);
        if (oldBounds == null) {
            return true;
        }
        AABox trueBounds = agent.getOcc().getBoundingBox(false);
        return oldBounds.test(trueBounds) != Containment.INSIDE;
    }

    public static AABox getFuzzyBounds(OccAgent agent, double dt) {
        AABox bounds = agent.getOcc().getBoundingBox(false);
        double predictDist = agent.getVel().length() * dt * 20.0;
        bounds.set(bounds.getMinX() - predictDist, bounds.getMinY() - predictDist, bounds.getMinZ() - predictDist, bounds.getMaxX() + predictDist, bounds.getMaxY() + predictDist, bounds.getMaxZ() + predictDist);
        return bounds;
    }

    public boolean occOverlapsOthers(Occupant occ, Point3d loc, double epsilon) {
        boolean[] result = new boolean[]{false};
        try {
            this.getOverlappingOccs(occ, loc, occ2 -> {
                result[0] = true;
                throw new CancellationException();
            });
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return result[0];
    }

    public void getOverlappingOccs(Occupant occ, Point3d loc, Consumer<? super OccAgent> overlaps) {
        AABox oabb = occ.getBoundingBox(loc, true);
        this.find(oabb, (IResult<? super OccAgent>)((IResult<OccAgent>)(otherAgent, ctmt) -> {
            if (otherAgent.getOcc() == occ) {
                return;
            }
            if (Inter.shapesOverlap(occ.bodyShape, otherAgent.getOcc().bodyShape)) {
                overlaps.accept((OccAgent)otherAgent);
            }
        }));
    }

    @Override
    public void find(final ITest<AABox> test, final IResult<? super OccAgent> result) {
        IResult<OccAgent> tightResult = new IResult<OccAgent>(){

            @Override
            public void mark(OccAgent obj, Containment ctmt) {
                if (ctmt == Containment.INSIDE) {
                    result.mark(obj, ctmt);
                } else {
                    ctmt = test.test(obj.getOcc().getBoundingBox(true));
                    if (ctmt.positive) {
                        result.mark(obj, ctmt);
                    }
                }
            }
        };
        super.find(test, tightResult);
    }

    public static ITest<AABox> testCyl(OccAgent me, double r, Plane3d ... additionalConstraints) {
        double rdiff = r - me.getCollisionShape().getEnclosingRadius();
        double minz = me.getPos().z - rdiff;
        double maxz = me.getPos().z + me.getOcc().bodyShape.getHeight() + rdiff;
        return OccLocator.testCyl(me.getPos(), r * r, minz, maxz, additionalConstraints);
    }

    public static ITest<AABox> testCyl(Point3d loc, double rSq, double minz, double maxz, Plane3d ... additionalConstraints) {
        return bb -> OccLocator.testNearOcc(bb, loc, rSq, minz, maxz, additionalConstraints);
    }

    private static Containment testNearOcc(AABox bb, Point3d aloc, double rsq, double minz, double maxz, Plane3d ... additionalConstraints) {
        Containment chTest;
        Containment cylTest;
        Point3d min = bb.getMin();
        Point3d max = bb.getMax();
        int totalIn = 0;
        Containment zTest = OccLocator.planesContainAABB(minz, maxz, min.z, max.z);
        if (zTest == Containment.OUTSIDE) {
            return Containment.OUTSIDE;
        }
        if (zTest == Containment.INSIDE) {
            ++totalIn;
        }
        if ((cylTest = OccLocator.infCylContainsAABB(min.x, min.y, max.x, max.y, aloc.x, aloc.y, rsq)) == Containment.OUTSIDE) {
            return Containment.OUTSIDE;
        }
        if (cylTest == Containment.INSIDE) {
            ++totalIn;
        }
        if ((chTest = OccLocator.testConvexHull(min, max, additionalConstraints)) == Containment.OUTSIDE) {
            return chTest;
        }
        if (chTest == Containment.INSIDE) {
            ++totalIn;
        }
        return totalIn == 3 ? Containment.INSIDE : Containment.INTERSECTS;
    }

    private static Containment testConvexHull(Point3d min, Point3d max, Plane3d ... planes) {
        if (planes.length == 0) {
            return Containment.INSIDE;
        }
        Point3d tempp = new Point3d();
        int inCount = 0;
        for (int m = 0; m < planes.length; ++m) {
            Containment ctmt = OccLocator.testPlane(min, max, planes[m], tempp);
            if (ctmt == Containment.OUTSIDE) {
                return ctmt;
            }
            if (ctmt != Containment.INSIDE) continue;
            ++inCount;
        }
        return inCount == planes.length ? Containment.INSIDE : Containment.INTERSECTS;
    }

    private static Containment testPlane(Point3d min, Point3d max, Plane3d plane, Point3d tempp) {
        int inCount = 0;
        for (int m = 0; m < 8; ++m) {
            OccLocator.getPoint(min, max, m, tempp);
            if (plane.dot(tempp) <= 0.0) {
                if (inCount != m) {
                    return Containment.INTERSECTS;
                }
                ++inCount;
                continue;
            }
            if (inCount <= 0) continue;
            return Containment.INTERSECTS;
        }
        if (inCount == 0) {
            return Containment.OUTSIDE;
        }
        assert (inCount == 8);
        return Containment.INSIDE;
    }

    private static void getPoint(Point3d min, Point3d max, int ix, Point3d result) {
        switch (ix) {
            case 0: {
                result.set(min.x, min.y, min.z);
                break;
            }
            case 1: {
                result.set(min.x, min.y, max.z);
                break;
            }
            case 2: {
                result.set(min.x, max.y, min.z);
                break;
            }
            case 3: {
                result.set(min.x, max.y, max.z);
                break;
            }
            case 4: {
                result.set(max.x, min.y, min.z);
                break;
            }
            case 5: {
                result.set(max.x, min.y, max.z);
                break;
            }
            case 6: {
                result.set(max.x, max.y, min.z);
                break;
            }
            case 7: {
                result.set(max.x, max.y, max.z);
            }
        }
    }

    private static Containment planesContainAABB(double pminz, double pmaxz, double aabbMinz, double aabbMaxz) {
        double tol = 1.0E-9;
        if (theUtil.le(pminz, aabbMaxz, tol) && theUtil.le(aabbMinz, pmaxz, tol)) {
            if (theUtil.le(pminz, aabbMinz, tol) && theUtil.le(aabbMaxz, pmaxz, tol)) {
                return Containment.INSIDE;
            }
            return Containment.INTERSECTS;
        }
        return Containment.OUTSIDE;
    }

    private static Containment infCylContainsAABB(double aabbMinx, double aabbMiny, double aabbMaxx, double aabbMaxy, double cylCenterx, double cylCentery, double cylRadiusSq) {
        boolean maxInside;
        double dxm = cylCenterx - aabbMinx;
        double dym = cylCentery - aabbMiny;
        double dxM = cylCenterx - aabbMaxx;
        double dyM = cylCentery - aabbMaxy;
        double dxmSq = dxm * dxm;
        double dymSq = dym * dym;
        double dxMSq = dxM * dxM;
        double dyMSq = dyM * dyM;
        boolean minInside = dxmSq + dymSq <= cylRadiusSq;
        boolean bl = maxInside = dxMSq + dyMSq <= cylRadiusSq;
        if (minInside && maxInside) {
            return Containment.INSIDE;
        }
        if (minInside || maxInside) {
            return Containment.INTERSECTS;
        }
        double d = 0.0;
        if (cylCenterx < aabbMinx) {
            d += dxmSq;
        } else if (cylCenterx > aabbMaxx) {
            d += dxMSq;
        }
        if (cylCentery < aabbMiny) {
            d += dymSq;
        } else if (cylCentery > aabbMaxy) {
            d += dyMSq;
        }
        return theUtil.le(d, cylRadiusSq, 1.0E-12) ? Containment.INTERSECTS : Containment.OUTSIDE;
    }

    public static Predicate<OccAgent> exclude(OccAgent toExclude, Predicate<OccAgent> filter) {
        return Predicates.and(Filters.reject(toExclude), filter);
    }
}

