/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ANode;
import inferno.data2.Tri;
import inferno.geom.VorDensityField;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.LinkedIdentityHashSet;

public class MeasurementRegion
implements Serializable {
    static final long serialVersionUID = 1L;
    public final String name;
    public final AABox area;
    public Data data = new Data();

    public MeasurementRegion(String name, AABox area) {
        this.name = name;
        this.area = area;
    }

    public void update(KB kb) {
        Data d;
        double[] vals = new double[]{0.0, 0.0};
        AABox r = this.area;
        ToDoubleFunction<OccAgent> instSpeed = a -> a.getVel().length();
        ToDoubleFunction<OccAgent> dirSpeed = a -> {
            Vector3d vel = a.getVel();
            IParametric3D scurve = a.getSeekCurve();
            a.getSeekDir();
            if (scurve == null) {
                return vel.length();
            }
            Vector3d seekDir = scurve.getTangent(0.0);
            Util3D.safeNormalize(seekDir, 0.0);
            return Math.max(0.0, vel.dot(seekDir));
        };
        double vd = this.getVoronoiDensity(kb, r, vals, instSpeed, dirSpeed);
        ArrayDeque agentsCenterInside = new ArrayDeque();
        kb.findOccs((ITest<AABox>)r, true, (occ, ctmt) -> {
            if (r.contains(occ.getPos())) {
                agentsCenterInside.add(occ);
            }
        });
        int count = agentsCenterInside.size();
        this.data = d = new Data(kb.getCurrentSimTime(), count, vd, vals[0], vals[1]);
    }

    private double getClassicalDensity(KB kb, final AABox bounds) {
        final ArrayList occs = new ArrayList();
        kb.findOccs((ITest<AABox>)bounds, true, new IResult<OccAgent>(){

            @Override
            public void mark(OccAgent oa, Containment ctmt) {
                if (bounds.contains(oa.getPos())) {
                    occs.add(oa);
                }
            }
        });
        double areaOfBox = bounds.getWidth() * bounds.getDepth();
        double density = (double)occs.size() / areaOfBox;
        return density;
    }

    public void getNodes(KB kb, Consumer<? super ANode> nodes) {
        AABox bounds = this.area;
        List<Tri> tris = kb.getMesh().findTris(bounds);
        if (tris.isEmpty()) {
            return;
        }
        for (Tri tri : tris) {
            nodes.accept(tri.node);
        }
    }

    private double getVoronoiDensity(KB kb, AABox bounds, double[] vals, ToDoubleFunction<OccAgent> ... valFuncs) {
        assert (vals.length == valFuncs.length);
        Arrays.fill(vals, 0.0);
        List<Tri> tris = kb.getMesh().findTris(bounds);
        if (tris.isEmpty()) {
            return 0.0;
        }
        LinkedIdentityHashSet nodes = new LinkedIdentityHashSet();
        for (Tri tri : tris) {
            if (!(tri.node.getDensityField() instanceof VorDensityField)) continue;
            nodes.add(tri.node);
        }
        if (nodes.isEmpty()) {
            return 0.0;
        }
        double boundsArea = bounds.getWidth() * bounds.getDepth();
        double density = 0.0;
        Point3d[] boundsPts = new Point3d[]{new Point3d(bounds.getMinX(), bounds.getMinY(), 0.0), new Point3d(bounds.getMinX(), bounds.getMaxY(), 0.0), new Point3d(bounds.getMaxX(), bounds.getMaxY(), 0.0), new Point3d(bounds.getMaxX(), bounds.getMinY(), 0.0)};
        Plane3d boundsPlane = new Plane3d(0.0, 0.0, -1.0, 0.0);
        double root2 = Math.sqrt(2.0);
        AABox expandedBounds = new AABox(new Point3d(bounds.getMinX() - root2, bounds.getMinY() - root2, bounds.getMinZ()), new Point3d(bounds.getMaxX() + root2, bounds.getMaxY() + root2, bounds.getMaxZ()));
        AABox bounds2d = new AABox(bounds.getMinX(), bounds.getMinY(), 0.0, bounds.getMaxX(), bounds.getMaxY(), 0.0);
        for (ANode node : nodes) {
            VorDensityField densityField = (VorDensityField)node.getDensityField();
            for (Map.Entry<OccAgent, Face> entry : densityField.getOccAreas().entrySet()) {
                OccAgent agent = entry.getKey();
                Face f = entry.getValue();
                if (!expandedBounds.contains(agent.getPos()) || !bounds2d.intersects(f.getBounds())) continue;
                Model polyPolyInterArea = new Model();
                polyPolyInterArea.addPolygonFace(0, boundsPlane, boundsPts);
                polyPolyInterArea.addFace(f, 1);
                Predicate<Face> bothGroupsFilter = face -> face.partOfGroup(0) && face.partOfGroup(1);
                Collection<Face> inBounds = polyPolyInterArea.getFaces(bothGroupsFilter);
                double faceDensity = 1.0 / Math.min(100.0, f.getArea());
                for (Face fragment : inBounds) {
                    double fraction = fragment.getArea() / boundsArea;
                    density += fraction * faceDensity;
                    for (int m = 0; m < vals.length; ++m) {
                        int n = m;
                        vals[n] = vals[n] + fraction * valFuncs[m].applyAsDouble(agent);
                    }
                }
            }
        }
        return density;
    }

    public static class Data
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final double time;
        public final double count;
        public final double density;
        public final double velocity;
        public final double seekVelocity;

        public Data() {
            this(0.0, 0.0, 0.0, 0.0, 0.0);
        }

        public Data(double time, double count, double density, double velocity, double seekVelocity) {
            this.time = time;
            this.count = count;
            this.density = density;
            this.velocity = velocity;
            this.seekVelocity = seekVelocity;
        }
    }
}

