/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.Occupant;
import inferno.data2.Tag;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;

public interface IOccFilter
extends Predicate<Occupant> {
    public static final String ACCEPT_ALL_KEY = "accept_all";
    public static final String REJECT_ALL_KEY = "reject_all";

    public InputFileInfo getInputFileInfo();

    default public JSONObject toJson() {
        return this.getInputFileInfo().toJson.get(this);
    }

    public static enum InputFileInfo {
        BY_TAG("by_tag", obj -> {
            JSONObject jobj = obj.getInputFileInfo().newJsonObj();
            jobj.put("logic", obj.logic.name().toLowerCase());
            JSONArray jtags = new JSONArray();
            for (Tag tag : obj.tags) {
                jtags.add(tag.name);
            }
            jobj.put("tags", jtags);
            return jobj;
        }, (jobj, getTag) -> {
            ByTag.Logic logic = ByTag.Logic.valueOf(jobj.get("logic").toString().toUpperCase());
            JSONArray jtags = (JSONArray)jobj.get("tags");
            LinkedIdentityHashSet<Tag> tags = jtags.isEmpty() ? Collections.emptySet() : new LinkedIdentityHashSet<Tag>(jtags.size());
            for (Object jtag : jtags) {
                tags.add((Tag)getTag.apply(jtag.toString()));
            }
            return new ByTag(logic, tags);
        }),
        ACCEPT_ALL("accept_all", obj -> InputFileInfo.newJsonObj(IOccFilter.ACCEPT_ALL_KEY), (jobj, getTag) -> Predicates.alwaysTrue()),
        REJECT_ALL("reject_all", obj -> InputFileInfo.newJsonObj(IOccFilter.REJECT_ALL_KEY), (jobj, getTag) -> Predicates.alwaysFalse());

        public final String key;
        public final FromJson fromJson;
        public final ToJson toJson;

        private <T extends Predicate<Occupant>> InputFileInfo(String key, ToJson<T> toJson, FromJson<T> fromJson) {
            this.key = key;
            this.toJson = toJson;
            this.fromJson = fromJson;
        }

        private static JSONObject newJsonObj(String key) {
            JSONObject jobj = new JSONObject();
            jobj.put("type", key);
            return jobj;
        }

        private JSONObject newJsonObj() {
            return InputFileInfo.newJsonObj(this.key);
        }

        public static InputFileInfo findType(JSONObject jobj) throws IOException {
            String key = (String)jobj.get("type");
            Optional<InputFileInfo> info = Stream.of(InputFileInfo.values()).filter(i -> i.key.equalsIgnoreCase(key)).findFirst();
            if (info.isEmpty()) {
                throw new IOException(String.format("Unknown target type: %s", key));
            }
            return info.get();
        }

        public static Optional<InputFileInfo> get(Predicate<? super Occupant> test) {
            if (Predicates.alwaysTrue(test)) {
                return Optional.of(ACCEPT_ALL);
            }
            if (Predicates.alwaysFalse(test)) {
                return Optional.of(REJECT_ALL);
            }
            return test instanceof IOccFilter ? Optional.of(((IOccFilter)test).getInputFileInfo()) : Optional.empty();
        }
    }

    public static interface ToJson<T extends Predicate<Occupant>> {
        public JSONObject get(T var1);
    }

    public static interface FromJson<T extends Predicate<Occupant>> {
        public T get(JSONObject var1, Function<String, Tag> var2);
    }

    public static class ByTag
    implements IOccFilter,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final Logic logic;
        public final Set<Tag> tags;

        public ByTag(Logic logic, Set<Tag> tags) {
            this.logic = logic;
            this.tags = tags;
        }

        @Override
        public boolean test(Occupant t) {
            return this.logic.test.test(t, this.tags);
        }

        @Override
        public InputFileInfo getInputFileInfo() {
            return InputFileInfo.BY_TAG;
        }

        public String toString() {
            return "ByTag [logic=" + String.valueOf((Object)this.logic) + ", tags=[" + this.tags.stream().map(Tag::toString).collect(Collectors.joining(",")) + "]]";
        }

        public static enum Logic {
            ANY(Stream::anyMatch),
            ALL(Stream::allMatch),
            NONE(Stream::noneMatch);

            public final BiPredicate<Occupant, Set<Tag>> test = (occ, tags) -> test.test(tags.stream(), t -> t.isTagged((Occupant)occ));

            private Logic(BiPredicate<Stream<Tag>, Predicate<? super Tag>> test) {
            }
        }
    }
}

