/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.IAgentBodyShape;
import inferno.data2.TriPoint;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.theUtil;

public class CylinderShape
implements IAgentBodyShape {
    private static final long serialVersionUID = -1955554314623830289L;
    private static final double MIN_TURNAROUND_TIME = theUtil.getSystemDouble("CylinderShape.minTurnaroundTime", 1.0);
    private final int occId;
    private final double radius;
    private final double geometryRadius;
    private final double height;
    private Point3d center;
    private Vector3d dir;

    public CylinderShape(Point3d center, double radius, double geometryRadius, double height, Vector3d dir, int occId) {
        this.center = center;
        this.radius = radius;
        this.geometryRadius = geometryRadius;
        this.height = (float)height;
        this.dir = dir;
        this.occId = occId;
    }

    @Override
    public String getName() {
        return "Cylinder";
    }

    @Override
    public double getProjectedArea() {
        return Math.PI * this.radius * this.radius;
    }

    @Override
    public Point3d getCenter() {
        return this.center;
    }

    @Override
    public IAgentBodyShape adjust(Point3d pos, double sizeFactor) {
        return new CylinderShape(pos, this.radius * sizeFactor, this.geometryRadius, this.height, this.dir, this.occId);
    }

    @Override
    public double getNearDist2d(Point3d p) {
        double distsq = this.center.distanceSquared(p);
        if (distsq < this.radius * this.radius) {
            return 0.0;
        }
        return Math.sqrt(distsq) - this.radius;
    }

    @Override
    public AABox getAABox3D() {
        Point3d loc = this.center;
        double minx = loc.x - this.radius;
        double miny = loc.y - this.radius;
        double maxx = loc.x + this.radius;
        double maxy = loc.y + this.radius;
        return new AABox(new Point3d(minx, miny, loc.z), new Point3d(maxx, maxy, loc.z + this.height));
    }

    @Override
    public Point3d[] getAABox2DVerts() {
        Point3d lb = new Point3d(this.center.x - this.radius, this.center.y - this.radius, this.center.z);
        Point3d lt = new Point3d(this.center.x - this.radius, this.center.y + this.radius, this.center.z);
        Point3d rb = new Point3d(this.center.x + this.radius, this.center.y - this.radius, this.center.z);
        Point3d rt = new Point3d(this.center.x + this.radius, this.center.y + this.radius, this.center.z);
        Point3d[] box = new Point3d[]{lb, rb, rt, lt};
        return box;
    }

    @Override
    public boolean contains2d(Point3d p) {
        double dx = p.x - this.center.x;
        double dy = p.y - this.center.y;
        double distsq = dx * dx + dy * dy;
        return distsq <= this.radius * this.radius;
    }

    @Override
    public double getEnclosingRadius() {
        return this.radius;
    }

    @Override
    public double getOccRadius() {
        return this.radius;
    }

    @Override
    public double getGeomRadius() {
        return this.geometryRadius;
    }

    @Override
    public double getDistToFront() {
        return this.radius;
    }

    @Override
    public double getLength() {
        return 2.0 * this.radius;
    }

    @Override
    public double getWidth() {
        return 2.0 * this.radius;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public double getMinTurnaroundTime() {
        return MIN_TURNAROUND_TIME;
    }

    public void update(Point3d center, Vector3d dir) {
        this.center = center;
        this.dir = dir;
    }

    @Override
    public boolean canRotate360(KB world) {
        return true;
    }

    @Override
    public boolean canTravel360() {
        return true;
    }

    @Override
    public int getOccId() {
        return this.occId;
    }

    @Override
    public List<TriPoint> getVisibilityPoints(KB kb, OccAgent agent) {
        return Collections.singletonList(agent.getLoc());
    }

    @Override
    public IAgentBodyShape moveInDirBy(double distOffset) {
        return this.moveInDirBy(this.dir, distOffset);
    }

    @Override
    public Vector3d getDir() {
        return this.dir;
    }

    @Override
    public IAgentBodyShape move(Vector3d moveVec) {
        if (moveVec.lengthSquared() == 0.0) {
            return this;
        }
        Point3d newCenter = Util3D.add(this.center, (Tuple3d)moveVec);
        return new CylinderShape(newCenter, this.radius, this.geometryRadius, this.height, new Vector3d(this.dir), this.occId);
    }

    @Override
    public CylinderShape orientTo(Vector3d dir) {
        if (dir.equals(this.dir)) {
            return this;
        }
        return new CylinderShape(this.center, this.radius, this.geometryRadius, this.height, dir, this.occId);
    }

    @Override
    public boolean getPrefersLateralAvoidance() {
        return false;
    }

    public String toString() {
        return String.format("CylinderShape: radius=%g, geomRadius=%g, height=%g", this.radius, this.geometryRadius, this.height);
    }

    private static ICurve cc(double val, Unit unit) {
        return new ConstantCurve(new UnitDouble(val, unit));
    }

    @Override
    public OccProfileSim.CylShapeGen toShapeGen() {
        return new OccProfileSim.CylShapeGen(CylinderShape.cc(this.radius * 2.0, SI.METER), this.geometryRadius != this.radius ? new UnitDouble(this.geometryRadius * 2.0, SI.METER) : null, CylinderShape.cc(this.height, SI.METER));
    }

    @Override
    public Object getStaticHash() {
        return new StaticHash(this);
    }

    public static class StaticHash {
        public final CylinderShape shape;

        public StaticHash(CylinderShape shape) {
            this.shape = shape;
        }

        public int hashCode() {
            return 0x9A9F83 ^ Objects.hash(this.shape.height, this.shape.radius, this.shape.geometryRadius);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StaticHash)) {
                return false;
            }
            StaticHash hash = (StaticHash)obj;
            return this.shape.height == hash.shape.height && this.shape.radius == hash.shape.radius && this.shape.geometryRadius == hash.shape.geometryRadius;
        }
    }
}

