/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ANode;
import inferno.data2.IAnimSrc;
import inferno.data2.IOccFilter;
import inferno.data2.Occupant;
import inferno.data2.TriPoint;
import inferno.data2.ai.IEventTime;
import inferno.sim.BehaviorSim;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;

public class AttractorSim
implements Serializable,
IAnimSrc {
    private static final long serialVersionUID = 1L;
    private int d_id;
    private long d_resultsId;
    public final AttractorSim rootAttractor;
    public final PlaceType type;
    public final OccAgent creator;
    private final double creationTime;
    public final boolean trackCreator;
    public final int rank;
    public final String name;
    private TriPoint d_location;
    public final double influenceRadius;
    public BehaviorSim behavior;
    public final Awareness awareness;
    public final int minAwarenessCount;
    public final double minAwarenessTime;
    public final Set<ANode> rooms;
    public final IEventTime reactTime;
    public final boolean forceConsiderationIfOccBecomesUnaware;
    public final boolean requiresCompletion;
    private final List<Pair<Double, Double>> d_influenceCurve;
    public final InfluenceFrom influenceFrom;
    private double d_influence;
    public boolean ignoreOccSuscp;
    public final Predicate<? super Occupant> occFilter;

    public AttractorSim(Props props, TriPoint location) {
        this(null, null, 0.0, false, location, props);
    }

    private AttractorSim(AttractorSim rootAttractor, OccAgent creator, double creationTime, boolean trackCreator, TriPoint location, Props props) {
        assert (!trackCreator || creator != null);
        assert (!props.influence.isEmpty());
        assert (IOccFilter.InputFileInfo.get(props.occFilter).isPresent());
        this.rootAttractor = rootAttractor == null ? this : rootAttractor;
        this.creator = creator;
        this.creationTime = creationTime;
        this.trackCreator = trackCreator;
        this.d_resultsId = props.resultsId;
        this.name = props.name;
        this.type = props.type;
        this.rank = props.rank;
        this.d_location = location;
        this.behavior = props.behavior;
        this.awareness = props.awareness;
        this.minAwarenessCount = props.minAwarenessCount;
        this.minAwarenessTime = props.minAwarenessTime;
        this.forceConsiderationIfOccBecomesUnaware = props.forceConsiderationIfOccBecomesUnaware;
        this.influenceRadius = props.influenceRadius;
        this.rooms = props.rooms;
        this.reactTime = props.reactTime;
        this.requiresCompletion = props.requiresCompletion;
        this.d_influence = props.initInfluence;
        this.d_influenceCurve = props.influence;
        this.ignoreOccSuscp = props.ignoreOccSusc;
        this.influenceFrom = props.influenceFrom;
        this.occFilter = props.occFilter;
    }

    public AABox getBounds() {
        return new BoundingSphere(this.d_location.p, this.influenceRadius).toAABox();
    }

    public int getId() {
        return this.d_id;
    }

    public void setId(int id) {
        this.d_id = id;
    }

    public long getResultsId() {
        return this.d_resultsId;
    }

    public void setResultsId(long id) {
        this.d_resultsId = id;
    }

    public int getRootId() {
        return this.rootAttractor.getId();
    }

    public TriPoint getLocation() {
        return this.d_location;
    }

    public void setLocation(TriPoint location) {
        this.d_location = location;
    }

    public double getInfluence() {
        return this.d_influence;
    }

    public void setInfluence(double influence) {
        this.d_influence = influence;
    }

    public boolean isIgnoreOccupantSusceptibility() {
        return this.ignoreOccSuscp;
    }

    public void setIgnoreSusceptibility(boolean ignore) {
        this.ignoreOccSuscp = ignore;
    }

    public List<Pair<Double, Double>> getInfluenceCurve() {
        return this.d_influenceCurve;
    }

    public double getProbabilityOfInfluence(Occupant occ, boolean idle) {
        if (!this.occFilter.test(occ)) {
            return 0.0;
        }
        double suscOverride = this.ignoreOccSuscp ? 1.0 : Double.NaN;
        return this.d_influence * occ.getAttractorSusceptibility(idle, this, suscOverride);
    }

    public boolean isVisible(KB kb, Occupant occ) {
        switch (this.awareness.ordinal()) {
            case 1: {
                return occ.curNode == this.d_location.tri.node;
            }
            case 0: {
                return occ.loc.distanceSquared(this.d_location.p) <= this.influenceRadius * this.influenceRadius && !kb.getMesh().isPathObstructed(occ.tri, occ.loc, this.d_location.tri, this.d_location.p, 0.0, Filters.acceptAll());
            }
            case 3: {
                return true;
            }
            case 2: {
                return this.rooms.contains(occ.curNode);
            }
        }
        assert (false);
        return false;
    }

    public AttractorSim createInstance(OccAgent creator, TriPoint location, boolean trackCreator, double time) {
        AttractorSim instance = new AttractorSim(this, creator, time, trackCreator, location, new Props(this.d_resultsId, this.name, PlaceType.INSTANCE, this.rank, this.behavior, this.requiresCompletion, this.awareness, this.minAwarenessCount, this.minAwarenessTime, this.forceConsiderationIfOccBecomesUnaware, this.influenceRadius, (Double)this.d_influenceCurve.get((int)0).v2, this.d_influenceCurve, this.influenceFrom, this.ignoreOccSuscp, this.rooms, this.reactTime, this.occFilter));
        return instance;
    }

    public boolean isInstance() {
        return this.type == PlaceType.INSTANCE;
    }

    public boolean isTemplate() {
        return this.type == PlaceType.TEMPLATE;
    }

    public static int compareCreateOrder(AttractorSim a1, AttractorSim a2) {
        int creatorCompare = Integer.compare(a1.creator.getId(), a2.creator.getId());
        if (creatorCompare != 0) {
            return creatorCompare;
        }
        int idCompare = Integer.compare(a1.getRootId(), a2.getRootId());
        if (idCompare != 0) {
            return idCompare;
        }
        int timeCompare = Double.compare(a1.creationTime, a2.creationTime);
        return timeCompare;
    }

    public String toString() {
        return this.name;
    }

    public static class Props {
        public final long resultsId;
        public final String name;
        public final PlaceType type;
        public final int rank;
        public final BehaviorSim behavior;
        public final boolean requiresCompletion;
        public final Awareness awareness;
        public final int minAwarenessCount;
        public final double minAwarenessTime;
        public final boolean forceConsiderationIfOccBecomesUnaware;
        public final double influenceRadius;
        public final double initInfluence;
        public final List<Pair<Double, Double>> influence;
        public final InfluenceFrom influenceFrom;
        public final boolean ignoreOccSusc;
        public final Set<ANode> rooms;
        public final IEventTime reactTime;
        public final Predicate<? super Occupant> occFilter;

        public Props(long resultsId, String name, PlaceType type, int rank, BehaviorSim behavior, boolean requiresCompletion, Awareness awareness, int minAwarenessCount, double minAwarenessTime, boolean forceConsiderationIfOccBecomesUnaware, double influenceRadius, double initInfluence, List<Pair<Double, Double>> influence, InfluenceFrom influenceFrom, boolean ignoreOccSusc, Set<ANode> rooms, IEventTime reactTime, Predicate<? super Occupant> occFilter) {
            this.resultsId = resultsId;
            this.name = name;
            this.type = type;
            this.rank = rank;
            this.behavior = behavior;
            this.requiresCompletion = requiresCompletion;
            this.awareness = awareness;
            this.minAwarenessCount = minAwarenessCount;
            this.minAwarenessTime = minAwarenessTime;
            this.forceConsiderationIfOccBecomesUnaware = forceConsiderationIfOccBecomesUnaware;
            this.influenceRadius = influenceRadius;
            this.initInfluence = initInfluence;
            this.influence = influence;
            this.influenceFrom = influenceFrom;
            this.ignoreOccSusc = ignoreOccSusc;
            this.rooms = rooms;
            this.reactTime = reactTime;
            this.occFilter = occFilter;
        }
    }

    public static enum PlaceType {
        PLACED(true, true),
        TEMPLATE(true, false),
        INSTANCE(false, true);

        public final boolean isRoot;
        public final boolean isPlaced;

        private PlaceType(boolean isRoot, boolean isPlaced) {
            this.isRoot = isRoot;
            this.isPlaced = isPlaced;
        }
    }

    public static enum Awareness {
        LINE_OF_SIGHT,
        ROOM_ONLY,
        ROOMS,
        GLOBAL;

    }

    public static enum InfluenceFrom {
        ATTRACTOR_CREATION,
        SIMULATION_START;

    }
}

