/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.AttractorSim;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.search.Containment;

public class AttractorLocator
extends RTree<AttractorSim>
implements Serializable {
    private static final long serialVersionUID = -4341995655197193408L;
    private static final double NUM_PREDICT_TIMESTEPS = 20.0;
    private final double d_crossoverFactor = 0.63;
    private double d_lastUpdateTime = -1.7976931348623157E308;

    public void insert(AttractorSim attractor, double dt) {
        this.insert(AttractorLocator.getFuzzyBounds(attractor, dt), attractor);
    }

    public void update(double t, double dt) {
        if (t == this.d_lastUpdateTime) {
            return;
        }
        this.d_lastUpdateTime = t;
        ArrayList<AttractorSim> attractors = new ArrayList<AttractorSim>();
        this.getAll((? super T attr, Containment ctmt) -> attractors.add((AttractorSim)attr));
        int crossover = (int)((double)attractors.size() * 0.63);
        Collection<AttractorSim> updateAttractors = this.getUpdateAttractors(attractors, crossover);
        if (updateAttractors.size() > crossover) {
            this.clear();
            for (AttractorSim attractor : attractors) {
                this.insert(attractor, dt);
            }
        } else {
            for (AttractorSim attractor : updateAttractors) {
                this.remove(attractor);
                this.insert(attractor, dt);
            }
        }
    }

    private Collection<AttractorSim> getUpdateAttractors(Collection<AttractorSim> attractors, int maxCount) {
        if (this.isEmpty()) {
            return attractors;
        }
        ArrayList<AttractorSim> updateObjs = new ArrayList<AttractorSim>(attractors.size());
        for (AttractorSim attractor : attractors) {
            if (!this.needsUpdate(attractor)) continue;
            updateObjs.add(attractor);
            if (updateObjs.size() <= maxCount) continue;
            break;
        }
        return updateObjs;
    }

    private boolean needsUpdate(AttractorSim attractor) {
        AABox oldBounds = (AABox)this.getBounds(attractor);
        if (oldBounds == null) {
            return true;
        }
        AABox trueBounds = attractor.getBounds();
        return oldBounds.test(trueBounds) != Containment.INSIDE;
    }

    public static AABox getFuzzyBounds(AttractorSim attractor, double dt) {
        AABox bounds = attractor.getBounds();
        Vector3d vel = attractor.creator != null ? attractor.creator.getVel() : new Vector3d();
        double predictDist = vel.length() * dt * 20.0;
        bounds.set(bounds.getMinX() - predictDist, bounds.getMinY() - predictDist, bounds.getMinZ() - predictDist, bounds.getMaxX() + predictDist, bounds.getMaxY() + predictDist, bounds.getMaxZ() + predictDist);
        return bounds;
    }
}

