/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.TriPoint;
import java.io.Serializable;
import java.util.Arrays;
import javax.vecmath.Point3d;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public abstract class ASplitComponent<T>
implements Serializable {
    static final long serialVersionUID = 1L;
    public final T comp;
    public final double[] splits;
    static final ILocResolver DEF_RESOLVER = new ILocResolver(){

        public double resolve(ASplitComponent sedge, double t1, double t2, double t) {
            return t - t1 <= t2 - t ? t1 : t2;
        }
    };

    public ASplitComponent(T comp, double[] splits) {
        this.comp = comp;
        this.splits = splits;
    }

    public Point3d get(double t) {
        return (Point3d)this.getDetailed((double)t).v2;
    }

    public abstract Pair<Integer, Point3d> getDetailed(double var1);

    public double get(Point3d p) {
        return (Double)this.getDetailed((Point3d)p, (int)-1).v2;
    }

    public abstract Pair<Integer, Double> getDetailed(Point3d var1, int var2);

    public boolean isTravellable() {
        return this.splits.length > 0;
    }

    public boolean isCrossable(double tloc) {
        return this.isCrossable(tloc, 0.0);
    }

    public boolean isCrossable(double tloc, double tol) {
        if (this.splits.length == 0) {
            return false;
        }
        int findix = Arrays.binarySearch(this.splits, tloc);
        if (findix >= 0) {
            return true;
        }
        int insertix = -1 - findix;
        if (insertix % 2 != 0) {
            return true;
        }
        if (tol == 0.0) {
            return false;
        }
        if (insertix == 0) {
            return theUtil.eq(tloc, this.splits[0], tol);
        }
        if (insertix == this.splits.length) {
            return theUtil.eq(tloc, this.splits[this.splits.length - 1], tol);
        }
        return theUtil.eq(tloc, this.splits[insertix], tol) || theUtil.eq(tloc, this.splits[insertix - 1], tol);
    }

    public abstract TriPoint findClosest(TriPoint var1);

    private int findSegment(double tloc) {
        int findix = Arrays.binarySearch(this.splits, tloc);
        if (findix >= 0) {
            return findix % 2 == 0 ? findix : findix - 1;
        }
        int insertix = -1 - findix;
        if (insertix % 2 != 0) {
            return insertix - 1;
        }
        if (insertix == 0) {
            return 0;
        }
        if (insertix == this.splits.length) {
            return this.splits.length - 2;
        }
        double t1 = this.splits[insertix - 1];
        double t2 = this.splits[insertix];
        return tloc - t1 <= t2 - tloc ? insertix - 2 : insertix;
    }

    public Point3d[] findSegment(Point3d p) {
        Pair<Integer, Point3d>[] result = this.findSegmentDetailed(p, -1);
        if (result == null) {
            return null;
        }
        return new Point3d[]{(Point3d)result[0].v2, (Point3d)result[1].v2};
    }

    public Pair<Integer, Point3d>[] findSegmentDetailed(Point3d p, int edgeHint) {
        int segment;
        if (this.splits.length == 0) {
            return null;
        }
        if (this.splits.length == 2) {
            segment = 0;
        } else {
            double tloc = (Double)this.getDetailed((Point3d)p, (int)edgeHint).v2;
            segment = this.findSegment(tloc);
        }
        return new Pair[]{this.getDetailed(this.splits[segment]), this.getDetailed(this.splits[segment + 1])};
    }

    public Point3d findClosest(Point3d p) {
        Pair<Integer, Point3d> result = this.findClosestDetailed(p, -1);
        if (result == null) {
            return null;
        }
        return (Point3d)result.v2;
    }

    public Pair<Integer, Point3d> findClosestDetailed(Point3d p, int edgeHint) {
        if (this.splits.length == 0) {
            return null;
        }
        Pair<Integer, Double> tloc = this.getDetailed(p, edgeHint);
        double result = this.findClosest((Double)tloc.v2);
        if (result == (Double)tloc.v2) {
            return new Pair<Integer, Point3d>((Integer)tloc.v1, p);
        }
        if (Double.isNaN(result)) {
            return null;
        }
        return this.getDetailed(result);
    }

    public double findClosest(double tloc) {
        return this.findClosest(tloc, ASplitComponent.defLocResolver());
    }

    public double findClosest(double tloc, ILocResolver<T> resolver) {
        double t;
        if (this.splits.length == 0) {
            return Double.NaN;
        }
        if (this.splits.length == 2) {
            if (tloc < this.splits[0]) {
                return this.splits[0];
            }
            if (tloc > this.splits[1]) {
                return this.splits[1];
            }
            return tloc;
        }
        int findix = Arrays.binarySearch(this.splits, tloc);
        if (findix >= 0) {
            return tloc;
        }
        int insertix = -1 - findix;
        if (insertix % 2 != 0) {
            return tloc;
        }
        if (insertix == 0) {
            t = this.splits[0];
        } else if (insertix == this.splits.length) {
            t = this.splits[this.splits.length - 1];
        } else {
            double t1 = this.splits[insertix - 1];
            double t2 = this.splits[insertix];
            t = resolver.resolve(this, t1, t2, tloc);
        }
        return t;
    }

    public static <T> ILocResolver<T> defLocResolver() {
        return DEF_RESOLVER;
    }

    public static interface ILocResolver<T> {
        public double resolve(ASplitComponent<T> var1, double var2, double var4, double var6);
    }
}

