/*
 * Decompiled with CFR 0.152.
 */
package fpserver;

import fpserver.Api;
import inferno.data2.ANode;
import inferno.data2.Blockage;
import inferno.data2.Mesh;
import inferno.data2.Obscuration;
import inferno.data2.Occupant;
import inferno.data2.SpeedModifier;
import inferno.data2.Tri;
import inferno.data2.ai.IGoal;
import inferno.elevator.ElevatorModel;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.Filters;

public class Status {
    private static Map<StatusArg, Object> getDefaultArgs() {
        HashMap<StatusArg, Object> props = new HashMap<StatusArg, Object>();
        for (StatusArg prop : StatusArg.values()) {
            if (prop.defVal == null) continue;
            props.put(prop, prop.defVal);
        }
        return props;
    }

    public static Map<StatusArg, Object> procArgs(List<String> args) throws Api.ApiException {
        return Status.procArgs(args, Integer.MAX_VALUE);
    }

    public static Map<StatusArg, Object> procArgs(List<String> args, int maxCount) throws Api.ApiException {
        int m;
        if (maxCount <= 0) {
            return Collections.EMPTY_MAP;
        }
        Map<StatusArg, Object> argMap = Status.getDefaultArgs();
        try {
            for (m = 0; m < args.size() && argMap.size() < maxCount; ++m) {
                String arg = args.get(m);
                if (arg.equalsIgnoreCase(StatusArg.NAME.argSwitch)) {
                    argMap.put(StatusArg.NAME, args.get(++m));
                    continue;
                }
                if (arg.equalsIgnoreCase(StatusArg.ROOM.argSwitch)) {
                    argMap.put(StatusArg.ROOM, args.get(++m));
                    continue;
                }
                if (arg.equalsIgnoreCase(StatusArg.ID.argSwitch)) {
                    int id = Integer.parseInt(args.get(++m));
                    argMap.put(StatusArg.ID, id);
                    continue;
                }
                if (!arg.equalsIgnoreCase(StatusArg.SPHERE.argSwitch)) continue;
                double x = Double.parseDouble(args.get(++m));
                double y = Double.parseDouble(args.get(++m));
                double z = Double.parseDouble(args.get(++m));
                double r = Double.parseDouble(args.get(++m));
                SphereData sphere = new SphereData(x, y, z, r);
                argMap.put(StatusArg.SPHERE, sphere);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new Api.ApiException(String.format("Missing argument after %s%n", args.get(m - 1)));
        }
        return argMap;
    }

    public static String getNoArg(Engine e) {
        double t = e.getKB().getCurrentSimTime();
        long step = e.getCurrentTimeStep();
        double dt = e.getCurrentDt();
        int persRem = e.getKB().getActiveAgents().size();
        String state = e.isFinished() ? "finished" : (e.isPaused() ? "paused" : "running");
        StringWriter strw = new StringWriter();
        PrintWriter response = new PrintWriter(strw);
        response.printf("STATE, T, STEP, DT, PERS_REMAINING%n", new Object[0]);
        response.printf("%s, %.2f, %s, %.3f, %s%n", state, t, step, dt, persRem);
        response.close();
        return strw.toString();
    }

    public static String getAgents(Engine e, String nameFilter, Integer idFilter, String roomFilter, SphereData sphereFilter) {
        List<OccAgent> allAgents;
        StringWriter strw = new StringWriter();
        PrintWriter response = new PrintWriter(strw);
        response.printf("ID, NAME, STATUS, GOAL, X, Y, Z%n", new Object[0]);
        if (sphereFilter != null) {
            KB kb = e.getKB();
            Point3d pt = new Point3d(sphereFilter.x, sphereFilter.y, sphereFilter.z);
            allAgents = kb.findOccs((ITest<AABox>)new BoundingSphere(pt, sphereFilter.r), Filters.acceptAll(), true);
        } else {
            allAgents = new ArrayList<OccAgent>(e.getKB().getAllAgentsEver());
        }
        Collections.sort(allAgents, new Comparator<OccAgent>(){

            @Override
            public int compare(OccAgent o1, OccAgent o2) {
                return Integer.compare(o1.getOcc().id, o2.getOcc().id);
            }
        });
        for (OccAgent agent : allAgents) {
            Occupant occ = agent.getOcc();
            if (idFilter != null && !idFilter.equals(occ.id) || nameFilter != null && !nameFilter.equals(occ.name) || roomFilter != null && !roomFilter.equals(agent.getLoc().tri.node.name)) continue;
            String status = "active";
            if (e.getKB().getForceIdle()) {
                status = "idle";
            } else if (agent.isAwaitingAssistance()) {
                status = "needs help";
            } else if (agent.isSeverelyInjured()) {
                status = "severe injury";
            } else if (agent.isDone()) {
                status = "finished";
            } else if (agent.isWaiting(e.getKB())) {
                status = "lost";
            }
            String goal = "unknown";
            try {
                IGoal goalObj = occ.behavior.get(agent.getGoalIx());
                goal = goalObj.getClass().getSimpleName();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            response.printf("%s, \"%s\", \"%s\", %s, %.2f, %.2f, %.2f%n", occ.id, occ.name, status, goal, occ.loc.x, occ.loc.y, occ.loc.z);
        }
        response.close();
        return strw.toString();
    }

    public static String getDoors(Engine e, String nameFilter, Integer idFilter) {
        StringWriter strw = new StringWriter();
        PrintWriter response = new PrintWriter(strw);
        response.printf("ID, NAME, TYPE, STATUS, EXITED, X, Y, Z%n", new Object[0]);
        ArrayList<ANode> allNodes = new ArrayList<ANode>(e.getKB().getNodes());
        for (int i = 0; i < allNodes.size(); ++i) {
            ANode door = (ANode)allNodes.get(i);
            if (!door.isDoor() || idFilter != null && !idFilter.equals(i) || nameFilter != null && !nameFilter.equals(door.name)) continue;
            String type = door.isExitDoor() ? "exit" : "internal";
            String status = door.isPhysicallyClosed() ? "closed" : "open";
            Point3d pt = door.getOptionalDoorGeom().map(dg -> (Point3d)dg.getMidpoint().v2).orElse(new Point3d());
            response.printf("%s, \"%s\", %s, %s, %s, %.2f, %.2f, %.2f%n", i, door.name, type, status, door.getExitedVia(), pt.x, pt.y, pt.z);
        }
        response.close();
        return strw.toString();
    }

    public static String getStairs(Engine e, String nameFilter, Integer idFilter) {
        StringWriter strw = new StringWriter();
        PrintWriter response = new PrintWriter(strw);
        response.printf("ID, NAME, TYPE, X, Y, Z%n", new Object[0]);
        ArrayList<ANode> allNodes = new ArrayList<ANode>(e.getKB().getNodes());
        for (int i = 0; i < allNodes.size(); ++i) {
            ANode stair = (ANode)allNodes.get(i);
            if (stair.stairData == null || idFilter != null && !idFilter.equals(i) || nameFilter != null && !nameFilter.equals(stair.name)) continue;
            SpeedModifier speedMod = stair.getMesh().get(0).getSpeedModifier();
            String type = speedMod != null && speedMod != SpeedModifier.IDENTITY ? "escalator" : "stairway";
            Point3d pt = stair.getGeometryBounds().getCenter();
            response.printf("%s, \"%s\", %s, %.2f, %.2f, %.2f%n", i, stair.name, type, pt.x, pt.y, pt.z);
        }
        response.close();
        return strw.toString();
    }

    public static String getRooms(Engine e, String nameFilter, Integer idFilter, SphereData sphereFilter) {
        ArrayList<ANode> allNodes;
        StringWriter strw = new StringWriter();
        PrintWriter response = new PrintWriter(strw);
        response.printf("ID, NAME, AREA, OCCUPANTS, X, Y, Z%n", new Object[0]);
        if (sphereFilter != null) {
            Point3d pt = new Point3d(sphereFilter.x, sphereFilter.y, sphereFilter.z);
            BoundingSphere sphere = new BoundingSphere(pt, sphereFilter.r);
            KB kb = e.getKB();
            Mesh m = kb.getMesh();
            List<Tri> tris = m.findTris(sphere);
            LinkedHashSet<ANode> nodes = new LinkedHashSet<ANode>();
            for (Tri t : tris) {
                if (!Inter3D.testTriSphere(t.v[0].p, t.v[1].p, t.v[2].p, sphere.center, sphere.radius)) continue;
                nodes.add(t.node);
            }
            allNodes = new ArrayList(nodes);
        } else {
            allNodes = new ArrayList<ANode>(e.getKB().getNodes());
        }
        for (int i = 0; i < allNodes.size(); ++i) {
            ANode room = (ANode)allNodes.get(i);
            if (room.isDoor() || idFilter != null && !idFilter.equals(i) || nameFilter != null && !nameFilter.equals(room.name)) continue;
            Point3d pt = room.getGeometryBounds().getCenter();
            response.printf("%s, \"%s\", %.2f, %s, %.2f, %.2f, %.2f%n", i, room.name, room.getArea(), room.getNumOccupants(), pt.x, pt.y, pt.z);
        }
        response.close();
        return strw.toString();
    }

    public static String getElevators(Engine e, Integer idFilter) {
        StringWriter strw = new StringWriter();
        PrintWriter response = new PrintWriter(strw);
        response.printf("ID, STATE, SERVING, PASSENGERS, X, Y, Z%n", new Object[0]);
        ElevatorModel elevModel = e.getKB().getElevatorModel();
        int n = elevModel.getNumElevators();
        for (int i = 0; i < n; ++i) {
            if (idFilter != null && !idFilter.equals(i)) continue;
            ElevatorModel.ElevatorStatus status = elevModel.getElevatorStatus(i);
            response.printf("%s, \"%s\", \"%s\", %d, %.2f, %.2f, %.2f%n", status.id, status.state, status.pickupNode, status.pax, status.pt.x, status.pt.y, status.pt.z);
        }
        response.close();
        return strw.toString();
    }

    public static String getObscuration(Engine e, String nameFilter, Integer idFilter) {
        StringWriter strw = new StringWriter();
        PrintWriter response = new PrintWriter(strw);
        response.printf("ID, NAME, ACTIVE, DENSITY, R, G, B%n", new Object[0]);
        for (Obscuration ob : e.getKB().getObscurations()) {
            if (idFilter != null && !idFilter.equals(ob.id) || nameFilter != null && !nameFilter.equals(ob.floorName)) continue;
            response.printf("%s, \"%s\", %s, %.2f, %s, %s, %s%n", ob.id, ob.floorName, ob.active, ob.density, ob.color.getRed(), ob.color.getGreen(), ob.color.getBlue());
        }
        response.close();
        return strw.toString();
    }

    public static String getBlockages(Engine e, String nameFilter, Integer idFilter, SphereData sphereFilter) {
        HashSet<Integer> triIdFilter = null;
        if (sphereFilter != null) {
            Point3d pt = new Point3d(sphereFilter.x, sphereFilter.y, sphereFilter.z);
            BoundingSphere sphere = new BoundingSphere(pt, sphereFilter.r);
            KB kb = e.getKB();
            Mesh m = kb.getMesh();
            List<Tri> tris = m.findTris(sphere);
            triIdFilter = new HashSet<Integer>();
            for (Tri t : tris) {
                if (!Inter3D.testTriSphere(t.v[0].p, t.v[1].p, t.v[2].p, sphere.center, sphere.radius)) continue;
                triIdFilter.add(t.id);
            }
        }
        StringWriter strw = new StringWriter();
        PrintWriter response = new PrintWriter(strw);
        response.printf("ID, NAME, ACTIVE, VELFACTOR%n", new Object[0]);
        ArrayList<Blockage> blockages = new ArrayList<Blockage>(e.getKB().getBlockages());
        for (Blockage obj : blockages) {
            if (idFilter != null && !idFilter.equals(obj.id) || nameFilter != null && !nameFilter.equals(obj.name)) continue;
            if (triIdFilter != null) {
                boolean blockageInSphere = false;
                int[] nArray = obj.tris;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer id = nArray[i];
                    if (!triIdFilter.contains(id)) continue;
                    blockageInSphere = true;
                }
                if (!blockageInSphere) continue;
            }
            response.printf("%s, \"%s\", %s, %.2f%n", obj.id, obj.name, obj.isActive(), obj.getSpeedModifier());
        }
        response.close();
        return strw.toString();
    }

    public static enum StatusArg {
        NAME("-name", null),
        ID("-id", null),
        ROOM("-room", null),
        SPHERE("-sphere", null);

        public final String argSwitch;
        public final Object defVal;

        private StatusArg(String argSwitch, Object defVal) {
            this.argSwitch = argSwitch;
            this.defVal = defVal;
        }
    }

    public static final class SphereData {
        public final double x;
        public final double y;
        public final double z;
        public final double r;

        public SphereData(double x, double y, double z, double r) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.r = r;
        }
    }
}

