/*
 * Decompiled with CFR 0.152.
 */
package fpserver;

import fpserver.Api;
import fpserver.CommThread;
import fpserver.Config;
import fpserver.ServerConsole;
import fpserver.ServerTcp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import merlin.MerlinPrefs;
import thunderheadeng.util.TeciProps;

public class Run {
    public static void main(String[] args) {
        Config cfg = new Config();
        boolean propsLoaded = false;
        if (0 < args.length) {
            propsLoaded = Run.load(cfg, args[0]);
        }
        TeciProps appPrefs = Run.readPreferences();
        MerlinPrefs.installAlternate(appPrefs);
        if (!propsLoaded) {
            System.out.printf("No props file. Using default ports. LOAD command must be issued manually.%n", new Object[0]);
        }
        System.out.printf("%s=%d%n", "PORT_SYNC", cfg.getInt("PORT_SYNC"));
        System.out.printf("%s=%d%n", "PORT_ASYNC", cfg.getInt("PORT_ASYNC"));
        System.out.printf("%s=%s%n", "PTH_FILE", cfg.getString("PTH_FILE"));
        ServerTcp tcpSyncServer = new ServerTcp(cfg.getInt("PORT_SYNC"), "TCP Server - sync");
        ServerTcp tcpAsyncServer = new ServerTcp(cfg.getInt("PORT_ASYNC"), "TCP Server - async");
        Api api = new Api(cfg, appPrefs, tcpAsyncServer);
        new CommThread(api, tcpSyncServer, "TCP sync").start();
        new CommThread(api, tcpAsyncServer, "TCP async").start();
        ServerConsole console = new ServerConsole();
        CommThread consoleInput = new CommThread(api, console, "console");
        consoleInput.start();
        if (propsLoaded) {
            console.exec("load");
        }
        try {
            consoleInput.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static TeciProps readPreferences() {
        TeciProps props = new TeciProps();
        String filename = Run.getPropertyFilename("Pathfinder");
        try {
            props.load(new FileInputStream(filename));
        }
        catch (IOException e) {
            System.out.println("Error retrieving preferences from file: " + filename);
            System.out.println("Using defaults.");
        }
        return props;
    }

    public static String getPropertyFilename(String appName) {
        String dirSep = File.separator;
        String userHome = System.getenv("APPDATA");
        if (userHome == null) {
            throw new NullPointerException("Unable to locate APPDATA folder.");
        }
        String dir = userHome + dirSep + appName + dirSep + appName + ".props";
        System.out.println("Using properties file: " + dir);
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean load(Config cfg, String propsFn) {
        FileReader r = null;
        try {
            r = new FileReader(propsFn, StandardCharsets.UTF_8);
            System.out.printf("Loading properties from: %s%n", propsFn);
            cfg.load(r);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            try {
                if (r != null) {
                    ((Reader)r).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

