/*
 * Decompiled with CFR 0.152.
 */
package common.vis;

import inferno.geom.Util;

public class ColorMaps {
    public static final DefaultColorMap DEFAULT = new DefaultColorMap();
    public static final IColorMap RAINBOW2 = new InterpolatedColorMap(new float[]{0.0f, 0.125f, 0.375f, 0.625f, 0.875f, 1.0f}, new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5254902f}, new float[]{0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f}, new float[]{0.5647059f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f});

    public static void getColorBW(double intensity, byte[] buffer) {
        if (intensity < 0.0) {
            intensity = 0.0;
        } else if (intensity > 1.0) {
            intensity = 1.0;
        }
        int value = (int)(intensity * 255.0);
        buffer[0] = (byte)value;
        buffer[1] = (byte)value;
        buffer[2] = (byte)value;
    }

    public static void getColor(IColorMap cmap, double intensity, byte[] buffer) {
        float[] vals = new float[3];
        cmap.getColor((float)intensity, vals);
        buffer[0] = (byte)(vals[0] * 255.0f);
        buffer[1] = (byte)(vals[1] * 255.0f);
        buffer[2] = (byte)(vals[2] * 255.0f);
    }

    public static interface IColorMap {
        public void getColor(float var1, float[] var2);
    }

    public static class DefaultColorMap
    implements IColorMap {
        @Override
        public void getColor(float t, float[] c) {
            c[0] = (float)DefaultColorMap.r(t);
            c[1] = (float)DefaultColorMap.g(t);
            c[2] = (float)DefaultColorMap.b(t);
        }

        private static double b(double x) {
            assert (0.0 <= x);
            assert (x <= 1.0);
            if (0.0 <= x && x <= 0.086957) {
                return DefaultColorMap.lerp(x, 0.0, 0.65, 0.086957, 1.0);
            }
            if (0.086957 <= x && x <= 0.391304) {
                return 1.0;
            }
            if (0.391304 <= x && x <= 0.652174) {
                return DefaultColorMap.lerp(x, 0.391304, 1.0, 0.652174, 0.0);
            }
            if (0.652174 <= x && x <= 1.0) {
                return 0.0;
            }
            return Double.NaN;
        }

        private static double g(double x) {
            assert (0.0 <= x);
            assert (x <= 1.0);
            if (0.0 <= x && x <= 0.086957) {
                return 0.0;
            }
            if (0.086957 <= x && x <= 0.347826) {
                return DefaultColorMap.lerp(x, 0.086957, 0.0, 0.347826, 1.0);
            }
            if (0.347826 <= x && x <= 0.652174) {
                return 1.0;
            }
            if (0.652174 <= x && x <= 0.913043) {
                return DefaultColorMap.lerp(x, 0.652174, 1.0, 0.913043, 0.0);
            }
            if (0.913043 <= x && x <= 1.0) {
                return 0.0;
            }
            return Double.NaN;
        }

        private static double r(double x) {
            assert (0.0 <= x);
            assert (x <= 1.0);
            if (0.0 <= x && x <= 0.347826) {
                return 0.0;
            }
            if (0.347826 <= x && x <= 0.608696) {
                return DefaultColorMap.lerp(x, 0.347826, 0.0, 0.608696, 1.0);
            }
            if (0.608696 <= x && x <= 0.913043) {
                return 1.0;
            }
            if (0.913043 <= x && x <= 1.0) {
                return DefaultColorMap.lerp(x, 0.913043, 1.0, 1.0, 0.65);
            }
            return Double.NaN;
        }

        private static double lerp(double v, double x1, double y1, double x2, double y2) {
            assert (x1 <= v && v <= x2);
            double alpha = (v - x1) / (x2 - x1);
            return y1 + alpha * (y2 - y1);
        }
    }

    private static class InterpolatedColorMap
    implements IColorMap {
        public final float[] x;
        public final float[] r;
        public final float[] g;
        public final float[] b;

        public InterpolatedColorMap(float[] x, float[] r, float[] g, float[] b) {
            this.x = x;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        @Override
        public void getColor(float t, float[] c) {
            c[0] = this.getVal(t, this.r);
            c[1] = this.getVal(t, this.g);
            c[2] = this.getVal(t, this.b);
        }

        private float getVal(float x, float[] color) {
            if (x < this.x[0]) {
                return color[0];
            }
            for (int i = 1; i < color.length; ++i) {
                if (!(this.x[i - 1] <= x) || !(x <= this.x[i])) continue;
                float t = (x - this.x[i - 1]) / (this.x[i] - this.x[i - 1]);
                return (float)Util.lerp(color[i - 1], color[i], t);
            }
            if (this.x[color.length - 1] < x) {
                return color[color.length - 1];
            }
            return 0.0f;
        }
    }
}

