/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.session;

import java.io.File;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import results.api.FileType;
import results.api.ICallbacks;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;

public class Filenames {
    private final ICallbacks d_callbacks;
    private final Map<FileType, String> d_defExtensions = new HashMap<FileType, String>();
    private final Map<FileType, TypedProp<String>> d_prefKeys = new HashMap<FileType, TypedProp<String>>();
    private final Map<FileType, String> d_prevPaths = new HashMap<FileType, String>();

    public Filenames(ICallbacks callbacks) {
        this.d_callbacks = callbacks;
        this.registerType(FileType.MOVIE, "wmv", "VideoCreate.lastFile");
        this.registerType(FileType.LIVEVIDEO, "wmv", "VideoCreate.lastLiveFile");
        this.registerType(FileType.SCREENSHOT, "png", "SSCreate.lastFile");
    }

    private void registerType(FileType type, String ext, String prefKey) {
        this.d_defExtensions.put(type, ext);
        TypedProp<String> prefProp = TypedProps.newProp((Object)prefKey, "", new Object[0]);
        this.d_prefKeys.put(type, prefProp);
        String lastPath = this.d_callbacks.getPreferences().get(prefProp);
        if (!lastPath.trim().isEmpty()) {
            this.d_prevPaths.put(type, lastPath);
        }
    }

    public String generatePath(FileType fileType, boolean unique) {
        Object ext;
        File parent;
        String prevName = this.d_prevPaths.get((Object)fileType);
        if (prevName != null) {
            parent = this.d_callbacks.getRootDir();
            ext = FilenameManager.splitFilename(prevName)[1];
        } else {
            parent = this.d_callbacks.getRootDir();
            ext = this.d_defExtensions.get((Object)fileType);
            if (ext == null) {
                ext = "";
            }
        }
        if (!((String)ext).isEmpty()) {
            ext = "." + (String)ext;
        }
        String baseName = parent.getAbsolutePath() + File.separator + this.d_callbacks.getRootName();
        if (!unique) {
            return baseName + (String)ext;
        }
        baseName = baseName + " " + Filenames.formatDate(Date.from(Instant.now()));
        Object currName = baseName;
        int m = 1;
        File f;
        while ((f = new File((String)currName + (String)ext)).exists()) {
            currName = String.format("%s (%s)", baseName, m);
            ++m;
        }
        return f.getAbsolutePath();
    }

    private static String formatDate(Date date) {
        Calendar c = Calendar.getInstance();
        try {
            return String.format("%d.%02d.%02d - %02d.%02d.%02d.%03d", c.get(1), c.get(2), c.get(5), c.get(11), c.get(12), c.get(13), c.get(14));
        }
        catch (Throwable t) {
            return Long.toString(c.getTimeInMillis());
        }
    }

    public void commitPath(FileType type, String path) {
        this.d_prevPaths.put(type, path);
        this.d_callbacks.getPreferences().set(this.d_prefKeys.get((Object)type), path);
    }
}

