/*
 * Decompiled with CFR 0.152.
 */
package montecarlo;

import com.google.gson.Gson;
import inferno.sim.output.SummaryWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import merlin.actions.InfernoUtil;
import merlin.data.montecarlo.SimulationInputList;
import thunderheadeng.io.TextFileEncoding;
import thunderheadeng.util.theUtil;

public class ProcessResults {
    private static final OutputRowFormat DATA_CSV = (id, min, max, avg, stddev) -> String.format("%s;%.2f;%.2f;%.2f;%.2f;%.2f;%.2f%n", id, min, max, avg - stddev, avg + stddev, avg, stddev);
    private static final OutputRowFormat DATA_HTML = (id, min, max, avg, stddev) -> String.format(Locale.US, "%n\t\t\t\t\t['%s', %.2f, %.2f, %.2f, %.2f],", id, max, avg - stddev, avg + stddev, min);

    public static void main(String[] args) throws Exception {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException("Simulation list is required.");
            }
            File file = new File(args[0]).getAbsoluteFile();
            SimulationInputList simulations = null;
            try (FileReader fileReader = new FileReader(file);
                 BufferedReader bufferedReader = new BufferedReader(fileReader);){
                Gson gson = new Gson();
                simulations = gson.fromJson((Reader)bufferedReader, SimulationInputList.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not parse simulation list");
            }
            Path outputDir = file.getParentFile().toPath();
            ProcessResults.processResults(simulations, outputDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void processResults(SimulationInputList simulations, Path outputDir) throws Exception {
        for (SimulationInputList.ScenarioDescription scenario : simulations.runningScenarios().values()) {
            if (scenario.variations().isEmpty()) continue;
            SimulationInputList.VariationDescription firstVariation = scenario.variations().getFirst();
            Path scenarioOutputDir = scenario.variations().size() > 1 ? outputDir.resolve(firstVariation.inputFile()).getParent() : outputDir.resolve(firstVariation.resultsFile()).getParent();
            Path baseName = scenarioOutputDir.getFileName();
            List<Path> scenarioOutputFiles = scenario.variations().stream().map(variation -> outputDir.resolve(variation.inputFile())).toList();
            ProcessResults.processResults(scenarioOutputFiles, baseName, scenarioOutputDir);
        }
        List<Path> outputFiles = simulations.streamRunningVariations().map(var -> outputDir.resolve(var.inputFile()).toAbsolutePath()).toList();
        ProcessResults.processResults(outputFiles, outputDir.getFileName(), outputDir);
    }

    private static void processResults(List<Path> outputFiles, Path baseFileName, Path outputDir) throws Exception {
        ProcessResults.processNonItemizedDataCSV(outputDir, baseFileName, outputFiles, Arrays.asList(SummaryWriter.Headers.COMPLETION_TIMES_ALL_OCCS, SummaryWriter.Headers.TRAVEL_DISTANCE_ALL_OCCS));
        ProcessResults.processNonItemizedDataHTML(outputDir, baseFileName, outputFiles, Arrays.asList(SummaryWriter.Headers.COMPLETION_TIMES_ALL_OCCS, SummaryWriter.Headers.TRAVEL_DISTANCE_ALL_OCCS), Arrays.asList(SummaryWriter.Headers.TIME.toString(), SummaryWriter.Headers.DISTANCE.toString()));
    }

    private static String getFilenameForHeader(String baseName, SummaryWriter.Headers header) {
        if (header == SummaryWriter.Headers.COMPLETION_TIMES_ALL_OCCS) {
            return String.format("%s_montecarlo_completion_times", baseName);
        }
        if (header == SummaryWriter.Headers.TRAVEL_DISTANCE_ALL_OCCS) {
            return String.format("%s_montecarlo_travel_distances", baseName);
        }
        if (header == SummaryWriter.Headers.MOVEMENT_DISTANCE_BY_BEHAVIOR) {
            return String.format("%s_montecarlo_behavior_movement_distances", baseName);
        }
        if (header == SummaryWriter.Headers.MOVEMENT_DISTANCE_BY_PROFILE) {
            return String.format("%s_montecarlo_profile_movement_distances", baseName);
        }
        throw new IllegalArgumentException(header.toString());
    }

    private static String intlHeaderToFilename(String header, String fallback, int tries) {
        int triesRemaining = Math.min(tries, header.length() - 1);
        while (0 < triesRemaining) {
            --triesRemaining;
            try {
                String fn = new File(header + ".tmp").getPath();
                Paths.get(fn, new String[0]);
                return header;
            }
            catch (InvalidPathException e) {
                header = header.substring(0, header.length() - 1);
            }
        }
        return fallback;
    }

    private static double getAverageOfAverages(List<Double> averages) {
        int length = averages.size();
        return averages.stream().mapToDouble(d -> d).sum() / (double)length;
    }

    private static double getAverageStdDev(List<Double> stddevs) {
        int length = stddevs.size();
        return Math.sqrt(stddevs.stream().mapToDouble(d -> d * d).sum() / (double)length);
    }

    public static OutputData processOutputData(OutputRowFormat format, SummaryWriter.Headers header, Path outputDir, List<Path> outputFiles) throws Exception {
        StringBuilder data = new StringBuilder();
        double all_min = Double.MAX_VALUE;
        double all_max = 0.0;
        ArrayList<Double> averages = new ArrayList<Double>();
        ArrayList<Double> stddevs = new ArrayList<Double>();
        for (Path fp : outputFiles) {
            try {
                NonItemizedResult nir = ProcessResults.parseNonItemizedData(fp, header.toString());
                String id = outputDir.relativize(fp).toString();
                id = id.replace("\\", "/");
                all_min = Math.min(all_min, nir.min);
                all_max = Math.max(all_max, nir.max);
                averages.add(nir.avg);
                stddevs.add(nir.stddev);
                String dataRow = format.format(id, nir.min, nir.max, nir.avg, nir.stddev);
                data.append(dataRow);
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        data.append(format.format("ALL", all_min, all_max, ProcessResults.getAverageOfAverages(averages), ProcessResults.getAverageStdDev(stddevs)));
        return new OutputData(data);
    }

    public static void processNonItemizedDataCSV(Path outputFolder, Path baseFileName, List<Path> outputFiles, List<SummaryWriter.Headers> headers) throws Exception {
        for (SummaryWriter.Headers header : headers) {
            OutputData output = ProcessResults.processOutputData(DATA_CSV, header, outputFolder, outputFiles);
            String template = ProcessResults.loadTemplate("non-itemized-result.csv.template");
            template = template.replace("{DATA}", output.data.toString());
            Path fn = outputFolder.resolve(ProcessResults.getFilenameForHeader(baseFileName.toString(), header) + ".csv");
            Files.write(fn, template.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            System.out.printf(" -> %s%n", fn.getFileName() != null ? fn.getFileName() : "");
        }
    }

    public static void processNonItemizedDataHTML(Path outputFolder, Path baseFileName, List<Path> outputFiles, List<SummaryWriter.Headers> headers, List<String> v_axis_labels) throws Exception {
        for (int i = 0; i < headers.size(); ++i) {
            OutputData output = ProcessResults.processOutputData(DATA_HTML, headers.get(i), outputFolder, outputFiles);
            String template = ProcessResults.loadTemplate("non-itemized-result.html.template");
            template = template.replace("{LANG}", Locale.getDefault().toString());
            template = template.replace("{DATA}", output.data.toString());
            template = template.replace("{TITLE}", headers.get(i).toString());
            template = template.replace("{H_AXIS_TITLE}", "Case");
            template = template.replace("{V_AXIS_TITLE}", v_axis_labels.get(i));
            Path fn = outputFolder.resolve(ProcessResults.getFilenameForHeader(baseFileName.toString(), headers.get(i)) + ".html");
            Files.write(fn, template.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            System.out.printf(" -> %s%n", fn.getFileName() != null ? fn.getFileName() : "");
        }
    }

    private static String loadTemplate(String fn) throws Exception {
        StringBuilder data = new StringBuilder();
        InputStream instrm = ProcessResults.class.getResourceAsStream(fn);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(instrm, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                data.append(line).append("\n");
                line = reader.readLine();
            }
        }
        return data.toString();
    }

    private static NonItemizedResult parseNonItemizedData(Path fn, String header) throws Exception {
        String baseName = InfernoUtil.rootFn(fn.toString());
        Path summaryFn = fn.getParent().resolve(baseName).resolve(baseName + "_summary.txt");
        try (BufferedReader reader = TextFileEncoding.buildEncodeSafeReader(new FileInputStream(summaryFn.toFile()));){
            while (!reader.readLine().startsWith(header)) {
            }
            NonItemizedResult nonItemizedResult = new NonItemizedResult(fn.getFileName().toString(), theUtil.parseDoubleRobust(reader.readLine().trim().split("[ \t]+")[1]), theUtil.parseDoubleRobust(reader.readLine().trim().split("[ \t]+")[1]), theUtil.parseDoubleRobust(reader.readLine().trim().split("[ \t]+")[1]), theUtil.parseDoubleRobust(reader.readLine().trim().split("[ \t]+")[1]));
            return nonItemizedResult;
        }
    }

    public static class NonItemizedResult {
        public final double min;
        public final double max;
        public final double avg;
        public final double stddev;
        public final String fn;

        public NonItemizedResult(String fn, double min, double max, double avg, double stddev) {
            this.fn = fn;
            this.min = min;
            this.max = max;
            this.avg = avg;
            this.stddev = stddev;
        }
    }

    private static interface OutputRowFormat {
        public String format(String var1, double var2, double var4, double var6, double var8);
    }

    public static class OutputData {
        public final StringBuilder data;

        public OutputData(StringBuilder data) {
            this.data = data;
        }
    }
}

