/*
 * Decompiled with CFR 0.152.
 */
package merlin.unitsystem;

import java.util.HashMap;
import java.util.Map;
import merlin.MerlinApp;
import merlin.unitsystem.MerlinUnitType;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.IUnitSrc;

public abstract class UnitSystem {
    public static final int LENGTH = 0;
    public static final int TIME = 1;
    public static final int OCC_DENSITY = 2;
    public static final int INV_OCC_DENSITY = 3;
    public static final int AREA = 4;
    public static final int VELOCITY = 5;
    public static final int SHORT_LENGTH = 6;
    public static final int ANGLE = 7;
    public static final int ACCEL = 8;
    public static final int PERSONS = 9;
    public static final int PERCENT = 10;
    public static final int NONE = 11;
    public static final int SPECIFIC_FLOWRATE = 12;
    public static final int FLOWRATE = 13;
    public static final int ANGLE_SPEED = 14;
    public static final int ZOOM_SPEED = 15;
    public static final int EXTINCTION_COEFFICIENT = 16;
    private static final Map<Unit, Integer> s_unitTypeMap = new HashMap<Unit, Integer>();
    private final String d_name;
    private final Map<Integer, Unit> d_typeUnitMap;

    public UnitSystem(String name) {
        this.d_name = name;
        this.d_typeUnitMap = new HashMap<Integer, Unit>();
    }

    protected void addUnit(int type, Unit unit, boolean defForType) {
        this.d_typeUnitMap.put(type, unit);
        s_unitTypeMap.put(unit, type);
        if (defForType) {
            s_unitTypeMap.put(unit.getSystemUnit(), type);
        }
    }

    public String getSystemName() {
        return this.d_name;
    }

    public static int getType(Unit u) {
        Integer type = s_unitTypeMap.get(u);
        if (type == null) {
            type = s_unitTypeMap.get(u.getSystemUnit());
        }
        if (type == null) {
            return -1;
        }
        return type;
    }

    public static IUnitSrc getType(int unitId, boolean observeChanges) {
        MerlinUnitType ut = new MerlinUnitType(unitId);
        if (observeChanges) {
            MerlinApp.getApp().getData().getEvents().addObserver(ut);
        }
        return ut;
    }

    public Unit getUnit(int type) {
        return this.d_typeUnitMap.get(type);
    }

    public Unit getLength() {
        return this.getUnit(0);
    }

    public Unit getTime() {
        return this.getUnit(1);
    }

    public Unit getOccDensity() {
        return this.getUnit(2);
    }

    public Unit getInvOccDensity() {
        return this.getUnit(3);
    }

    public Unit getArea() {
        return this.getUnit(4);
    }

    public Unit getAngle() {
        return this.getUnit(7);
    }

    public Unit getAccel() {
        return this.getUnit(8);
    }

    public Unit getPersons() {
        return this.getUnit(9);
    }

    public Unit getSpecificFlowrate() {
        return this.getUnit(12);
    }
}

