/*
 * Decompiled with CFR 0.152.
 */
package merlin.treeview;

import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreeCellEditor;
import merlin.MerlinApp;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.gui.guiUtil;
import merlin.treeview.CellRenderer;
import merlin.treeview.TVEntryPoint;
import merlin.treeview.TreeView;
import merlin.treeview.Util;

public class CellEditor
extends DefaultTreeCellEditor
implements TreeCellEditor {
    private final MerlinData d_data;

    public CellEditor(MerlinData md, TreeView tree, CellRenderer ren) {
        super(tree, ren);
        this.d_data = md;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        IMerlinObj obj = (IMerlinObj)value;
        TVEntryPoint<Object> ep = Util.getEP(value);
        String name = "";
        if (ep != null) {
            name = ep.getName(this.d_data, obj);
        }
        Component c = super.getTreeCellEditorComponent(tree, name, isSelected, expanded, leaf, row);
        if (ep != null) {
            boolean vis = ep.isVisible(this.d_data, obj);
            int iconix = vis ? 0 : 1;
            Collection errors = MerlinApp.getGlobalErrors().map(analysis -> analysis.getCollapsedErrors(obj)).orElse(Collections.emptyList());
            Icon[] icons = guiUtil.decorateIcons(this.d_data, ep, () -> tree.repaint(), c, obj, errors);
            this.editingIcon = icons[iconix];
        }
        return c;
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        TreeView t = (TreeView)this.tree;
        if (t.getSelectionCount() != 1) {
            return false;
        }
        IMerlinObj sel = (IMerlinObj)t.getSelectionPath().getLastPathComponent();
        TVEntryPoint<Object> ep = Util.getEP(sel);
        return super.isCellEditable(evt) && ep != null && ep.canRename(this.d_data, sel);
    }
}

