/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.util.ArrayList;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.geom.GeomLocator;
import merlin.geom.IMerlinGeomSrc;
import merlin.mv.ModelView;
import merlin.mv.Snappers.GridSnapper;
import merlin.mv.displays.AgentRenderer;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickConfig;
import thunderheadeng.scene3d.picking.IPickRoot;
import thunderheadeng.scene3d.picking.IPickSession;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.tools.IAdvancedTool;
import thunderheadeng.util.theUtil;

public class MerlinPickRoot
implements IPickRoot {
    private static final Class[] PICK_PREFS = new Class[]{IHandle.class, IBehaviorAction.class, Attractor.class, IQueueElement.class, OccTarget.class, EgressBlockage.class, IEgressConnector.class, EgressCorridor.class, IEgressComp.class};
    private final MerlinData d_data;
    private final ModelView d_mv;
    private final AgentRenderer d_renderer;

    public MerlinPickRoot(MerlinData md, ModelView mv, AgentRenderer renderer) {
        this.d_data = md;
        this.d_mv = mv;
        this.d_renderer = renderer;
    }

    @Override
    public IPickSession beginPicking() {
        return new Session();
    }

    private class Session
    implements IPickSession {
        private final Camera d_camera;
        private final Predicate<Object> d_isWireframe;
        private int d_active;
        private MerlinData.ReadLock d_lock;

        private Session() {
            this.d_camera = MerlinPickRoot.this.d_mv.getMainView().getCamera();
            this.d_isWireframe = MerlinPickRoot.this.d_mv.getDisplayManager().getWireframeTester();
            this.d_active = 0;
            this.d_lock = null;
        }

        @Override
        public boolean isActive() {
            return this.d_active > 0;
        }

        @Override
        public void begin() {
            if (this.d_active++ == 0) {
                assert (this.d_lock == null);
                this.d_lock = MerlinPickRoot.this.d_data.lockRead();
            }
        }

        @Override
        public void end() {
            if (--this.d_active == 0) {
                assert (this.d_lock != null);
                this.d_lock.close();
                this.d_lock = null;
            }
        }

        @Override
        public IPickConfig[] getPickConfigs() {
            assert (this.isActive());
            ArrayList<IPickConfig> configs = new ArrayList<IPickConfig>();
            configs.add(new EgressConfig());
            boolean allVisible = true;
            ArrayList<ImportConfig> floorConfigs = new ArrayList<ImportConfig>();
            for (Floor floor : MerlinPickRoot.this.d_data.floors.getMembers(Floor.class)) {
                if (!floor.isVisible()) continue;
                ConvexHull clip = MerlinPickRoot.this.d_data.floors.getClippingRegion(floor);
                floorConfigs.add(new ImportConfig(clip));
                allVisible &= clip.acceptsAll();
            }
            if (allVisible) {
                configs.add(new ImportConfig(new ConvexHull(new Plane3d[0])));
            } else {
                configs.addAll(floorConfigs);
            }
            return theUtil.toArray(configs, IPickConfig.class);
        }

        @Override
        public boolean isVisible(IPickConfig config, Object o) {
            assert (this.isActive());
            if (MerlinPickRoot.this.d_mv.getHandleMgr().isModifying() && (o instanceof IHandle || MerlinPickRoot.this.d_mv.getHandleMgr().isModifying(o))) {
                return false;
            }
            return MerlinPickRoot.this.d_data.isVisible(o);
        }

        @Override
        public boolean isWireframe(IPickConfig config, Object o) {
            assert (this.isActive());
            return this.d_isWireframe.test(o);
        }

        @Override
        public boolean isOcclusionTarget(Object o, boolean occludeGuides) {
            assert (this.isActive());
            if (o instanceof IHandle && MerlinPickRoot.this.d_mv.getHandleMgr().getCurrentSourceObj() instanceof EgressAgent) {
                return false;
            }
            if (occludeGuides) {
                return true;
            }
            if (o instanceof GridSnapper) {
                return this.d_camera instanceof PerspectiveCamera;
            }
            return !(o instanceof ISnapConstraint);
        }

        @Override
        public boolean isOcclusionSource(Object o) {
            assert (this.isActive());
            return !(o instanceof IHandle);
        }

        @Override
        public int compare(Object o1, Object o2) {
            assert (this.isActive());
            int diff = this.getClassPreference(o1) - this.getClassPreference(o2);
            if (diff == 0) {
                // empty if block
            }
            return diff;
        }

        private int getClassPreference(Object obj) {
            for (int m = 0; m < PICK_PREFS.length; ++m) {
                if (!PICK_PREFS[m].isInstance(obj)) continue;
                return m;
            }
            return PICK_PREFS.length;
        }

        private double getVolume(Object o) {
            if (o instanceof IMerlinGeomSrc) {
                AABox bounds = ((IMerlinGeomSrc)o).getBounds();
                return bounds != null ? bounds.volume(2.220446049250313E-16) : Double.MAX_VALUE;
            }
            return Double.MAX_VALUE;
        }

        public boolean isFloorFilteredGeom(MerlinData md, Object object) {
            return MerlinPickRoot.this.d_mv.getDisplayManager().isClippedByFloor(object);
        }

        @Override
        public void pickPoints(IPickable obj, IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
            assert (this.isActive());
            obj.pickPoints(isects, filter, rayBegin, rayDirN, maxDist, tester, MerlinPickRoot.this.d_mv.getDisplayProps());
        }

        @Override
        public void pickBox(IPickable obj, IBoxCollector result, IIsectFilter filter, ConvexHull region) {
            assert (this.isActive());
            obj.pickBox(result, filter, region, MerlinPickRoot.this.d_mv.getDisplayProps());
        }

        private void findAdditionalSnaps(ITest<AABox> test, IResult<IPickable> result) {
            IPickSession.findAdditionalSnaps(test, result, this.d_camera, MerlinPickRoot.this.d_mv.getHandleMgr().isModifying(), () -> {
                Tool tool = MerlinPickRoot.this.d_mv.getTools().getCurrentTool();
                if (tool instanceof IAdvancedTool) {
                    return ((IAdvancedTool)tool).getAngledSnapBasis();
                }
                return null;
            });
        }

        public void find(ITest<AABox> test, IResult<IPickable> result, boolean quick, boolean filterByFloor) {
            assert (this.isActive());
            GeomLocator locator = MerlinPickRoot.this.d_data.geomLocation.getLocator();
            IResult<IPickable> baseResult = result;
            IResult<IDisplayableGeomSrc> fresult = (obj, ctmt) -> {
                if (obj instanceof IPickable && filterByFloor == this.isFloorFilteredGeom(MerlinPickRoot.this.d_data, obj)) {
                    baseResult.mark((IPickable)((Object)obj), ctmt);
                }
            };
            int options = 0;
            if (quick) {
                options |= 4;
            }
            locator.find(test, fresult, options);
        }

        private class EgressConfig
        implements IPickConfig {
            private EgressConfig() {
            }

            @Override
            public ConvexHull getClippingRegion() {
                return new ConvexHull(new Plane3d[0]);
            }

            @Override
            public void find(ITest<AABox> test, IResult<IPickable> result, boolean quick) {
                result.mark(MerlinPickRoot.this.d_renderer, Containment.INTERSECTS);
                Session.this.findAdditionalSnaps(test, result);
                Session.this.find(test, result, quick, false);
            }
        }

        private class ImportConfig
        implements IPickConfig {
            private final ConvexHull d_clip;

            public ImportConfig(ConvexHull ch) {
                this.d_clip = ch;
            }

            @Override
            public ConvexHull getClippingRegion() {
                return this.d_clip;
            }

            @Override
            public void find(ITest<AABox> test, IResult<IPickable> result, boolean quick) {
                Session.this.find(test, result, quick, true);
            }
        }
    }
}

