/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.behaviors;

import java.util.Set;
import java.util.function.Function;
import merlin.Intl;
import merlin.builders.GotoOccActionBuilder;
import merlin.data.egress.scripting.GotoOcc;
import merlin.gui.MerlinValueFields;
import merlin.gui.StrTagsField;
import merlin.gui.guiUtil;
import merlin.mv.gui.behaviors.ANewBehaviorActionPnl;
import merlin.mv.gui.behaviors.ActionCreatePnl;
import merlin.mv.gui.behaviors.BehaviorPnl;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;

public class NewGotoOccPanel
extends ANewBehaviorActionPnl<GotoOccActionBuilder> {
    private static final long serialVersionUID = 1L;

    public NewGotoOccPanel() {
        super(new Object[0]);
        this.addSection(new BehaviorPnl());
        this.addSeparator();
        this.addSection(new ActionCreatePnl());
    }

    @Override
    public void activate() {
        guiDialog dlg = new guiDialog(guiUtil.getWindow(this), Intl.intl("Goto Occupant"), 9);
        dlg.getButton(1).setText(ANewBehaviorActionPnl.CREATE);
        Function<IDisplayProp, guiLabel> lbl = prop -> guiUtil.lblHtml(String.format(Intl.intl("%s:"), prop.getDisplayName()), prop.getDisplayDesc());
        guiComboBox<GotoOcc.TagLogic> tagLogicCombo = guiUtil.newCombo(o -> guiUtil.encodeToHtmlLabel(o.name, o.desc), GotoOcc.TagLogic.values());
        StrTagsField tagsFld = new StrTagsField();
        tagsFld.setNullAllowed(false);
        tagsFld.setColumns(10);
        guiComboBox<GotoOcc.DistancePref> distPrefCombo = guiUtil.newEnumCombo(GotoOcc.DistancePref.class);
        guiComboBox<GotoOcc.Tracking> trackingCombo = guiUtil.newEnumCombo(GotoOcc.Tracking.class);
        ValueField<UnitDouble> arrivalRadiusFld = MerlinValueFields.udFld(0.0, DoubleVR.above(0.0, true), (Unit)SI.METER, 0);
        guiComboBox<GotoOcc.TargetNotFound> noOccs = guiUtil.newEnumCombo(GotoOcc.TargetNotFound.class);
        guiComboBox<GotoOcc.TargetUnreachable> unreachable = guiUtil.newEnumCombo(GotoOcc.TargetUnreachable.class);
        tagLogicCombo.setSelectedItem(((GotoOccActionBuilder)this.props()).get(GotoOcc.PROP_TAG_LOGIC));
        tagsFld.setTypedValue(((GotoOccActionBuilder)this.props()).get(GotoOccActionBuilder.STR_TAGS));
        distPrefCombo.setSelectedItem(((GotoOccActionBuilder)this.props()).get(GotoOcc.PROP_DIST_PREF));
        trackingCombo.setSelectedItem(((GotoOccActionBuilder)this.props()).get(GotoOcc.PROP_TRACKING));
        arrivalRadiusFld.setTypedValue(((GotoOccActionBuilder)this.props()).get(GotoOcc.PROP_ARRIVAL_RADIUS));
        noOccs.setSelectedItem(((GotoOccActionBuilder)this.props()).get(GotoOcc.PROP_NO_OCCUPANTS));
        unreachable.setSelectedItem(((GotoOccActionBuilder)this.props()).get(GotoOcc.PROP_UNREACHABLE));
        guiPanel tagsComponents = new guiPanel();
        GridBagHelper gb = new GridBagHelper(tagsComponents);
        gb.addRow(tagLogicCombo, tagsFld, 1.0);
        guiPanel mainPnl = dlg.getDialogPane();
        GridBagHelper gb2 = new GridBagHelper(mainPnl);
        gb2.addRow(lbl.apply(GotoOcc.PROP_GOTO_TAGS), tagsComponents, 1.0);
        gb2.addRow(lbl.apply(GotoOcc.PROP_DIST_PREF), distPrefCombo, 1.0);
        gb2.addRow(lbl.apply(GotoOcc.PROP_TRACKING), trackingCombo, 1.0);
        gb2.addRow(lbl.apply(GotoOcc.PROP_ARRIVAL_RADIUS), arrivalRadiusFld, 1.0);
        gb2.addRow(lbl.apply(GotoOcc.PROP_NO_OCCUPANTS), noOccs, 1.0);
        gb2.addRow(lbl.apply(GotoOcc.PROP_UNREACHABLE), unreachable, 1.0);
        gb2.finalizeRows();
        if (dlg.doModal() != 1) {
            this.cancel();
            return;
        }
        ((GotoOccActionBuilder)this.props()).pause();
        ((GotoOccActionBuilder)this.props()).set(GotoOcc.PROP_TAG_LOGIC, tagLogicCombo.getSelectedItem());
        ((GotoOccActionBuilder)this.props()).set(GotoOccActionBuilder.STR_TAGS, (Set)tagsFld.getValue());
        ((GotoOccActionBuilder)this.props()).set(GotoOcc.PROP_DIST_PREF, distPrefCombo.getSelectedItem());
        ((GotoOccActionBuilder)this.props()).set(GotoOcc.PROP_TRACKING, trackingCombo.getSelectedItem());
        ((GotoOccActionBuilder)this.props()).set(GotoOcc.PROP_ARRIVAL_RADIUS, (UnitDouble)arrivalRadiusFld.getValue());
        ((GotoOccActionBuilder)this.props()).set(GotoOcc.PROP_NO_OCCUPANTS, noOccs.getSelectedItem());
        ((GotoOccActionBuilder)this.props()).set(GotoOcc.PROP_UNREACHABLE, unreachable.getSelectedItem());
        ((GotoOccActionBuilder)this.props()).resume();
        this.create();
    }
}

