/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui.behaviors;

import java.awt.Component;
import java.util.Collection;
import java.util.function.Consumer;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.builders.GotoActionBuilder;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.elevators.Elevator;
import merlin.gui.APropEditPanel;
import merlin.gui.ElevatorChooser;
import merlin.gui.ElevatorFloorComboBox;
import merlin.mv.gui.behaviors.ANewBehaviorActionPnl;
import merlin.mv.gui.behaviors.ActionCreatePnl;
import merlin.mv.gui.behaviors.BehaviorPnl;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.guiLabel;

public class NewGotoElevatorsPnl
extends ANewBehaviorActionPnl<GotoActionBuilder> {
    private static final long serialVersionUID = 1L;
    Consumer<Collection<Elevator>> d_updateFloorElevators;

    public NewGotoElevatorsPnl() {
        super(new Object[0]);
        MerlinData md = MerlinApp.getApp().getData();
        this.addSection(new BehaviorPnl());
        this.addSeparator();
        this.addSection(new ElevatorPanel(md));
        this.addSeparator();
        this.addSection(new ActionCreatePnl());
    }

    private class ElevatorPanel
    extends APropEditPanel<GotoActionBuilder> {
        private static final long serialVersionUID = 1L;
        private final ElevatorChooser d_chooser;
        private final ElevatorFloorComboBox d_floor;

        public ElevatorPanel(MerlinData md) {
            super(GotoActionBuilder.DEST_CHANGED);
            this.d_floor = new ElevatorFloorComboBox(md);
            NewGotoElevatorsPnl.this.d_updateFloorElevators = elevators -> {
                if (elevators.isEmpty()) {
                    this.d_floor.setElevators(md, md.elevators.flatten(Elevator.class));
                } else {
                    this.d_floor.setElevators(md, (Collection<Elevator>)elevators);
                }
            };
            this.d_chooser = new ElevatorChooser(md, NewGotoElevatorsPnl.this.d_updateFloorElevators);
            this.d_chooser.setButtonLabel(8, ANewBehaviorActionPnl.GO_BACK);
            this.setLayout(new MigLayout("al center center, insets 0, gap 6"));
            this.add(new guiLabel(Intl.intl("Elevators:")));
            this.add(this.d_chooser);
            this.add((Component)new guiLabel(Intl.intl("Target Floor:")), "newline");
            this.add((Component)this.d_floor, "growx");
            this.initComboBox(this.d_floor);
            this.d_chooser.addValueListener(e -> NewGotoElevatorsPnl.this.d_updateFloorElevators.accept(this.d_chooser.getElevators()));
            this.d_chooser.addPropertyChangeListener("edit", e -> {
                if (((Boolean)e.getNewValue()).booleanValue()) {
                    NewGotoElevatorsPnl.this.d_updateFloorElevators.accept(this.d_chooser.getElevators());
                    this.getUpdateToCommand().updateProp(this, true);
                }
            });
        }

        @Override
        protected void updateFromProps(GotoActionBuilder props) {
            this.d_chooser.setObjs(props.getElevators());
            this.d_floor.setSelectedItem(props.getTargetFloor());
        }

        @Override
        protected void updateToProps(GotoActionBuilder props) {
            props.setElevatorDest(this.d_chooser.getElevators());
            props.setFloorDest((Floor)this.d_floor.getSelectedItem());
        }
    }
}

