/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import common.data.EscalatorPreference;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3f;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.CompElementActions;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.ObjsFilter;
import merlin.data.Proxy;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.IProfileProp;
import merlin.data.egress.agents.IProfilePropDist;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.ProfileProps;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.tag.Tag;
import merlin.data.value.ConstFunction1d;
import merlin.data.value.IFunction1d;
import merlin.gui.AvatarEditor;
import merlin.gui.MerlinComboBox;
import merlin.gui.MerlinUDF;
import merlin.gui.TagsEditor;
import merlin.gui.agents.AttractorsFilterEditorComponents;
import merlin.gui.agents.CompRestrictionsEditor;
import merlin.gui.agents.PersonalDistanceEditor;
import merlin.gui.agents.ShapeEditor;
import merlin.gui.agents.SpeedInSmokeEditor;
import merlin.gui.filter.ObjsFilterEditor;
import merlin.gui.filter.ObjsFilterEditorComponents;
import merlin.gui.guiUtil;
import merlin.gui.labels.ILabelGenerator;
import merlin.gui.labels.WrappedComp;
import merlin.gui.value.Function1dEditorFactory;
import merlin.mv.gui.SelectionEditorPanel;
import merlin.unitsystem.SIUS;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Comm;
import thunderheadeng.gui.DlgListener;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.gui.guiValueField;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.gui.value.PopupValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Events;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.Urn;

public class OccEditorPanel {
    private final List<SelectionEditorPanel.EditorPanel> d_panels;

    public OccEditorPanel(MerlinData data) {
        this.d_panels = Arrays.asList(new DefPanel(data), new PropsPnl(data), new ExtraPnl(), new AdvancedPnl());
    }

    public List<SelectionEditorPanel.EditorPanel> getPanels() {
        return this.d_panels;
    }

    private void setUDFToText(guiValueField<UnitDouble> fld, String txt) {
        fld.addSpecialValue(txt, new UnitDouble(0.0, Unit.ONE));
        fld.setText(txt);
        fld.removeSpecialValue(txt);
        fld.setEditable(false);
    }

    public static WrappedComp<guiMultiStateCheckBox> newOverrideCheckbox(SelectionEditorPanel.EditorPanel panel, ILabelGenerator labels, String text, String tooltip, boolean checked, EgressAgent.AgentProfProp<?, ?, ?> overrideProps) {
        WrappedComp<guiMultiStateCheckBox> result = labels.checkbox(overrideProps, text, tooltip);
        ((guiMultiStateCheckBox)result.comp).setSelected(checked);
        ((guiMultiStateCheckBox)result.comp).setCheckAfterSemi(true);
        return result;
    }

    private static <SampledT, DistT extends IDistributedVal<SampledT>> PropField<SampledT, DistT, guiPanel> newPropField(SelectionEditorPanel.EditorPanel panel, MerlinData md, ILabelGenerator labels, IProfilePropDist<SampledT, DistT> prop) {
        return new PropField(panel, labels, prop, OccEditorPanel.getEditor(md, prop), OccEditorPanel.editorConn(true), prop.getDisplayName(), prop.getHtmlDescr());
    }

    private static <SampledT, DistT extends IDistributedVal<SampledT>> IValEditor<SampledT> getEditor(MerlinData md, IProfilePropDist<SampledT, DistT> prop) {
        assert (prop.getSampledValEditor() != null);
        return prop.getSampledValEditor().get(md, false);
    }

    private static <OccT, ProfT> CompElementActions.IObjectProp<IMerlinObj, OccT> translateProp(IProfileProp<OccT, ProfT> prop) {
        return new CompElementActions.MappedProp<IMerlinObj, Object, EgressAgent.AgentValue>(new CompElementActions.DefProp(EgressAgent.asAgentOccProp(prop), true), (obj, agentVal) -> agentVal.value(), (obj, occVal) -> new EgressAgent.AgentValue<Object>(true, occVal));
    }

    private static PropField<IFunction1d, IFunction1d, JComponent> newFunctionProp(SelectionEditorPanel.EditorPanel panel, ILabelGenerator labels, ProfileProps.ProfileFunction1dProp prop) {
        return new PropField<IFunction1d, IFunction1d, JComponent>(panel, labels, prop, Function1dEditorFactory.nonNullable(prop.fprop, false, () -> prop.defVal != null ? (IFunction1d)prop.defVal : new ConstFunction1d(SIUS.newud(0.0, prop.fprop.y.unitType)), Function1dEditorFactory.GENERAL_TYPES), OccEditorPanel.editorConn(true), prop.getDisplayName(), prop.getDisplayDesc());
    }

    private static PropField<OccProfile.IProfileFunction, OccProfile.IProfileFunction, JComponent> newSlopeFunctionProp(SelectionEditorPanel.EditorPanel panel, ILabelGenerator labels, ProfileProps.ProfileFunctionProp prop) {
        return new PropField<OccProfile.IProfileFunction, OccProfile.IProfileFunction, JComponent>(panel, labels, prop, OccProfile.newSlopedFundEditor(prop, () -> prop.defVal instanceof OccProfile.ConstProfileFunction ? ((OccProfile.ConstProfileFunction)prop.defVal).function : new ConstFunction1d(SIUS.newud(0.0, prop.fprop.y.unitType))), OccEditorPanel.editorConn(true), prop.fprop.desc, prop.fprop.longDesc);
    }

    private static INewConnection<UnitDouble, ICurve, MerlinUDF> udfConn() {
        return (field, live) -> {
            CompElementActions.IObjectProp<IMerlinObj, UnitDouble> oprop = OccEditorPanel.translateProp(field.prop);
            SelectionEditorPanel.UDPropConnection udconn = new SelectionEditorPanel.UDPropConnection(oprop, (guiUnitDoubleField)field.comp);
            udconn.setLive(live);
            return udconn;
        };
    }

    private static <OccT, ProfT, CompT extends JComponent> INewConnection<OccT, ProfT, CompT> editorConn(boolean overrideEnter) {
        return (field, live) -> {
            CompElementActions.IObjectProp oprop = OccEditorPanel.translateProp(field.prop);
            SelectionEditorPanel.ValEditorConn vconn = new SelectionEditorPanel.ValEditorConn(oprop, field.editor, overrideEnter);
            vconn.setLive(live);
            return vconn;
        };
    }

    public static class DefPanel
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -5377075130628786541L;
        private final guiComboBox<OccProfile> d_cbProfiles;
        private final guiComboBox<Behavior> d_behaviorCB;

        public DefPanel(MerlinData data) {
            this.d_cbProfiles = new MerlinComboBox(data, OccProfile.class, (IMerlinObj[])new OccProfile[0]);
            SelectionEditorPanel.ComboPropConn profConn = new SelectionEditorPanel.ComboPropConn(Intl.intl("Edit Base Profile"), new CompElementActions.DefProp<OccProfile>(EgressAgent.PARENT_PROFILE), this.d_cbProfiles);
            data.getEvents().addObserver(profConn);
            this.addConnection(profConn);
            this.d_behaviorCB = new MerlinComboBox(data, Behavior.class, (IMerlinObj[])new Behavior[0]);
            SelectionEditorPanel.ComboPropConn behaviorConn = new SelectionEditorPanel.ComboPropConn(Intl.intl("Edit Behavior"), new CompElementActions.DefProp<Behavior>(EgressAgent.BEHAVIOR), this.d_behaviorCB);
            data.getEvents().addObserver(behaviorConn);
            this.addConnection(behaviorConn);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(SelectionEditorPanel.lblOverride(this, EgressAgent.PARENT_PROFILE), this.d_cbProfiles, 1.0, 0);
            gb.addRow(SelectionEditorPanel.lblOverride(this, EgressAgent.BEHAVIOR), this.d_behaviorCB, 1.0, 0);
        }
    }

    public static class PropsPnl
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = -2372456976652027835L;
        private final PropField<Integer, IUrn<Integer>, guiIntField> d_priority;
        private final CurveField d_speed;
        private PropField<OccProfile.OccShape, OccProfile.OccShape, ShapeEditor> d_shapeEditor;

        public PropsPnl(MerlinData md) {
            ILabelGenerator labels = SelectionEditorPanel.getSelectionOverrideCallback();
            this.d_priority = new PropField<Integer, IUrn<Integer>, guiIntField>((SelectionEditorPanel.EditorPanel)this, labels, OccProfile.PROP_PRIORITY_LEVEL, (field, live) -> new SelectionEditorPanel.IntPropConn(OccEditorPanel.translateProp(field.prop), (guiIntField)field.comp), new guiIntField(IntVR.above(0, true)), Intl.intl("Priority"), Intl.intl("Occupant priority - higher values indicate higher priority"));
            this.d_priority.connect(this);
            this.d_speed = new CurveField(this, labels, OccProfile.PROP_MAXVEL, 5, Intl.intl("Speed"), Intl.intl("Maximum velocity"));
            this.d_speed.connect(this);
            this.d_shapeEditor = new PropField((SelectionEditorPanel.EditorPanel)this, labels, OccProfile.PROP_SHAPE, new ShapeEditor(md, 1, labels), (field, live) -> new ShapePropConn((ShapeEditor)field.comp), Intl.intl("Shape"), guiUtil.encodeToHtmlLabel(Intl.intl("Shape of the occupant.")));
            this.d_shapeEditor.connect(this);
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 2;
            gb.addRow(this.d_priority.localCB, this.d_priority.comp, 1.0, 0);
            gb.addRow(this.d_speed.localCB, this.d_speed.comp, 1.0, 0);
            gb.addRow(this.d_shapeEditor.localCB, this.d_shapeEditor.comp, 1.0, 0);
        }
    }

    public static class ExtraPnl
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 3102895775937067288L;
        private final PropField<Point3f, Point3f, ColorButton> d_color;
        private final PropField<IAvatar, IUrn<IAvatar>, AvatarEditor> d_model;
        private CurveField d_orient;

        public ExtraPnl() {
            ILabelGenerator labels = SelectionEditorPanel.getSelectionOverrideCallback();
            this.d_color = new PropField((SelectionEditorPanel.EditorPanel)this, labels, OccProfile.PROP_COLOR, (field, live) -> new ColorPropConn((ColorButton)field.comp), new ColorButton(1), Intl.intl("Color"), Intl.intl("Color used to draw occupants"));
            this.d_color.connect(this);
            this.d_model = new PropField<IAvatar, IUrn<IAvatar>, AvatarEditor>((SelectionEditorPanel.EditorPanel)this, labels, OccProfile.PROP_OCCMODEL, (field, live) -> new ModelPropConn((AvatarEditor)field.comp), new AvatarEditor(2, ResourceAvatar.Type.OCCUPANT), Intl.intl("3D Model"), Intl.intl("3D model used to show this occupant."));
            this.d_model.connect(this);
            this.d_orient = new CurveField(this, labels, OccProfile.PROP_INIT_ORIENT, 7, Intl.intl("Orientation"), Intl.intl("Initial orientation in degrees from positive x axis counter-clockwise"));
            this.d_orient.connect(this);
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 2;
            gb.addRow(this.d_color.localCB, this.d_color.comp, 1.0, 0);
            gb.addRow(this.d_model.localCB, this.d_model.comp, 1.0, 0);
            gb.addRow(this.d_orient.localCB, this.d_orient.comp, 1.0, 0);
        }
    }

    private static class AdvancedPnl
    extends SelectionEditorPanel.EditorPanel {
        private static final long serialVersionUID = 3299495978619698103L;
        private final JButton d_advancedPropsBtn;
        private final JButton d_resetPropsBtn;
        private Collection<IMerlinObj> d_currObjs = Collections.EMPTY_LIST;

        public AdvancedPnl() {
            this.d_advancedPropsBtn = new JButton(Intl.intl("More..."));
            this.d_advancedPropsBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.editAdvanced();
                }
            });
            this.d_resetPropsBtn = new JButton(Intl.intl("Reset..."));
            this.d_resetPropsBtn.setToolTipText(Intl.intl("Clear customized parameters"));
            this.d_resetPropsBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int option = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Are you sure you want to clear all customized parameters?"), Intl.intl("Clear Custom Parameters?"), 0);
                    if (option != 0) {
                        return;
                    }
                    this.resetParams();
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_advancedPropsBtn, 1.0, 0);
            gb.addRow(this.d_resetPropsBtn, 1.0, 0);
        }

        @Override
        public void bind(Collection<? extends IMerlinObj> objs) {
            super.bind(objs);
            this.d_currObjs = new ArrayList<IMerlinObj>(objs);
            this.updateEnabled();
        }

        @Override
        public void release() {
            super.release();
            this.d_currObjs = Collections.EMPTY_LIST;
        }

        @Override
        public void update(Events events) {
            this.updateEnabled();
        }

        private void updateEnabled() {
            this.d_resetPropsBtn.setEnabled(!AdvancedPnl.getResetAgents(this.d_currObjs).isEmpty());
        }

        protected void editAdvanced() {
            AdvancedDlg dlg = new AdvancedDlg((Window)MerlinApp.getApp().getActiveFrame(), this);
            dlg.load(this.d_currObjs);
            dlg.doModal();
        }

        private static Collection<EgressAgent> getResetAgents(Collection<IMerlinObj> objs) {
            Collection<EgressAgent> agents = MerlinUtil.flatten(objs, EgressAgent.class, new Predicate<EgressAgent>(){

                @Override
                public boolean test(EgressAgent o) {
                    return o.getProfile().getNumLocal() != 0;
                }
            });
            Collection<Proxy> agentProxies = MerlinUtil.flatten(objs, Proxy.class, new Predicate<Proxy>(){

                @Override
                public boolean test(Proxy p) {
                    Object obj = p.getObj();
                    if (!(obj instanceof EgressAgent)) {
                        return false;
                    }
                    return ((EgressAgent)obj).getProfile().getNumLocal() != 0;
                }
            });
            if (agentProxies.isEmpty()) {
                return agents;
            }
            LinkedIdentityHashSet<EgressAgent> allResetAgents = new LinkedIdentityHashSet<EgressAgent>(agents);
            for (Proxy p : agentProxies) {
                EgressAgent a = (EgressAgent)p.getObj();
                allResetAgents.add(a);
            }
            return allResetAgents;
        }

        protected void resetParams() {
            MerlinData md = MerlinApp.getApp().getData();
            md.pauseUpdates();
            Collection<EgressAgent> agents = AdvancedPnl.getResetAgents(this.d_currObjs);
            Undo.begin(Intl.intl("Reset Occupant Params"));
            Undo.insertUndoEntry_restore(md, agents);
            for (EgressAgent agent : agents) {
                OccProfile.streamProfileProps().filter(prop -> agent.getProfile().isDefinedLocally(prop.asProp())).forEach(prop -> agent.removeProfileValue((IProfileProp<?, ?>)prop));
            }
            Undo.end(md);
            md.resumeUpdates();
        }
    }

    private static class PropField<OccT, ProfT, CompT extends Component> {
        public final IProfileProp<OccT, ProfT> prop;
        public final WrappedComp<guiMultiStateCheckBox> localCB;
        public final CompT comp;
        public final IValEditor<OccT> editor;
        public final INewConnection<OccT, ProfT, CompT> newConn;

        public PropField(SelectionEditorPanel.EditorPanel panel, ILabelGenerator labels, IProfileProp<OccT, ProfT> prop, INewConnection<OccT, ProfT, CompT> newConn, CompT comp, String desc, String tooltip) {
            this(panel, labels, prop, comp instanceof IValEditor ? (veditor = (IValEditor)comp) : null, newConn, comp, desc, tooltip);
            IValEditor veditor;
        }

        public PropField(SelectionEditorPanel.EditorPanel panel, ILabelGenerator labels, IProfileProp<OccT, ProfT> prop, IValEditor<OccT> editor, INewConnection<OccT, ProfT, CompT> newConn, String desc, String tooltip) {
            this(panel, labels, prop, editor, newConn, editor.getComponent(), desc, tooltip);
        }

        private PropField(SelectionEditorPanel.EditorPanel panel, ILabelGenerator labels, IProfileProp<OccT, ProfT> prop, IValEditor<OccT> editor, INewConnection<OccT, ProfT, CompT> newConn, CompT comp, String desc, String tooltip) {
            this.prop = prop;
            this.localCB = OccEditorPanel.newOverrideCheckbox(panel, labels, String.format(Intl.intl("%s:"), desc), tooltip, false, EgressAgent.asAgentProfProp(prop));
            this.comp = comp;
            this.editor = editor;
            LinkStatus.link((AbstractButton)this.localCB.comp, new Component[]{comp});
            this.newConn = newConn;
        }

        public SelectionEditorPanel.BoolPropConnection newIsLocalConn(boolean live) {
            SelectionEditorPanel.BoolPropConnection conn = new SelectionEditorPanel.BoolPropConnection(new IsLocalProp<OccT, ProfT>(this.prop), (guiMultiStateCheckBox)this.localCB.comp);
            conn.setLive(live);
            return conn;
        }

        public void connect(SelectionEditorPanel.EditorPanel pnl) {
            pnl.addConnection(this.newIsLocalConn(true));
            pnl.addConnection(this.newConn.create(this, true));
        }
    }

    private static interface INewConnection<OccT, ProfT, CompT extends Component> {
        public SelectionEditorPanel.IPropConnection create(PropField<OccT, ProfT, CompT> var1, boolean var2);
    }

    private static class AttrRestrDlg
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        public final AttractorsFilterEditorComponents restrPanel = new AttractorsFilterEditorComponents(MerlinApp.getApp().getData(), true);

        public AttrRestrDlg(Window parent, MerlinData md) {
            super(parent, Intl.intl("Trigger Restrictions"), 9);
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            this.restrPanel.addToLayout(gb);
            gb.finalizeRows();
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            return this.restrPanel.validateData(this, showWarn, allowModify);
        }
    }

    private static class AttrRestrictionsEditor
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final HTMLBtn editor = new HTMLBtn("");
        private ObjsFilter<Attractor> restrictions;
        protected boolean d_modified = false;

        public AttrRestrictionsEditor(MerlinData md) {
            this.editor.setWrapEnabled(false);
            this.editor.setPreferredWidth(150);
            this.editor.addActionListener(e -> {
                if (this.editor.isEnabled()) {
                    ObjsFilter newVal;
                    Window owner = SwingUtilities.getWindowAncestor(this);
                    AttrRestrDlg dlg = new AttrRestrDlg(owner, md);
                    dlg.restrPanel.setValue(this.restrictions);
                    if (dlg.doModal() == 1 && !Objects.equals(newVal = dlg.restrPanel.getValue(), this.restrictions)) {
                        this.restrictions = newVal;
                        this.setModified(true);
                        this.updateDesc();
                    }
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.editor, new double[]{1.0, 1.0});
        }

        public ObjsFilter<Attractor> commit() {
            return this.restrictions;
        }

        private void updateDesc() {
            if (this.restrictions != null) {
                String str = this.restrictions.toString();
                this.editor.setText(str);
                this.editor.setToolTipText(str);
            } else {
                this.editor.setText(Intl.intl("&lt;mixed&gt;"));
                this.editor.setToolTipText(null);
            }
        }

        public void init(ObjsFilter<Attractor> restrictions) {
            this.restrictions = restrictions;
            this.updateDesc();
        }

        @Override
        public void setModified(boolean modified) {
            this.d_modified = modified;
            super.setModified(modified);
        }

        @Override
        public boolean isModified() {
            return this.d_modified;
        }
    }

    private static class AttrRestrictionConn
    extends SelectionEditorPanel.ASinglePropConnection<CompElementActions.IObjectProp<IMerlinObj, ObjsFilter<Attractor>>, AttrRestrictionsEditor> {
        public AttrRestrictionConn(MerlinData md, CompElementActions.IObjectProp<IMerlinObj, ObjsFilter<Attractor>> prop, AttrRestrictionsEditor control) {
            super(prop, control);
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, ObjsFilter<Attractor>> prop, Collection<? extends IMerlinObj> objs, AttrRestrictionsEditor comp) {
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Trigger Restrictions"), prop, objs, comp.commit());
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, ObjsFilter<Attractor>> prop, Collection<? extends IMerlinObj> objs, AttrRestrictionsEditor comp) {
            PropValue<ObjsFilter<Attractor>> restr = prop.get(MerlinApp.getApp().getData(), objs);
            comp.init(restr.orElse(null));
            comp.setModified(false);
        }
    }

    private static class AdvancedDlg
    extends guiDialog
    implements DlgListener {
        private static final long serialVersionUID = -1146490481750944077L;
        private final List<?> d_fields;
        private final List<Pair<SelectionEditorPanel.BoolPropConnection, SelectionEditorPanel.IPropConnection>> d_connections;
        private Collection<IMerlinObj> d_currObjs = Collections.emptyList();

        public AdvancedDlg(Window parent, SelectionEditorPanel.EditorPanel panel) {
            super(parent, Intl.intl("Additional Occupant Parameters"), 11);
            Comm comm = new Comm();
            MerlinData md = MerlinApp.getApp().getData();
            SelectionEditorPanel.LabelGenerator labels = new SelectionEditorPanel.LabelGenerator(md){

                @Override
                public void applyOverride(Collection<? extends IDisplayProp<?>> props, boolean setCustomized) {
                    if (this.isModified()) {
                        String msg = setCustomized ? Intl.intl("Do you want to commit your unsaved changes before customizing this property? NOTE: Pressing \"No\" will reset this editor back to its initial state.") : Intl.intl("Do you want to commit your unsaved changes before removing this property customization? NOTE: Pressing \"Yes\" will reset the current property to its default scenario value regardless. Pressing \"No\" will reset this editor back to its initial state.");
                        int selection = JOptionPane.showConfirmDialog(this, msg, Intl.intl("Commit unsaved changes?"), 1);
                        switch (selection) {
                            case 0: {
                                this.apply();
                                break;
                            }
                            case 1: {
                                this.reset();
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    super.applyOverride(props, setCustomized);
                    this.reset();
                }
            };
            this.addDlgListener(this);
            this.d_fields = Arrays.asList(new TabLbl(Intl.intl("Movement")), !MerlinApp.isFP() ? null : new BooleanField(panel, labels, OccProfile.PROP_ASSIST, Intl.intl("Yes"), Intl.intl("No"), false, Intl.intl("Requires Assistance"), null), new BooleanField(panel, labels, OccProfile.PROP_REQUIRES_ASSISTANCE, Intl.intl("Yes"), Intl.intl("No"), false, Intl.intl("Requires Assistance to Move"), Intl.intl("Recommended for occupants that are unable to move under their own power (e.g. in a bed or other carrying device).")), new BooleanField(panel, labels, OccProfile.PROP_OBEY_ONEWAY_DOORS, Intl.intl("Yes"), Intl.intl("No"), true, Intl.intl("Ignore One-way Door Restrictions"), guiUtil.encodeToHtmlLabel(Intl.intl("Controls whether occupants observe directionality of one-way doors,<br>stairs, and ramps. If they ignore it, they will go through in either <br>direction; if not, they will go only in the required direction."))), new EnumField(panel, (ILabelGenerator)labels, OccProfile.PROP_ESCALATOR_PREF, Intl.intl("Escalator Preference"), Intl.intl("Controls if occupants walk on escalators and moving walkways, or if they stand, where they stand"), (Enum[])EscalatorPreference.values(), val -> val != null ? val.name : ""), new PropField<UnitDouble, ICurve, MerlinUDF>(panel, (ILabelGenerator)labels, OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK, OccEditorPanel.udfConn(), new MerlinUDF(10, UnitDoubleVR.between(0.0, 100.0, NonSI.PERCENT, true, true)), OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK.getDisplayName(), OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK.getHtmlDescr()), new PropField<UnitDouble, ICurve, MerlinUDF>(panel, (ILabelGenerator)labels, OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE, OccEditorPanel.udfConn(), new MerlinUDF(10, UnitDoubleVR.between(0.0, 100.0, NonSI.PERCENT, true, true)), OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE.getDisplayName(), OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE.getHtmlDescr()), new PropField(panel, (ILabelGenerator)labels, OccProfile.PROP_ATTRACTOR_RESTRICTIONS, (field, live) -> {
                AttrRestrictionConn profConn = new AttrRestrictionConn(md, OccEditorPanel.translateProp(field.prop), (AttrRestrictionsEditor)field.comp);
                profConn.setLive(live);
                return profConn;
            }, new AttrRestrictionsEditor(md), OccProfile.PROP_ATTRACTOR_RESTRICTIONS.getDisplayName(), OccProfile.PROP_ATTRACTOR_RESTRICTIONS.getHtmlDescr()), new TabLbl(Intl.intl("Restrictions")), new PropField(panel, (ILabelGenerator)labels, OccProfile.PROP_RESTRICTED_COMPONENTS, (field, live) -> {
                CompRestrictionConn profConn = new CompRestrictionConn(md, OccEditorPanel.translateProp(field.prop), (CompRestrictionsEditor)field.editor);
                profConn.setLive(live);
                return profConn;
            }, new CompRestrictionsEditor(md, labels), Intl.intl("Restricted Components"), Intl.intl("Restricted Components.")), new TabLbl(Intl.intl("Door Choice")), Intl.intl("Cost Factors:"), new PropField<UnitDouble, ICurve, MerlinUDF>(panel, (ILabelGenerator)labels, OccProfile.PROP_LOCAL_TRAVEL_TIME_FACTOR, OccEditorPanel.udfConn(), new MerlinUDF(11, UnitDoubleVR.above(0.0, SIUS.unit(11), true)), Intl.intl("Current Room Travel Time"), guiUtil.encodeToHtmlLabel(Intl.intl("This value affects the cost of travelling to a door in the occupant's\ncurrent room.  Higher values increase a door's cost in this category."))), new PropField<UnitDouble, ICurve, MerlinUDF>(panel, (ILabelGenerator)labels, OccProfile.PROP_LOCAL_QUEUE_TIME_FACTOR, OccEditorPanel.udfConn(), new MerlinUDF(11, UnitDoubleVR.above(0.0, SIUS.unit(11), true)), Intl.intl("Current Room Queue Time"), guiUtil.encodeToHtmlLabel(Intl.intl("This value affects the cost of waiting in a queue at a door in the\noccupant's current room.  Higher values increase a door's cost in\nthis category."))), new PropField<UnitDouble, ICurve, MerlinUDF>(panel, (ILabelGenerator)labels, OccProfile.PROP_TAIL_TIME_FACTOR, OccEditorPanel.udfConn(), new MerlinUDF(11, UnitDoubleVR.above(0.0, SIUS.unit(11), true)), Intl.intl("Global Travel Time"), guiUtil.encodeToHtmlLabel(Intl.intl("This value affects the cost of travelling from a door in the occupant's\ncurrent room to an exit or the occupant's next goal. Higher values increase\na door's cost in this category."))), new PropField<UnitDouble, ICurve, MerlinUDF>(panel, (ILabelGenerator)labels, OccProfile.PROP_ELEVATOR_WAIT_TIME, OccEditorPanel.udfConn(), new MerlinUDF(1, UnitDoubleVR.above(0.0, SIUS.unit(1), true)), Intl.intl("Elevator Wait Time"), guiUtil.encodeToHtmlLabel(Intl.intl("This value determines for how long occupants wait for an elevator even if there\nis a faster alternative.\n"))), Intl.intl("Advanced"), new PropField<UnitDouble, ICurve, MerlinUDF>(panel, (ILabelGenerator)labels, OccProfile.PROP_CURR_DOOR_PREF, OccEditorPanel.udfConn(), new MerlinUDF(10, UnitDoubleVR.above(0.0, SIUS.unit(10), true)), Intl.intl("Current Door Preference"), guiUtil.encodeToHtmlLabel(Intl.intl("This value is used to help occupants stick to their currently chosen\ndoors, preventing excessive switching.  A value of 100 % will cause\noccupants to never switch doors, and a value of 0 % will allow occupants\nto freely change their selected doors."))), new PropField<UnitDouble, ICurve, MerlinUDF>(panel, (ILabelGenerator)labels, OccProfile.PROP_CURRENT_ROOM_DIST_PENALTY, OccEditorPanel.udfConn(), new MerlinUDF(0, UnitDoubleVR.above(0.0, SIUS.unit(0), true)), Intl.intl("Current Room Distance Penalty"), guiUtil.encodeToHtmlLabel(Intl.intl("<b>NOTE: Enter <i>0</i> to turn off.</b>\nThis value is used as a simple way to model fatigue.  The further an occupant\ntravels in a room, the more the occupant prefers shorter distances over shorter\ntimes.<br>More precisely, every time the occupant travels this distance in the current\nroom, the overall travel time cost will have doubled."))), new TabLbl(Intl.intl("Animation")), OccEditorPanel.newPropField(panel, md, labels, OccProfile.PROP_ANIMS_IDLE), OccEditorPanel.newPropField(panel, md, labels, OccProfile.PROP_ANIMS_MOVING), new TabLbl(Intl.intl("Output")), new BooleanField(panel, labels, OccProfile.PROP_PRINT_EXTRA_OUTPUT, Intl.intl("Yes"), Intl.intl("No"), false, Intl.intl("Output Detailed Data"), Intl.intl("Create a detailed output file with location and velocity information.")), new TabLbl(Intl.intl("Advanced")), new PropField<UnitDouble, ICurve, MerlinUDF>(panel, (ILabelGenerator)labels, OccProfile.PROP_ACCEL_TIME, OccEditorPanel.udfConn(), new MerlinUDF(1, UnitDoubleVR.above(0.0, SIUS.unit(1), true)), Intl.intl("Acceleration Time"), guiUtil.encodeToHtmlLabel(Intl.intl("The amount of time for an occupant to accelerate from standing to moving at maximum velocity."))), new PropField<UnitDouble, ICurve, MerlinUDF>(panel, (ILabelGenerator)labels, OccProfile.PROP_PERSIST_TIME, OccEditorPanel.udfConn(), new MerlinUDF(1, UnitDoubleVR.above(0.0, SIUS.unit(1), true)), Intl.intl("Persist Time"), guiUtil.encodeToHtmlLabel(Intl.intl("Amount of time an occupant keeps elevated priority to resolve conflicts when no progress is being made."))), new PropField<UnitDouble, ICurve, MerlinUDF>(panel, (ILabelGenerator)labels, OccProfile.PROP_COLLISION_RESPONSE_TIME, OccEditorPanel.udfConn(), new MerlinUDF(1, UnitDoubleVR.above(0.0, SIUS.unit(1), true)), Intl.intl("Collision Response Time"), guiUtil.encodeToHtmlLabel(Intl.intl("Time used by an occupant to determine the critical stopping distance to avoid hitting other occupants."))), new PropField<UnitDouble, ICurve, MerlinUDF>(panel, (ILabelGenerator)labels, OccProfile.PROP_SLOW_FACTOR, OccEditorPanel.udfConn(), new MerlinUDF(11, UnitDoubleVR.above(0.0, SIUS.unit(11), true)), Intl.intl("Slow Factor"), guiUtil.encodeToHtmlLabel(Intl.intl("The fraction of an occupant's maximum speed that determines if the occupant is slow,\nallowing the occupant to consider more travel directions."))), new PropField<UnitDouble, ICurve, MerlinUDF>(panel, (ILabelGenerator)labels, OccProfile.PROP_BOUNDARY_LAYER, OccEditorPanel.udfConn(), new MerlinUDF(0, UnitDoubleVR.above(0.0, SIUS.unit(0), true)), Intl.intl("Wall Boundary Layer"), guiUtil.encodeToHtmlLabel(Intl.intl("The distance the occupant tries to maintain with walls."))), new PropField<OccProfile.Spacing, OccProfile.Spacing, PersonalDistanceEditor>(panel, (ILabelGenerator)labels, OccProfile.PROP_SPACING, OccEditorPanel.editorConn(true), new PersonalDistanceEditor(comm, 1), Intl.intl("Personal Distance"), guiUtil.encodeToHtmlLabel(Intl.intl("Controls the spacing of occupants when queueing or travelling with restricted speed."))), new PropField(panel, (ILabelGenerator)labels, OccProfile.PROP_SOCIAL_DIST_FILTER, OccEditorPanel.editorConn(true), new PopupValEditor<ObjsFilter>(PopupValEditor.Mode.HTML, ObjsFilter.class, Intl.intl("Distance from Occupants with Tags"), () -> new ObjsFilterEditor<Tag>(new ObjsFilterEditorComponents<Tag>(null, Tag.class, new TagsEditor(true))), v -> v.format(30)), OccProfile.PROP_SOCIAL_DIST_FILTER.getDisplayName(), OccProfile.PROP_SOCIAL_DIST_FILTER.getDisplayDesc()), new PropField<UnitDouble, ICurve, MerlinUDF>(panel, (ILabelGenerator)labels, OccProfile.PROP_SOCIAL_DIST, OccEditorPanel.udfConn(), new MerlinUDF(0, UnitDoubleVR.above(0.0, SIUS.unit(0), true)), Intl.intl("Social Distance"), guiUtil.encodeToHtmlLabel(Intl.intl("The preferred distance to other occupants outside the occupant's movement group\nand whom are accepted by <b>Social Distance Occupants</b>."))), new PropField(panel, (ILabelGenerator)labels, OccProfile.PROP_SPEED_IN_SMOKE, OccEditorPanel.editorConn(true), new SpeedInSmokeEditor(comm), OccProfile.PROP_SPEED_IN_SMOKE.getDisplayName(), OccProfile.PROP_SPEED_IN_SMOKE.getDisplayDesc()), new TabLbl(Intl.intl("Advanced Speed")), Intl.intl("Level Terrain"), OccEditorPanel.newFunctionProp(panel, labels, OccProfile.PROP_FUNDAMENTAL), Intl.intl("Stairs"), OccEditorPanel.newFunctionProp(panel, labels, OccProfile.PROP_STAIR_SPEED_UP), OccEditorPanel.newSlopeFunctionProp(panel, labels, OccProfile.PROP_STAIR_FUNDAMENTAL_UP), OccEditorPanel.newFunctionProp(panel, labels, OccProfile.PROP_STAIR_SPEED_DOWN), OccEditorPanel.newSlopeFunctionProp(panel, labels, OccProfile.PROP_STAIR_FUNDAMENTAL_DOWN), Intl.intl("Ramps"), OccEditorPanel.newFunctionProp(panel, labels, OccProfile.PROP_RAMP_SPEED_UP), OccEditorPanel.newSlopeFunctionProp(panel, labels, OccProfile.PROP_RAMP_FUNDAMENTAL_UP), OccEditorPanel.newFunctionProp(panel, labels, OccProfile.PROP_RAMP_SPEED_DOWN), OccEditorPanel.newSlopeFunctionProp(panel, labels, OccProfile.PROP_RAMP_FUNDAMENTAL_DOWN));
            this.d_connections = new ArrayList<Pair<SelectionEditorPanel.BoolPropConnection, SelectionEditorPanel.IPropConnection>>(this.d_fields.size());
            GridBagHelper dlgGb = new GridBagHelper(this.getDialogPane());
            JTabbedPane tabPane = new JTabbedPane();
            guiPanel currTabPnl = this.getDialogPane();
            GridBagHelper gb = dlgGb;
            int iCount = 0;
            for (int m = 0; m < this.d_fields.size(); ++m) {
                Object prop = this.d_fields.get(m);
                if (prop == null) continue;
                if (prop instanceof TabLbl) {
                    if (gb != null && gb != dlgGb) {
                        gb.finalizeRows();
                    }
                    currTabPnl = new guiPanel();
                    currTabPnl.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
                    gb = new GridBagHelper(currTabPnl);
                    tabPane.addTab(((TabLbl)prop).lbl, currTabPnl);
                    iCount = 0;
                    continue;
                }
                if (prop instanceof String) {
                    if (iCount > 0) {
                        gb.unindent();
                    }
                    gb.addFilledRow(new TitleSeparator((String)prop));
                    gb.indent();
                    iCount = 1;
                    continue;
                }
                if (prop instanceof Component) {
                    gb.addRow(prop, new double[]{0.0, 2.0});
                    continue;
                }
                PropField pf = (PropField)prop;
                SelectionEditorPanel.IPropConnection conn = pf.newConn.create(pf, false);
                SelectionEditorPanel.BoolPropConnection lconn = pf.newIsLocalConn(false);
                this.d_connections.add(new Pair<SelectionEditorPanel.BoolPropConnection, SelectionEditorPanel.IPropConnection>(lconn, conn));
                gb.addRow(pf.localCB, pf.comp, 1.0, 0);
            }
            gb.finalizeRows();
            dlgGb.addRow(tabPane, new double[]{1.0, 1.0}, new int[]{0, 0});
        }

        public void load(Collection<IMerlinObj> objs) {
            this.d_currObjs = objs;
            for (Pair<SelectionEditorPanel.BoolPropConnection, SelectionEditorPanel.IPropConnection> pc : this.d_connections) {
                ((SelectionEditorPanel.BoolPropConnection)pc.v1).bind(objs);
                ((SelectionEditorPanel.IPropConnection)pc.v2).bind(objs);
            }
            this.setModified(false);
        }

        public void reset() {
            this.load(this.d_currObjs);
        }

        @Override
        public void applyPressed() {
            this.apply();
        }

        @Override
        public void okPressed() {
            this.apply();
        }

        @Override
        public void cancelPressed() {
        }

        @Override
        public void closePressed() {
        }

        @Override
        public void helpPressed() {
        }

        @Override
        public void resetPressed() {
        }

        public void apply() {
            SelectionEditorPanel.runCommitOp(this.getClass(), "editAdvanced", true, null, (app, md) -> {
                md.pauseUpdates();
                Undo.begin(Intl.intl("Edit Advanced Occ Params"));
                for (Pair<SelectionEditorPanel.BoolPropConnection, SelectionEditorPanel.IPropConnection> pc : this.d_connections) {
                    ((SelectionEditorPanel.BoolPropConnection)pc.v1).commit();
                    if (!((guiMultiStateCheckBox)((SelectionEditorPanel.BoolPropConnection)pc.v1).getControl()).isSelected()) continue;
                    ((SelectionEditorPanel.IPropConnection)pc.v2).commit();
                }
                this.setModified(false);
                Undo.end(md);
                md.resumeUpdates();
            });
        }

        private static class TabLbl {
            public final String lbl;

            public TabLbl(String lbl) {
                this.lbl = lbl;
            }
        }
    }

    private static class CompRestrictionConn
    extends SelectionEditorPanel.ASinglePropConnection<CompElementActions.IObjectProp<IMerlinObj, OccProfile.CompRestrictions>, CompRestrictionsEditor> {
        public CompRestrictionConn(MerlinData md, CompElementActions.IObjectProp<IMerlinObj, OccProfile.CompRestrictions> prop, CompRestrictionsEditor control) {
            super(prop, control);
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, OccProfile.CompRestrictions> prop, Collection<? extends IMerlinObj> objs, CompRestrictionsEditor comp) {
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Component Restrictions"), prop, objs, (OccProfile.CompRestrictions)comp.getValue());
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, OccProfile.CompRestrictions> prop, Collection<? extends IMerlinObj> objs, CompRestrictionsEditor comp) {
            PropValue<OccProfile.CompRestrictions> compRestrictions = prop.get(MerlinApp.getApp().getData(), objs);
            comp.setValue(compRestrictions.orElse(null));
            comp.setModified(false);
        }
    }

    public static class ShapePropConn
    extends SelectionEditorPanel.ASinglePropConnection<CompElementActions.IObjectProp<IMerlinObj, OccProfile.OccShape>, ShapeEditor> {
        private boolean d_modified;
        private ShapeEditor d_shapeEditor;

        public ShapePropConn(ShapeEditor shapeEditor) {
            super(OccEditorPanel.translateProp(OccProfile.PROP_SHAPE), shapeEditor);
            this.d_shapeEditor = shapeEditor;
            this.d_shapeEditor.addValueListener(e -> {
                this.d_modified = true;
                this.onControlChanged();
                this.initFromProp();
            });
            this.d_modified = false;
        }

        @Override
        protected boolean isModified(HTMLBtn comp) {
            return this.d_modified;
        }

        @Override
        protected void setModified(HTMLBtn comp, boolean modified) {
            this.d_modified = modified;
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, OccProfile.OccShape> prop, Collection<? extends IMerlinObj> objs, ShapeEditor comp) {
            OccProfile.OccShape shape = this.d_shapeEditor.getValue();
            SelectionEditorPanel.setPropRecursive(Intl.intl("Edit Shape"), prop, objs, shape);
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, OccProfile.OccShape> prop, Collection<? extends IMerlinObj> objs, ShapeEditor shapeEditor) {
            PropValue<OccProfile.OccShape> val = prop.get(MerlinApp.getApp().getData(), objs);
            shapeEditor.setValue((OccProfile.OccShape)val.orElse(null));
            this.setModified(shapeEditor, false);
        }
    }

    private static class ModelPropConn<ObjT>
    extends SelectionEditorPanel.ASinglePropConnection<CompElementActions.IObjectProp<IMerlinObj, IAvatar>, AvatarEditor> {
        public ModelPropConn(AvatarEditor editor) {
            super(OccEditorPanel.translateProp(OccProfile.PROP_OCCMODEL), editor);
            editor.addValueListener(e -> this.onControlChanged());
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, IAvatar> prop, Collection<? extends IMerlinObj> objs, AvatarEditor comp) {
            PropValue result = (PropValue)comp.getValue();
            if (!result.isUniform()) {
                return;
            }
            ArrayList lvals = new ArrayList();
            ((IUrn)result.get()).getUnique(lvals);
            assert (!lvals.isEmpty());
            IAvatar sel = (IAvatar)lvals.get(0);
            SelectionEditorPanel.setPropRecursive(Intl.intl("Edit Model"), prop, objs, sel);
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, IAvatar> prop, Collection<? extends IMerlinObj> objs, AvatarEditor comp) {
            PropValue<IAvatar> val = prop.get(MerlinApp.getApp().getData(), objs);
            PropValue<IUrn> uval = val.map(avatar -> new Urn<IAvatar>(avatar));
            comp.setValue(uval);
            comp.setModified(false);
        }
    }

    private static class ColorPropConn
    extends SelectionEditorPanel.ASinglePropConnection<CompElementActions.IObjectProp<IMerlinObj, Color>, ColorButton>
    implements Observer {
        public ColorPropConn(ColorButton btn) {
            super(new ColorProp(), btn);
            btn.setText(Intl.intl("<multiple>"));
            btn.addObserver(this);
            Insets margin = btn.getMargin();
            btn.setMargin(new Insets(margin.top, 3, margin.bottom, 3));
        }

        @Override
        public void update(Observable o, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void initFromProp(CompElementActions.IObjectProp<IMerlinObj, Color> prop, Collection<? extends IMerlinObj> objs, ColorButton comp) {
            PropValue<Color> color = prop.get(MerlinApp.getApp().getData(), objs);
            comp.setColor(color.orElse(null));
            comp.setModified(false);
        }

        @Override
        public void setProp(CompElementActions.IObjectProp<IMerlinObj, Color> prop, Collection<? extends IMerlinObj> objs, ColorButton comp) {
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Occ. Color"), prop, objs, comp.getColor());
        }
    }

    private static class ColorProp
    implements CompElementActions.IObjectProp<IMerlinObj, Color> {
        private final CompElementActions.IObjectProp<IMerlinObj, Point3f> d_baseProp = OccEditorPanel.translateProp(OccProfile.PROP_COLOR);

        @Override
        public Collection<? extends IMerlinObj> filterObjs(Collection<? extends IMerlinObj> objs) {
            return this.d_baseProp.filterObjs(objs);
        }

        @Override
        public PropValue<Color> get(MerlinData md, Collection<? extends IMerlinObj> objs) {
            PropValue<Point3f> color = this.d_baseProp.get(md, objs);
            return color.map(c3f -> c3f != null ? new Color(c3f.x, c3f.y, c3f.z) : null);
        }

        @Override
        public void set(MerlinData md, Collection<? extends IMerlinObj> objs, Color color) {
            float[] comps = new float[3];
            color.getColorComponents(comps);
            Point3f newVal = new Point3f(comps);
            this.d_baseProp.set(md, objs, newVal);
        }
    }

    private static class BoolToStrProp
    implements CompElementActions.IObjectProp<IMerlinObj, String> {
        private final String d_checkStr;
        private final String d_uncheckStr;
        private final CompElementActions.IObjectProp<IMerlinObj, Boolean> d_boolProp;
        private final boolean d_invert;

        public BoolToStrProp(CompElementActions.IObjectProp<IMerlinObj, Boolean> boolProp, String checkStr, String uncheckStr, boolean invert) {
            this.d_boolProp = boolProp;
            this.d_checkStr = checkStr;
            this.d_uncheckStr = uncheckStr;
            this.d_invert = invert;
        }

        @Override
        public Collection<? extends IMerlinObj> filterObjs(Collection<? extends IMerlinObj> objs) {
            return objs;
        }

        @Override
        public void set(MerlinData md, Collection<? extends IMerlinObj> objs, String newVal) {
            Boolean bval = this.d_checkStr.equals(newVal);
            if (this.d_invert) {
                bval = bval == false;
            }
            this.d_boolProp.set(md, objs, bval);
        }

        @Override
        public PropValue<String> get(MerlinData md, Collection<? extends IMerlinObj> objs) {
            PropValue<Boolean> val = this.d_boolProp.get(md, objs);
            return val.map(bval -> {
                if (bval == null) {
                    return null;
                }
                if (this.d_invert) {
                    bval = bval == false;
                }
                return bval != false ? this.d_checkStr : this.d_uncheckStr;
            });
        }
    }

    private static class BooleanField
    extends PropField<Boolean, IUrn<Boolean>, guiComboBox<String>> {
        public BooleanField(SelectionEditorPanel.EditorPanel panel, ILabelGenerator labels, IProfilePropDist<Boolean, IUrn<Boolean>> prop, String checkStr, String uncheckStr, boolean invert, String desc, String tooltip) {
            super(panel, labels, prop, (PropField<OccT, ProfT, CompT> bfield, boolean live) -> {
                CompElementActions.IObjectProp<IMerlinObj, Boolean> oprop = OccEditorPanel.translateProp(prop);
                BoolToStrProp strProp = new BoolToStrProp(oprop, checkStr, uncheckStr, invert);
                SelectionEditorPanel.ComboPropConn<String, guiComboBox> cconn = new SelectionEditorPanel.ComboPropConn<String, guiComboBox>(strProp, (guiComboBox)bfield.comp);
                cconn.setLive(live);
                return cconn;
            }, new guiComboBox<String>((T[])new String[]{checkStr, uncheckStr}), desc, tooltip);
        }
    }

    private static class EnumField<T extends Enum<T>>
    extends PropField<T, IUrn<T>, guiComboBox<T>> {
        public EnumField(SelectionEditorPanel.EditorPanel panel, ILabelGenerator labels, IProfilePropDist<T, IUrn<T>> prop, String desc, String toolTip, T[] items, Function<T, String> tToStr) {
            super(panel, labels, prop, (PropField<OccT, ProfT, CompT> ef, boolean live) -> {
                CompElementActions.IObjectProp oprop = OccEditorPanel.translateProp(prop);
                SelectionEditorPanel.ComboPropConn ccon = new SelectionEditorPanel.ComboPropConn(oprop, (guiComboBox)ef.comp);
                ccon.setLive(live);
                return ccon;
            }, guiUtil.newCombo(val -> new Pair<String, Object>((String)tToStr.apply(val), null), items), desc, toolTip);
        }
    }

    private static class CurveField
    extends PropField<UnitDouble, ICurve, MerlinUDF> {
        public CurveField(SelectionEditorPanel.EditorPanel panel, ILabelGenerator labels, IProfileProp<UnitDouble, ICurve> prop, int unitType, String desc, String tooltip) {
            super(panel, labels, prop, OccEditorPanel.udfConn(), new MerlinUDF(unitType), desc, tooltip);
        }
    }

    public static class IsLocalProp<OccT, ProfT>
    extends CompElementActions.MappedProp<IMerlinObj, Boolean, EgressAgent.AgentValue<OccT>> {
        public IsLocalProp(IProfileProp<OccT, ProfT> baseProp) {
            super(new CompElementActions.DefProp(EgressAgent.asAgentOccProp(baseProp), true), (agent, agentVal) -> agentVal.isLocal(), (agent, isLocal) -> {
                if (!isLocal.booleanValue()) {
                    return new EgressAgent.AgentValue<Object>((boolean)isLocal, null);
                }
                EgressAgent.AgentValue currVal = (EgressAgent.AgentValue)agent.get(EgressAgent.asAgentOccProp(baseProp));
                return new EgressAgent.AgentValue((boolean)isLocal, currVal.value());
            });
        }
    }

    private static class DisablableCurveEditor
    extends guiPanel
    implements IValEditor<UnitDouble> {
        private static final long serialVersionUID = 7857498806615311470L;
        private final guiComboBox<Boolean> d_enabled = guiUtil.newCombo(Boolean.valueOf(false), Intl.intl("Disabled"), true, Intl.intl("Enabled"));
        private final MerlinUDF d_value;
        private final int d_unit;

        public DisablableCurveEditor(MerlinUDF value, int unit) {
            this.d_value = value;
            this.d_value.setEmptyAllowed(true);
            this.d_unit = unit;
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_enabled, this.d_value, 1.0);
            this.d_enabled.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.updateState();
                }
            });
            this.updateState();
        }

        private void updateState() {
            this.d_value.setEnabled(this.isEnabled() && this.d_enabled.getSelectedItem() != null && this.d_enabled.getSelectedItem() != false);
        }

        @Override
        public boolean isLive() {
            return true;
        }

        @Override
        public String formatNonLiveValue() {
            return "";
        }

        @Override
        public <DomainT extends Mediator> UnitDouble commit(DomainT domain) {
            this.setModified(false);
            return this.getValue();
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable);
            this.updateState();
        }

        @Override
        public Class<UnitDouble> getType() {
            return UnitDouble.class;
        }

        @Override
        public UnitDouble getValue() {
            Boolean enabled = this.d_enabled.getSelectedItem();
            if (enabled == null) {
                return null;
            }
            if (!enabled.booleanValue()) {
                return new UnitDouble(Double.NaN, SIUS.unit(this.d_unit));
            }
            return (UnitDouble)this.d_value.getValue();
        }

        @Override
        public void setValue(UnitDouble value) {
            if (value == null) {
                this.d_enabled.setSelectedIndex(-1);
                this.d_value.setValue(null);
            } else {
                boolean enabled = !Double.isNaN(value.getRawValue());
                this.d_enabled.setSelectedItem(enabled);
                this.d_value.setValue(enabled ? value : null);
            }
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this, 1.0);
        }
    }
}

