/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.awt.Component;
import java.util.Observable;
import javax.swing.JButton;
import javax.swing.JPanel;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.builders.PlanarGeomBuilder;
import merlin.data.MerlinData;
import merlin.geom.IMerlinGeomSrc;
import merlin.gui.APropEditPanel;
import merlin.gui.IPropEditCommand;
import merlin.gui.MerlinUDF;
import merlin.mv.ModelView;
import merlin.mv.tools.ZPickListener;
import org.jscience.physics.units.SI;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class NewPlanarGeomPanel<T extends PlanarGeomBuilder>
extends APropEditPanel<T> {
    private static final long serialVersionUID = 5639085548247039970L;
    public static final int PANEL_ZLOC = 1;
    private final MerlinData d_data;
    private guiUnitDoubleField d_zLoc;
    private JButton d_selectLocBtn;

    public NewPlanarGeomPanel(MerlinData data, int options) {
        super(new Object[0]);
        this.d_data = data;
        this.setOptions(options);
    }

    protected boolean testOption(int options, int option) {
        return (options & option) == option;
    }

    protected void setOptions(int options) {
        if (this.testOption(options, 1)) {
            this.addSeparator();
            this.addZLocPanel();
        }
    }

    private void addZLocPanel() {
        this.d_zLoc = this.initValueField(new MerlinUDF(0.0, SI.METER), new IPropEditCommand(){

            @Override
            public void updateProp(Component c, boolean hardValidate) {
                NewPlanarGeomPanel.this.updateZPlane(hardValidate);
            }
        });
        this.d_selectLocBtn = this.initButton(new JButton(Intl.intl("Pick Z from Scene")), new IPropEditCommand(){

            @Override
            public void updateProp(Component c, boolean hardValidate) {
                final ModelView mv = MerlinApp.getApp().getModelView();
                mv.getRenderComp().requestFocus();
                ZPickListener listener = new ZPickListener(){

                    @Override
                    public void pointPicked(IMerlinGeomSrc source, UnitPoint3D p) {
                        ((PlanarGeomBuilder)NewPlanarGeomPanel.this.props()).setZLoc(p.zu());
                        mv.stopChoosingPoints();
                    }

                    @Override
                    public void stopPicking() {
                    }
                };
                mv.startChoosingPoints(listener);
            }
        });
        String selTT = Intl.intl("Pick a point in the scene. The Z location of the chosen point<br>will determine the Z drawing plane.");
        this.d_selectLocBtn.setToolTipText("<html>" + selTT + "</html>");
        JPanel zPanel = new JPanel();
        GridBagHelper gb = new GridBagHelper(zPanel);
        gb.addRow(Intl.intl("Z Plane:"), 2, this.d_zLoc, 0, 1.0);
        gb.addRow(this.d_selectLocBtn, 0);
        this.addSection(zPanel);
    }

    @Override
    public void setProps(T props) {
        super.setProps(props);
        this.updateZPlaneCtrls();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.props() == null || ((PlanarGeomBuilder)this.props()).wasSource(this)) {
            return;
        }
        if (this.propChanged(PlanarGeomBuilder.Z_LOC)) {
            this.updateZPlaneCtrls();
        }
    }

    private void updateZPlane(boolean hardValidate) {
        if (this.props() == null || !this.d_zLoc.validateData(hardValidate, hardValidate)) {
            return;
        }
        ((PlanarGeomBuilder)this.props()).pause(this);
        ((PlanarGeomBuilder)this.props()).setZLoc((UnitDouble)this.d_zLoc.getValue());
        ((PlanarGeomBuilder)this.props()).resume();
    }

    private void updateZPlaneCtrls() {
        if (this.d_zLoc != null) {
            this.d_zLoc.setValue(((PlanarGeomBuilder)this.props()).getZLoc());
        }
    }
}

