/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import merlin.data.MerlinData;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.egress.geom.IEgressComp;
import merlin.mv.displays.IMerlinDispMgr;
import merlin.mv.displays.NavMeshTriDisplay;
import thunderheadeng.scene3d.IDisplayMgr;
import thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.transformpreview.EmptyTransformPreview;
import thunderheadeng.scene3d.transformpreview.ITransformPreview;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventRecord;

public class NavMeshTriDispMgr
implements IMerlinDispMgr<Object> {
    private final MerlinData d_data;
    private final NavMeshTriDisplay d_display;
    private boolean d_visible = false;
    private boolean d_dirty = true;

    public NavMeshTriDispMgr(MerlinData data, ModelScene scene, INativeDisplayProps dispProps) {
        this.d_data = data;
        this.d_display = new NavMeshTriDisplay(dispProps);
        this.d_display.setVisible(this.d_visible);
        scene.addSceneObjects(this.d_display);
    }

    @Override
    public ITransformPreview getTransformPreview(IDisplayMgr<? super Object> copyMgr, Collection<? extends Object> objs, boolean copyMode) {
        return EmptyTransformPreview.INSTANCE;
    }

    public void setVisible(boolean visible) {
        if (visible == this.d_visible) {
            return;
        }
        this.d_visible = visible;
        this.update();
        this.d_display.setVisible(this.d_visible);
    }

    public void setSelected(boolean selected) {
    }

    @Override
    public void update(Events events) {
        for (EventChannel<MerlinData> channel2 : events.getAffectedChannels(MerlinData.class, new Class[0])) {
            if (!channel2.containsChange(MerlinData.MESH_CHANGED)) continue;
            this.d_dirty = true;
            break;
        }
        Predicate<IEventRecord> testChannel = channel -> channel.hasAddedObjs() || channel.hasRemovedObjs() || !channel.areChangesExclusiveTo(MerlinData.SELECTION_CHANGED);
        this.d_dirty = this.d_dirty || testChannel.test(events.getEvents(IEgressComp.class, new Class[0])) || testChannel.test(events.getEvents(EgressBlockage.class, new Class[0]));
        this.update();
    }

    @Override
    public void updateVisibility(Collection<? extends Object> objs) {
    }

    @Override
    public void updateAll() {
        this.d_dirty = true;
        this.update();
    }

    public void update() {
        if (this.d_dirty) {
            if (this.d_visible) {
                this.regenerateDisplay();
            } else {
                this.d_display.resetData();
            }
        }
    }

    private void regenerateDisplay() {
        this.d_display.regenerateDisplay(this.d_data);
        this.d_dirty = false;
    }

    @Override
    public void getScenes(Consumer<ModelScene> scenes) {
    }

    @Override
    public void getScenes(Object obj, Consumer<ModelScene> scenes) {
    }

    public Object getSelectionObj() {
        return null;
    }

    @Override
    public Predicate<Object> getFilter() {
        return Filters.rejectAll();
    }

    @Override
    public Class<Object> getType() {
        return Object.class;
    }

    @Override
    public void removeAll() {
    }

    @Override
    public void addDisplays(Collection<? extends Object> objs) {
    }

    @Override
    public void updateDisplays(Collection<? extends Object> objs) {
    }

    @Override
    public void removeDisplays(Collection<? extends Object> objs) {
    }

    @Override
    public void removeFromScene(Collection<? extends Object> obj) {
    }

    @Override
    public void addToScene(Collection<? extends Object> obj) {
    }
}

