/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.FloorComposite;
import merlin.mv.displays.IMerlinDispMgr;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.scene3d.IDisplayMgr;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.transformpreview.EmptyTransformPreview;
import thunderheadeng.scene3d.transformpreview.ITransformPreview;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashMap;

public class FloorDispMgr
implements IMerlinDispMgr<Floor> {
    private final MerlinData d_data;
    private final Collection<ModelScene> d_importScenes;
    private final Map<Floor, ConvexHull> d_floorCRMap = new LinkedIdentityHashMap<Floor, ConvexHull>();

    public FloorDispMgr(MerlinData data, Collection<ModelScene> importScenes) {
        this.d_data = data;
        this.d_importScenes = importScenes;
        this.addFloorClipRegions(this.getAllFloors());
    }

    private Collection<Floor> getAllFloors() {
        return this.d_data.floors.getMembers(Floor.class);
    }

    @Override
    public Predicate<Floor> getFilter() {
        return Filters.acceptAll();
    }

    @Override
    public Class<Floor> getType() {
        return Floor.class;
    }

    @Override
    public void update(Events events) {
        for (EventChannel<Floor> channel : events.getAffectedChannels(Floor.class, new Class[0])) {
            if (channel.hasAddedObjs() || channel.hasRemovedObjs() || !channel.getChangedNotOfType(MerlinData.VISIBILITY, FloorComposite.ACTIVE_FLOOR).isEmpty()) {
                this.updateAll();
                continue;
            }
            this.updateClipVisibility(channel.getChangedObjs((Object)MerlinData.VISIBILITY));
        }
    }

    @Override
    public void updateVisibility(Collection<? extends Floor> objs) {
    }

    @Override
    public void updateAll() {
        this.removeFloorClipRegions(new ArrayList<Floor>(this.d_floorCRMap.keySet()));
        this.addFloorClipRegions(this.getAllFloors());
        this.updateClipVisibility(this.getAllFloors());
    }

    private void addFloorClipRegions(Collection<? extends Floor> floorsSet) {
        Floor[] floors = floorsSet.toArray(new Floor[floorsSet.size()]);
        ConvexHull[] hulls = this.d_data.floors.getClippingRegions(floors);
        for (int m = 0; m < floors.length; ++m) {
            this.d_floorCRMap.put(floors[m], hulls[m]);
        }
        this.updateClipVisibility(floorsSet);
    }

    private void removeFloorClipRegions(Collection<? extends Floor> floors) {
        for (Floor floor : floors) {
            ConvexHull ch = this.d_floorCRMap.remove(floor);
            if (ch == null) continue;
            this.removeCullBox(ch);
        }
    }

    @Override
    public ITransformPreview getTransformPreview(IDisplayMgr<? super Floor> copyMgr, Collection<? extends Floor> objs, boolean copyMode) {
        return EmptyTransformPreview.INSTANCE;
    }

    private void updateClipVisibility(Collection<? extends Floor> floors) {
        for (Floor floor : floors) {
            ConvexHull ch = this.d_floorCRMap.get(floor);
            if (ch == null) continue;
            if (floor.isVisible()) {
                this.addCullBox(ch);
                continue;
            }
            this.removeCullBox(ch);
        }
        boolean anyVis = false;
        for (Floor floor : this.d_data.floors.getMembers(Floor.class)) {
            if (!floor.isVisible()) continue;
            anyVis = true;
            break;
        }
        if (!anyVis) {
            this.addCullBox(ConvexHull.ACCEPT_NONE);
        } else {
            this.removeCullBox(ConvexHull.ACCEPT_NONE);
        }
    }

    private void addCullBox(ConvexHull ch) {
        for (ModelScene ms : this.d_importScenes) {
            ms.addCullBox(ch);
        }
    }

    private void removeCullBox(ConvexHull ch) {
        for (ModelScene ms : this.d_importScenes) {
            ms.removeCullBox(ch);
        }
    }

    @Override
    public void getScenes(Consumer<ModelScene> scenes) {
    }

    @Override
    public void getScenes(Floor obj, Consumer<ModelScene> scenes) {
    }

    @Override
    public void removeAll() {
    }

    @Override
    public void addDisplays(Collection<? extends Floor> objs) {
    }

    @Override
    public void updateDisplays(Collection<? extends Floor> objs) {
    }

    @Override
    public void removeDisplays(Collection<? extends Floor> objs) {
    }

    @Override
    public void removeFromScene(Collection<? extends Floor> obj) {
    }

    @Override
    public void addToScene(Collection<? extends Floor> obj) {
    }
}

