/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import inferno.data2.CommonAnimTags;
import inferno.sim.OccTracker;
import inferno.sim.output.OccVisWriter;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.IProfilePropDist;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.egress.agents.VehicleShape;
import merlin.geom.Geometry;
import merlin.mv.displays.AgentDisplayType;
import merlin.mv.displays.IMerlinDisplay;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.io.nativexfer.ANativelyMirrored;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public abstract class AAgentDisplay
extends ANativelyMirrored
implements IMerlinDisplay,
IDisplayable {
    private static final long serialVersionUID = 2854184482722444176L;
    private static final int method_setVisible = 0;
    private boolean d_visible = true;
    private static final Quat4d s_occOrientToInitOrient = Util3D.shortestArc(OccVisWriter.OCC_ROT_REF, OccProfile.INIT_ORIENT_REF, GeomConstants.VEC3D_ZPOS, 1.0E-9);

    protected abstract Point3d getLocation();

    protected abstract boolean isTestAgent();

    protected abstract Point3f getColor();

    protected abstract Point3f getGroupColor();

    protected abstract Point3f getGroupTemplateColor();

    protected abstract Point3f getBehaviorColor();

    protected abstract OccProfile getProfile();

    protected abstract long getProfileSeed();

    protected abstract long getOrientSeed();

    protected abstract AgentDisplayType getDisplayType();

    @Override
    public Class<?> resolveNativeClass() {
        return AAgentDisplay.class;
    }

    @Override
    public IDisplayable[] getDisplayObjs() {
        return new IDisplayable[]{this};
    }

    private static void writef(INativeStream writer, Tuple3d t) {
        writer.writeFloats((float)t.x, (float)t.y, (float)t.z);
    }

    private static IAvatar getHumanAvatar(OccProfile profile, long profileSeed) {
        return profile != null ? profile.toOccValue(OccProfile.PROP_OCCMODEL, profileSeed, 0L) : null;
    }

    private static IAvatar getVehicleAvatar(VehicleShape vehicleShape) {
        return vehicleShape != VehicleShape.NONE ? vehicleShape.get(VehicleShape.PROP_MODEL) : null;
    }

    private static Pair<OccTracker.ITrackerShape, Boolean> getDisplayShape(OccProfile profile, long profileSeed, long orientSeed, AgentDisplayType dtype, VehicleShape vehicleShape, boolean realistic) {
        boolean human;
        boolean bl = human = dtype == AgentDisplayType.HUMAN;
        if (realistic) {
            IAvatar havatar;
            if (human && (havatar = AAgentDisplay.getHumanAvatar(profile, profileSeed)) instanceof ResourceAvatar) {
                Point3d offset = GeomConstants.PNT3D_ORIGIN;
                if (vehicleShape != null) {
                    offset = vehicleShape.get(VehicleShape.PROP_OCCAVATAR_OFFSET).getPoint3dValue(Geometry.LENGTH_UNIT);
                }
                return new Pair<OccTracker.ITrackerShape, Boolean>(new OccTracker.RealisticShape(((ResourceAvatar)havatar).path, offset, true), true);
            }
            if (vehicleShape != null) {
                IAvatar vavatar = AAgentDisplay.getVehicleAvatar(vehicleShape);
                if (vavatar instanceof ResourceAvatar) {
                    return new Pair<OccTracker.ITrackerShape, Boolean>(new OccTracker.RealisticShape(((ResourceAvatar)vavatar).path, GeomConstants.PNT3D_ORIGIN, false), false);
                }
                return new Pair<Object, Boolean>(null, false);
            }
            return new Pair<Object, Boolean>(null, human);
        }
        if (vehicleShape == null) {
            UnitDouble diam;
            UnitDouble height;
            if (profile == null) {
                diam = height = new UnitDouble(0.0, SI.METER);
            } else {
                diam = profile.toOccValue(OccProfile.PROP_DIAMETER, profileSeed, orientSeed);
                height = profile.toOccValue(OccProfile.PROP_HEIGHT, profileSeed, orientSeed);
            }
            Unit lu = Geometry.LENGTH_UNIT;
            return new Pair<OccTracker.ITrackerShape, Boolean>(new OccTracker.CylShape(diam.get(lu) * 0.5, height.get(lu)), true);
        }
        double height = vehicleShape.get(VehicleShape.PROP_HEIGHT).get(Geometry.LENGTH_UNIT);
        return new Pair<OccTracker.ITrackerShape, Boolean>(new OccTracker.PolyShape(height, vehicleShape.getBodyPoints()), false);
    }

    private static void writef(INativeStream writer, Quat4d q) {
        writer.writeFloat((float)q.w);
        writer.writeFloat((float)q.x);
        writer.writeFloat((float)q.y);
        writer.writeFloat((float)q.z);
    }

    private <SampleT, DistT> SampleT sampleValue(OccProfile profile, IProfilePropDist<SampleT, DistT> prop) {
        return profile.toOccValue(prop, this.getProfileSeed(), this.getOrientSeed());
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        writer.writeInt(this.getKey());
        writer.writeBooleans(this.d_visible);
        long seed = this.getProfileSeed();
        long orientSeed = this.getOrientSeed();
        writer.writeLong(seed);
        writer.writeBoolean(this.isTestAgent());
        AgentDisplayType dtype = this.getDisplayType();
        OccProfile profile = this.getProfile();
        OccProfile parentProfile = profile != null ? profile.getProfParent() : profile;
        double angle = profile != null ? this.sampleValue(profile, OccProfile.PROP_INIT_ORIENT).getValue(Geometry.ANGLE_UNIT) : 0.0;
        Quat4d initOrientToWorld = Util3D.toQuat(0.0, 0.0, 1.0, angle);
        Quat4d orient = Util3D.concatenate(s_occOrientToInitOrient, initOrientToWorld);
        Point3d loc = this.getLocation();
        AAgentDisplay.writef(writer, loc);
        AAgentDisplay.writef(writer, orient);
        VehicleShape vehicleShape = profile != null ? profile.get(OccProfile.PROP_VEHICLE_SHAPE) : VehicleShape.NONE;
        Pair<OccTracker.ITrackerShape, Boolean> rshape = AAgentDisplay.getDisplayShape(profile, seed, orientSeed, dtype, vehicleShape, true);
        Pair<OccTracker.ITrackerShape, Boolean> cshape = AAgentDisplay.getDisplayShape(profile, seed, orientSeed, dtype, vehicleShape, false);
        assert (cshape.v1 != null);
        writer.writeBoolean(dtype == AgentDisplayType.VEHICLE ? false : (Boolean)rshape.v2);
        try {
            OccVisWriter.writeShape(writer, (OccTracker.ITrackerShape)cshape.v1);
        }
        catch (IOException e) {
            assert (false);
            e.printStackTrace();
        }
        writer.writeBoolean(rshape.v1 != null);
        if (rshape.v1 != null) {
            try {
                OccVisWriter.writeShape(writer, (OccTracker.ITrackerShape)rshape.v1);
            }
            catch (IOException e) {
                assert (false);
                e.printStackTrace();
            }
        }
        boolean hasRealHumanAvatar = AAgentDisplay.getHumanAvatar(profile, seed) != null;
        boolean hasRealVehicleAvatar = AAgentDisplay.getVehicleAvatar(vehicleShape) != null;
        int visFlags = OccVisWriter.getVisFlags(dtype == AgentDisplayType.HUMAN, hasRealHumanAvatar, hasRealVehicleAvatar);
        writer.writeInt(visFlags);
        Point3f c3f = this.getColor();
        writer.writeFloats(c3f.x, c3f.y, c3f.z);
        Consumer<Point3f> writeColor = color -> {
            if (color != null) {
                writer.writeFloats(color.x, color.y, color.z);
            } else {
                writer.writeFloats(c3f.x, c3f.y, c3f.z);
            }
        };
        writeColor.accept(this.getGroupColor());
        writeColor.accept(this.getGroupTemplateColor());
        writeColor.accept(this.getBehaviorColor());
        writeColor.accept(parentProfile != null ? parentProfile.get(OccProfile.PROP_COLOR) : null);
        Supplier<Set> getTags = () -> {
            if (((Boolean)rshape.v2).booleanValue()) {
                Set<String> vehicleAnimTags;
                if (vehicleShape != VehicleShape.NONE && !(vehicleAnimTags = vehicleShape.get(VehicleShape.PROP_ANIM_TAGS)).isEmpty()) {
                    return vehicleAnimTags;
                }
                return profile != null ? this.sampleValue(profile, OccProfile.PROP_ANIMS_IDLE) : CommonAnimTags.DEFAULT_UPRIGHT.tags;
            }
            return CommonAnimTags.NO_ANIMATION.tags;
        };
        Set at = getTags.get();
        writer.writeInt(at.size());
        at.stream().forEach(s -> writer.writeString((String)s));
    }

    @Override
    @Deprecated
    public void setSelected(boolean selected) {
        assert (false);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            Native.manager.execMethod(AAgentDisplay.class, (INativeObject)this, 0, visible);
        }
    }

    @Override
    public void update() {
        this.markNativeDirty();
    }
}

