/*
 * Decompiled with CFR 0.152.
 */
package merlin.legacy.v0151.data.egress.geom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.IOccCount;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.SpeedModifier;
import merlin.data.tag.Tag;
import merlin.geom.IMerlinDispProps;
import merlin.io.MerlinOIS;
import merlin.io.inferno.InfernoGeom;
import merlin.legacy.v0151.data.egress.geom.EgressBlockage;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;

public class EgressRoom
extends AEgressComp
implements Serializable {
    static final long serialVersionUID = 1L;
    public Model d_geometry;
    public Map<Integer, EgressBlockage> d_blockages;
    public SpeedModifier d_speedModifier;
    public Set<String> d_tags;
    public IOccCount d_capacity = new ConstOccCount(50);
    public boolean d_capacityEnabled = false;
    public IMaterial d_material;
    private transient MerlinOIS d_readStream;

    protected EgressRoom() {
        super("");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_capacity = new ConstOccCount(50);
        this.d_capacityEnabled = false;
        in.defaultReadObject();
        if (this.d_blockages == null) {
            this.d_blockages = new LinkedHashMap<Integer, EgressBlockage>();
        }
        if (this.d_speedModifier == null) {
            this.d_speedModifier = SpeedModifier.DEFAULT;
        }
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
        if (in instanceof MerlinOIS) {
            this.d_readStream = (MerlinOIS)in;
        }
    }

    protected void initData(merlin.data.egress.geom.EgressRoom room) {
        room.setCapacity(this.d_capacity);
        room.setCapacityEnabled(this.d_capacityEnabled);
        room.setColor(this.getColor());
        room.setOpacity(this.getOpacity());
        room.setEnabled(this.isEnabled());
        room.setMaterial(this.d_material);
        room.setResultsId(this.getResultsId());
        room.setSpeedModifier(this.d_speedModifier);
        room.setPredefinedOccTags(this.d_tags);
        room.setVisible(this.isVisible());
    }

    private Object readResolve() throws ObjectStreamException {
        merlin.data.egress.geom.EgressRoom room = new merlin.data.egress.geom.EgressRoom(this.getName());
        this.initData(room);
        Model roomGeom = this.d_geometry;
        boolean needsCleanup = false;
        if (!this.d_blockages.isEmpty()) {
            Model newGeom = this.d_geometry.clone();
            boolean modified = false;
            for (Face face : newGeom.getFaces()) {
                modified |= face.removeGroupsIf(id -> this.d_blockages.containsKey(id));
            }
            if (modified) {
                roomGeom = newGeom;
                needsCleanup = true;
            }
        }
        room.setModel(roomGeom);
        if (this.d_readStream != null) {
            this.d_readStream.addPre152Room(this, room, needsCleanup);
        }
        return room;
    }

    @Override
    public void getConnectors(Collection<? super IEgressConnector> connectors) {
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return null;
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return null;
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return false;
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
    }

    @Override
    public void connectTo(IEgressObj conn) {
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
    }

    @Override
    public boolean updateTopo() {
        return false;
    }

    @Override
    public Point3d astarGetTestPoint() {
        return null;
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return null;
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return null;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return null;
    }

    @Override
    public void setGeom(IGeomNode geom) {
    }

    @Override
    public IGeomNode getGeom() {
        return null;
    }

    @Override
    public void getInfernoGeom(List<InfernoGeom> geoms, IMerlinDispProps dprops) {
    }

    @Override
    public Set<String> getPredefinedOccTags() {
        return null;
    }

    @Override
    public void setPredefinedOccTags(Set<String> tags) {
    }

    @Override
    public Set<Tag> getCustomOccTags() {
        return Set.of();
    }

    @Override
    public void setCustomOccTags(Set<Tag> tags) {
    }
}

