/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.data.property.Function1dProp;
import merlin.data.value.ImpulseFunction1d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.units.UnitDouble;

public class ByTimeFlowrateEditor
extends AValEditor<ImpulseFunction1d> {
    private static final long serialVersionUID = 1L;
    private final guiTable d_table;
    private final Semaphore d_valLock = new Semaphore(1);
    private boolean d_valueDirty = true;

    public ByTimeFlowrateEditor(Function1dProp prop) {
        super(ImpulseFunction1d.class);
        String[] headers = new String[]{Intl.intl("Time")};
        guiTableEditor ed = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, new Class[]{UnitDouble.class}), 30);
        this.d_table = ed.getTable();
        this.d_table.setNullValuesAllowed(true);
        this.d_table.getColumnModel().getColumn(0).setCellEditor(new guiTable.UnitDoubleEditor(SI.SECOND));
        this.d_table.autoSizeColumns(700);
        this.d_table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.d_table.setPreferredScrollableViewportSize(new Dimension(this.d_table.getPreferredSize().width, Math.max(300, this.d_table.getPreferredSize().height)));
        this.d_table.getModel().addTableModelListener(e -> {
            this.d_valueDirty = true;
        });
        GridBagHelper gb = new GridBagHelper(this);
        gb.addTitle(Intl.intl("Occupant Entry Times"));
        gb.addRow(ed, new double[]{1.0, 1.0}, new int[]{1, 1});
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public String formatNonLiveValue() {
        return "";
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.addRow(this, 1.0);
    }

    @Override
    public ImpulseFunction1d getValue() {
        if (this.d_valueDirty && this.d_valLock.tryAcquire()) {
            this.updateValue();
            this.d_valueDirty = false;
            this.d_valLock.release();
        }
        return (ImpulseFunction1d)super.getValue();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (!this.getTimes().findAny().isPresent()) {
            if (showWarn) {
                JOptionPane.showMessageDialog(guiUtil.getWindow(this), Intl.intl("There must be at least one entry."), Intl.intl("Missing Occupants"), 2);
            }
            return false;
        }
        return true;
    }

    public Stream<UnitDouble> getTimes() {
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        int rows = model.getRowCount();
        return IntStream.range(0, rows).mapToObj(row -> (UnitDouble)model.getValueAt(row, 0)).filter(ud -> ud != null);
    }

    @Override
    protected void loadValue(ImpulseFunction1d var) {
        if (!this.d_valLock.tryAcquire()) {
            return;
        }
        this.d_table.clearRows();
        guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
        if (var != null) {
            assert (var.defaultValue.getRawValue() == 0.0);
            int row = 0;
            for (ImpulseFunction1d.Pulse entry : var.entries) {
                int numOccs = (int)Math.round(entry.duration.multiply(entry.y).get(Unit.ONE));
                for (int m = 0; m < numOccs; ++m) {
                    model.setValueAt(entry.x, row++, 0);
                }
            }
        }
        super.setValue(var);
        this.d_valueDirty = false;
        this.setModified(false);
        this.d_valLock.release();
    }

    @Override
    protected ImpulseFunction1d saveValue(Mediator mediator) {
        List times = this.getTimes().collect(Collectors.toCollection(() -> new ArrayList()));
        Collections.sort(times);
        return ImpulseFunction1d.toImpulseFunction(13, times);
    }
}

