/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.agents;

import common.data.SpeedInSmoke;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.egress.agents.OccProfile;
import merlin.data.property.Function1dProp;
import merlin.data.value.ConstFunction1d;
import merlin.data.value.IFunction1d;
import merlin.data.value.PiecewiseFunction1d;
import merlin.gui.MerlinUDF;
import merlin.gui.guiUtil;
import merlin.gui.value.Function1dEditorFactory;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Comm;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;

public class SpeedInSmokeEditor
extends HTMLBtn
implements Modifiable,
IValEditor<OccProfile.SpeedInSmokeConfig> {
    private static final long serialVersionUID = 1L;
    private final Comm d_comm;
    private boolean d_modified;
    private OccProfile.SpeedInSmokeConfig d_data;

    public SpeedInSmokeEditor(Comm comm) {
        super("");
        this.d_comm = comm;
        this.d_modified = false;
        this.addActionListener(e -> {
            OccProfile.SpeedInSmokeConfig newData;
            guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Speed in Smoke"), 9);
            SpeedInSmokePnl pnl = new SpeedInSmokePnl();
            pnl.load(this.d_data);
            dlg.getDialogPane().add(pnl);
            if (dlg.doModal() == 1 && !Objects.equals(newData = pnl.save(), this.d_data)) {
                this.setValue(newData);
                this.setModified(true);
                this.d_comm.touch(e);
            }
        });
        this.update();
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public String formatNonLiveValue() {
        return "";
    }

    @Override
    public <DomainT extends Mediator> OccProfile.SpeedInSmokeConfig commit(DomainT domain) {
        this.setModified(false);
        return this.getValue();
    }

    public void update() {
        if (this.d_data != null) {
            this.setText(SpeedInSmokeEditor.format(this.d_data));
        } else {
            this.setText(Intl.intl("&lt;mixed&gt;"));
        }
    }

    private static String format(OccProfile.SpeedInSmokeConfig data) {
        assert (data != null);
        StringBuilder sb = new StringBuilder();
        if (data.mode == SpeedInSmoke.Mode.DISABLED) {
            return data.mode.name;
        }
        if (data.mode == SpeedInSmoke.Mode.CUSTOM_VISIBILITY && data.customFuncVis instanceof ConstFunction1d) {
            int unit = data.customFuncVisType == SpeedInSmoke.FuncType.AS_GIVEN ? 5 : 11;
            sb.append(guiUtil.format(((ConstFunction1d)data.customFuncVis).val, unit));
        } else {
            sb.append(data.mode.name);
        }
        if (!Objects.equals(SpeedInSmoke.Data.DEFAULT.customFuncVisThreshold, data.customFuncVisThreshold)) {
            sb.append(String.format(Intl.intl(", threshold=%s"), guiUtil.format(data.customFuncVisThreshold, 0)));
        }
        if (!Objects.equals((Object)SpeedInSmoke.Data.DEFAULT.customFuncVisType, (Object)data.customFuncVisType)) {
            sb.append(String.format(Intl.intl(", %s"), new Object[]{data.customFuncVisType}));
        }
        return sb.toString();
    }

    @Override
    public Class<OccProfile.SpeedInSmokeConfig> getType() {
        return OccProfile.SpeedInSmokeConfig.class;
    }

    @Override
    public OccProfile.SpeedInSmokeConfig getValue() {
        return this.d_data;
    }

    @Override
    public void setValue(OccProfile.SpeedInSmokeConfig value) {
        if (!Objects.equals(this.d_data, value)) {
            OccProfile.SpeedInSmokeConfig oldVal = this.d_data;
            this.d_data = value;
            this.update();
            this.setModified(false);
            this.firePropertyChange("value", oldVal, this.d_data);
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.add(this, 1.0);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
    }

    private static class SpeedInSmokePnl
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final IFunction1d DEFAULT_CUSTOM_ASGIVEN = PiecewiseFunction1d.newFunction(SpeedInSmoke.CURVE_FRIDOLF);
        private static final IFunction1d DEFAULT_CUSTOM_ASFACTOR = PiecewiseFunction1d.newFunction(SpeedInSmoke.CURVE_FRIDOLF_ASFACTOR);
        private final guiRadioButton d_rbDisabled;
        private final guiRadioButton d_rbFridolf;
        private final guiRadioButton d_rbUserFuncVis;
        private final MerlinUDF d_thresholdVis;
        private final guiPanel d_userFuncCardPanel;
        private final IValEditor<IFunction1d> d_userFuncVis;
        private final IValEditor<IFunction1d> d_userFuncAsFactor;
        private final guiRadioButton d_userFuncTypeAsIs;
        private final guiRadioButton d_userFuncTypeFactor;

        public SpeedInSmokePnl() {
            this.d_rbDisabled = new guiRadioButton(SpeedInSmoke.Mode.DISABLED.alternateName);
            this.d_rbDisabled.setToolTipText(Intl.intl("Occupant speed not influenced by smoke."));
            this.d_rbFridolf = new guiRadioButton(SpeedInSmoke.Mode.FRIDOLF.alternateName);
            this.d_rbFridolf.setToolTipText(Intl.intl("Function based on both visibility and smoke-free max speed."));
            this.d_rbUserFuncVis = new guiRadioButton(SpeedInSmoke.Mode.CUSTOM_VISIBILITY.alternateName);
            this.d_rbUserFuncVis.setToolTipText(Intl.intl("Calculate maximum speed using a user defined function of visibility."));
            guiUtil.group(new AbstractButton[]{this.d_rbDisabled, this.d_rbFridolf, this.d_rbUserFuncVis});
            guiLabel lblThresholdVis = guiUtil.lblHtml(Intl.intl("Threshold Visibility:"), Intl.intl("Maximum value for visibility to influence occupant speed."));
            this.d_thresholdVis = new MerlinUDF(0);
            guiLabel lblUserFuncVis = guiUtil.lblHtml(Intl.intl("Function:"), Intl.intl("Custom maximum speed function."));
            this.d_userFuncVis = SpeedInSmokePnl.funcEditorVisibility();
            assert (this.d_userFuncVis.isLive()) : "Delayed visibility editor not yet supported";
            this.d_userFuncAsFactor = SpeedInSmokePnl.funcEditorAsFactor();
            assert (this.d_userFuncAsFactor.isLive()) : "Delayed factor editor not yet supported";
            String funcOptionVis = Intl.intl("Use as Given");
            String funcOptionFactor = Intl.intl("Use as Factor");
            this.d_userFuncCardPanel = new guiPanel(new CardLayout());
            this.d_userFuncCardPanel.add((Component)this.d_userFuncVis.getComponent(), funcOptionVis);
            this.d_userFuncCardPanel.add((Component)this.d_userFuncAsFactor.getComponent(), funcOptionFactor);
            guiLabel lblUserFuncVisType = guiUtil.lblHtml(Intl.intl("Function Type:"), "");
            this.d_userFuncTypeAsIs = new guiRadioButton(funcOptionVis);
            this.d_userFuncTypeAsIs.setToolTipText(Intl.intl("Maximum speed value will be used as given."));
            this.d_userFuncTypeFactor = new guiRadioButton(funcOptionFactor);
            this.d_userFuncTypeFactor.setToolTipText(Intl.intl("Value will be used as a factor to scale smoke-free max speed."));
            ButtonGroup bgFuncType = guiUtil.group(new AbstractButton[]{this.d_userFuncTypeAsIs, this.d_userFuncTypeFactor});
            guiUtil.addItemListener(bgFuncType, evt -> {
                if (evt.getStateChange() == 1 && evt.getSource() == this.d_userFuncTypeAsIs) {
                    CardLayout cards = (CardLayout)this.d_userFuncCardPanel.getLayout();
                    cards.show(this.d_userFuncCardPanel, funcOptionVis);
                } else if (evt.getStateChange() == 1 && evt.getSource() == this.d_userFuncTypeFactor) {
                    CardLayout cards = (CardLayout)this.d_userFuncCardPanel.getLayout();
                    cards.show(this.d_userFuncCardPanel, funcOptionFactor);
                }
            });
            guiUtil.link((AbstractButton)this.d_rbUserFuncVis, lblThresholdVis, this.d_thresholdVis, lblUserFuncVis, this.d_userFuncCardPanel, lblUserFuncVisType, this.d_userFuncTypeAsIs, this.d_userFuncTypeFactor);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_rbDisabled, 1.0, 0);
            gb.addRow(this.d_rbFridolf, 1.0, 0);
            gb.addRow(this.d_rbUserFuncVis, 1.0, 0);
            gb.addIdentRow(lblThresholdVis, 1, this.d_thresholdVis, 1.0, 0);
            gb.addIdentRow(lblUserFuncVisType, this.d_userFuncTypeAsIs, this.d_userFuncTypeFactor, 1.0, 0);
            gb.addIdentRow(lblUserFuncVis, this.d_userFuncCardPanel, 1.0, 0);
            gb.finalizeRows();
        }

        private static IValEditor<IFunction1d> funcEditorVisibility() {
            Function1dProp prop = new Function1dProp((Object)"speedInSmoke", "", DEFAULT_CUSTOM_ASGIVEN, Intl.intl("Max Speed Function"), Intl.intl("Occupant speed limit as a function of visibility."), Intl.intl("Speed in Smoke:"), null, new Function1dProp.Var(Intl.intl("Visibility"), 0, UnitDoubleVR.above(SIUS.newud(0.0, 0), true)), new Function1dProp.Var(Intl.intl("Max Speed"), 5, UnitDoubleVR.above(SIUS.newud(0.0, 5), true)), new UnitDouble[]{SIUS.newud(0.0, 0), null, SIUS.newud(0.0, 5), null}, Function1dEditorFactory.GENERAL_TYPES, Set.of(), new Function1dProp.PredefFunction[0]);
            return prop.newValueEditor(MerlinApp.getAppData(), false).get();
        }

        private static IValEditor<IFunction1d> funcEditorAsFactor() {
            Function1dProp prop = new Function1dProp((Object)"speedInSmoke", "", DEFAULT_CUSTOM_ASFACTOR, Intl.intl("Max Speed Function"), Intl.intl("Occupant speed limit as a factor."), Intl.intl("Speed in Smoke:"), null, new Function1dProp.Var(Intl.intl("Visibility"), 0, UnitDoubleVR.above(SIUS.newud(0.0, 0), true)), new Function1dProp.Var(Intl.intl("Fraction of Max Speed"), 11, UnitDoubleVR.above(new UnitDouble(0.0, Unit.ONE), true)), new UnitDouble[]{SIUS.newud(0.0, 0), null, new UnitDouble(0.0, Unit.ONE), null}, Function1dEditorFactory.GENERAL_TYPES, Set.of(), new Function1dProp.PredefFunction[0]);
            return prop.newValueEditor(MerlinApp.getAppData(), false).get();
        }

        public void load(OccProfile.SpeedInSmokeConfig data) {
            if (data == null) {
                data = new OccProfile.SpeedInSmokeConfig(SpeedInSmoke.Data.DEFAULT);
            }
            this.d_rbDisabled.setSelected(data.mode == SpeedInSmoke.Mode.DISABLED);
            this.d_rbFridolf.setSelected(data.mode == SpeedInSmoke.Mode.FRIDOLF);
            this.d_rbUserFuncVis.setSelected(data.mode == SpeedInSmoke.Mode.CUSTOM_VISIBILITY);
            this.d_thresholdVis.setValue(data.customFuncVisThreshold);
            if (data.customFuncVisType == SpeedInSmoke.FuncType.AS_GIVEN && data.customFuncVis != null) {
                this.d_userFuncVis.setValue(data.customFuncVis);
            } else {
                this.d_userFuncVis.setValue(DEFAULT_CUSTOM_ASGIVEN);
            }
            if (data.customFuncVisType == SpeedInSmoke.FuncType.AS_FACTOR && data.customFuncVis != null) {
                this.d_userFuncAsFactor.setValue(data.customFuncVis);
            } else {
                this.d_userFuncAsFactor.setValue(DEFAULT_CUSTOM_ASFACTOR);
            }
            this.d_userFuncTypeAsIs.setSelected(data.customFuncVisType == SpeedInSmoke.FuncType.AS_GIVEN);
            this.d_userFuncTypeFactor.setSelected(data.customFuncVisType == SpeedInSmoke.FuncType.AS_FACTOR);
        }

        public OccProfile.SpeedInSmokeConfig save() {
            IFunction1d customFunc;
            SpeedInSmoke.FuncType customFuncType;
            SpeedInSmoke.Mode mode;
            if (this.d_rbDisabled.isSelected()) {
                mode = SpeedInSmoke.Mode.DISABLED;
            } else if (this.d_rbFridolf.isSelected()) {
                mode = SpeedInSmoke.Mode.FRIDOLF;
            } else if (this.d_rbUserFuncVis.isSelected()) {
                mode = SpeedInSmoke.Mode.CUSTOM_VISIBILITY;
            } else {
                throw new IllegalStateException("unknown mode");
            }
            if (this.d_userFuncTypeAsIs.isSelected()) {
                customFuncType = SpeedInSmoke.FuncType.AS_GIVEN;
                customFunc = this.d_userFuncVis.getValue();
            } else if (this.d_userFuncTypeFactor.isSelected()) {
                customFuncType = SpeedInSmoke.FuncType.AS_FACTOR;
                customFunc = this.d_userFuncAsFactor.getValue();
            } else {
                throw new IllegalStateException("unknown custom function type");
            }
            return new OccProfile.SpeedInSmokeConfig(mode, (UnitDouble)this.d_thresholdVis.getValue(), customFuncType, customFunc);
        }
    }
}

