/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComponent;
import merlin.data.MerlinData;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.gui.StrTagsField;
import merlin.util.StringTagsUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.value.IValEditor;

public class TagsEditor
implements IValEditor<Set<Tag>>,
PropertyChangeListener {
    private final StrTagsField d_strTagsFld;
    private Set<Tag> d_value = Collections.emptySet();

    public TagsEditor(boolean emptyAllowed) {
        this(TagsEditor.newStrTagsField(emptyAllowed));
    }

    public TagsEditor(StrTagsField field) {
        this.d_strTagsFld = field;
        this.d_strTagsFld.setNullAllowed(true);
        this.d_strTagsFld.addValueCommitListener(this);
    }

    private static StrTagsField newStrTagsField(boolean emptyAllowed) {
        StrTagsField tags = new StrTagsField();
        tags.setEmptyAllowed(emptyAllowed);
        return tags;
    }

    @Override
    public Class<Set<Tag>> getType() {
        return Set.class;
    }

    @Override
    public Set<Tag> getValue() {
        return this.d_value;
    }

    @Override
    public boolean isLive() {
        return false;
    }

    @Override
    public String formatNonLiveValue() {
        Set strTags = (Set)this.d_strTagsFld.getValue();
        return StringTagsUtil.format(strTags);
    }

    @Override
    public <DomainT extends Mediator> Set<Tag> commit(DomainT domain) {
        MerlinData md = (MerlinData)domain;
        Set<Tag> result = TagsUtil.getOrCreateTags((Set)this.d_strTagsFld.getValue(), md);
        this.setValue(result);
        this.d_strTagsFld.setModified(false);
        return result;
    }

    @Override
    public void setValue(Set<Tag> value) {
        this.d_value = value;
        this.d_strTagsFld.removeValueCommitListener(this);
        this.d_strTagsFld.setTypedValue(TagsUtil.tagsAsStrings(value));
        this.d_strTagsFld.addValueCommitListener(this);
    }

    @Override
    public JComponent getComponent() {
        return this.d_strTagsFld;
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.add(this.d_strTagsFld);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.d_strTagsFld.firePropertyChange("value", false, true);
    }
}

