/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.scenario.Scenario;
import merlin.util.MerlinUtil;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.MutableInt;

public class ScenarioEditorPanel
extends guiPanel
implements IEditor<Scenario> {
    private static final long serialVersionUID = -3921857112384823448L;
    private static final Logger LOGGER = Logger.getLogger(ScenarioEditorPanel.class.getSimpleName());
    private final guiTextField d_name;
    private final guiTextField d_desc;
    private final ColorButton d_colorBtn;
    private static final int COLUMN_TYPE = 0;
    private static final int COLUMN_OBJECT = 1;
    private static final int COLUMN_PROPERTY = 2;
    private static final int COLUMN_DEFAULT_VALUE = 3;
    private static final int COLUMN_VALUE = 4;
    private final guiTableEditor d_tableEditor;
    private final guiTable d_table;
    private final JCheckBox d_showOnlyNonDefaultsCb;
    private Scenario d_loadedObject;

    public ScenarioEditorPanel() {
        this.setLayout(new GridBagLayout());
        this.d_name = new guiTextField();
        this.d_name.setEditable(false);
        this.d_desc = new guiTextField();
        this.d_desc.getDocument().addDocumentListener(this.d_comm);
        this.d_colorBtn = new ColorButton(1);
        this.d_colorBtn.addObserver(this.d_comm);
        String[] headers = new String[]{Intl.intl("Object Type"), Intl.intl("Object"), Intl.intl("Property"), Intl.intl("Default Value"), Intl.intl("Scenario Value")};
        Class[] colClasses = new Class[]{String.class, String.class, String.class, String.class, String.class};
        this.d_tableEditor = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, colClasses, 23), 0);
        this.d_table = this.d_tableEditor.getTable();
        this.d_table.setColumnEditable(0, false);
        this.d_table.setColumnEditable(1, false);
        this.d_table.setColumnEditable(2, false);
        this.d_table.setColumnEditable(3, false);
        this.d_table.setColumnEditable(4, false);
        this.d_table.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.d_table.getSelectionModel().setSelectionMode(0);
        this.d_table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new JTextField()));
        this.d_table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(new JTextField()));
        this.d_table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(new JTextField()));
        this.d_table.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(new JTextField()));
        this.d_table.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(new JTextField()));
        this.d_table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer());
        this.d_table.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer());
        this.d_table.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer());
        this.d_table.getColumnModel().getColumn(3).setCellRenderer(new DefaultTableCellRenderer());
        this.d_table.getColumnModel().getColumn(4).setCellRenderer(new DefaultTableCellRenderer());
        this.d_table.autoSizeColumns(300);
        this.d_table.addMouseListener(new MouseListener(this){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.d_showOnlyNonDefaultsCb = new JCheckBox(Intl.intl("Show non-default values only"));
        this.d_showOnlyNonDefaultsCb.addItemListener(e -> {
            boolean modified = this.isModified();
            this.loadTable(MerlinApp.getAppData(), this.d_loadedObject);
            if (!modified) {
                this.setModified(false);
            }
        });
        this.d_showOnlyNonDefaultsCb.setSelected(true);
        this.setLayout(new MigLayout("insets 0, gap 6, wrap 2", "[][grow]"));
        this.add(new guiLabel(Intl.intl("Name:")));
        this.add((Component)this.d_name, "span, pushx, grow");
        this.add(new guiLabel(Intl.intl("Description:")));
        this.add((Component)this.d_desc, "span, pushx, grow");
        this.add(new guiLabel(Scenario.PROP_COLOR.getDisplayName() + ":"));
        this.add((Component)this.d_colorBtn, "grow 0");
        this.add((Component)new TitleSeparator(Intl.intl("Customized Properties")), "span, grow");
        this.add((Component)this.d_tableEditor, "span, grow, push, width 500:500:");
        this.add((Component)this.d_showOnlyNonDefaultsCb, "span, grow");
    }

    @Override
    public void init(Scenario dataObj) {
        if (dataObj == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            MerlinData md = MerlinApp.getApp().getData();
            this.d_name.setText(dataObj.get(NamedMerlinObj.NAME));
            this.d_desc.setText(dataObj.get(Scenario.DESCRIPTION));
            this.d_colorBtn.setColor(dataObj.get(Scenario.PROP_COLOR));
            if (dataObj.isDefault()) {
                this.d_colorBtn.setEnabled(false);
            }
            this.loadTable(md, dataObj);
            this.d_loadedObject = dataObj;
            this.setModified(false);
        }
    }

    private void updateColumnSizes() {
        int[] nonValCols = new int[]{0, 1, 2};
        IntStream.of(nonValCols).forEach(i -> this.d_table.getColumnModel().getColumn(i).setMaxWidth(Integer.MAX_VALUE));
        this.d_table.autoSizeColumns(300);
        IntStream.of(nonValCols).forEach(i -> {
            TableColumn column = this.d_table.getColumnModel().getColumn(i);
            column.setMaxWidth(column.getPreferredWidth());
        });
    }

    private void loadTable(MerlinData md, Scenario dataObj) {
        this.d_table.clearRows();
        if (dataObj == null || dataObj.isDefault()) {
            return;
        }
        Set<IMerlinObj> customObjs = dataObj.getCustomizedObjects();
        MutableInt mrow = new MutableInt(0);
        customObjs.stream().flatMap(obj -> {
            String objType = EntryPointFactory.get(obj).getCategoryName(md, (IMerlinObj)obj);
            String objName = MerlinUtil.getName(obj);
            return dataObj.streamCustomVals((IMerlinObj)obj).filter(kvPair -> {
                if (!this.d_showOnlyNonDefaultsCb.isSelected()) {
                    return true;
                }
                IDisplayProp prop = kvPair.prop();
                Object scenarioValue = kvPair.val();
                Object defaultValue = md.scenarios.getDefaultScenarioValue(obj, prop).orElse(null);
                return !Objects.deepEquals(defaultValue, scenarioValue);
            }).map(entry -> {
                String defStr;
                Object defVal = md.scenarios.getDefaultScenarioValue(obj, entry.prop()).orElse(null);
                try {
                    defStr = entry.prop().formatValue(obj, defVal);
                }
                catch (Throwable t) {
                    assert (false);
                    TeciLogging.log(LOGGER, t);
                    defStr = Intl.intl("<undefined>");
                }
                return new String[]{objType, objName, entry.prop().getDisplayName(), defStr, entry.prop().formatValue(obj, entry.val())};
            });
        }).sorted((v1, v2) -> {
            int typeCompare = v1[0].compareTo(v2[0]);
            if (typeCompare != 0) {
                return typeCompare;
            }
            int objectCompare = v1[1].compareTo(v2[1]);
            if (objectCompare != 0) {
                return objectCompare;
            }
            int propertyCompare = v1[3].compareTo(v2[3]);
            return propertyCompare;
        }).forEachOrdered(v -> {
            int row = mrow.val++;
            this.d_table.getModel().setValueAt(v[0], row, 0);
            this.d_table.getModel().setValueAt(v[1], row, 1);
            this.d_table.getModel().setValueAt(v[2], row, 2);
            this.d_table.getModel().setValueAt(v[3], row, 3);
            this.d_table.getModel().setValueAt(v[4], row, 4);
        });
        this.updateColumnSizes();
    }

    @Override
    public Scenario commit(final Scenario dataObj) {
        if (dataObj != null) {
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    try (MerlinData.WriteLock lock = md.lockWrite();){
                        Undo.begin(Intl.intl("Edit Scenario"));
                        Undo.insertUndoEntry_propRestore(md, Collections.singleton(dataObj), Scenario.DESCRIPTION);
                        dataObj.set(Scenario.DESCRIPTION, ScenarioEditorPanel.this.d_desc.getText());
                        Undo.insertUndoEntry_propRestore(md, Collections.singleton(dataObj), Scenario.PROP_COLOR);
                        dataObj.set(Scenario.PROP_COLOR, ScenarioEditorPanel.this.d_colorBtn.getColor());
                        Undo.end(MerlinApp.getApp().getData());
                    }
                }
            };
            UIHook.run(this, "ScenarioEditorPanel.commit", op, 0);
        }
        this.setModified(false);
        return dataObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }
}

