/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import common.data.EscalatorPreference;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.vecmath.Point3f;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.ObjsFilter;
import merlin.data.egress.agents.IProfileProp;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.ProfileProps;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.property.Function1dProp;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.data.value.IFunction1d;
import merlin.gui.AvatarEditor;
import merlin.gui.StrTagsField;
import merlin.gui.agents.AttractorsFilterEditorComponents;
import merlin.gui.agents.CompRestrictionsPanel;
import merlin.gui.agents.PersonalDistanceEditor;
import merlin.gui.agents.ShapeEditor;
import merlin.gui.agents.SpeedInSmokeEditor;
import merlin.gui.guiUtil;
import merlin.gui.labels.ILabelGenerator;
import merlin.gui.labels.WrappedComp;
import merlin.gui.stat.VerboseCurveEditor;
import merlin.gui.stat.guiCurveUtil;
import merlin.gui.value.Function1dEditorFactory;
import merlin.unitsystem.SIUS;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.value.AValEditor;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.gui.value.MultiValEditor;
import thunderheadeng.gui.value.PopupValEditor;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.stat.UrnUtil;

public class ProfilesPanel
extends guiPanel
implements IEditor<OccProfile> {
    private static final long serialVersionUID = 1L;
    private final guiTextField d_name;
    private final guiTextField d_desc;
    private final StrTagsField d_tags;
    private final AvatarEditor d_model;
    private final ColorButton d_colorBtn;
    private final CharPanel d_propsPnl;
    private final MovementPanel d_behaviorPnl;
    private final RestrictionsPanel d_restrictionsPnl;
    private final DoorChoicePanel d_doorChoicePnl;
    private final AnimationPanel d_animPnl;
    private final OutputPanel d_outputPnl;
    private final AdvancedPanel d_advancedPnl;
    private static List<TypedProp<?>> ADVANCED_SPEED_PROPS = Arrays.asList(OccProfile.PROP_MAXVEL, OccProfile.PROP_FUNDAMENTAL, OccProfile.PROP_STAIR_SPEED_UP, OccProfile.PROP_STAIR_FUNDAMENTAL_UP, OccProfile.PROP_STAIR_SPEED_DOWN, OccProfile.PROP_STAIR_FUNDAMENTAL_DOWN, OccProfile.PROP_RAMP_SPEED_UP, OccProfile.PROP_RAMP_FUNDAMENTAL_UP, OccProfile.PROP_RAMP_SPEED_DOWN, OccProfile.PROP_RAMP_FUNDAMENTAL_DOWN);

    public ProfilesPanel(Window owner, ILabelGenerator labels) {
        this.setLayout(new GridBagLayout());
        MerlinData md = MerlinApp.getApp().getData();
        this.d_name = new guiTextField();
        this.d_name.setEditable(false);
        this.d_desc = new guiTextField();
        this.d_desc.getDocument().addDocumentListener(this.d_comm);
        this.d_tags = new StrTagsField();
        this.d_colorBtn = new ColorButton(1);
        this.d_model = new AvatarEditor(3, ResourceAvatar.Type.OCCUPANT);
        this.d_model.addValueListener(e -> this.setModified(true));
        Border border = BorderFactory.createEmptyBorder(12, 12, 12, 12);
        this.d_propsPnl = new CharPanel(md, labels);
        this.d_propsPnl.setBorder(border);
        this.d_behaviorPnl = new MovementPanel(md, labels);
        this.d_behaviorPnl.setBorder(border);
        this.d_restrictionsPnl = new RestrictionsPanel(md, labels);
        this.d_restrictionsPnl.setBorder(border);
        this.d_advancedPnl = new AdvancedPanel(md, labels);
        this.d_advancedPnl.setBorder(border);
        this.d_doorChoicePnl = new DoorChoicePanel(md, labels);
        this.d_doorChoicePnl.setBorder(border);
        this.d_animPnl = new AnimationPanel(md, labels);
        this.d_animPnl.setBorder(border);
        this.d_outputPnl = new OutputPanel(md, labels);
        this.d_outputPnl.setBorder(border);
        JTabbedPane tb = new JTabbedPane();
        tb.addTab(CharPanel.TITLE, this.d_propsPnl);
        tb.addTab(MovementPanel.TITLE, this.d_behaviorPnl);
        tb.addTab(RestrictionsPanel.TITLE, this.d_restrictionsPnl);
        tb.addTab(DoorChoicePanel.TITLE, this.d_doorChoicePnl);
        tb.addTab(AnimationPanel.TITLE, this.d_animPnl);
        tb.addTab(OutputPanel.TITLE, this.d_outputPnl);
        tb.addTab(AdvancedPanel.TITLE, this.d_advancedPnl);
        this.setLayout(new MigLayout("insets 0, gap 6, wrap 2", "[fill][fill]"));
        this.add(labels.lbl(OccProfile.PROP_NAME));
        this.add(this.d_name);
        this.add(labels.lbl(OccProfile.PROP_DESC));
        this.add(this.d_desc);
        this.add(labels.lbl(OccProfile.PROP_TAGS));
        this.add(this.d_tags);
        this.add(labels.lbl(OccProfile.PROP_OCCMODEL));
        this.add((Component)this.d_model, "height 25::");
        this.add(labels.lbl(OccProfile.PROP_COLOR));
        this.add((Component)this.d_colorBtn, "grow 0");
        this.add((Component)tb, "span, pushy, grow");
    }

    @Override
    public OccProfile preview(OccProfile previewObj) {
        return previewObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(OccProfile dataObj) {
        if (dataObj != null) {
            MerlinData md = MerlinApp.getApp().getData();
            try (MerlinData.ReadLock lock = md.lockRead();){
                this.d_name.setText(dataObj.get(OccProfile.PROP_NAME));
                this.d_desc.setText(dataObj.get(OccProfile.PROP_DESC));
                this.d_tags.setTypedValue(TagsUtil.tagsAsStrings(dataObj.get(OccProfile.PROP_TAGS)));
                Point3f c3f = dataObj.get(OccProfile.PROP_COLOR);
                this.d_colorBtn.setColor(new Color(c3f.x, c3f.y, c3f.z, 1.0f));
                this.d_model.setValue(PropValue.of((IUrn)dataObj.get(OccProfile.PROP_OCCMODEL)));
                this.d_propsPnl.init(dataObj);
                this.d_behaviorPnl.init(dataObj);
                this.d_restrictionsPnl.init(dataObj);
                this.d_advancedPnl.init(dataObj);
                this.d_outputPnl.init(dataObj);
                this.d_doorChoicePnl.init(dataObj);
                this.d_animPnl.init(dataObj);
            }
        }
        this.setEnabled(dataObj != null);
        this.setModified(false);
        this.repaint();
    }

    @Override
    public OccProfile commit(final OccProfile dataObj) {
        if (dataObj != null) {
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    try (MerlinData.WriteLock lock = md.lockWrite();){
                        Undo.begin(Intl.intl("Edit Profile"));
                        ProfilesPanel.this.commitProfile(md, dataObj, true);
                        Undo.end(MerlinApp.getApp().getData());
                    }
                }
            };
            UIHook.run(this, "ProfilesPanel.commit", op, 0);
        }
        this.setModified(false);
        return dataObj;
    }

    private void commitProfile(MerlinData md, OccProfile profile, boolean commitToDataModel) {
        if (profile == null) {
            return;
        }
        if (commitToDataModel) {
            Undo.insertUndoEntry_restore(md, profile);
        }
        profile.set(OccProfile.PROP_DESC, this.d_desc.getText());
        Color c = this.d_colorBtn.getColor();
        Point3f c3f = new Point3f((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
        profile.set(OccProfile.PROP_COLOR, c3f);
        profile.set(OccProfile.PROP_OCCMODEL, (IUrn)((PropValue)this.d_model.getValue()).get());
        if (commitToDataModel) {
            assert (md != null);
            profile.set(OccProfile.PROP_TAGS, TagsUtil.getOrCreateTags((Set)this.d_tags.getValue(), md));
        }
        this.d_propsPnl.commit(profile, commitToDataModel);
        this.d_behaviorPnl.commit(profile, commitToDataModel);
        this.d_restrictionsPnl.commit(profile, commitToDataModel);
        this.d_advancedPnl.commit(md, profile, commitToDataModel);
        this.d_outputPnl.commit(profile, commitToDataModel);
        this.d_doorChoicePnl.commit(profile, commitToDataModel);
        this.d_animPnl.commit(profile, commitToDataModel);
    }

    public Collection<IDisplayProp> getChanges(OccProfile origProf) {
        OccProfile tempProf = origProf.clone();
        this.commitProfile(null, tempProf, false);
        ArrayList<IDisplayProp> changes = new ArrayList<IDisplayProp>();
        Set strTagsNew = (Set)this.d_tags.getValue();
        Set<String> strTagsOld = TagsUtil.tagsAsStrings(origProf.get(OccProfile.PROP_TAGS));
        if (!strTagsNew.equals(strTagsOld)) {
            changes.add(OccProfile.PROP_TAGS);
        }
        for (TypedProp<?> o : tempProf.getSupportedProps(IMerlinObj.SupportMode.UNION)) {
            if (Objects.equals(tempProf.get(o), origProf.get(o))) continue;
            assert (o instanceof IDisplayProp);
            if (!(o instanceof IDisplayProp)) continue;
            IDisplayProp displayProp = (IDisplayProp)((Object)o);
            changes.add(displayProp);
        }
        return changes;
    }

    public static boolean checkReset(Component comp, String valType) {
        int option = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(comp), String.format("<html>" + Intl.intl("Are you sure you want to reset to the default <b>%s</b> values?") + "</html>", valType), Intl.intl("Confirm Reset"), 0);
        return option == 0;
    }

    private static IValEditor<OccProfile> newSpeedEditor() {
        Predicate<OccProfile> isAdvanced = prof -> ADVANCED_SPEED_PROPS.stream().anyMatch(prop -> prop != OccProfile.PROP_MAXVEL && !Objects.equals(prof.get(prop), prop.defVal));
        Collection<MultiValEditor.Entry<ICurve, ? extends ICurve>> curveEntries = VerboseCurveEditor.getEntries(5, 15, false, UnitDoubleVR.above(0.0, SIUS.unit(5), true));
        ArrayList speedEntries = new ArrayList();
        for (MultiValEditor.Entry<ICurve, ? extends ICurve> entry : curveEntries) {
            MultiValEditor.Entry<OccProfile, OccProfile> newEntry = new MultiValEditor.Entry<OccProfile, OccProfile>(entry.key, entry.tooltip, new ProfileSpeedEditor(entry.editor), prof -> {
                if (prof == null || isAdvanced.test((OccProfile)prof)) {
                    return false;
                }
                ICurve curve = (ICurve)prof.get(OccProfile.PROP_MAXVEL);
                return entry.editor.getType().isInstance(curve) && entry.filter.test(curve);
            }, entry.init, prof -> {
                OccProfile result = new OccProfile();
                ICurve newCurve = (ICurve)entry.converter.apply((ICurve)prof.get(OccProfile.PROP_MAXVEL));
                result.set(OccProfile.PROP_MAXVEL, newCurve);
                return result;
            });
            speedEntries.add(newEntry);
        }
        PopupValEditor<OccProfile> advSpeedEditor = new PopupValEditor<OccProfile>(PopupValEditor.Mode.BUTTON, OccProfile.class, Intl.intl("Advanced Speed Properties"), () -> new AdvancedSpeedEditor(), profile -> AdvancedSpeedEditor.format(profile));
        speedEntries.add(new MultiValEditor.Entry<OccProfile, OccProfile>(Intl.intl("Advanced"), "<html>" + Intl.intl("Enter advanced speed properties, such as the speed-density profile<br>and ramp and stair speeds."), advSpeedEditor, o -> o != null, () -> advSpeedEditor.editValue(), o -> o));
        return new MultiValEditor(OccProfile.class, speedEntries, false);
    }

    private static guiLabel newLabel(Function1dProp prop) {
        guiLabel lbl = new guiLabel(prop.desc + ":");
        if (prop.longDesc != null) {
            lbl.setToolTipText(prop.longDesc);
        }
        return lbl;
    }

    private static <T> IUrn<T> toUrn(T value) {
        return new Urn<Object>(value);
    }

    private static <T> EditorInfo<T> addProp(MerlinData md, guiPanel panel, GridBagHelper gb, Consumer<? super EditorInfo<T>> editors, IProfileProp<?, T> prop, ILabelGenerator labels) {
        WrappedComp<guiLabel> lbl = labels.lbl(prop);
        IValEditor editor = prop.newValueEditor(md, false).get();
        editor.addValueListener(e -> panel.setModified(true));
        gb.addRow(lbl, editor.getComponent(), 1.0);
        EditorInfo<T> edInfo = new EditorInfo<T>(prop, editor);
        editors.accept(edInfo);
        return edInfo;
    }

    private static class CharPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Characteristics");
        private final IValEditor<OccProfile> d_speed;
        private final guiIntField d_priorityFld;
        private final JButton d_resetBtn;
        private final ShapeEditor.ShapePnl d_shapePnl;

        public CharPanel(MerlinData md, ILabelGenerator labels) {
            WrappedComp<guiLabel> speedLbl = labels.lbl(OccProfile.PROP_MAXVEL);
            this.d_speed = ProfilesPanel.newSpeedEditor();
            WrappedComp<guiLabel> priorityLbl = labels.lbl(OccProfile.PROP_PRIORITY_LEVEL);
            this.d_priorityFld = new guiIntField(IntVR.above(0, true));
            this.d_priorityFld.setColumns(6);
            this.d_shapePnl = new ShapeEditor.ShapePnl(md, labels, 15);
            this.d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));
            this.d_resetBtn.addActionListener(arg0 -> {
                if (!ProfilesPanel.checkReset(this, TITLE)) {
                    return;
                }
                this.init(new OccProfile());
                this.setModified(true);
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(new Object[]{priorityLbl, this.d_priorityFld, 1, GridBagHelper.Fill.HORIZONTAL});
            gb.add(speedLbl);
            this.d_speed.add(gb);
            this.d_shapePnl.add(md, labels, gb, this);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.addRow(this.d_resetBtn, 0);
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_speed.setValue(this.getSpeedVal(dataObj));
            this.d_priorityFld.setValue((Integer)UrnUtil.getDominant((IUrn)dataObj.get(OccProfile.PROP_PRIORITY_LEVEL)));
            this.d_shapePnl.load((OccProfile.OccShape)dataObj.get(OccProfile.PROP_SHAPE));
            this.setModified(false);
            this.repaint();
        }

        private static <T> IUrn<T> toUrn(T value) {
            return new Urn<Object>(value);
        }

        public void commit(OccProfile dataObj, boolean commitToDataModel) {
            assert (dataObj != null);
            this.saveSpeed(dataObj, this.d_speed.getValue());
            dataObj.set(OccProfile.PROP_PRIORITY_LEVEL, CharPanel.toUrn((Integer)this.d_priorityFld.getValue()));
            dataObj.set(OccProfile.PROP_SHAPE, this.d_shapePnl.save());
            if (commitToDataModel) {
                this.setModified(false);
            }
        }

        private OccProfile getSpeedVal(OccProfile val) {
            OccProfile adv = new OccProfile();
            CharPanel.copyAdvancedVals(val, adv);
            return adv;
        }

        private void saveSpeed(OccProfile val, OccProfile speed) {
            CharPanel.copyAdvancedVals(speed, val);
        }

        private static void copyAdvancedVals(OccProfile src, OccProfile target) {
            for (TypedProp<?> prop : ADVANCED_SPEED_PROPS) {
                target.set(prop, src.get(prop));
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            return this.d_shapePnl.validateData(showWarn, allowModify);
        }
    }

    private static class MovementPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Movement");
        private final JButton d_resetBtn;
        private final WrappedComp<guiMultiStateCheckBox> d_assisted;
        private final WrappedComp<guiMultiStateCheckBox> d_requiresAssistance;
        private final WrappedComp<guiMultiStateCheckBox> d_ignoreOnewayDoors;
        private final guiComboBox<EscalatorPreference> d_escalatorPreference;
        private final IValEditor<ICurve> d_orient;
        private final IValEditor<ICurve> d_attractorSuscSeek;
        private final IValEditor<ICurve> d_attractorSuscWait;
        private final AttractorsFilterEditorComponents d_attrRestrictions;

        public MovementPanel(MerlinData md, ILabelGenerator labels) {
            WrappedComp<guiLabel> orientLbl = labels.lbl(OccProfile.PROP_INIT_ORIENT);
            this.d_orient = OccProfile.PROP_INIT_ORIENT.newValueEditor(md, false).get();
            this.d_assisted = labels.checkbox(OccProfile.PROP_ASSIST);
            this.d_requiresAssistance = labels.checkbox(OccProfile.PROP_REQUIRES_ASSISTANCE);
            this.d_ignoreOnewayDoors = labels.checkbox(OccProfile.PROP_OBEY_ONEWAY_DOORS);
            WrappedComp<guiLabel> escalatorPrefLabel = labels.lbl(OccProfile.PROP_ESCALATOR_PREF);
            this.d_escalatorPreference = guiUtil.newCombo(val -> new Pair<String, Object>(val.name, null), EscalatorPreference.values());
            escalatorPrefLabel.setToolTipText(OccProfile.PROP_ESCALATOR_PREF.getDisplayDesc());
            this.d_attractorSuscSeek = OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK.newValueEditor(md, false).get();
            this.d_attractorSuscWait = OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE.newValueEditor(md, false).get();
            this.d_attrRestrictions = new AttractorsFilterEditorComponents(md, Intl.intl("Triggers"), labelStr -> labels.lbl(OccProfile.PROP_ATTRACTOR_RESTRICTIONS, (String)labelStr, ""));
            this.d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));
            this.d_resetBtn.addActionListener(evt -> {
                if (!ProfilesPanel.checkReset(this, TITLE)) {
                    return;
                }
                this.init(new OccProfile());
                this.setModified(true);
            });
            GridBagHelper gb = new GridBagHelper(this);
            if (MerlinApp.isFP()) {
                gb.addRow(this.d_assisted, 1.0, 0);
            }
            gb.addRow(orientLbl, this.d_orient, 1.0, 0);
            gb.addRow(this.d_requiresAssistance, 0);
            gb.addRow(this.d_ignoreOnewayDoors, 0);
            gb.addRow(escalatorPrefLabel, this.d_escalatorPreference, 0);
            gb.addRow(labels.lbl(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK), this.d_attractorSuscSeek, 0);
            gb.addRow(labels.lbl(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE), this.d_attractorSuscWait, 0);
            this.d_attrRestrictions.addToLayout(gb);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.addRow(this.d_resetBtn, 0);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            return this.d_attrRestrictions.validateData(this, showWarn, allowModify);
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_orient.setValue((ICurve)dataObj.get(OccProfile.PROP_INIT_ORIENT));
            ((guiMultiStateCheckBox)this.d_assisted.comp).setSelected((Boolean)UrnUtil.getDominant((IUrn)dataObj.get(OccProfile.PROP_ASSIST)));
            ((guiMultiStateCheckBox)this.d_requiresAssistance.comp).setSelected((Boolean)UrnUtil.getDominant((IUrn)dataObj.get(OccProfile.PROP_REQUIRES_ASSISTANCE)));
            ((guiMultiStateCheckBox)this.d_ignoreOnewayDoors.comp).setSelected((Boolean)UrnUtil.getDominant((IUrn)dataObj.get(OccProfile.PROP_OBEY_ONEWAY_DOORS)) == false);
            this.d_escalatorPreference.setSelectedItem(UrnUtil.getDominant((IUrn)dataObj.get(OccProfile.PROP_ESCALATOR_PREF)));
            this.d_attractorSuscSeek.setValue((ICurve)dataObj.get(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK));
            this.d_attractorSuscWait.setValue((ICurve)dataObj.get(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE));
            this.d_attrRestrictions.setValue(dataObj.get(OccProfile.PROP_ATTRACTOR_RESTRICTIONS));
            this.setModified(false);
            this.repaint();
        }

        public void commit(OccProfile dataObj, boolean commitToDataModel) {
            assert (dataObj != null);
            dataObj.set(OccProfile.PROP_ASSIST, ProfilesPanel.toUrn(((guiMultiStateCheckBox)this.d_assisted.comp).isSelected()));
            dataObj.set(OccProfile.PROP_REQUIRES_ASSISTANCE, ProfilesPanel.toUrn(((guiMultiStateCheckBox)this.d_requiresAssistance.comp).isSelected()));
            dataObj.set(OccProfile.PROP_OBEY_ONEWAY_DOORS, ProfilesPanel.toUrn(!((guiMultiStateCheckBox)this.d_ignoreOnewayDoors.comp).isSelected()));
            dataObj.set(OccProfile.PROP_ESCALATOR_PREF, ProfilesPanel.toUrn(this.d_escalatorPreference.getSelectedItem()));
            dataObj.set(OccProfile.PROP_INIT_ORIENT, this.d_orient.getValue());
            dataObj.set(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_SEEK, this.d_attractorSuscSeek.getValue());
            dataObj.set(OccProfile.PROP_ATTRACTOR_SUSCEPTIBILITY_IDLE, this.d_attractorSuscWait.getValue());
            dataObj.set(OccProfile.PROP_ATTRACTOR_RESTRICTIONS, this.d_attrRestrictions.getValue());
            if (commitToDataModel) {
                this.setModified(false);
            }
        }
    }

    public static class RestrictionsPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        public static final String TITLE = Intl.intl("Restrictions");
        private final JButton d_resetBtn;
        private final CompRestrictionsPanel d_restrictionsPnl;

        public RestrictionsPanel(MerlinData md, ILabelGenerator labels) {
            this.d_restrictionsPnl = new CompRestrictionsPanel(md, labels);
            this.d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));
            this.d_resetBtn.addActionListener(arg0 -> {
                if (!ProfilesPanel.checkReset(this, TITLE)) {
                    return;
                }
                this.init(new OccProfile());
                this.setModified(true);
            });
            this.setLayout(new MigLayout("insets 0, gap 6"));
            this.d_restrictionsPnl.addToLayout(this);
            this.add((Component)this.d_resetBtn, "newline push, span");
        }

        public void init(OccProfile dataObj) {
            this.d_restrictionsPnl.init(dataObj);
            this.repaint();
        }

        public void commit(OccProfile dataObj, boolean commitToDataModel) {
            assert (dataObj != null);
            dataObj.set(OccProfile.PROP_RESTRICTED_COMPONENTS, this.d_restrictionsPnl.commit());
            if (commitToDataModel) {
                this.setModified(false);
            }
        }
    }

    private static class AdvancedPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Advanced");
        private final IValEditor<ICurve> d_persist;
        private final IValEditor<ICurve> d_collResponseTime;
        private final IValEditor<ICurve> d_slowFactor;
        private final IValEditor<ICurve> d_accelTime;
        private final IValEditor<ICurve> d_boundaryLayer;
        private final PersonalDistanceEditor d_spacingPnl;
        private final IValEditor<ICurve> d_socialDist;
        private final IValEditor<ObjsFilter<Tag>> d_socialDistFilter;
        private final SpeedInSmokeEditor d_velSmokePnl;
        private final JButton d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));

        public AdvancedPanel(MerlinData md, ILabelGenerator labels) {
            this.d_resetBtn.addActionListener(arg0 -> {
                if (!ProfilesPanel.checkReset(this, TITLE)) {
                    return;
                }
                this.init(new OccProfile());
                this.setModified(true);
            });
            WrappedComp<guiLabel> accelLbl = labels.lbl(OccProfile.PROP_ACCEL_TIME);
            this.d_accelTime = OccProfile.PROP_ACCEL_TIME.newValueEditor(md, false).get();
            WrappedComp<guiLabel> persistLbl = labels.lbl(OccProfile.PROP_PERSIST_TIME);
            this.d_persist = OccProfile.PROP_PERSIST_TIME.newValueEditor(md, false).get();
            WrappedComp<guiLabel> collResponseTimeLbl = labels.lbl(OccProfile.PROP_COLLISION_RESPONSE_TIME);
            this.d_collResponseTime = OccProfile.PROP_COLLISION_RESPONSE_TIME.newValueEditor(md, false).get();
            WrappedComp<guiLabel> slowFactorLbl = labels.lbl(OccProfile.PROP_SLOW_FACTOR);
            this.d_slowFactor = OccProfile.PROP_SLOW_FACTOR.newValueEditor(md, false).get();
            WrappedComp<guiLabel> blayerLbl = labels.lbl(OccProfile.PROP_BOUNDARY_LAYER);
            this.d_boundaryLayer = OccProfile.PROP_BOUNDARY_LAYER.newValueEditor(md, false).get();
            WrappedComp<guiLabel> spacingLbl = labels.lbl(OccProfile.PROP_SPACING);
            this.d_spacingPnl = new PersonalDistanceEditor(this.getComm());
            WrappedComp<guiLabel> socialDistLbl = labels.lbl(OccProfile.PROP_SOCIAL_DIST);
            this.d_socialDist = OccProfile.PROP_SOCIAL_DIST.newValueEditor(md, false).get();
            WrappedComp<guiLabel> socialDistFilterLbl = labels.lbl(OccProfile.PROP_SOCIAL_DIST_FILTER);
            this.d_socialDistFilter = OccProfile.PROP_SOCIAL_DIST_FILTER.newValueEditor(md, false).get();
            WrappedComp<guiLabel> speedVisFuncLbl = labels.lbl(OccProfile.PROP_SPEED_IN_SMOKE);
            this.d_velSmokePnl = new SpeedInSmokeEditor(this.getComm());
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(accelLbl, this.d_accelTime, 1.0, 0);
            gb.addRow(persistLbl, this.d_persist, 1.0, 0);
            gb.addRow(collResponseTimeLbl, this.d_collResponseTime, 1.0, 0);
            gb.addRow(slowFactorLbl, this.d_slowFactor, 1.0, 0);
            gb.addRow(blayerLbl, this.d_boundaryLayer, 1.0, 0);
            gb.addRow(socialDistFilterLbl, this.d_socialDistFilter, 1.0, 0);
            gb.addRow(socialDistLbl, this.d_socialDist, 1.0, 0);
            gb.addRow(spacingLbl, this.d_spacingPnl, 1.0, 0);
            gb.addRow(speedVisFuncLbl, this.d_velSmokePnl, 1.0, 0);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.addRow(this.d_resetBtn, 0);
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_accelTime.setValue((ICurve)dataObj.get(OccProfile.PROP_ACCEL_TIME));
            this.d_collResponseTime.setValue((ICurve)dataObj.get(OccProfile.PROP_COLLISION_RESPONSE_TIME));
            this.d_persist.setValue((ICurve)dataObj.get(OccProfile.PROP_PERSIST_TIME));
            this.d_slowFactor.setValue((ICurve)dataObj.get(OccProfile.PROP_SLOW_FACTOR));
            this.d_boundaryLayer.setValue((ICurve)dataObj.get(OccProfile.PROP_BOUNDARY_LAYER));
            this.d_spacingPnl.setValue((OccProfile.Spacing)dataObj.get(OccProfile.PROP_SPACING));
            this.d_socialDist.setValue((ICurve)dataObj.get(OccProfile.PROP_SOCIAL_DIST));
            this.d_socialDistFilter.setValue(dataObj.get(OccProfile.PROP_SOCIAL_DIST_FILTER));
            this.d_velSmokePnl.setValue(dataObj.get(OccProfile.PROP_SPEED_IN_SMOKE));
            this.setModified(false);
            this.repaint();
        }

        public OccProfile commit(MerlinData md, OccProfile dataObj, boolean commitToDataModel) {
            assert (dataObj != null);
            dataObj.set(OccProfile.PROP_ACCEL_TIME, this.d_accelTime.getValue());
            dataObj.set(OccProfile.PROP_COLLISION_RESPONSE_TIME, this.d_collResponseTime.getValue());
            dataObj.set(OccProfile.PROP_PERSIST_TIME, this.d_persist.getValue());
            dataObj.set(OccProfile.PROP_SLOW_FACTOR, this.d_slowFactor.getValue());
            dataObj.set(OccProfile.PROP_BOUNDARY_LAYER, this.d_boundaryLayer.getValue());
            dataObj.set(OccProfile.PROP_SPACING, this.d_spacingPnl.getValue());
            dataObj.set(OccProfile.PROP_SOCIAL_DIST, this.d_socialDist.getValue());
            if (commitToDataModel) {
                dataObj.set(OccProfile.PROP_SOCIAL_DIST_FILTER, this.d_socialDistFilter.commit(md));
            }
            dataObj.set(OccProfile.PROP_SPEED_IN_SMOKE, this.d_velSmokePnl.getValue());
            if (commitToDataModel) {
                this.setModified(false);
            }
            return dataObj;
        }
    }

    private static class DoorChoicePanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Door Choice");
        private final IValEditor<ICurve> d_localTime;
        private final IValEditor<ICurve> d_queueTime;
        private final IValEditor<ICurve> d_tailTime;
        private final IValEditor<ICurve> d_elevatorWaitTime;
        private final IValEditor<ICurve> d_currDoorPref;
        private final IValEditor<ICurve> d_doubleDist;
        private final JButton d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));

        public DoorChoicePanel(MerlinData md, ILabelGenerator labels) {
            this.d_resetBtn.addActionListener(arg0 -> {
                if (!ProfilesPanel.checkReset(this, TITLE)) {
                    return;
                }
                this.init(new OccProfile());
                this.setModified(true);
            });
            WrappedComp<guiLabel> localTimeLbl = labels.lbl(OccProfile.PROP_LOCAL_TRAVEL_TIME_FACTOR);
            this.d_localTime = OccProfile.PROP_LOCAL_TRAVEL_TIME_FACTOR.newValueEditor(md, false).get();
            WrappedComp<guiLabel> queueLbl = labels.lbl(OccProfile.PROP_LOCAL_QUEUE_TIME_FACTOR);
            this.d_queueTime = OccProfile.PROP_LOCAL_QUEUE_TIME_FACTOR.newValueEditor(md, false).get();
            WrappedComp<guiLabel> tailLbl = labels.lbl(OccProfile.PROP_TAIL_TIME_FACTOR);
            this.d_tailTime = OccProfile.PROP_TAIL_TIME_FACTOR.newValueEditor(md, false).get();
            WrappedComp<guiLabel> elevatorWaitTimeLbl = labels.lbl(OccProfile.PROP_ELEVATOR_WAIT_TIME);
            this.d_elevatorWaitTime = OccProfile.PROP_ELEVATOR_WAIT_TIME.newValueEditor(md, false).get();
            WrappedComp<guiLabel> currDoorPrefLbl = labels.lbl(OccProfile.PROP_CURR_DOOR_PREF);
            this.d_currDoorPref = OccProfile.PROP_CURR_DOOR_PREF.newValueEditor(md, false).get();
            WrappedComp<guiLabel> doubleLbl = labels.lbl(OccProfile.PROP_CURRENT_ROOM_DIST_PENALTY);
            this.d_doubleDist = OccProfile.PROP_CURRENT_ROOM_DIST_PENALTY.newValueEditor(md, false).get();
            GridBagHelper gb = new GridBagHelper(this);
            gb.addFilledRow(new TitleSeparator(Intl.intl("Cost Factors")));
            gb.indent();
            gb.addRow(localTimeLbl, this.d_localTime, 1.0, 0);
            gb.addRow(queueLbl, this.d_queueTime, 1.0, 0);
            gb.addRow(tailLbl, this.d_tailTime, 1.0, 0);
            gb.addRow(elevatorWaitTimeLbl, this.d_elevatorWaitTime, 1.0, 0);
            gb.unindent();
            gb.addFilledRow(new TitleSeparator(Intl.intl("Advanced")));
            gb.indent();
            gb.addRow(currDoorPrefLbl, this.d_currDoorPref, 1.0, 0);
            gb.addRow(doubleLbl, this.d_doubleDist, 1.0, 0);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.unindent();
            gb.addRow(this.d_resetBtn, 0);
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_localTime.setValue((ICurve)dataObj.get(OccProfile.PROP_LOCAL_TRAVEL_TIME_FACTOR));
            this.d_queueTime.setValue((ICurve)dataObj.get(OccProfile.PROP_LOCAL_QUEUE_TIME_FACTOR));
            this.d_tailTime.setValue((ICurve)dataObj.get(OccProfile.PROP_TAIL_TIME_FACTOR));
            this.d_elevatorWaitTime.setValue((ICurve)dataObj.get(OccProfile.PROP_ELEVATOR_WAIT_TIME));
            this.d_currDoorPref.setValue((ICurve)dataObj.get(OccProfile.PROP_CURR_DOOR_PREF));
            this.d_doubleDist.setValue((ICurve)dataObj.get(OccProfile.PROP_CURRENT_ROOM_DIST_PENALTY));
            this.setModified(false);
            this.repaint();
        }

        public OccProfile commit(OccProfile dataObj, boolean commitToDataModel) {
            assert (dataObj != null);
            dataObj.set(OccProfile.PROP_LOCAL_TRAVEL_TIME_FACTOR, this.d_localTime.getValue());
            dataObj.set(OccProfile.PROP_LOCAL_QUEUE_TIME_FACTOR, this.d_queueTime.getValue());
            dataObj.set(OccProfile.PROP_TAIL_TIME_FACTOR, this.d_tailTime.getValue());
            dataObj.set(OccProfile.PROP_ELEVATOR_WAIT_TIME, this.d_elevatorWaitTime.getValue());
            dataObj.set(OccProfile.PROP_CURR_DOOR_PREF, this.d_currDoorPref.getValue());
            dataObj.set(OccProfile.PROP_CURRENT_ROOM_DIST_PENALTY, this.d_doubleDist.getValue());
            if (commitToDataModel) {
                this.setModified(false);
            }
            return dataObj;
        }
    }

    private static class AnimationPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Animation");
        private final List<EditorInfo<?>> d_editors = new ArrayList();
        private final JButton d_resetBtn = new JButton(Intl.intl("Reset to Defaults..."));

        public AnimationPanel(MerlinData md, ILabelGenerator overrideCallback) {
            this.d_resetBtn.addActionListener(arg0 -> {
                if (!ProfilesPanel.checkReset(this, TITLE)) {
                    return;
                }
                this.init(new OccProfile());
                this.setModified(true);
            });
            GridBagHelper gb = new GridBagHelper(this);
            ProfilesPanel.addProp(md, this, gb, this.d_editors::add, OccProfile.PROP_ANIMS_IDLE, overrideCallback);
            ProfilesPanel.addProp(md, this, gb, this.d_editors::add, OccProfile.PROP_ANIMS_MOVING, overrideCallback);
            GridBagUtil.addHorizontalGlue(this);
            gb.addRow(Box.createGlue(), new double[]{0.0, 1.0});
            gb.addRow(this.d_resetBtn, 0);
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            this.d_editors.forEach(ei -> ei.init(dataObj));
            this.setModified(false);
            this.repaint();
        }

        public OccProfile commit(OccProfile dataObj, boolean commitToDataModel) {
            assert (dataObj != null);
            this.d_editors.forEach(ed -> ed.commit(dataObj));
            if (commitToDataModel) {
                this.setModified(false);
            }
            return dataObj;
        }
    }

    private static class OutputPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private static final String TITLE = Intl.intl("Output");
        private final WrappedComp<guiMultiStateCheckBox> d_extraOutput;

        public OutputPanel(MerlinData md, ILabelGenerator labels) {
            this.d_extraOutput = labels.checkbox(OccProfile.PROP_PRINT_EXTRA_OUTPUT);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_extraOutput, 0);
            gb.finalizeRows();
        }

        public void init(OccProfile dataObj) {
            assert (dataObj != null);
            ((guiMultiStateCheckBox)this.d_extraOutput.comp).setSelected((Boolean)UrnUtil.getDominant((IUrn)dataObj.get(OccProfile.PROP_PRINT_EXTRA_OUTPUT)));
            this.setModified(false);
            this.repaint();
        }

        public OccProfile commit(OccProfile dataObj, boolean commitToDataModel) {
            assert (dataObj != null);
            dataObj.set(OccProfile.PROP_PRINT_EXTRA_OUTPUT, ProfilesPanel.toUrn(((guiMultiStateCheckBox)this.d_extraOutput.comp).isSelected()));
            if (commitToDataModel) {
                this.setModified(false);
            }
            return dataObj;
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_extraOutput.isModified() && ((guiMultiStateCheckBox)this.d_extraOutput.comp).isSelected() && showWarn) {
                String msg = Intl.intl("WARNING: Enabling detailed output for many occupants may use significant computing\nresources and/or disk space during simulation. Are you sure you want to enable\nthis feature?");
                int opt = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), msg, Intl.intl("Detailed Output"), 0, 2);
                if (opt != 0) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class ProfileSpeedEditor
    extends AValEditor<OccProfile> {
        private static final long serialVersionUID = 1L;
        private final IValEditor<? extends ICurve> d_curveEditor;

        public ProfileSpeedEditor(IValEditor<? extends ICurve> curveEditor) {
            super(OccProfile.class);
            this.d_curveEditor = curveEditor;
            this.d_curveEditor.addValueListener(e -> this.updateValue());
            this.add(this.d_curveEditor.getComponent());
        }

        @Override
        public boolean isLive() {
            return true;
        }

        @Override
        public String formatNonLiveValue() {
            return "";
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this.d_curveEditor.getComponent(), 1.0);
        }

        @Override
        protected void loadValue(OccProfile value) {
            this.d_curveEditor.setValue((ICurve)value.get(OccProfile.PROP_MAXVEL));
        }

        @Override
        protected OccProfile saveValue(Mediator mediator) {
            OccProfile result = new OccProfile();
            result.set(OccProfile.PROP_MAXVEL, this.d_curveEditor.getValue());
            return result;
        }
    }

    private static class EditorInfo<T> {
        public final IProfileProp<?, T> prop;
        public final IValEditor<T> editor;

        public EditorInfo(IProfileProp<?, T> prop, IValEditor<T> editor) {
            this.prop = prop;
            this.editor = editor;
        }

        public void init(OccProfile dataObj) {
            this.editor.setValue(dataObj.get(this.prop.asProp()));
        }

        public void commit(OccProfile dataObj) {
            dataObj.set(this.prop.asProp(), this.editor.getValue());
        }
    }

    private static class AdvancedSpeedEditor
    extends AValEditor<OccProfile> {
        private static final long serialVersionUID = 1L;
        private final VerboseCurveEditor d_levelSpeed = this.registerEd(new VerboseCurveEditor(5, false));
        private final IValEditor<IFunction1d> d_levelFundamental;
        private final SlopedSpeedEditor d_stairEditor;
        private final SlopedSpeedEditor d_rampEditor;

        public AdvancedSpeedEditor() {
            super(OccProfile.class);
            this.d_levelFundamental = this.registerEd(Function1dEditorFactory.nonNullable(OccProfile.PROP_FUNDAMENTAL.fprop, false, () -> null, Function1dEditorFactory.GENERAL_TYPES));
            guiPanel levelPnl = new guiPanel();
            GridBagHelper gb = new GridBagHelper(levelPnl, true);
            gb.add(Intl.intl("Speed:"));
            this.d_levelSpeed.add(gb);
            gb.nextRow();
            gb.add(ProfilesPanel.newLabel(OccProfile.PROP_FUNDAMENTAL.fprop));
            this.d_levelFundamental.add(gb);
            gb.nextRow();
            gb.finalizeRows();
            this.d_stairEditor = this.registerEd(new SlopedSpeedEditor(Intl.intl("Stair"), () -> this.d_levelFundamental.getValue(), OccProfile.PROP_STAIR_SPEED_UP, OccProfile.PROP_STAIR_FUNDAMENTAL_UP, OccProfile.PROP_STAIR_SPEED_DOWN, OccProfile.PROP_STAIR_FUNDAMENTAL_DOWN, OccProfile.SFPE_STAIR_FUNCTION));
            this.d_rampEditor = this.registerEd(new SlopedSpeedEditor(Intl.intl("Ramp"), () -> this.d_levelFundamental.getValue(), OccProfile.PROP_RAMP_SPEED_UP, OccProfile.PROP_RAMP_FUNDAMENTAL_UP, OccProfile.PROP_RAMP_SPEED_DOWN, OccProfile.PROP_RAMP_FUNDAMENTAL_DOWN, OccProfile.SFPE_RAMP_FUNCTION));
            guiPanel stairsPnl = new guiPanel();
            gb = new GridBagHelper(stairsPnl, true);
            gb.addFilledRow(this.d_stairEditor);
            gb.finalizeRows();
            guiPanel rampsPnl = new guiPanel();
            gb = new GridBagHelper(rampsPnl, true);
            gb.addFilledRow(this.d_rampEditor);
            gb.finalizeRows();
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab(Intl.intl("Level Terrain"), levelPnl);
            tabs.addTab(Intl.intl("Stairs"), stairsPnl);
            tabs.addTab(Intl.intl("Ramps"), rampsPnl);
            JButton resetButton = new JButton(Intl.intl("Reset to Defaults..."));
            resetButton.setToolTipText(Intl.intl("Resets the advanced speed properties."));
            resetButton.addActionListener(e -> {
                if (!ProfilesPanel.checkReset(this, Intl.intl("Speed"))) {
                    return;
                }
                this.setValue(new OccProfile());
            });
            gb = new GridBagHelper(this);
            gb.addFilledRow(tabs);
            gb.addFilledRow("<html>" + Intl.intl("NOTE: When simulating in SFPE mode, all advanced speed properties are ignored except for <i>Speed</i>."));
            gb.addRow(resetButton, 0);
            gb.finalizeRows();
        }

        @Override
        public boolean isLive() {
            return true;
        }

        @Override
        public String formatNonLiveValue() {
            return "";
        }

        @Override
        protected void updateValue() {
            super.updateValue();
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this, 1.0);
        }

        @Override
        protected void loadValue(OccProfile value) {
            this.d_levelSpeed.setValue((ICurve)value.get(OccProfile.PROP_MAXVEL));
            this.d_levelFundamental.setValue(value.get(OccProfile.PROP_FUNDAMENTAL));
            this.d_stairEditor.load(value);
            this.d_rampEditor.load(value);
        }

        @Override
        protected OccProfile saveValue(Mediator mediator) {
            OccProfile adv = new OccProfile();
            adv.set(OccProfile.PROP_MAXVEL, (ICurve)this.d_levelSpeed.getValue());
            adv.set(OccProfile.PROP_FUNDAMENTAL, this.d_levelFundamental.getValue());
            this.d_stairEditor.save(adv);
            this.d_rampEditor.save(adv);
            return adv;
        }

        public static String format(OccProfile adv) {
            StringBuilder str = new StringBuilder();
            str.append(String.format(Intl.intl("Speed=%s"), guiCurveUtil.format((IDistributedVal)adv.get(OccProfile.PROP_MAXVEL))));
            if (AdvancedSpeedEditor.isCustom(adv, OccProfile.PROP_FUNDAMENTAL)) {
                str.append("; ");
                str.append(Intl.intl("Custom speed-density profile"));
            }
            if (AdvancedSpeedEditor.isCustom(adv, OccProfile.PROP_STAIR_FUNDAMENTAL_DOWN, OccProfile.PROP_STAIR_FUNDAMENTAL_UP, OccProfile.PROP_STAIR_SPEED_DOWN, OccProfile.PROP_STAIR_SPEED_UP)) {
                str.append("; ");
                str.append(Intl.intl("Custom stair speed"));
            }
            if (AdvancedSpeedEditor.isCustom(adv, OccProfile.PROP_RAMP_FUNDAMENTAL_DOWN, OccProfile.PROP_RAMP_FUNDAMENTAL_UP, OccProfile.PROP_RAMP_SPEED_DOWN, OccProfile.PROP_RAMP_SPEED_UP)) {
                str.append("; ");
                str.append(Intl.intl("Custom ramp speed"));
            }
            return str.toString();
        }

        private static boolean isCustom(OccProfile profile, TypedProp<?> ... props) {
            for (TypedProp<?> prop : props) {
                if (Objects.equals(profile.get(prop), prop.defVal)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum CorridorType {
        STAIR(Intl.intl("Stair")),
        RAMP(Intl.intl("Ramp"));

        public final String desc;

        private CorridorType(String desc) {
            this.desc = desc;
        }
    }

    private static class SlopedSpeedEditor
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final ProfileProps.ProfileFunction1dProp d_upSpeedProp;
        private final ProfileProps.ProfileFunctionProp d_upFundProp;
        private final ProfileProps.ProfileFunction1dProp d_downSpeedProp;
        private final ProfileProps.ProfileFunctionProp d_downFundProp;
        private final IValEditor<IFunction1d> d_upEditor;
        private final IValEditor<OccProfile.IProfileFunction> d_upFundEditor;
        private final IValEditor<IFunction1d> d_downEditor;
        private final IValEditor<OccProfile.IProfileFunction> d_downFundEditor;

        public SlopedSpeedEditor(String compDesc, Supplier<IFunction1d> levelFund, ProfileProps.ProfileFunction1dProp upSpeedProp, ProfileProps.ProfileFunctionProp upFundProp, ProfileProps.ProfileFunction1dProp downSpeedProp, ProfileProps.ProfileFunctionProp downFundProp, IFunction1d sfpeFunc) {
            this.d_upSpeedProp = upSpeedProp;
            this.d_upFundProp = upFundProp;
            this.d_downSpeedProp = downSpeedProp;
            this.d_downFundProp = downFundProp;
            this.d_upEditor = this.registerEd(Function1dEditorFactory.nonNullable(upSpeedProp.fprop, false, () -> null, Function1dEditorFactory.GENERAL_TYPES));
            this.d_upFundEditor = this.registerEd(OccProfile.newSlopedFundEditor(this.d_upFundProp, levelFund));
            this.d_downEditor = this.registerEd(Function1dEditorFactory.nonNullable(downSpeedProp.fprop, false, () -> null, Function1dEditorFactory.GENERAL_TYPES));
            this.d_downFundEditor = this.registerEd(OccProfile.newSlopedFundEditor(this.d_downFundProp, levelFund));
            guiLabel fracUp = ProfilesPanel.newLabel(upSpeedProp.fprop);
            guiLabel densUp = ProfilesPanel.newLabel(upFundProp.fprop);
            guiLabel fracDown = ProfilesPanel.newLabel(downSpeedProp.fprop);
            guiLabel densDown = ProfilesPanel.newLabel(downFundProp.fprop);
            GridBagHelper gb = new GridBagHelper(this);
            gb.add(fracUp);
            this.d_upEditor.add(gb);
            gb.nextRow();
            gb.add(densUp);
            this.d_upFundEditor.add(gb);
            gb.nextRow();
            gb.add(fracDown);
            this.d_downEditor.add(gb);
            gb.nextRow();
            gb.add(densDown);
            this.d_downFundEditor.add(gb);
            gb.nextRow();
            gb.finalizeRows();
        }

        private <T extends IValEditor<?>> T registerEd(T editor) {
            editor.addValueListener(e -> this.firePropertyChange("value", e.getOldValue(), e.getNewValue()));
            return editor;
        }

        public void load(OccProfile profile) {
            this.d_upEditor.setValue(profile.get(this.d_upSpeedProp));
            this.d_upFundEditor.setValue(profile.get(this.d_upFundProp));
            this.d_downEditor.setValue(profile.get(this.d_downSpeedProp));
            this.d_downFundEditor.setValue(profile.get(this.d_downFundProp));
        }

        public void save(OccProfile profile) {
            profile.set(this.d_upSpeedProp, this.d_upEditor.getValue());
            profile.set(this.d_upFundProp, this.d_upFundEditor.getValue());
            profile.set(this.d_downSpeedProp, this.d_downEditor.getValue());
            profile.set(this.d_downFundProp, this.d_downFundEditor.getValue());
        }
    }
}

