/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.OccGroupObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.egress.agents.OccProfile;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsUtil;
import merlin.gui.MerlinComboBox;
import merlin.gui.MerlinValueFields;
import merlin.gui.ObjSources;
import merlin.gui.StrTagsField;
import merlin.gui.guiUtil;
import merlin.gui.labels.ILabelGenerator;
import merlin.gui.labels.WrappedComp;
import merlin.gui.stat.VerboseCurveEditor;
import merlin.gui.stat.guiCurveUtil;
import merlin.unitsystem.UnitUpdatableComponent;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Comm;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.gui.value.IValEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;

public class OccGroupsPanel
extends guiPanel
implements IEditor<OccGroupObj> {
    private static final long serialVersionUID = 1L;
    private final guiTextField d_name;
    private final guiTextField d_desc;
    private final StrTagsField d_tags;
    private final MerlinData d_md;
    private boolean d_isModified = false;
    private ValueField<UnitDouble> d_maxDistanceFld;
    private guiUnitDoubleField d_slowdownTimeFld;
    private WrappedComp<guiMultiStateCheckBox> d_socialDistInGroup;
    private WrappedComp<guiMultiStateCheckBox> d_cbFollowLeader;
    private boolean d_isGroupType;
    private ProfileConstraintsPanel d_profileConstraintsPanel;
    private guiRadioButton d_specifyOverallCount;
    private guiRadioButton d_specifyProfiles;
    private GroupCreationEditor d_groupCreationEditor;
    private MerlinComboBox<OccProfile> d_cbLeaderProfile;
    private WrappedComp<guiLabel> d_lLeaderProfile;
    private ColorButton d_colorBtn;
    private OccGroupObj d_dataObj;
    public static final String MIN_WARNING = Intl.intl("Total number of members must be at least 1.");

    public OccGroupsPanel(JFrame owner, boolean isGroupType, ILabelGenerator labels) {
        this.d_isGroupType = isGroupType;
        this.setLayout(new GridBagLayout());
        this.d_md = MerlinApp.getApp().getData();
        WrappedComp<guiLabel> nameLbl = labels.lbl(OccGroupObj.NAME);
        this.d_name = new guiTextField();
        this.d_name.setEditable(false);
        WrappedComp<guiLabel> descLbl = labels.lbl(OccGroupObj.PROP_DESC);
        this.d_desc = new guiTextField();
        this.d_desc.setColumns(25);
        this.d_desc.getDocument().addDocumentListener(this.d_comm);
        WrappedComp<guiLabel> tagsLbl = labels.lbl(MerlinData.TAGS);
        this.d_tags = new StrTagsField();
        ActionListener enableLeadersProfileListener = e -> this.updateEnabled();
        this.d_cbFollowLeader = labels.checkbox(OccGroupObj.PROP_REQUIRES_GROUP_LEADER);
        ((guiMultiStateCheckBox)this.d_cbFollowLeader.comp).addActionListener(enableLeadersProfileListener);
        this.d_socialDistInGroup = labels.checkbox(OccGroupObj.PROP_SOCIAL_DIST_IN_GROUP);
        this.d_maxDistanceFld = MerlinValueFields.udFld(0);
        this.d_slowdownTimeFld = new guiUnitDoubleField((Unit)SI.SECOND, UnitDoubleVR.above(0.0, SI.SECOND, true));
        WrappedComp<guiLabel> colorLbl = labels.lbl(OccGroupObj.PROP_COLOR, Intl.intl("Color:"), "");
        this.d_colorBtn = new ColorButton(1);
        this.d_colorBtn.setMinimumSize(this.d_colorBtn.getPreferredSize());
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(nameLbl, this.d_name, 1.0, GridBagHelper.REMAINING);
        gb.addRow(descLbl, this.d_desc, 1.0, GridBagHelper.REMAINING);
        gb.addRow(tagsLbl, this.d_tags, 1.0, GridBagHelper.REMAINING);
        gb.addRow(colorLbl, this.d_colorBtn);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Movement")));
        WrappedComp<guiLabel> lMaxDist = labels.lbl(OccGroupObj.PROP_MAX_DISTANCE);
        gb.addIdentRow(lMaxDist, this.d_maxDistanceFld, 1.0, GridBagHelper.REMAINING);
        WrappedComp<guiLabel> lSlowDown = labels.lbl(OccGroupObj.PROP_SLOWDOWN_TIME);
        gb.addIdentRow(lSlowDown, this.d_slowdownTimeFld, 1.0, GridBagHelper.REMAINING);
        gb.addIdentRow(this.d_cbFollowLeader, 1.0, GridBagHelper.REMAINING);
        gb.addIdentRow(this.d_socialDistInGroup, 1.0, GridBagHelper.REMAINING);
        if (this.d_isGroupType) {
            this.d_groupCreationEditor = new GroupCreationEditor(this.getComm(), false);
            WrappedComp<guiLabel> creationLbl = labels.lbl(OccGroupTypeObj.PROP_CREATION);
            gb.addFilledRow(new TitleSeparator(creationLbl));
            gb.indent();
            this.d_specifyOverallCount = new guiRadioButton(Intl.intl("Specify Number of Members"));
            this.d_specifyOverallCount.setToolTipText(Intl.intl("Specify total number of members regardless of their profiles."));
            String specNumMembersProfLbl = Intl.intl("Specify Number of Members per Profile");
            this.d_specifyProfiles = new guiRadioButton(specNumMembersProfLbl);
            this.d_specifyProfiles.setToolTipText(Intl.intl("Specify number of members with each profile."));
            guiUtil.group(new AbstractButton[]{this.d_specifyProfiles, this.d_specifyOverallCount});
            LinkStatus.link2((AbstractButton)this.d_specifyOverallCount, this.d_groupCreationEditor);
            this.d_specifyOverallCount.addActionListener(enableLeadersProfileListener);
            this.d_specifyProfiles.addActionListener(enableLeadersProfileListener);
            this.d_profileConstraintsPanel = new ProfileConstraintsPanel();
            this.d_cbLeaderProfile = new MerlinComboBox<OccProfile>(this.d_md, ObjSources.fromModelRobust(this.d_md, OccProfile.class, Intl.intl("[Any]")));
            this.d_cbLeaderProfile.setEnabled(false);
            this.d_lLeaderProfile = labels.lbl(OccGroupTypeObj.PROP_LEADER_PROFILE);
            LinkStatus.link2((AbstractButton)this.d_specifyProfiles, this.d_profileConstraintsPanel, this.d_cbLeaderProfile, this.d_lLeaderProfile);
            LinkStatus.link2((AbstractButton)this.d_cbFollowLeader.comp, this.d_cbLeaderProfile, this.d_lLeaderProfile);
            gb.addRow(this.d_specifyOverallCount, GridBagHelper.REMAINING);
            gb.indent();
            gb.addFilledRow(this.d_groupCreationEditor);
            gb.unindent();
            gb.addRow(this.d_specifyProfiles, GridBagHelper.REMAINING);
            gb.addIdentRow(this.d_profileConstraintsPanel, new double[]{1.0, 1.0}, GridBagHelper.REMAINING);
            gb.addIdentRow(this.d_lLeaderProfile, this.d_cbLeaderProfile, new double[]{1.0, 0.0}, GridBagHelper.REMAINING);
            gb.unindent();
        }
        this.setModified(false);
    }

    @Override
    public void init(OccGroupObj dataObj) {
        if (dataObj != null) {
            this.d_dataObj = dataObj;
            this.d_name.setText((String)dataObj.get(OccGroupObj.NAME));
            this.d_desc.setText(dataObj.get(OccGroupObj.PROP_DESC));
            this.d_tags.setTypedValue(TagsUtil.tagsAsStrings(dataObj.get(MerlinData.TAGS)));
            this.d_maxDistanceFld.setValue(dataObj.get(OccGroupObj.PROP_MAX_DISTANCE));
            this.d_slowdownTimeFld.setValue(dataObj.get(OccGroupObj.PROP_SLOWDOWN_TIME));
            ((guiMultiStateCheckBox)this.d_cbFollowLeader.comp).setSelected(dataObj.get(OccGroupObj.PROP_REQUIRES_GROUP_LEADER));
            ((guiMultiStateCheckBox)this.d_socialDistInGroup.comp).setSelected(dataObj.get(OccGroupObj.PROP_SOCIAL_DIST_IN_GROUP));
            if (this.d_isGroupType) {
                this.d_groupCreationEditor.setValue(new OccGroupTypeObj.GroupCreationDataObj((OccGroupTypeObj)dataObj));
                this.d_specifyProfiles.setSelected(dataObj.get(OccGroupTypeObj.PROP_SPECIFY_PROFILES));
                this.d_specifyOverallCount.setSelected(dataObj.get(OccGroupTypeObj.PROP_SPECIFY_PROFILES) == false);
                this.d_profileConstraintsPanel.init(dataObj.get(OccGroupTypeObj.PROP_PROFILE_DATA));
                this.d_cbLeaderProfile.setEnabled(((guiMultiStateCheckBox)this.d_cbFollowLeader.comp).isSelected() && this.d_specifyOverallCount.isSelected());
                this.d_cbLeaderProfile.setSelectedItem(dataObj.get(OccGroupTypeObj.PROP_LEADER_PROFILE));
                this.d_colorBtn.setColor(dataObj.get(OccGroupObj.PROP_COLOR));
            }
        }
        this.setModified(false);
    }

    @Override
    public OccGroupObj commit(final OccGroupObj dataObj) {
        if (dataObj != null) {
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    try (MerlinData.WriteLock lock = md.lockWrite();){
                        Undo.begin(Intl.intl("Edit Movement Group Templates"));
                        Undo.insertUndoEntry_restore(md, dataObj);
                        dataObj.set(OccGroupObj.PROP_DESC, OccGroupsPanel.this.d_desc.getText());
                        Set tagStrings = (Set)OccGroupsPanel.this.d_tags.getValue();
                        Set<Tag> tags = TagsUtil.getOrCreateTags(tagStrings, md);
                        dataObj.set(MerlinData.TAGS, tags);
                        dataObj.set(OccGroupObj.PROP_REQUIRES_GROUP_LEADER, ((guiMultiStateCheckBox)OccGroupsPanel.this.d_cbFollowLeader.comp).isSelected());
                        dataObj.set(OccGroupObj.PROP_SOCIAL_DIST_IN_GROUP, ((guiMultiStateCheckBox)OccGroupsPanel.this.d_socialDistInGroup.comp).isSelected());
                        dataObj.set(OccGroupObj.PROP_MAX_DISTANCE, (UnitDouble)OccGroupsPanel.this.d_maxDistanceFld.getValue());
                        dataObj.set(OccGroupObj.PROP_SLOWDOWN_TIME, (UnitDouble)OccGroupsPanel.this.d_slowdownTimeFld.getValue());
                        if (OccGroupsPanel.this.d_isGroupType) {
                            OccGroupTypeObj.GroupCreationDataObj data = OccGroupsPanel.this.d_groupCreationEditor.getValue();
                            dataObj.set(OccGroupTypeObj.PROP_MIN_NUMBER_OF_MEMBERS, data.minNumberOfMembers);
                            dataObj.set(OccGroupTypeObj.PROP_PREF_NUMBER_OF_MEMBERS, data.prefNumberOfMembers);
                            dataObj.set(OccGroupTypeObj.PROP_ALLOW_SMALLER_GROUPS, data.allowSmallerGroups);
                            dataObj.set(OccGroupTypeObj.PROP_SPECIFY_PROFILES, OccGroupsPanel.this.d_specifyProfiles.isSelected());
                            dataObj.set(OccGroupTypeObj.PROP_PROFILE_DATA, OccGroupsPanel.this.d_profileConstraintsPanel.commit());
                            dataObj.set(OccGroupTypeObj.PROP_LEADER_PROFILE, (OccProfile)OccGroupsPanel.this.d_cbLeaderProfile.getSelectedItem());
                            dataObj.set(OccGroupObj.PROP_COLOR, OccGroupsPanel.this.d_colorBtn.getColor());
                        }
                        Undo.end(MerlinApp.getApp().getData());
                    }
                }
            };
            UIHook.run(this, "OccGroupsPanel.commit", op, 0);
        }
        this.setModified(false);
        return dataObj;
    }

    private void updateEnabled() {
        if (this.d_isGroupType) {
            this.d_cbLeaderProfile.setEnabled(((guiMultiStateCheckBox)this.d_cbFollowLeader.comp).isSelected() && this.d_specifyProfiles.isSelected());
            this.d_lLeaderProfile.setEnabled(((guiMultiStateCheckBox)this.d_cbFollowLeader.comp).isSelected() && this.d_specifyProfiles.isSelected());
        }
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public boolean isModified() {
        return this.d_isModified || super.isModified();
    }

    @Override
    public void setModified(boolean isModified) {
        this.d_isModified = isModified;
        super.setModified(isModified);
    }

    @Override
    public void setEnabled(boolean enable) {
        if (!enable) {
            this.clear();
        }
        super.setEnabled(enable);
        if (enable) {
            this.updateEnabled();
        }
    }

    public void clear() {
        this.d_name.setText("");
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (this.d_isGroupType) {
            double minPrefNumberOfMembers;
            ICurve minConstraints;
            OccProfile leaderProf;
            if (((guiMultiStateCheckBox)this.d_cbFollowLeader.comp).isSelected() && this.d_specifyProfiles.isSelected() && (leaderProf = (OccProfile)this.d_cbLeaderProfile.getSelectedItem()) != null && (minConstraints = this.d_profileConstraintsPanel.getMinConstraints(leaderProf)).getMin().getValue(Unit.ONE) == 0.0) {
                String msg = Intl.intl("Leader's Profile must have minimum number of members set to at least 1.");
                JOptionPane.showMessageDialog(this, msg, Intl.intl("Invalid data"), 0);
                return false;
            }
            if (this.d_specifyOverallCount.isSelected() && (minPrefNumberOfMembers = this.d_groupCreationEditor.getValue().prefNumberOfMembers.getMin().get(Unit.ONE)) < 1.0) {
                String msg = MIN_WARNING;
                JOptionPane.showMessageDialog(this, msg, Intl.intl("Invalid data"), 0);
                return false;
            }
            if (this.d_specifyProfiles.isSelected()) {
                double totalMin = 0.0;
                for (OccProfile prof : this.d_profileConstraintsPanel.profMap.keySet()) {
                    if (!((totalMin += this.d_profileConstraintsPanel.profMap.get((Object)prof).getValue().prefNumberOfMembers.getMin().get(Unit.ONE)) >= 1.0)) continue;
                    break;
                }
                if (totalMin < 1.0) {
                    String msg = MIN_WARNING;
                    JOptionPane.showMessageDialog(this, msg, Intl.intl("Invalid data"), 0);
                    return false;
                }
            }
        }
        return super.validateData(showWarn, allowModify);
    }

    public static class GroupCreationEditor
    extends HTMLBtn
    implements Modifiable,
    IValEditor<OccGroupTypeObj.GroupCreationDataObj>,
    UnitUpdatableComponent {
        private static final long serialVersionUID = 1L;
        private final Comm d_comm;
        private OccGroupTypeObj.GroupCreationDataObj d_groupCreationData;
        private boolean d_modified;
        private GroupCreationPanel d_pnl;

        public GroupCreationEditor(Comm comm, boolean allowZero) {
            super("");
            this.d_comm = comm;
            this.d_modified = false;
            this.addActionListener(e -> {
                OccGroupTypeObj.GroupCreationDataObj newData;
                guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Group Creation"), 9);
                this.d_pnl = new GroupCreationPanel(allowZero);
                this.d_pnl.load(this.d_groupCreationData);
                dlg.getDialogPane().add(this.d_pnl);
                if (dlg.doModal() == 1 && !Objects.equals(newData = this.d_pnl.save(), this.d_groupCreationData)) {
                    this.setValue(newData);
                    this.setModified(true);
                    this.d_comm.touch(e);
                }
            });
            this.update();
        }

        @Override
        public boolean isLive() {
            return true;
        }

        @Override
        public String formatNonLiveValue() {
            return "";
        }

        @Override
        public <DomainT extends Mediator> OccGroupTypeObj.GroupCreationDataObj commit(DomainT domain) {
            this.setModified(false);
            return this.getValue();
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this, 1.0);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public Class<OccGroupTypeObj.GroupCreationDataObj> getType() {
            return OccGroupTypeObj.GroupCreationDataObj.class;
        }

        @Override
        public boolean isModified() {
            return this.d_modified;
        }

        @Override
        public void setModified(boolean modified) {
            this.d_modified = modified;
        }

        @Override
        public void setValue(OccGroupTypeObj.GroupCreationDataObj newType) {
            if (Objects.equals(newType, this.d_groupCreationData)) {
                return;
            }
            this.d_groupCreationData = newType;
            this.update();
            this.setModified(false);
        }

        @Override
        public OccGroupTypeObj.GroupCreationDataObj getValue() {
            return this.d_groupCreationData;
        }

        public void update() {
            this.setText(this.d_groupCreationData != null ? GroupCreationEditor.format(this.d_groupCreationData) : Intl.intl("&lt;mixed&gt;"));
        }

        public static String format(OccGroupTypeObj.GroupCreationDataObj groupType) {
            if (!groupType.allowSmallerGroups) {
                return String.format(Intl.intl("Number of Members: %s"), guiCurveUtil.format(groupType.prefNumberOfMembers));
            }
            return String.format(Intl.intl("Number of Members: %s, Min: %s"), guiCurveUtil.format(groupType.prefNumberOfMembers), guiCurveUtil.format(groupType.minNumberOfMembers));
        }

        @Override
        public void update(Unit newUnit) {
            this.update();
        }

        @Override
        public Unit getDisplayUnit() {
            return Unit.ONE;
        }
    }

    private static class ProfileConstraintsPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private Map<OccProfile, GroupCreationEditor> profMap;

        public ProfileConstraintsPanel() {
            MerlinData md = MerlinApp.getApp().getData();
            ArrayList<OccProfile> allProfiles = new ArrayList<OccProfile>(md.profiles.flatten(OccProfile.class));
            allProfiles.sort((p1, p2) -> p1.getName().compareTo(p2.getName()));
            int rowHeight = 30;
            JPanel panel = new JPanel();
            JScrollPane sp = new JScrollPane(panel);
            sp.setBorder(BorderFactory.createEmptyBorder());
            sp.getVerticalScrollBar().setUnitIncrement(6);
            this.setLayout(new BorderLayout());
            this.add((Component)sp, "Center");
            GridBagHelper gb = new GridBagHelper(panel, false, 12, 3);
            gb.fill = GridBagHelper.Fill.HORIZONTAL;
            this.profMap = new LinkedHashMap<OccProfile, GroupCreationEditor>();
            int maxNameLength = 25;
            for (OccProfile prof : allProfiles) {
                guiLabel lbl;
                GroupCreationEditor groupCreationEditor = new GroupCreationEditor(this.getComm(), true);
                groupCreationEditor.setWrapEnabled(false);
                groupCreationEditor.setValue(new OccGroupTypeObj.GroupCreationDataObj(new ConstantCurve(new UnitDouble(0.0, Unit.ONE)), false, new ConstantCurve(new UnitDouble(0.0, Unit.ONE))));
                this.profMap.put(prof, groupCreationEditor);
                Object name = prof.getName();
                if (((String)name).length() > maxNameLength) {
                    name = ((String)name).substring(0, maxNameLength);
                    name = (String)name + "...";
                    lbl = new guiLabel((String)name);
                    lbl.setToolTipText(prof.getName());
                } else {
                    lbl = new guiLabel((String)name);
                }
                gb.addRow(new Object[]{lbl, groupCreationEditor, new double[]{1.0, 0.0}, GridBagHelper.REMAINING, GridBagHelper.Anchor.LEFT});
            }
            gb.finalizeRows();
            sp.setPreferredSize(new Dimension(100, Math.min(allProfiles.size() * rowHeight + 10, 100)));
        }

        public void init(Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj> map) {
            for (OccProfile prof : this.profMap.keySet()) {
                this.profMap.get(prof).setValue(map.getOrDefault(prof, new OccGroupTypeObj.GroupCreationDataObj(prof)));
            }
        }

        public Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj> commit() {
            LinkedHashMap<OccProfile, OccGroupTypeObj.GroupCreationDataObj> profileConstraints = new LinkedHashMap<OccProfile, OccGroupTypeObj.GroupCreationDataObj>();
            for (OccProfile prof : this.profMap.keySet()) {
                GroupCreationEditor editor = this.profMap.get(prof);
                profileConstraints.put(prof, editor.getValue());
            }
            return profileConstraints;
        }

        public ICurve getMinConstraints(OccProfile profile) {
            Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj> map = this.commit();
            if (!map.containsKey(profile)) {
                return null;
            }
            OccGroupTypeObj.GroupCreationDataObj data = map.get(profile);
            return data.allowSmallerGroups ? data.minNumberOfMembers : data.prefNumberOfMembers;
        }
    }

    public static class GroupCreationPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private VerboseCurveEditor minNumberOfMembers;
        private VerboseCurveEditor prefNumberOfMembers;
        private guiCheckBox cbAllowSmaller;
        private guiLabel lMinNumberOfMembers;

        public GroupCreationPanel(boolean allowZero) {
            this.minNumberOfMembers = new VerboseCurveEditor(11, false, UnitDoubleVR.above(new UnitDouble(0.0, Unit.ONE), allowZero));
            this.prefNumberOfMembers = new VerboseCurveEditor(11, false, UnitDoubleVR.above(new UnitDouble(0.0, Unit.ONE), allowZero));
            this.cbAllowSmaller = new guiCheckBox(OccGroupTypeObj.PROP_ALLOW_SMALLER_GROUPS.getNameWithColon());
            this.lMinNumberOfMembers = new guiLabel(OccGroupTypeObj.PROP_MIN_NUMBER_OF_MEMBERS.getNameWithColon());
            LinkStatus.link2((AbstractButton)this.cbAllowSmaller, this.minNumberOfMembers, this.lMinNumberOfMembers);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(OccGroupTypeObj.PROP_PREF_NUMBER_OF_MEMBERS.getNameWithColon(), this.prefNumberOfMembers, 1.0, GridBagHelper.REMAINING);
            gb.addRow(this.cbAllowSmaller, 1.0, GridBagHelper.REMAINING);
            gb.addIdentRow(this.lMinNumberOfMembers, this.minNumberOfMembers, 1.0, GridBagHelper.REMAINING);
        }

        public void load(OccGroupTypeObj.GroupCreationDataObj groupCreationData) {
            boolean allowSmaller = groupCreationData.allowSmallerGroups;
            this.cbAllowSmaller.setSelected(allowSmaller);
            ICurve min = groupCreationData.minNumberOfMembers != null ? groupCreationData.minNumberOfMembers : new ConstantCurve(new UnitDouble(0.0, Unit.ONE));
            this.minNumberOfMembers.setValue(min);
            this.prefNumberOfMembers.setValue(groupCreationData.prefNumberOfMembers);
        }

        public OccGroupTypeObj.GroupCreationDataObj save() {
            OccGroupTypeObj.GroupCreationDataObj data = new OccGroupTypeObj.GroupCreationDataObj((ICurve)this.prefNumberOfMembers.getValue(), this.cbAllowSmaller.isSelected(), this.cbAllowSmaller.isSelected() ? (ICurve)this.minNumberOfMembers.getValue() : null);
            return data;
        }
    }
}

