/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import merlin.EntryPointFactory;
import merlin.data.AssistedEvacTeam;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.OccGroupTypeObj;
import merlin.data.egress.Floor;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.queues.IGotoQueueDestination;
import merlin.data.material.Material;
import merlin.data.tag.Tag;
import merlin.gui.AvatarChooser;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.framework.ObjSource;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;

public class ObjSources {
    public static <T extends IMerlinObj> ObjSource<T> fromModelRobust(MerlinData data, Class<T> type, String nullName) {
        return ObjSources.fromModelRobust(data, type, nullName, Predicates.alwaysTrue());
    }

    public static <T extends IMerlinObj> ObjSource<T> fromModelRobust(MerlinData data, Class<T> type, String nullName, Predicate<? super T> filter) {
        return ObjSources.fromModelRobust(data, type, nullName, filter, (T obj) -> 0, null, (MerlinData md) -> List.of());
    }

    public static <T extends IMerlinObj> ObjSource<T> fromModelRobust(MerlinData md, Class<T> type, String nullName, Predicate<? super T> filter, ToIntFunction<T> getFontStyle, Comparator<T> nonNullSorter, Function<MerlinData, ? extends Collection<? extends T>> getSpecialValues) {
        Function<MerlinData, Collection<Object>> finalGetSpecialValues;
        ObjSource.IFormat<IMerlinObj> format;
        ObjSource.IFormat<IMerlinObj> baseFormatter = (obj, bc) -> {
            Composite<IMerlinObj> root;
            Composite<IMerlinObj> composite = root = obj != null ? EntryPointFactory.get(obj).getRootComposite(md) : null;
            if (root != null) {
                return MerlinUtil.getName(root, obj, bc);
            }
            return MerlinUtil.getName(md, obj, bc);
        };
        if (nullName == null) {
            format = baseFormatter;
            finalGetSpecialValues = getSpecialValues;
        } else {
            format = (v, bc) -> v == null ? nullName : baseFormatter.apply((IMerlinObj)v, bc);
            finalGetSpecialValues = data -> {
                Collection baseVals = (Collection)getSpecialValues.apply((MerlinData)data);
                assert (baseVals != null);
                try {
                    if (baseVals.contains(null)) {
                        return baseVals;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ArrayList items = new ArrayList(1 + baseVals.size());
                items.add(null);
                items.addAll(baseVals);
                return items;
            };
        }
        return ObjSources.fromModelRobust(md, type, filter, getFontStyle, nonNullSorter, format, finalGetSpecialValues);
    }

    public static <T extends IMerlinObj> ObjSource<T> fromModelRobust(MerlinData md, Class<T> type, Predicate<? super T> filter, ToIntFunction<T> getFontStyle, Comparator<T> nonNullSorter, ObjSource.IFormat<T> format, Function<MerlinData, ? extends Collection<? extends T>> getSpecialValues) {
        Supplier<Stream> getBaseObjs = () -> {
            Stream<Object> stream = type.equals(Material.class) ? md.materials.flatten(type, filter).stream() : md.getChildren().stream().filter(member -> member instanceof Composite).map(member -> (Composite)member).flatMap(comp -> comp.flatten(type, filter).stream());
            if (nonNullSorter == null) {
                ArrayList values = stream.collect(Collectors.toCollection(() -> new ArrayList()));
                Comparator sort = MerlinUtil.getSorter(md, values);
                Collections.sort(values, sort);
                return values.stream();
            }
            return stream.sorted(nonNullSorter);
        };
        Supplier<Stream> getObjs = () -> {
            Collection specialValues = (Collection)getSpecialValues.apply(md);
            return Stream.concat(specialValues.stream(), (Stream)getBaseObjs.get());
        };
        return new ObjSource<T>(type, format, getFontStyle, getObjs, true);
    }

    public static <T extends IMerlinObj> ObjSource<T> fromRoot(MerlinData md, Composite<? extends IMerlinObj> root, Class<T> clazz, Predicate<? super T> availFilter) {
        return ObjSources.fromRoot(md, root, clazz, availFilter, null);
    }

    public static <T extends IMerlinObj> ObjSource<T> fromRoot(MerlinData md, Composite<? extends IMerlinObj> root, Class<T> clazz, Predicate<? super T> availFilter, Comparator<T> sorter) {
        Predicate<Object> filter = availFilter == null ? Filters.acceptAll(clazz) : availFilter;
        return new ObjSource<IMerlinObj>(clazz, (obj, bc) -> MerlinUtil.getName(root, obj, bc), obj -> 0, () -> {
            Stream stream = root.flatten(clazz, filter).stream();
            if (sorter == null) {
                ArrayList objs = stream.collect(Collectors.toCollection(() -> new ArrayList()));
                Comparator sort = MerlinUtil.getSorter(md, objs);
                Collections.sort(objs, sort);
                return objs.stream();
            }
            return stream.sorted(sorter);
        }, true);
    }

    public static ObjSource<Floor> getFloors(MerlinData md, String nullName) {
        return ObjSource.includeNull(Floor.class, null, (obj, bc) -> MerlinUtil.getName(md.floors, obj, bc), obj -> 0, (f1, f2) -> f1.getWorkingZ().compareTo(f2.getWorkingZ()), () -> md.floors.flatten(Floor.class).stream(), true);
    }

    public static ObjSource<IEgressOccupiable> getRooms(MerlinData md, String nullName) {
        return ObjSources.includeNull(IEgressOccupiable.class, nullName, (obj, bc) -> MerlinUtil.getName(md.floors, obj, bc), obj -> 0, () -> md.floors.flatten(IEgressOccupiable.class).stream());
    }

    public static ObjSource<Material> getMaterials(MerlinData md, String nullName) {
        return ObjSources.includeNull(Material.class, nullName, (obj, bc) -> MerlinUtil.getName(md.materials, obj, bc), obj -> 0, () -> md.materials.flatten(Material.class).stream());
    }

    public static ObjSource<IAvatar> getAvatars(ResourceAvatar.Type type, String nullName) {
        return ObjSource.includeNull(IAvatar.class, nullName, (obj, bc) -> obj.getName(), obj -> 0, (obj1, obj2) -> 0, () -> AvatarChooser.getSortedAvailableAvatars(type, false).stream(), false);
    }

    public static ObjSource<Tag> getTags(MerlinData md, String nullName) {
        return ObjSources.includeNull(Tag.class, nullName, (obj, bc) -> MerlinUtil.getName(md.tags, obj, bc), obj -> 0, () -> md.tags.flatten(Tag.class).stream());
    }

    public static ObjSource<OccProfile> getProfiles(MerlinData md, String nullName, boolean includeNoChangeProf) {
        return ObjSources.getSourceWithSpecialVal(md, OccProfile.class, nullName, includeNoChangeProf ? md.profiles.NO_CHANGE : null, () -> md.profiles);
    }

    private static <T extends IMerlinObj> ObjSource<T> getSourceWithSpecialVal(MerlinData md, Class<T> type, String nullName, T specialVal, Supplier<Composite<? super T>> getRoot) {
        ObjSource.IFormat<IMerlinObj> getName = (obj, bc) -> MerlinUtil.getName(getRoot.get(), obj, bc);
        MerlinUtil.SortByName<IMerlinObj> sortByName = MerlinUtil.sortByName(obj -> getName.apply((IMerlinObj)obj, false));
        return ObjSource.includeNull(type, nullName, getName, obj -> 0, (obj1, obj2) -> {
            if (obj1 == obj2) {
                return 0;
            }
            if (obj1 == specialVal) {
                return -1;
            }
            if (obj2 == specialVal) {
                return 1;
            }
            return sortByName.compare((IMerlinObj)obj1, (IMerlinObj)obj2);
        }, specialVal == null ? () -> ((Composite)getRoot.get()).flatten(type).stream() : () -> Stream.concat(Stream.of(specialVal), ((Composite)getRoot.get()).flatten(type).stream()), true);
    }

    public static ObjSource<Behavior> getBehaviors(MerlinData md, String nullName, boolean includeNoChangeBehavior) {
        return ObjSources.getSourceWithSpecialVal(md, Behavior.class, nullName, includeNoChangeBehavior ? md.behaviors.NO_CHANGE : null, () -> md.behaviors);
    }

    public static ObjSource<EgressAgent> getEgressAgents(MerlinData md, String nullName) {
        return ObjSources.includeNull(EgressAgent.class, null, (obj, bc) -> MerlinUtil.getName(md.agents, obj, bc), obj -> 0, () -> md.agents.flatten(EgressAgent.class).stream());
    }

    public static ObjSource<OccGroupTypeObj> getGroupTypes(MerlinData md, String nullName, boolean includeUngrouped) {
        return ObjSources.getSourceWithSpecialVal(md, OccGroupTypeObj.class, nullName, includeUngrouped ? md.occGroupTypes.NO_GROUP_TYPE : null, () -> md.occGroupTypes);
    }

    public static ObjSource<EgressDoor> getDoors(MerlinData md, String nullName) {
        return ObjSources.includeNull(EgressDoor.class, null, (obj, bc) -> MerlinUtil.getName(md.floors, obj, bc), obj -> 0, () -> md.floors.flatten(EgressDoor.class).stream());
    }

    public static ObjSource<Elevator> getElevators(MerlinData md, String nullName) {
        return ObjSources.includeNull(Elevator.class, null, (obj, bc) -> MerlinUtil.getName(md.elevators, obj, bc), obj -> 0, () -> md.elevators.flatten(Elevator.class).stream());
    }

    public static ObjSource<OccTarget> getOccTargets(MerlinData md, String nullName) {
        return ObjSources.includeNull(OccTarget.class, null, (obj, bc) -> MerlinUtil.getName(md.occTargets, obj, bc), obj -> 0, () -> md.occTargets.flatten(OccTarget.class).stream());
    }

    public static ObjSource<IGotoQueueDestination> getQueueDestinations(MerlinData md, String nullName) {
        return ObjSources.includeNull(IGotoQueueDestination.class, null, (obj, bc) -> MerlinUtil.getName(md.queues, obj, bc), obj -> 0, () -> md.queues.flatten(IGotoQueueDestination.class).stream());
    }

    public static ObjSource<AssistedEvacTeam> getEvacTeams(MerlinData md, String nullName) {
        return ObjSources.includeNull(AssistedEvacTeam.class, null, (obj, bc) -> MerlinUtil.getName(md.assistedEvacTeams, obj, bc), obj -> 0, () -> md.assistedEvacTeams.flatten(AssistedEvacTeam.class).stream());
    }

    public static ObjSource<Attractor> getAttractors(MerlinData md, String nullName) {
        return ObjSources.includeNull(Attractor.class, null, (obj, bc) -> MerlinUtil.getName(md.attractors, obj, bc), obj -> 0, () -> md.attractors.flatten(Attractor.class).stream());
    }

    public static ObjSource<Attractor> getAttractorTemplates(MerlinData md, String nullName) {
        return ObjSources.includeNull(Attractor.class, null, (obj, bc) -> MerlinUtil.getName(md.attractorTemplates, obj, bc), obj -> 0, () -> md.attractorTemplates.flatten(Attractor.class).stream());
    }

    public static ObjSource<VehicleShape> getVehicleShapes(MerlinData md, String nullName) {
        return ObjSources.includeNull(VehicleShape.class, null, (obj, bc) -> MerlinUtil.getName(md.vehicleShapes, obj, bc), obj -> 0, () -> md.vehicleShapes.flatten(VehicleShape.class).stream());
    }

    public static <ObjT extends IMerlinObj> ObjSource<ObjT> includeNull(Class<ObjT> type, String nullName, ObjSource.IFormat<ObjT> nonNullFormat, ToIntFunction<ObjT> getFontStyle, Supplier<? extends Stream<? extends ObjT>> getNonNullObjs) {
        return ObjSource.includeNull(type, nullName, nonNullFormat, getFontStyle, MerlinUtil.sortByName(obj -> nonNullFormat.apply(obj, false)), getNonNullObjs, true);
    }
}

