/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import common.data.ElevatorType;
import common.data.IElevatorTimingModel;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.UIManager;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.actions.CreateElevator;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorUtil;
import merlin.data.egress.geom.EgressRoom;
import merlin.geom.Geometry;
import merlin.gui.BasicFloorComboBox;
import merlin.gui.MerlinComboBox;
import merlin.gui.MerlinUDF;
import merlin.gui.guiUtil;
import merlin.gui.labels.DefaultLabelGenerator;
import merlin.gui.labels.ILabelGenerator;
import merlin.gui.labels.WrappedComp;
import merlin.unitsystem.SIUS;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;

public class NewElevatorDlg
extends guiDialog {
    private static final long serialVersionUID = 2901230551278915163L;
    private final guiTextField d_name = new guiTextField(Intl.intl("Elevator"));
    private final guiComboBox<ElevatorType> d_elevatorType = guiUtil.newEnumCombo(ElevatorType.class);
    private final guiDoubleField d_x = new guiDoubleField(0.0);
    private final guiDoubleField d_y = new guiDoubleField(0.0);
    private final guiDoubleField d_z = new guiDoubleField(1.0);
    private final guiUnitDoubleField d_nominalLoad;
    private final guiUnitDoubleField d_callDistance;
    private final MerlinComboBox<Floor> d_topFloorCB;
    private final MerlinComboBox<Floor> d_bottomFloorCB;
    private final TimingPnl d_timingPnl;
    private final MerlinUDF d_openCloseTime;
    private final guiCheckBox d_doubleDeck;
    private final guiLabel d_multiElevatorInfoLbl;
    private Collection<EgressRoom> d_baseRooms = null;

    public NewElevatorDlg(Window owner, MerlinData md) {
        super(owner, Intl.intl("New Elevator"), 9);
        this.d_x.setColumns(7);
        this.d_y.setColumns(7);
        this.d_z.setColumns(7);
        this.d_nominalLoad = new guiUnitDoubleField(SIUS.unit(9));
        this.d_topFloorCB = new BasicFloorComboBox(md, Intl.intl("[highest]"));
        this.d_bottomFloorCB = new BasicFloorComboBox(md, Intl.intl("[lowest]"));
        this.d_timingPnl = new TimingPnl(List.of(), new DefaultLabelGenerator());
        this.d_openCloseTime = new MerlinUDF(1, DoubleVR.above(0.0, true));
        this.d_callDistance = new MerlinUDF(0, DoubleVR.above(0.0, true));
        this.d_doubleDeck = new guiCheckBox(Intl.intl("Double-Deck"), false);
        this.d_multiElevatorInfoLbl = new guiLabel("<html>" + Intl.intl("<i>When creating multiple elevators, creation order is determined by room selection order.</i><br><i>Try selecting the rooms in an alternative order if the resulting elevators don't appear as expected.</i>"));
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addRow(Intl.intl("Name:"), this.d_name, 1.0, 0);
        gb.addRow(Intl.intl("Type:"), this.d_elevatorType, 0);
        gb.addRow(Intl.intl("Nominal Load:"), this.d_nominalLoad, 0);
        gb.addRow(Intl.intl("Travel Direction:"), Intl.intl("X:"), this.d_x, Intl.intl("Y:"), this.d_y, Intl.intl("Z:"), this.d_z);
        gb.addRow(this.d_multiElevatorInfoLbl, 0);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Elevator Bounds")));
        gb.indent();
        gb.addRow(Intl.intl("Bottom Floor:"), this.d_bottomFloorCB, 0);
        gb.addRow(Intl.intl("Top Floor:"), this.d_topFloorCB, 0);
        gb.unindent();
        gb.addFilledRow(new TitleSeparator(Intl.intl("Elevator Timing")));
        gb.indent();
        this.d_timingPnl.addToLayout(gb);
        gb.addRow(Intl.intl("Open+Close Time:"), this.d_openCloseTime, 0);
        gb.addRow(Intl.intl("Call Distance:"), this.d_callDistance, 0);
        gb.unindent();
        gb.addFilledRow(new TitleSeparator(Intl.intl("Elevator Type")));
        gb.addIdentRow(this.d_doubleDeck, 1.0, 0);
        gb.finalizeRows();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        for (EgressRoom baseRoom : this.d_baseRooms) {
            if (!baseRoom.getDoors().isEmpty()) continue;
            if (showWarn) {
                String msg = Intl.intl("The base room must contain doors that will connect with each floor.");
                NewElevatorDlg.showInvalidEntryMessage(this, msg);
            }
            return false;
        }
        UnitDouble bottom = this.getLoc(this.d_bottomFloorCB);
        UnitDouble top = this.getLoc(this.d_topFloorCB);
        if (bottom != null && top != null && bottom.compareTo(top) >= 0) {
            if (showWarn) {
                String msg = Intl.intl("The top floor must be above the bottom floor.");
                NewElevatorDlg.showInvalidEntryMessage(this, msg);
            }
            return false;
        }
        if (this.isSelFloorEmpty(this.d_bottomFloorCB)) {
            if (showWarn) {
                String msg = Intl.intl("The bottom floor must not be empty.");
                NewElevatorDlg.showInvalidEntryMessage(this, msg);
            }
            return false;
        }
        if (this.isSelFloorEmpty(this.d_topFloorCB)) {
            if (showWarn) {
                String msg = Intl.intl("The top floor must not be empty.");
                NewElevatorDlg.showInvalidEntryMessage(this, msg);
            }
            return false;
        }
        if ((Double)this.d_x.getValue() == 0.0 && (Double)this.d_y.getValue() == 0.0 && (Double)this.d_z.getValue() == 0.0) {
            if (showWarn) {
                String msg = Intl.intl("The travel direction must be non-zero.");
                NewElevatorDlg.showInvalidEntryMessage(this, msg);
            }
            return false;
        }
        return true;
    }

    private boolean isSelFloorEmpty(MerlinComboBox<Floor> floorcb) {
        Floor selFloor = (Floor)floorcb.getSelectedItem();
        return selFloor == null ? false : selFloor.getDeepMembers().isEmpty();
    }

    private UnitDouble getLoc(MerlinComboBox<Floor> floorcb) {
        Floor floor = (Floor)floorcb.getSelectedItem();
        return floor != null ? floor.getWorkingZ() : null;
    }

    private void loadProps(MerlinData md, CreateElevator.ActionProps props) {
        this.d_name.setText(props.get(CreateElevator.ActionProps.PROP_NAME));
        this.d_bottomFloorCB.setSelectedItem(props.get(CreateElevator.ActionProps.PROP_BOTTOM_FLOOR));
        this.d_topFloorCB.setSelectedItem(props.get(CreateElevator.ActionProps.PROP_TOP_FLOOR));
        this.d_openCloseTime.setValue(props.get(CreateElevator.ActionProps.PROP_OPEN_CLOSE_TIME));
        this.d_timingPnl.load(props.get(CreateElevator.ActionProps.PROP_TIMING_MODEL));
        this.d_callDistance.setValue(props.get(CreateElevator.ActionProps.PROP_CALL_DISTANCE));
        this.d_doubleDeck.setSelected(props.get(CreateElevator.ActionProps.PROP_DOUBLE_DECK));
        this.d_elevatorType.setSelectedItem(props.get(CreateElevator.ActionProps.PROP_TYPE));
        this.d_nominalLoad.setValue(props.get(CreateElevator.ActionProps.PROP_NOMINAL_LOAD));
        this.d_x.setValue(props.get(CreateElevator.ActionProps.PROP_TRAVEL_DIR).x);
        this.d_y.setValue(props.get(CreateElevator.ActionProps.PROP_TRAVEL_DIR).y);
        this.d_z.setValue(props.get(CreateElevator.ActionProps.PROP_TRAVEL_DIR).z);
    }

    private void saveProps(MerlinData md, CreateElevator.ActionProps props) {
        props.set(CreateElevator.ActionProps.PROP_NAME, this.d_name.getText());
        props.set(CreateElevator.ActionProps.PROP_BOTTOM_FLOOR, (Floor)this.d_bottomFloorCB.getSelectedItem());
        props.set(CreateElevator.ActionProps.PROP_TOP_FLOOR, (Floor)this.d_topFloorCB.getSelectedItem());
        props.set(CreateElevator.ActionProps.PROP_OPEN_CLOSE_TIME, (UnitDouble)this.d_openCloseTime.getValue());
        props.set(CreateElevator.ActionProps.PROP_TIMING_MODEL, this.d_timingPnl.save());
        props.set(CreateElevator.ActionProps.PROP_CALL_DISTANCE, (UnitDouble)this.d_callDistance.getValue());
        props.set(CreateElevator.ActionProps.PROP_DOUBLE_DECK, this.d_doubleDeck.isSelected());
        props.set(CreateElevator.ActionProps.PROP_TYPE, this.d_elevatorType.getSelectedItem());
        props.set(CreateElevator.ActionProps.PROP_NOMINAL_LOAD, (UnitDouble)this.d_nominalLoad.getValue());
        Vector3d dir = new Vector3d((Double)this.d_x.getValue(), (Double)this.d_y.getValue(), (Double)this.d_z.getValue());
        dir.normalize();
        props.set(CreateElevator.ActionProps.PROP_TRAVEL_DIR, dir);
    }

    public void load(MerlinData md, Collection<EgressRoom> baseRooms, CreateElevator.ActionProps props) {
        this.loadProps(md, props);
        this.d_baseRooms = new LinkedHashSet<EgressRoom>(baseRooms);
        Floor dischargeFloor = ElevatorUtil.getFloor(md, this.d_baseRooms.iterator().next());
        UnitDouble discharge = dischargeFloor.getWorkingZ();
        UnitDouble top = this.getLoc(this.d_topFloorCB);
        UnitDouble bottom = this.getLoc(this.d_bottomFloorCB);
        if (top != null && discharge.compareTo(top) > 0) {
            this.d_topFloorCB.setSelectedItem(dischargeFloor);
        }
        if (bottom != null && discharge.compareTo(bottom) < 0) {
            this.d_bottomFloorCB.setSelectedItem(dischargeFloor);
        }
        this.d_multiElevatorInfoLbl.setVisible(this.d_baseRooms.size() > 1);
    }

    public void save(MerlinData md, CreateElevator.ActionProps props) {
        this.saveProps(md, props);
    }

    public static class TimingPnl
    extends guiPanel {
        private static final long serialVersionUID = -4081032343494838159L;
        private final WrappedComp<guiMultiStateCheckBox> d_accelCB;
        private final MerlinUDF d_accel;
        private final MerlinUDF d_vel;
        private final WrappedComp<guiLabel> d_velLbl;
        private final guiLabel d_legacyWarning;

        public TimingPnl(Collection<? extends IMerlinObj> objs, ILabelGenerator labels) {
            this.d_accelCB = labels.checkbox(Elevator.PROP_TIMING_MODEL, Intl.intl("Acceleration:"), "");
            this.d_accel = new MerlinUDF(8, DoubleVR.above(0.0, false));
            this.d_vel = new MerlinUDF(5, DoubleVR.above(0.0, false));
            this.d_velLbl = labels.lbl(Elevator.PROP_TIMING_MODEL, Intl.intl("Max Velocity:"), "");
            this.d_legacyWarning = new guiLabel(Intl.intl("<html><body style='width: 120px;'>Previous Legacy model will be converted to Velocity or Acceleration model.</body></html>"));
            this.d_legacyWarning.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
            this.d_legacyWarning.setVisible(false);
            LinkStatus.link((AbstractButton)this.d_accelCB.comp, this.d_accel);
            GridBagHelper gb = new GridBagHelper(this);
            this.addToLayout(gb);
            gb.finalizeRows();
        }

        public void addToLayout(GridBagHelper gb) {
            gb.addRow(this.d_accelCB, this.d_accel, 0);
            gb.addRow(this.d_velLbl, this.d_vel, 0);
            gb.addFilledRow(this.d_legacyWarning);
        }

        public void load(IElevatorTimingModel model) {
            this.d_legacyWarning.setVisible(model instanceof IElevatorTimingModel.DistModel);
            if (model instanceof IElevatorTimingModel.DistModel) {
                model = new IElevatorTimingModel.VelModel(((IElevatorTimingModel.DistModel)model).defaultVel);
            }
            if (model instanceof IElevatorTimingModel.AccelModel) {
                IElevatorTimingModel.AccelModel am = (IElevatorTimingModel.AccelModel)model;
                ((guiMultiStateCheckBox)this.d_accelCB.comp).setSelected(true);
                this.d_accel.setValue(new UnitDouble(am.accel, Geometry.ACCEL_UNIT));
                this.d_vel.setValue(new UnitDouble(am.maxVel, Geometry.VEL_UNIT));
            } else if (model instanceof IElevatorTimingModel.VelModel) {
                IElevatorTimingModel.VelModel vm = (IElevatorTimingModel.VelModel)model;
                ((guiMultiStateCheckBox)this.d_accelCB.comp).setSelected(false);
                this.d_accel.setValue(new UnitDouble(IElevatorTimingModel.DEF_MODEL.accel, Geometry.ACCEL_UNIT));
                this.d_vel.setValue(new UnitDouble(vm.vel, Geometry.VEL_UNIT));
            }
        }

        public IElevatorTimingModel save() {
            if (((guiMultiStateCheckBox)this.d_accelCB.comp).isSelected()) {
                return new IElevatorTimingModel.AccelModel(((UnitDouble)this.d_accel.getValue()).getValue(Geometry.ACCEL_UNIT), ((UnitDouble)this.d_vel.getValue()).getValue(Geometry.VEL_UNIT));
            }
            return new IElevatorTimingModel.VelModel(((UnitDouble)this.d_vel.getValue()).getValue(Geometry.VEL_UNIT));
        }
    }
}

