/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.montecarlo.VariationOccFilter;
import net.miginfocom.swing.MigLayout;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.DefaultTableClipboard;
import thunderheadeng.gui.table.ToolTipTableHeader;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableClipboard;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;

public class MonteCarloOccFilterPnl
extends guiPanel {
    private final guiTable d_table;
    ArrayList<EgressAgentComp> d_occGroups;

    public MonteCarloOccFilterPnl(final MerlinData md) {
        String[] headers = new String[]{Intl.intl("Occupant Group"), Intl.intl("Randomize Positions"), Intl.intl("Randomize Profile Properties"), Intl.intl("Randomize Profiles")};
        String[] headerTooltips = new String[]{Intl.intl("An occupant group node from within the Occupants tree."), Intl.intl("Whether to randomize occupant positions within this group."), Intl.intl("Whether to randomize occupant properties within this group."), Intl.intl("Whether to randomize occupant profiles within this group.")};
        this.d_occGroups = this.populateOccGroups(md);
        guiTableEditor ed = new guiTableEditor(guiTableUtil.fixedColumnTable(headers, new Class[]{EgressAgentComp.class, Boolean.class, Boolean.class, Boolean.class}, new guiTable(new guiDefaultTableModel(), 24){

            @Override
            protected Object[] allocateRow() {
                return new Object[]{null, true, true, true};
            }
        }), 30);
        this.d_table = ed.getTable();
        this.d_table.setNullValuesAllowed(false);
        this.d_table.setTableHeader(new ToolTipTableHeader(this.d_table.getColumnModel(), headerTooltips));
        guiComboBox<EgressAgentComp> groupBox = new guiComboBox<EgressAgentComp>((Collection<EgressAgentComp>)this.d_occGroups);
        groupBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                EgressAgentComp group = (EgressAgentComp)value;
                if (group == null) {
                    this.setText(" ");
                } else {
                    this.setText(group.getGroupPath().substring(md.agents.getName().length()));
                }
                return c;
            }
        });
        this.d_table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(groupBox));
        this.d_table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setText(value == null ? " " : ((EgressAgentComp)value).getGroupPath().substring(md.agents.getName().length()));
                return c;
            }
        });
        this.d_table.setClipboard(EgressAgentComp.class, (guiTableClipboard)new EgressAgentCompClipboard(md));
        this.d_table.autoSizeColumns(700);
        this.d_table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.d_table.setPreferredScrollableViewportSize(new Dimension(this.d_table.getPreferredSize().width, Math.min(700, this.d_table.getPreferredSize().height)));
        this.setLayout(new MigLayout("insets 0, fill"));
        this.add((Component)ed, "grow");
    }

    public void load(List<VariationOccFilter> occFilters) {
        if (occFilters != null) {
            TableModel model = this.d_table.getModel();
            for (int i = 0; i < occFilters.size(); ++i) {
                VariationOccFilter f = occFilters.get(i);
                if (f.group() == null) continue;
                model.setValueAt(f.group(), i, 0);
                model.setValueAt(f.randomizePositions(), i, 1);
                model.setValueAt(f.randomizeProperties(), i, 2);
                model.setValueAt(f.randomizeProfiles(), i, 3);
            }
        }
        this.setModified(false);
    }

    public List<VariationOccFilter> save() {
        TableModel model = this.d_table.getModel();
        int rows = model.getRowCount();
        if (rows == 0) {
            return Collections.emptyList();
        }
        ArrayList<VariationOccFilter> filtersList = new ArrayList<VariationOccFilter>();
        for (int i = 0; i < rows; ++i) {
            EgressAgentComp group = (EgressAgentComp)model.getValueAt(i, 0);
            if (group == null) continue;
            boolean randPos = (Boolean)model.getValueAt(i, 1);
            boolean randProp = (Boolean)model.getValueAt(i, 2);
            boolean randProf = (Boolean)model.getValueAt(i, 3);
            VariationOccFilter filter = new VariationOccFilter(group, randPos, randProp, randProf);
            filtersList.add(filter);
        }
        return filtersList;
    }

    private ArrayList<EgressAgentComp> populateOccGroups(MerlinData md) {
        return new ArrayList<EgressAgentComp>(md.agents.flatten(EgressAgentComp.class));
    }

    private static class EgressAgentCompClipboard
    extends DefaultTableClipboard {
        private final MerlinData d_md;

        public EgressAgentCompClipboard(MerlinData md) {
            this.d_md = md;
        }

        @Override
        public boolean pasteObject(guiTable table, Object data, int pasteRow, int pasteCol) {
            EgressAgentComp comp;
            EgressAgentComp conflict;
            if (data instanceof EgressAgentComp && (conflict = EntryPointFactory.get(comp = (EgressAgentComp)data).getConflict(this.d_md, comp)) != null) {
                return super.pasteObject(table, conflict, pasteRow, pasteCol);
            }
            return false;
        }
    }
}

