/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.JsonObj;
import merlin.data.MerlinData;
import merlin.gui.JsonPnl;
import merlin.gui.ManagerDlg;
import merlin.unitsystem.UnitSystem;
import thunderheadeng.gui.IEditor;

public class JsonDlg
extends ManagerDlg<JsonObj, ManagerDlg.IManager<JsonObj>> {
    private static final long serialVersionUID = 8919101630244346602L;
    private static final int s_newActionIx = 0;
    private static final int s_deleteActionIx = 1;
    private static final int s_overrideActionIx = 2;
    private final IEditor<JsonObj> d_editor = new JsonPnl(this.getMgrOverrideCallback());
    private ManagerDlg.IManager<JsonObj> d_mgr;

    public JsonDlg(JFrame owner, UnitSystem uSys) {
        super(owner, Intl.intl("Edit JSON Objects"), JsonObj.class);
        this.d_actions = new Action[]{new NewAction(), new ManagerDlg.DeleteAction(this), this.d_overrideAction};
        this.updateActions();
    }

    @Override
    protected boolean validateEditor(IEditor<JsonObj> editor, boolean showWarn, boolean allowModify) {
        boolean modified = this.d_editor.isModified();
        if (!super.validateEditor(editor, showWarn, allowModify)) {
            return false;
        }
        if (modified) {
            int ix = this.getList().getSelectedIx();
            JsonObj prof = (JsonObj)this.getList().getItem(ix);
            if (prof != null && !this.validateJson(prof, showWarn, allowModify)) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateJson(JsonObj prof, boolean showWarn, boolean allowModify) {
        return true;
    }

    @Override
    public void updateActions() {
        this.updateActionEnabled(0, this.shouldEnableNew());
        this.updateActionEnabled(1, this.shouldEnableDelete());
        this.updateActionEnabled(2, this.shouldEnableOverride());
    }

    public void init(MerlinData md, ManagerDlg.IManager<JsonObj> mgr, JsonObj init) {
        this.d_mgr = mgr;
        super.init(md, this.d_mgr, this.d_editor, this.d_actions);
        this.updateActions();
        if (init != null) {
            this.getList().select(init);
        }
    }

    public static JsonObj addJson(MerlinData md, JsonObj baseProf) {
        JsonObj profNew;
        Undo.begin(Intl.intl("New JSON Object"));
        try {
            profNew = baseProf != null ? (JsonObj)baseProf.clone() : new JsonObj();
            AddObject.add((MerlinData)md, (Composite)md.json, (int)md.json.getMembers().size(), (IMerlinObj[])new JsonObj[]{profNew});
        }
        finally {
            Undo.end(md);
        }
        return profNew;
    }

    private class NewAction
    extends AbstractAction {
        private static final long serialVersionUID = -1115265798423911446L;

        public NewAction() {
            super(Intl.intl("New..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!JsonDlg.this.preSave()) {
                return;
            }
            final JsonObj[] newProf = new JsonObj[1];
            AMerlinOp op = new AMerlinOp(this){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    try (MerlinData.WriteLock lock = md.lockWrite();){
                        newProf[0] = JsonDlg.addJson(md, null);
                    }
                }
            };
            UIHook.run(UIHook.getComponent(e), "JsonDlg.NewAction", op, 0);
            assert (newProf[0] != null);
            JsonDlg.this.getList().updateModelView(JsonDlg.this.d_mgr);
            JsonDlg.this.getList().select(newProf[0]);
            JsonDlg.this.d_editor.getEditorPanel().setModified(false);
            JsonDlg.this.updateActions();
        }
    }
}

