/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.io.File;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.data.material.MaterialDB;
import thunderheadeng.gui.ImageBtn;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.gui.materialdlg.IImageBtnListener;

public class ImageBtnListener
implements IImageBtnListener {
    public static final ImageBtnListener INSTANCE = new ImageBtnListener();
    private String d_lastChoice;

    @Override
    public void setDefaultFile(File dir) {
        this.d_lastChoice = dir.getAbsolutePath();
    }

    @Override
    public boolean chooseNewImage(ImageBtn btn, String name) {
        IImage imgLoc = btn.getImage();
        String startingDir = null;
        if (imgLoc != null) {
            startingDir = new File(imgLoc.getFilename()).getParent();
        }
        if (startingDir == null && this.d_lastChoice != null) {
            startingDir = this.d_lastChoice;
        } else if (startingDir == null) {
            startingDir = MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF);
        }
        guiJFXFileChooser chooser = new guiJFXFileChooser(imgLoc == null ? null : imgLoc.getFilename(), startingDir, String.format(Intl.intl("Choose %s Image"), name), (Boolean)true, (Boolean)true, (Boolean)false, MerlinApp.getApp().getData().materials.getFileFilters());
        File f = chooser.showOpenDialog();
        if (f == null) {
            return false;
        }
        this.d_lastChoice = f.getAbsolutePath();
        IImage img = MaterialDB.loadImage(f.getAbsolutePath());
        if (img == null) {
            return false;
        }
        if (img != btn.getImage()) {
            btn.setImage(img);
            btn.setModified(true);
        }
        return true;
    }
}

