/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.data.egress.Floor;
import merlin.data.egress.elevators.Elevator;
import merlin.gui.MerlinComboBox;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.framework.ObjSource;

public class ElevatorFloorComboBox
extends MerlinComboBox<Floor> {
    private static final long serialVersionUID = 1L;

    public ElevatorFloorComboBox(MerlinData md) {
        super(md, ElevatorFloorComboBox.getFloorSource(md, md.elevators.flatten(Elevator.class)));
    }

    private static ObjSource<Floor> getFloorSource(MerlinData md, Collection<Elevator> elevators) {
        Supplier<Stream> getFloors = () -> {
            Collection<Elevator> finalElevators = elevators == null ? md.elevators.flatten(Elevator.class) : elevators;
            Stream sortedFloors = finalElevators.stream().filter(e -> e.getDomain() != null).flatMap(e -> e.getFloorLevelMap().keySet().stream()).distinct().sorted((f1, f2) -> f1.getWorkingZ().compareTo(f2.getWorkingZ(), 1.0E-6));
            return Stream.concat(Stream.of((Floor)null), sortedFloors);
        };
        return new ObjSource<Floor>(Floor.class, (floor, bc) -> {
            if (floor == null) {
                return Intl.intl("Discharge Floor");
            }
            return MerlinUtil.getName(md.floors, floor, bc);
        }, floor -> 0, getFloors, true);
    }

    public void setElevators(MerlinData md, Collection<Elevator> elevators) {
        this.setSource(ElevatorFloorComboBox.getFloorSource(md, elevators));
    }
}

