/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.ScenarioSetupAction;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.SimParams;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioUtil;
import merlin.gui.MerlinValueFields;
import merlin.gui.ScenarioSetupDlg;
import merlin.gui.guiUtil;
import merlin.gui.labels.ILabelGenerator;
import merlin.gui.labels.IScenarioLabelGenerator;
import merlin.gui.labels.WrappedComp;
import merlin.unitsystem.SIUS;
import merlin.util.MerlinUtil;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.SmvParseUtil;

public class EditSimParamsDlg
extends guiDialog {
    private static final long serialVersionUID = 1L;
    private MerlinData d_md;
    private ScenarioUtil.MixedOverrideState d_overrides = ScenarioUtil.MixedOverrideState.EMPTY;
    private JButton d_overrideBtn;
    private Map<String, EditorPanel> d_tabs;

    public EditSimParamsDlg(JFrame owner, MerlinData md) {
        super((Window)owner, Intl.intl("Simulation Parameters"), 9);
        this.d_md = md;
        this.d_tabs = new LinkedHashMap<String, EditorPanel>();
        this.d_tabs.put(Intl.intl("Time"), new TimeEditor(this));
        this.d_tabs.put(Intl.intl("Output"), new OutputEditor(this));
        this.d_tabs.put(Intl.intl("Paths"), new PathingEditor(this));
        this.d_tabs.put(Intl.intl("Behavior"), new BehaviorEditor(this));
        this.d_tabs.put(Intl.intl("FDS Data"), new FdsOutputLinkageEditor(this));
        this.d_tabs.put(Intl.intl("Misc"), new MiscEditor(this));
        JTabbedPane jtp = new JTabbedPane();
        for (Map.Entry<String, EditorPanel> entry : this.d_tabs.entrySet()) {
            jtp.addTab(entry.getKey(), entry.getValue());
        }
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new BorderLayout());
        dlgPanel.add((Component)jtp, "Center");
        this.d_overrideBtn = new JButton(new ScenarioSetupAction(e -> {
            SimParams obj = this.d_md.simParams;
            ScenarioSetupDlg dlg = new ScenarioSetupDlg((Window)this, 0, false);
            List<IDisplayProp<?>> supportedProps = ScenarioUtil.getSortedAvailableDisplayProps(obj);
            dlg.setAvailObjs(supportedProps);
            dlg.setObjectSelectionState(this.d_overrides.toDisplay(supportedProps));
            if (dlg.doModal() == 1) {
                this.applyNewOverrideState(dlg.getObjectSelectionState().toStorage());
            }
            this.repaint();
        }));
        guiPanel southPnl = new guiPanel(new GridBagLayout());
        GridBagUtil.add(southPnl, this.d_overrideBtn, 0, 0, 1, 1, 6, 12, 0, 12, 0, 0.0, 0.0);
        GridBagUtil.add(southPnl, Box.createGlue(), 1, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0);
        GridBagUtil.add(southPnl, this.getButtonPanel(), 2, 0, 1, 1, 0, 12, 0, 0, 0, 0.0, 0.0);
        this.getRootPane().getContentPane().add((Component)southPnl, "South");
    }

    public void applyNewOverrideState(ScenarioUtil.MixedOverrideState newOverrides) {
        SimParams tempParams = new SimParams();
        this.store(this.d_md, tempParams, true);
        Set<IDisplayProp<?>> newSelectedState = newOverrides.overrides();
        for (IDisplayProp<?> prop : this.d_overrides.overrides()) {
            PropValue<?> getProp;
            if (newSelectedState.contains(prop) || !(getProp = this.d_md.scenarios.getDefault().getObjValue(this.d_md.simParams, prop)).isSupported()) continue;
            tempParams.set(prop.asProp(), getProp.get());
        }
        this.load(tempParams, this.d_md.scenarios.getActive(), true);
        this.d_overrides = newOverrides;
        this.setModified(true);
    }

    public void load(SimParams sp, Scenario activeScenario, boolean loadFromTemp) {
        if (!loadFromTemp) {
            this.d_overrides = ScenarioUtil.getScenarioOverrideState(activeScenario, Collections.singleton(sp));
        }
        this.d_overrideBtn.setEnabled(!activeScenario.isDefault());
        for (Map.Entry<String, EditorPanel> entry : this.d_tabs.entrySet()) {
            entry.getValue().load(sp);
        }
        this.setModified(loadFromTemp);
    }

    public void store(MerlinData md, SimParams sp, boolean isTemp) {
        assert (isTemp == (sp.getDomain() == null));
        if (!isTemp) {
            Undo.insertUndoEntry_restore(md, sp);
            Scenario activeScenario = md.scenarios.getActive();
            if (!activeScenario.isDefault()) {
                ScenarioUtil.applyScenarioOverrideState(md, activeScenario, Collections.singleton(sp), this.getOverrideStateCopy());
            }
        }
        for (Map.Entry<String, EditorPanel> entry : this.d_tabs.entrySet()) {
            entry.getValue().store(sp);
        }
    }

    public ScenarioUtil.MixedOverrideState getOverrideStateCopy() {
        return this.d_overrides.toStorage();
    }

    private static ILabelGenerator getLabels(final EditSimParamsDlg dlg) {
        return new IScenarioLabelGenerator(){
            MerlinData d_md = MerlinApp.getAppData();

            @Override
            public Collection<? extends IMerlinObj> getSelection() {
                return Set.of(this.d_md.simParams);
            }

            @Override
            public Boolean getState(Collection<Object> props) {
                return dlg.getOverrideStateCopy().overrides().containsAll(props);
            }

            @Override
            public void applyOverride(Collection<? extends IDisplayProp<?>> props, boolean setCustomized) {
                ScenarioUtil.MixedOverrideState tempState = dlg.getOverrideStateCopy();
                if (setCustomized) {
                    tempState.overrides().addAll(props);
                } else {
                    tempState.overrides().removeAll(props);
                }
                dlg.applyNewOverrideState(tempState.toStorage());
                dlg.repaint();
            }
        };
    }

    private static boolean containsQuantities(List<String[]> qs, String ... fdsNames) {
        ArrayList<String> fdsNameList = new ArrayList<String>(Arrays.asList(fdsNames));
        for (String[] quantDescLbls : qs) {
            fdsNameList.remove(quantDescLbls[0]);
        }
        return fdsNameList.isEmpty();
    }

    private static double getAverageInterval(Float[] fs) {
        double allIntervals = 0.0;
        for (int i = 1; i < fs.length; ++i) {
            allIntervals += (double)(fs[i].floatValue() - fs[i - 1].floatValue());
        }
        return allIntervals / (double)(fs.length - 1);
    }

    private static double getAverageInterval(Set<Float> fs) {
        return EditSimParamsDlg.getAverageInterval(fs.toArray(new Float[fs.size()]));
    }

    private static class TimeEditor
    extends EditorPanel {
        private static final long serialVersionUID = 1L;
        private WrappedComp<guiMultiStateCheckBox> d_ckMaxTime;
        private ValueField<UnitDouble> d_fldMaxTime;
        private WrappedComp<guiLabel> d_labDT;
        private ValueField<UnitDouble> d_fldDT;

        public TimeEditor(EditSimParamsDlg dlg) {
            ILabelGenerator labels = EditSimParamsDlg.getLabels(dlg);
            this.d_ckMaxTime = labels.checkbox(SimParams.RUNTIME_MAX_FLAG, false);
            WrappedComp<guiLabel> labMaxTime = labels.lbl(SimParams.RUNTIME_MAX);
            this.d_fldMaxTime = ValueFields.udFld(DoubleVR.above(0.0, false), (Unit)SI.SECOND);
            LinkStatus.link((AbstractButton)this.d_ckMaxTime.comp, labMaxTime, this.d_fldMaxTime);
            this.d_labDT = labels.lbl(SimParams.DT_SIM);
            this.d_fldDT = ValueFields.udFld(DoubleVR.above(0.0, false), (Unit)SI.SECOND);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(this.d_ckMaxTime, 0);
            gb.addIdentRow(labMaxTime, this.d_fldMaxTime, 0);
            if (MerlinApp.isDev()) {
                gb.addRow(this.d_labDT, this.d_fldDT);
            }
            gb.finalizeRows();
        }

        @Override
        public void load(SimParams sp) {
            this.d_fldMaxTime.setValue(sp.get(SimParams.RUNTIME_MAX));
            ((guiMultiStateCheckBox)this.d_ckMaxTime.comp).setSelected(sp.get(SimParams.RUNTIME_MAX_FLAG));
            this.d_fldDT.setValue(sp.get(SimParams.DT_SIM));
        }

        @Override
        public void store(SimParams sp) {
            sp.set(SimParams.RUNTIME_MAX, (UnitDouble)this.d_fldMaxTime.getValue());
            sp.set(SimParams.RUNTIME_MAX_FLAG, ((guiMultiStateCheckBox)this.d_ckMaxTime.comp).isSelected());
            sp.set(SimParams.DT_SIM, (UnitDouble)this.d_fldDT.getValue());
        }
    }

    private static class OutputEditor
    extends EditorPanel {
        private static final long serialVersionUID = 1L;
        private WrappedComp<guiLabel> d_labVisDT;
        private ValueField<UnitDouble> d_fldVisDT;
        private WrappedComp<guiLabel> d_labCSVDT;
        private ValueField<UnitDouble> d_fldCSVDT;
        private WrappedComp<guiLabel> d_labStatusDT;
        private ValueField<UnitDouble> d_fldStatusDT;
        private ValueField<UnitDouble> d_fldSlowSpeed;
        private ValueField<UnitDouble> d_fldSlowSpeedAveragingTime;
        private final guiComboBox<Boolean> d_occCSVOptions;
        private final WrappedComp<guiMultiStateCheckBox> d_densityRegionSeekSpeed;
        private final WrappedComp<guiMultiStateCheckBox> d_outputOccParamsFile;
        private final WrappedComp<guiMultiStateCheckBox> d_socialDistanceEnable;
        private final ValueField<UnitDouble> d_socialDistanceFld;
        private final WrappedComp<guiMultiStateCheckBox> d_writeJsonFiles;

        public OutputEditor(EditSimParamsDlg dlg) {
            ILabelGenerator labels = EditSimParamsDlg.getLabels(dlg);
            this.d_labVisDT = labels.lbl(SimParams.DT_VIS);
            this.d_fldVisDT = ValueFields.udFld(1.0, DoubleVR.above(0.0, false), SI.SECOND);
            this.d_labCSVDT = labels.lbl(SimParams.DT_CSV);
            this.d_labCSVDT.setToolTipText(Intl.intl("Controls how frequently (in sim time) output files are updated during the simulation."));
            this.d_fldCSVDT = ValueFields.udFld(1.0, DoubleVR.above(0.0, false), SI.SECOND);
            this.d_labStatusDT = labels.lbl(SimParams.DT_STATUS);
            this.d_fldStatusDT = ValueFields.udFld(1.0, DoubleVR.above(0.0, false), SI.SECOND);
            WrappedComp<guiLabel> occCSVLbl = labels.lbl(SimParams.OCC_CSV_FILE_MERGE);
            this.d_occCSVOptions = guiUtil.newCombo(Boolean.valueOf(true), Intl.intl("Merge into one file"), false, Intl.intl("Create one file per occupant"));
            this.d_densityRegionSeekSpeed = labels.checkbox(SimParams.MEASUREMENT_REGION_SEEK_SPEED, false);
            guiLabel slowTitle = new guiLabel(Intl.intl("Congestion Reporting:"));
            WrappedComp<guiLabel> labSlowSpeed = labels.lbl(SimParams.LOW_SPEED_THRESHOLD);
            this.d_fldSlowSpeed = MerlinValueFields.udFld(1.0, DoubleVR.above(0.0, false), SIUS.unit(5), 5);
            WrappedComp<guiLabel> labSlowSpeedAveragingTime = labels.lbl(SimParams.LOW_SPEED_AVERAGING_TIME);
            this.d_fldSlowSpeedAveragingTime = ValueFields.udFld(1.0, DoubleVR.above(0.0, false), SI.SECOND);
            this.d_outputOccParamsFile = labels.checkbox(SimParams.WRITE_OCCUPANT_PARAMS_FILE, false);
            this.d_writeJsonFiles = labels.checkbox(SimParams.WRITE_JSON_FILES, false);
            this.d_socialDistanceEnable = labels.checkbox(SimParams.WRITE_SOCIAL_DISTANCE, false);
            WrappedComp<guiLabel> labSocialDistance = labels.lbl(SimParams.SOCIAL_DISTANCE);
            this.d_socialDistanceFld = MerlinValueFields.udFld(2.0, DoubleVR.between(0.0, 100.0, false, true), SIUS.unit(0), 0);
            LinkStatus.link((AbstractButton)this.d_socialDistanceEnable.comp, labSocialDistance, this.d_socialDistanceFld);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(this.d_labVisDT, this.d_fldVisDT);
            gb.addRow(this.d_labCSVDT, this.d_fldCSVDT);
            gb.addRow(this.d_labStatusDT, this.d_fldStatusDT);
            gb.addRow(slowTitle, 0, 1.0);
            gb.addIdentRow(labSlowSpeed, this.d_fldSlowSpeed);
            gb.addIdentRow(labSlowSpeedAveragingTime, this.d_fldSlowSpeedAveragingTime);
            gb.addRow(occCSVLbl, this.d_occCSVOptions);
            gb.addRow(this.d_densityRegionSeekSpeed, 0);
            gb.addRow(this.d_outputOccParamsFile, 0);
            gb.addRow(this.d_writeJsonFiles, 0);
            gb.addRow(this.d_socialDistanceEnable, 0);
            gb.addIdentRow(labSocialDistance, this.d_socialDistanceFld);
            gb.finalizeRows();
        }

        @Override
        public void load(SimParams sp) {
            this.d_fldVisDT.setValue(sp.get(SimParams.DT_VIS));
            this.d_fldCSVDT.setValue(sp.get(SimParams.DT_CSV));
            this.d_fldStatusDT.setValue(sp.get(SimParams.DT_STATUS));
            this.d_fldSlowSpeed.setValue(sp.get(SimParams.LOW_SPEED_THRESHOLD));
            this.d_fldSlowSpeedAveragingTime.setValue(sp.get(SimParams.LOW_SPEED_AVERAGING_TIME));
            this.d_occCSVOptions.setSelectedItem(sp.get(SimParams.OCC_CSV_FILE_MERGE));
            ((guiMultiStateCheckBox)this.d_densityRegionSeekSpeed.comp).setSelected(sp.get(SimParams.MEASUREMENT_REGION_SEEK_SPEED));
            ((guiMultiStateCheckBox)this.d_outputOccParamsFile.comp).setSelected(sp.get(SimParams.WRITE_OCCUPANT_PARAMS_FILE));
            ((guiMultiStateCheckBox)this.d_writeJsonFiles.comp).setSelected(sp.get(SimParams.WRITE_JSON_FILES));
            ((guiMultiStateCheckBox)this.d_socialDistanceEnable.comp).setSelected(sp.get(SimParams.WRITE_SOCIAL_DISTANCE));
            this.d_socialDistanceFld.setValue(sp.get(SimParams.SOCIAL_DISTANCE));
        }

        @Override
        public void store(SimParams sp) {
            sp.set(SimParams.DT_VIS, (UnitDouble)this.d_fldVisDT.getValue());
            sp.set(SimParams.DT_CSV, (UnitDouble)this.d_fldCSVDT.getValue());
            sp.set(SimParams.DT_STATUS, (UnitDouble)this.d_fldStatusDT.getValue());
            sp.set(SimParams.LOW_SPEED_THRESHOLD, (UnitDouble)this.d_fldSlowSpeed.getValue());
            sp.set(SimParams.LOW_SPEED_AVERAGING_TIME, (UnitDouble)this.d_fldSlowSpeedAveragingTime.getValue());
            sp.set(SimParams.OCC_CSV_FILE_MERGE, this.d_occCSVOptions.getSelectedItem());
            sp.set(SimParams.MEASUREMENT_REGION_SEEK_SPEED, ((guiMultiStateCheckBox)this.d_densityRegionSeekSpeed.comp).isSelected());
            sp.set(SimParams.WRITE_OCCUPANT_PARAMS_FILE, ((guiMultiStateCheckBox)this.d_outputOccParamsFile.comp).isSelected());
            sp.set(SimParams.WRITE_JSON_FILES, ((guiMultiStateCheckBox)this.d_writeJsonFiles.comp).isSelected());
            sp.set(SimParams.WRITE_SOCIAL_DISTANCE, ((guiMultiStateCheckBox)this.d_socialDistanceEnable.comp).isSelected());
            sp.set(SimParams.SOCIAL_DISTANCE, (UnitDouble)this.d_socialDistanceFld.getValue());
        }
    }

    private static class PathingEditor
    extends EditorPanel {
        private static final long serialVersionUID = 1L;
        private final ValueField<UnitDouble> d_dfMaxTrimError;
        private final guiRadioButton d_noRefinementRB;
        private final guiRadioButton d_edgeRefinementRB;
        private final guiRadioButton d_areaRefinementRB;
        private final ValueField<UnitDouble> d_dfMaxEdge;
        private final WrappedComp<guiLabel> d_labLMax;
        private final WrappedComp<guiLabel> d_labMinAngle;
        private final ValueField<UnitDouble> d_fldMinAngle;
        private final ValueField<UnitDouble> d_maxAreaFld;

        public PathingEditor(EditSimParamsDlg dlg) {
            ILabelGenerator labels = EditSimParamsDlg.getLabels(dlg);
            TitleSeparator labNavMeshRefinement = new TitleSeparator(labels.lbl(SimParams.NAVMESH_REFINEMENT));
            this.d_noRefinementRB = new guiRadioButton(Intl.intl("None"));
            this.d_noRefinementRB.setToolTipText(Intl.intl("Disables navigation mesh refinement"));
            this.d_edgeRefinementRB = new guiRadioButton(Intl.intl("Constrain edge length"));
            this.d_edgeRefinementRB.setToolTipText(Intl.intl("Refines triangles by limiting edge length and angle between edges."));
            this.d_areaRefinementRB = new guiRadioButton(Intl.intl("Constrain triangle area"));
            this.d_areaRefinementRB.setToolTipText(Intl.intl("Refines triangles by setting an upper limit on triangle area."));
            guiUtil.group(new AbstractButton[]{this.d_noRefinementRB, this.d_edgeRefinementRB, this.d_areaRefinementRB});
            this.d_dfMaxEdge = MerlinValueFields.udFld(2.5, DoubleVR.above(0.0, false), (Unit)SI.METER, 0);
            this.d_dfMaxEdge.setEnabled(false);
            this.d_labLMax = labels.lbl(SimParams.MAX_EDGE_LENGTH);
            this.d_labMinAngle = labels.lbl(SimParams.MIN_ANGLE);
            this.d_fldMinAngle = MerlinValueFields.udFld(0.0, DoubleVR.between(0.0, 45.0, true, true), NonSI.DEGREE_ANGLE, 7);
            WrappedComp<guiLabel> maxAreaLbl = labels.lbl(SimParams.MAX_TRIANGLE_AREA);
            this.d_maxAreaFld = MerlinValueFields.udFld(2.0, DoubleVR.above(0.0, false), SI.METER.pow(2), 4);
            WrappedComp<guiLabel> trimErrorLbl = labels.lbl(SimParams.MAX_TRIM_ERROR);
            this.d_dfMaxTrimError = MerlinValueFields.udFld(1.0, DoubleVR.above(0.0, true), NonSI.INCH, 6);
            LinkStatus.link2((AbstractButton)this.d_edgeRefinementRB, this.d_dfMaxEdge, this.d_labLMax, this.d_labMinAngle, this.d_fldMinAngle);
            LinkStatus.link2((AbstractButton)this.d_areaRefinementRB, maxAreaLbl, this.d_maxAreaFld);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(trimErrorLbl, this.d_dfMaxTrimError);
            gb.addFilledRow(labNavMeshRefinement);
            gb.indent();
            gb.addRow(this.d_noRefinementRB);
            gb.addRow(this.d_areaRefinementRB);
            gb.addIdentRow(maxAreaLbl, this.d_maxAreaFld);
            gb.addRow(this.d_edgeRefinementRB);
            gb.indent();
            gb.addRow(this.d_labLMax, this.d_dfMaxEdge);
            gb.addRow(this.d_labMinAngle, this.d_fldMinAngle);
            gb.unindent();
            gb.unindent();
            gb.finalizeRows();
        }

        @Override
        public void load(SimParams sp) {
            switch (sp.get(SimParams.NAVMESH_REFINEMENT)) {
                case EDGE_LENGTH: {
                    this.d_edgeRefinementRB.setSelected(true);
                    break;
                }
                case TRIANGLE_AREA: {
                    this.d_areaRefinementRB.setSelected(true);
                    break;
                }
                default: {
                    this.d_noRefinementRB.setSelected(true);
                }
            }
            this.d_dfMaxEdge.setValue(sp.get(SimParams.MAX_EDGE_LENGTH));
            this.d_fldMinAngle.setValue(sp.get(SimParams.MIN_ANGLE));
            this.d_maxAreaFld.setValue(sp.get(SimParams.MAX_TRIANGLE_AREA));
            this.d_dfMaxTrimError.setValue(sp.get(SimParams.MAX_TRIM_ERROR));
        }

        @Override
        public void store(SimParams sp) {
            SimParams.NavMeshRefinement refinement = this.d_edgeRefinementRB.isSelected() ? SimParams.NavMeshRefinement.EDGE_LENGTH : (this.d_areaRefinementRB.isSelected() ? SimParams.NavMeshRefinement.TRIANGLE_AREA : SimParams.NavMeshRefinement.NONE);
            sp.set(SimParams.NAVMESH_REFINEMENT, refinement);
            sp.set(SimParams.MAX_EDGE_LENGTH, (UnitDouble)this.d_dfMaxEdge.getValue());
            sp.set(SimParams.MIN_ANGLE, (UnitDouble)this.d_fldMinAngle.getValue());
            sp.set(SimParams.MAX_TRIANGLE_AREA, (UnitDouble)this.d_maxAreaFld.getValue());
            sp.set(SimParams.MAX_TRIM_ERROR, (UnitDouble)this.d_dfMaxTrimError.getValue());
        }
    }

    private static class BehaviorEditor
    extends EditorPanel {
        private static final long serialVersionUID = 1L;
        private final WrappedComp<guiMultiStateCheckBox> d_ckCollideSteering;
        private final WrappedComp<guiMultiStateCheckBox> d_ckForcedSeparation;
        private final WrappedComp<guiMultiStateCheckBox> d_ckLimitFlowrateSteering;
        private final ValueField<UnitDouble> d_fldSteerUpdate;
        private final ValueField<UnitDouble> d_fldDoorBndLayerSteering;
        private final ValueField<UnitDouble> d_fldSpFlowSteering;
        private final ValueField<Double> d_fldMinFlowrateFactorSteering;
        private final ValueField<UnitDouble> d_fldDMax;
        private final ValueField<UnitDouble> d_fldDoorBndLayerSFPE;
        private final ValueField<Double> d_fldMinVelSFPE;
        private final guiRadioButton d_rbUseProfileFundamental;
        private final guiRadioButton d_rbUseSFPEFundamental;
        private final guiRadioButton d_rbUseMaxFlow;
        private final guiRadioButton d_rbFlowFromDensity;
        private final String[] OPTS = new String[]{Intl.intl("Steering"), Intl.intl("SFPE")};
        private final int REACTIVE_OPT = 0;
        private final int SFPE_OPT = 1;
        private guiComboBox<?> d_behaviorBox;

        public BehaviorEditor(EditSimParamsDlg dlg) {
            ILabelGenerator labels = EditSimParamsDlg.getLabels(dlg);
            WrappedComp<guiLabel> labBehaviorBox = labels.lbl(SimParams.REACTIVE_STEERING);
            this.d_behaviorBox = new guiComboBox<Object>((T[])this.OPTS);
            Unit siInvOccDensityu = SIUS.unit(3);
            Unit siShortLen = SIUS.unit(6);
            guiPanel reactivePanel = new guiPanel(new MigLayout("insets 0, gap 6"));
            this.d_ckCollideSteering = labels.checkbox(SimParams.HANDLE_COLLISIONS, false);
            this.d_ckForcedSeparation = labels.checkbox(SimParams.FORCE_SEPARATION, false);
            WrappedComp<guiLabel> labSteerUpdate = labels.lbl(SimParams.DT_STEER_UPDATE);
            this.d_fldSteerUpdate = ValueFields.udFld(0.1, DoubleVR.above(0.0, true), SI.SECOND);
            this.d_ckLimitFlowrateSteering = labels.checkbox(SimParams.USE_DOOR_QUEUES, false);
            WrappedComp<guiLabel> steering_doorBndLayerSteeringLbl = labels.lbl(SimParams.DOOR_BOUNDARY_LAYER);
            this.d_fldDoorBndLayerSteering = MerlinValueFields.udFld(0.0, DoubleVR.above(0.0, true), siShortLen, 6);
            WrappedComp<guiLabel> defMaxFlowrateLbl = labels.lbl(SimParams.SPECIFIC_FLOW_STEERING);
            this.d_fldSpFlowSteering = MerlinValueFields.udFld(0.0, DoubleVR.above(0.0, false), SIUS.unit(12), 12);
            LinkStatus.link((AbstractButton)this.d_ckLimitFlowrateSteering.comp, steering_doorBndLayerSteeringLbl, this.d_fldDoorBndLayerSteering, defMaxFlowrateLbl, this.d_fldSpFlowSteering);
            this.d_fldMinFlowrateFactorSteering = ValueFields.doubleFld(0.1, DoubleVR.between(0.0, 1.0, true, true));
            WrappedComp<guiLabel> minFlowLbl = labels.lbl(SimParams.MIN_FLOWRATE_FACTOR);
            reactivePanel.add(labSteerUpdate, "grow");
            reactivePanel.add(this.d_fldSteerUpdate, "wrap");
            reactivePanel.add(minFlowLbl, "grow");
            reactivePanel.add(this.d_fldMinFlowrateFactorSteering, "wrap");
            reactivePanel.add(this.d_ckCollideSteering, "grow, span, wrap");
            reactivePanel.add(this.d_ckForcedSeparation, "grow, span, wrap");
            reactivePanel.add(this.d_ckLimitFlowrateSteering, "grow, span, wrap");
            reactivePanel.add(steering_doorBndLayerSteeringLbl, "grow, gapleft 18");
            reactivePanel.add(this.d_fldDoorBndLayerSteering, "wrap");
            reactivePanel.add(defMaxFlowrateLbl, "grow, gapleft 18");
            reactivePanel.add(this.d_fldSpFlowSteering, "wrap");
            guiPanel sfpePanel = new guiPanel(new GridBagLayout());
            WrappedComp<guiLabel> dmaxLbl = labels.lbl(SimParams.DENSITY_MAX);
            this.d_fldDMax = MerlinValueFields.udFld(1.0, DoubleVR.above(0.0, false), siInvOccDensityu, 3);
            WrappedComp<guiLabel> sfpe_doorBndLayerSteeringLbl = labels.lbl(SimParams.DOOR_BOUNDARY_LAYER);
            this.d_fldDoorBndLayerSFPE = MerlinValueFields.udFld(0.0, DoubleVR.above(0.0, true), siShortLen, 6);
            WrappedComp<guiLabel> labHighDensityFlow = labels.lbl(SimParams.DOOR_FLOW_DENSITY_FLAG);
            this.d_rbUseMaxFlow = new guiRadioButton(Intl.intl("Always Use Max Specific Flow"));
            this.d_rbUseMaxFlow.setToolTipText(Intl.intl("Uses Fs=(1-aD)kD with D always set to 1.88 pers/m^2."));
            this.d_rbFlowFromDensity = new guiRadioButton(Intl.intl("Use a Calculated Specific Flow"));
            this.d_rbFlowFromDensity.setToolTipText(Intl.intl("Uses Fs=(1-aD)kD when D is greater than 1.88 pers/m^2."));
            new guiButtonGroup(this.d_rbFlowFromDensity, this.d_rbUseMaxFlow);
            WrappedComp<guiLabel> minVelSFPELbl = labels.lbl(SimParams.MIN_SFPE_VELOCITY_FRACTION);
            this.d_fldMinVelSFPE = ValueFields.doubleFld(0.15, DoubleVR.between(0.0, 1.0, true, true));
            this.d_rbUseSFPEFundamental = new guiRadioButton(Intl.intl("Use SFPE"));
            this.d_rbUseSFPEFundamental.setToolTipText("<html>" + Intl.intl("Uses the SFPE speed-density relationship."));
            this.d_rbUseProfileFundamental = new guiRadioButton(Intl.intl("Use Value Specified in Occupant Profile"));
            this.d_rbUseProfileFundamental.setToolTipText("<html>" + Intl.intl("Uses the speed-density relationship set in the occupants' profiles."));
            LinkStatus.link((AbstractButton)this.d_rbUseSFPEFundamental, minVelSFPELbl, this.d_fldMinVelSFPE);
            guiUtil.group(new AbstractButton[]{this.d_rbUseSFPEFundamental, this.d_rbUseProfileFundamental});
            TitleSeparator fundamentalLbl = new TitleSeparator(Intl.intl("Speed-Density Profile"));
            fundamentalLbl.setToolTipText(Intl.intl("Controls density/speed relationship"));
            GridBagHelper gb = new GridBagHelper(sfpePanel);
            gb.addRow(dmaxLbl, this.d_fldDMax, 0);
            gb.addRow(minVelSFPELbl, this.d_fldMinVelSFPE, 0);
            gb.addFilledRow(new TitleSeparator(Intl.intl("Door Flow Rate")));
            gb.indent();
            gb.addRow(sfpe_doorBndLayerSteeringLbl, this.d_fldDoorBndLayerSFPE, 0);
            gb.addRow(labHighDensityFlow, 0);
            gb.indent();
            gb.addRow(this.d_rbFlowFromDensity, 0);
            gb.addRow(this.d_rbUseMaxFlow, 0);
            gb.unindent();
            gb.unindent();
            gb.finalizeRows();
            final CardLayout cardLayout = new CardLayout();
            final guiPanel cardPanel = new guiPanel(cardLayout);
            cardPanel.add((Component)reactivePanel, this.OPTS[0]);
            cardPanel.add((Component)sfpePanel, this.OPTS[1]);
            this.setLayout(new GridBagLayout());
            gb = new GridBagHelper(this);
            gb.addBorder();
            gb.addRow(labBehaviorBox, this.d_behaviorBox, 0);
            gb.addFilledRow(new guiSeparator());
            gb.addFilledRow(cardPanel);
            gb.finalizeRows();
            this.d_behaviorBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String selItem = (String)d_behaviorBox.getSelectedItem();
                    cardLayout.show(cardPanel, selItem);
                }
            });
            this.d_behaviorBox.setSelectedItem(this.OPTS[0]);
        }

        @Override
        public void load(SimParams sp) {
            if (sp.get(SimParams.REACTIVE_STEERING).booleanValue()) {
                this.d_behaviorBox.setSelectedItem(this.OPTS[0]);
                ((guiMultiStateCheckBox)this.d_ckCollideSteering.comp).setSelected(sp.get(SimParams.HANDLE_COLLISIONS));
                ((guiMultiStateCheckBox)this.d_ckForcedSeparation.comp).setSelected(sp.get(SimParams.FORCE_SEPARATION));
                ((guiMultiStateCheckBox)this.d_ckLimitFlowrateSteering.comp).setSelected(sp.get(SimParams.USE_DOOR_QUEUES));
                this.d_rbFlowFromDensity.setSelected(true);
                this.d_rbUseSFPEFundamental.setSelected(true);
                this.d_fldMinVelSFPE.setValue(0.15);
            } else {
                this.d_behaviorBox.setSelectedItem(this.OPTS[1]);
                ((guiMultiStateCheckBox)this.d_ckCollideSteering.comp).setSelected(true);
                ((guiMultiStateCheckBox)this.d_ckForcedSeparation.comp).setSelected(false);
                ((guiMultiStateCheckBox)this.d_ckLimitFlowrateSteering.comp).setSelected(false);
                this.d_rbFlowFromDensity.setSelected(sp.get(SimParams.DOOR_FLOW_DENSITY_FLAG));
                this.d_rbUseMaxFlow.setSelected(sp.get(SimParams.DOOR_FLOW_DENSITY_FLAG) == false);
                this.d_rbUseSFPEFundamental.setSelected(sp.get(SimParams.USE_PROFILE_FUNDAMENTAL) == false);
                this.d_rbUseProfileFundamental.setSelected(sp.get(SimParams.USE_PROFILE_FUNDAMENTAL));
                this.d_fldMinVelSFPE.setValue(sp.get(SimParams.MIN_SFPE_VELOCITY_FRACTION));
            }
            this.d_fldSpFlowSteering.setValue(sp.get(SimParams.SPECIFIC_FLOW_STEERING));
            this.d_fldMinFlowrateFactorSteering.setValue(sp.get(SimParams.MIN_FLOWRATE_FACTOR));
            this.d_fldDoorBndLayerSteering.setValue(sp.get(SimParams.DOOR_BOUNDARY_LAYER));
            this.d_fldDoorBndLayerSFPE.setValue(sp.get(SimParams.DOOR_BOUNDARY_LAYER));
            this.d_fldSteerUpdate.setValue(sp.get(SimParams.DT_STEER_UPDATE));
            this.d_fldDMax.setValue(sp.get(SimParams.DENSITY_MAX));
        }

        @Override
        public void store(SimParams sp) {
            if (this.d_behaviorBox.getSelectedItem() == this.OPTS[0]) {
                sp.set(SimParams.REACTIVE_STEERING, true);
                sp.set(SimParams.DOOR_FLOW_DENSITY_FLAG, false);
                sp.set(SimParams.DT_STEER_UPDATE, (UnitDouble)this.d_fldSteerUpdate.getValue());
                sp.set(SimParams.HANDLE_COLLISIONS, ((guiMultiStateCheckBox)this.d_ckCollideSteering.comp).isSelected());
                sp.set(SimParams.FORCE_SEPARATION, ((guiMultiStateCheckBox)this.d_ckForcedSeparation.comp).isSelected());
                sp.set(SimParams.USE_DOOR_QUEUES, ((guiMultiStateCheckBox)this.d_ckLimitFlowrateSteering.comp).isSelected());
                sp.set(SimParams.DOOR_BOUNDARY_LAYER, (UnitDouble)this.d_fldDoorBndLayerSteering.getValue());
                sp.set(SimParams.SPECIFIC_FLOW_STEERING, (UnitDouble)this.d_fldSpFlowSteering.getValue());
                sp.set(SimParams.MIN_FLOWRATE_FACTOR, (Double)this.d_fldMinFlowrateFactorSteering.getValue());
            } else if (this.d_behaviorBox.getSelectedItem() == this.OPTS[1]) {
                sp.set(SimParams.REACTIVE_STEERING, false);
                sp.set(SimParams.USE_DOOR_QUEUES, true);
                sp.set(SimParams.HANDLE_COLLISIONS, false);
                sp.set(SimParams.DENSITY_MAX, (UnitDouble)this.d_fldDMax.getValue());
                sp.set(SimParams.DOOR_BOUNDARY_LAYER, (UnitDouble)this.d_fldDoorBndLayerSFPE.getValue());
                sp.set(SimParams.DOOR_FLOW_DENSITY_FLAG, this.d_rbFlowFromDensity.isSelected());
                sp.set(SimParams.USE_PROFILE_FUNDAMENTAL, this.d_rbUseProfileFundamental.isSelected());
                sp.set(SimParams.MIN_SFPE_VELOCITY_FRACTION, (Double)this.d_fldMinVelSFPE.getValue());
            }
        }
    }

    private static class FdsOutputLinkageEditor
    extends EditorPanel {
        private static final long serialVersionUID = 1L;
        private WrappedComp<guiMultiStateCheckBox> d_enableSmvData;
        private JButton d_smvFileEdit;
        private guiTextField d_smvFileField;
        private guiLabel d_dataSourceMsg;
        private guiLabel d_dataFreqMsg;
        private guiLabel d_dataTempMsg;
        private guiLabel d_dataCoMsg;
        private guiLabel d_dataCo2Msg;
        private guiLabel d_dataO2Msg;
        private guiLabel d_dataSootVisMsg;
        private guiLabel d_dataFedMsg;
        private final ValueField<UnitDouble> d_o2HypoxiaThreshold;
        private static final int STATUS_HAPPY = 0;
        private static final int STATUS_SAD = 1;
        private static final Color PATHFINDERGREEN = new Color(0, 96, 0);
        private static final Color DISABLEDGRAY = new Color(109, 109, 109);

        public FdsOutputLinkageEditor(EditSimParamsDlg dlg) {
            ILabelGenerator labels = EditSimParamsDlg.getLabels(dlg);
            this.setLayout(new MigLayout("insets 12, gap 6"));
            this.d_o2HypoxiaThreshold = MerlinValueFields.udFld(DoubleVR.between(0.0, 100.0, true, true), NonSI.PERCENT, 10);
            WrappedComp<guiLabel> hypoxiaLbl = labels.lbl(SimParams.HYPOXIA_LIMIT);
            this.d_enableSmvData = labels.checkbox(SimParams.SMV_DATA_ENABLE, false);
            this.add(this.d_enableSmvData, "span, wrap");
            WrappedComp<guiLabel> smvFileLabel = labels.lbl(SimParams.SMV_DATA_FILE_NAME);
            this.d_smvFileField = new guiTextField();
            this.d_smvFileField.setPreferredSize(new Dimension(200, this.d_smvFileField.getPreferredSize().height));
            this.d_smvFileField.setEditable(false);
            this.d_smvFileEdit = new JButton(Intl.intl("Edit..."));
            Dimension d = this.d_smvFileEdit.getPreferredSize();
            this.d_smvFileEdit.setPreferredSize(new Dimension(d.width, this.d_smvFileField.getPreferredSize().height + 2));
            MultiLineLabel warningLbl = new MultiLineLabel(Intl.intl("NOTE: FED calculation will pause for occupants outside of FDS meshes or whose sample points are in an obstructed cell."));
            warningLbl.setFont(warningLbl.getFont().deriveFont(1));
            this.add(smvFileLabel, "grow");
            this.add((Component)this.d_smvFileField, "grow");
            this.add((Component)this.d_smvFileEdit, "wrap");
            this.add((Component)new guiSeparator(), "span, grow, wrap");
            guiLabel dataSource = new guiLabel(Intl.intl("Data Source:"));
            this.d_dataSourceMsg = new guiLabel();
            this.add((Component)dataSource, "grow");
            this.add((Component)this.d_dataSourceMsg, "grow, wrap");
            guiLabel dataFreq = new guiLabel(Intl.intl("Data Interval:"));
            this.d_dataFreqMsg = new guiLabel();
            this.add((Component)dataFreq, "grow");
            this.add((Component)this.d_dataFreqMsg, "grow, wrap");
            guiLabel dataT = new guiLabel(Intl.intl("Temperature:"));
            this.d_dataTempMsg = new guiLabel();
            this.add((Component)dataT, "grow");
            this.add((Component)this.d_dataTempMsg, "grow, wrap");
            guiLabel dataCO = new guiLabel(Intl.intl("CO Volume Fraction:"));
            this.d_dataCoMsg = new guiLabel();
            this.add((Component)dataCO, "grow");
            this.add((Component)this.d_dataCoMsg, "grow, wrap");
            guiLabel dataCO2 = new guiLabel(Intl.intl("CO2 Volume Fraction:"));
            this.d_dataCo2Msg = new guiLabel();
            this.add((Component)dataCO2, "grow");
            this.add((Component)this.d_dataCo2Msg, "grow, wrap");
            guiLabel dataO2 = new guiLabel(Intl.intl("O2 Volume Fraction:"));
            this.d_dataO2Msg = new guiLabel();
            this.add((Component)dataO2, "grow");
            this.add((Component)this.d_dataO2Msg, "grow, wrap");
            guiLabel dataSootVis = new guiLabel(Intl.intl("SOOT Visibility:"));
            this.d_dataSootVisMsg = new guiLabel();
            this.add((Component)dataSootVis, "grow");
            this.add((Component)this.d_dataSootVisMsg, "grow, wrap");
            guiLabel dataFed = new guiLabel(Intl.intl("FED Output:"));
            this.d_dataFedMsg = new guiLabel();
            this.add((Component)dataFed, "grow");
            this.add((Component)this.d_dataFedMsg, "grow, wrap");
            this.add((Component)warningLbl, "span, grow, wrap");
            this.add((Component)new guiSeparator(), "span, grow, wrap");
            this.add(hypoxiaLbl, "grow");
            this.add(this.d_o2HypoxiaThreshold, "wrap");
            LinkStatus.link((AbstractButton)this.d_enableSmvData.comp, smvFileLabel, this.d_smvFileField, this.d_smvFileEdit, hypoxiaLbl, this.d_o2HypoxiaThreshold, dataSource, this.d_dataSourceMsg, dataFreq, this.d_dataFreqMsg, dataT, this.d_dataTempMsg, dataCO, this.d_dataCoMsg, dataCO2, this.d_dataCo2Msg, dataO2, this.d_dataO2Msg, dataSootVis, this.d_dataSootVisMsg, dataFed, this.d_dataFedMsg, warningLbl);
            this.updateStatusMsg(1, Intl.intl("Not Found"), this.d_dataSourceMsg, this.d_dataFreqMsg, this.d_dataTempMsg, this.d_dataCoMsg, this.d_dataCo2Msg, this.d_dataO2Msg, this.d_dataSootVisMsg, this.d_dataFedMsg);
            this.d_smvFileEdit.addActionListener(evt -> this.doClickEditButton());
            ((guiMultiStateCheckBox)this.d_enableSmvData.comp).addItemListener(e -> {
                String fn = this.d_smvFileField.getValue();
                if (e.getStateChange() == 1 && fn != null && fn.length() > 0) {
                    new Thread(new UpdateLoader(true, fn)).start();
                }
            });
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            String msg;
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (!((guiMultiStateCheckBox)this.d_enableSmvData.comp).isSelected()) {
                return true;
            }
            List<SmvParseUtil.ISmvSectionData> data = Collections.emptyList();
            boolean validXYZ = false;
            boolean validPl3D = false;
            boolean containsXYZ = false;
            try {
                data = SmvParseUtil.parseSmv(this.d_smvFileField.getValue(), SmvParseUtil.SmvSectionType.PL3D, SmvParseUtil.SmvSectionType.XYZ);
                containsXYZ = SmvParseUtil.checkHasXYZ(data);
                File smvParentFolder = new File(this.d_smvFileField.getValue()).getParentFile();
                validXYZ = SmvParseUtil.testValidityForResultType(smvParentFolder, data, SmvParseUtil.XYZSectionData.class);
                validPl3D = SmvParseUtil.testValidityForResultType(smvParentFolder, data, SmvParseUtil.Pl3dSectionData.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (showWarn) {
                    String msg2 = Intl.intl("FDS integration is enabled, but FDS output data not found:\n" + this.d_smvFileField.getValue() + "\n\nDisable FDS integration to continue.");
                    guiDialog.showInvalidEntryMessage(this, msg2);
                }
                return false;
            }
            if (!containsXYZ) {
                if (showWarn) {
                    msg = Intl.intl("FDS integration is enabled, but FDS output does not contain XYZ data.\nPlease verify FDS parameter WRITE_XYZ=.TRUE.\n\nDisable FDS integration to continue.");
                    guiDialog.showInvalidEntryMessage(this, msg);
                }
                return false;
            }
            if (!validPl3D || !validXYZ) {
                if (showWarn) {
                    msg = Intl.intl("FDS integration in enabled, but some FDS results files cannot be accessed.\nPlease confirm that all Q and XYZ files are available in the results directory.");
                    guiDialog.showInvalidEntryMessage(this, msg);
                }
                return false;
            }
            return true;
        }

        private void updateStatusMsg(int style, String msg, guiLabel ... comps) {
            for (guiLabel comp : comps) {
                comp.setText(msg);
                comp.setFont(comp.getFont().deriveFont(1));
                comp.setEnabled(style == 0);
                if (style == 0) {
                    comp.setForeground(PATHFINDERGREEN);
                    continue;
                }
                if (style == 1) {
                    comp.setForeground(DISABLEDGRAY);
                    continue;
                }
                assert (false) : "Unknown status!";
            }
        }

        private void doClickEditButton() {
            String prevValue = this.d_smvFileField.getValue();
            System.out.println(prevValue);
            guiJFXFileChooser chooser = new guiJFXFileChooser(null, prevValue == null || prevValue.isBlank() || prevValue.isEmpty() ? MerlinPrefs.get(MerlinPrefs.OPEN_DIR_PREF) : prevValue, null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_SMOKEVIEW);
            File f = chooser.showOpenDialog();
            if (f == null) {
                return;
            }
            MerlinPrefs.set(MerlinPrefs.OPEN_DIR_PREF, f.getParent());
            this.updateStatusMsg(1, Intl.intl("Detecting..."), this.d_dataSourceMsg, this.d_dataFreqMsg, this.d_dataTempMsg, this.d_dataCoMsg, this.d_dataCo2Msg, this.d_dataO2Msg, this.d_dataSootVisMsg, this.d_dataFedMsg);
            Path selectedFile = MerlinUtil.relativizeFile(f.toPath());
            new Thread(new UpdateLoader(true, selectedFile.toString())).start();
        }

        @Override
        public void load(SimParams sp) {
            ((guiMultiStateCheckBox)this.d_enableSmvData.comp).setSelected(sp.get(SimParams.SMV_DATA_ENABLE));
            if (sp.get(SimParams.SMV_DATA_ENABLE).booleanValue() && sp.get(SimParams.SMV_DATA_FILE_NAME) != null) {
                this.d_smvFileField.setValue(sp.get(SimParams.SMV_DATA_FILE_NAME));
                this.d_smvFileField.setToolTipText(sp.get(SimParams.SMV_DATA_FILE_NAME));
                this.updateStatusMsg(1, Intl.intl("Detecting..."), this.d_dataSourceMsg, this.d_dataFreqMsg, this.d_dataTempMsg, this.d_dataCoMsg, this.d_dataCo2Msg, this.d_dataO2Msg, this.d_dataSootVisMsg, this.d_dataFedMsg);
                new Thread(new UpdateLoader(false, sp.get(SimParams.SMV_DATA_FILE_NAME))).start();
            }
            this.d_o2HypoxiaThreshold.setValue(sp.get(SimParams.HYPOXIA_LIMIT));
        }

        @Override
        public void store(SimParams sp) {
            sp.set(SimParams.SMV_DATA_ENABLE, ((guiMultiStateCheckBox)this.d_enableSmvData.comp).isSelected());
            sp.set(SimParams.SMV_DATA_FILE_NAME, MerlinUtil.relativizeFile(this.d_smvFileField.getValue()).toString());
            sp.set(SimParams.HYPOXIA_LIMIT, (UnitDouble)this.d_o2HypoxiaThreshold.getValue());
        }

        private class UpdateLoader
        implements Runnable {
            public boolean d_promptOnFail;
            private String d_smvFile;

            public UpdateLoader(boolean flag, String smvFile) {
                this.d_promptOnFail = flag;
                this.d_smvFile = smvFile;
            }

            @Override
            public void run() {
                File smvFile = new File(this.d_smvFile);
                if (!smvFile.isAbsolute()) {
                    smvFile = MerlinUtil.resolveFile(smvFile.toPath()).toFile();
                }
                FdsOutputLinkageEditor.this.d_smvFileField.setText(smvFile.getPath());
                FdsOutputLinkageEditor.this.d_smvFileField.setToolTipText(smvFile.getPath());
                try {
                    EventQueue.invokeLater(new UpdateSmvLoaded(smvFile.getParentFile(), SmvParseUtil.parseSmv(smvFile.getAbsolutePath(), SmvParseUtil.SmvSectionType.XYZ, SmvParseUtil.SmvSectionType.PL3D)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    EventQueue.invokeLater(new UpdateResultError(this.d_promptOnFail));
                }
                finally {
                    FdsOutputLinkageEditor.this.setModified(true);
                }
            }
        }

        private class UpdateSmvLoaded
        implements Runnable {
            private final Collection<SmvParseUtil.ISmvSectionData> d_sections;
            private final File d_smvDir;

            public UpdateSmvLoaded(File smvParent, Collection<SmvParseUtil.ISmvSectionData> sections) {
                this.d_smvDir = smvParent;
                this.d_sections = sections;
            }

            @Override
            public void run() {
                boolean validXYZ = SmvParseUtil.testValidityForResultType(this.d_smvDir, this.d_sections, SmvParseUtil.XYZSectionData.class);
                boolean validPl3D = SmvParseUtil.testValidityForResultType(this.d_smvDir, this.d_sections, SmvParseUtil.Pl3dSectionData.class);
                if (validXYZ && validPl3D) {
                    FdsOutputLinkageEditor.this.updateStatusMsg(0, "PLOT3D", FdsOutputLinkageEditor.this.d_dataSourceMsg);
                } else if (!validXYZ) {
                    FdsOutputLinkageEditor.this.updateStatusMsg(1, Intl.intl("PLOT3D: XYZ Data Missing"), FdsOutputLinkageEditor.this.d_dataSourceMsg);
                } else if (!validPl3D) {
                    FdsOutputLinkageEditor.this.updateStatusMsg(1, Intl.intl("PLOT3D: PL3D Data Missing"), FdsOutputLinkageEditor.this.d_dataSourceMsg);
                }
                Set<Float> times = SmvParseUtil.getPl3dTimes(this.d_sections);
                if (times.size() > 1) {
                    String sdt = String.format("%.2f", EditSimParamsDlg.getAverageInterval(times));
                    FdsOutputLinkageEditor.this.updateStatusMsg(0, String.format(Intl.intl("%s s"), sdt), FdsOutputLinkageEditor.this.d_dataFreqMsg);
                } else {
                    FdsOutputLinkageEditor.this.updateStatusMsg(1, Intl.intl("Insufficient Data"), FdsOutputLinkageEditor.this.d_dataFreqMsg);
                }
                List<String[]> quantities = SmvParseUtil.getQuantities(this.d_sections);
                this.updateFoundMsg(EditSimParamsDlg.containsQuantities(quantities, "TEMPERATURE"), FdsOutputLinkageEditor.this.d_dataTempMsg);
                this.updateFoundMsg(EditSimParamsDlg.containsQuantities(quantities, "CARBON DIOXIDE VOLUME FRACTION"), FdsOutputLinkageEditor.this.d_dataCo2Msg);
                this.updateFoundMsg(EditSimParamsDlg.containsQuantities(quantities, "CARBON MONOXIDE VOLUME FRACTION"), FdsOutputLinkageEditor.this.d_dataCoMsg);
                this.updateFoundMsg(EditSimParamsDlg.containsQuantities(quantities, "OXYGEN VOLUME FRACTION"), FdsOutputLinkageEditor.this.d_dataO2Msg);
                this.updateFoundMsg(EditSimParamsDlg.containsQuantities(quantities, "SOOT VISIBILITY"), FdsOutputLinkageEditor.this.d_dataSootVisMsg);
                String[] fedQuants = new String[]{"CARBON DIOXIDE VOLUME FRACTION", "OXYGEN VOLUME FRACTION", "CARBON MONOXIDE VOLUME FRACTION"};
                if (EditSimParamsDlg.containsQuantities(quantities, fedQuants)) {
                    FdsOutputLinkageEditor.this.updateStatusMsg(0, Intl.intl("Enabled"), FdsOutputLinkageEditor.this.d_dataFedMsg);
                } else {
                    FdsOutputLinkageEditor.this.updateStatusMsg(1, Intl.intl("Disabled. Requires CO, CO2, and O2."), FdsOutputLinkageEditor.this.d_dataFedMsg);
                }
            }

            private void updateFoundMsg(boolean flag, guiLabel comp) {
                if (flag) {
                    FdsOutputLinkageEditor.this.updateStatusMsg(0, Intl.intl("Enabled"), comp);
                } else {
                    FdsOutputLinkageEditor.this.updateStatusMsg(1, Intl.intl("Not Found"), comp);
                }
            }
        }

        private class UpdateResultError
        implements Runnable {
            public boolean d_promptOnFail;

            public UpdateResultError(boolean flag) {
                this.d_promptOnFail = flag;
            }

            @Override
            public void run() {
                if (this.d_promptOnFail) {
                    JOptionPane.showMessageDialog(FdsOutputLinkageEditor.this, Intl.intl("Error loading SMV file."));
                }
                FdsOutputLinkageEditor.this.updateStatusMsg(1, Intl.intl("Error"), FdsOutputLinkageEditor.this.d_dataSourceMsg);
                FdsOutputLinkageEditor.this.updateStatusMsg(1, Intl.intl("Not Found"), FdsOutputLinkageEditor.this.d_dataFreqMsg, FdsOutputLinkageEditor.this.d_dataTempMsg, FdsOutputLinkageEditor.this.d_dataCoMsg, FdsOutputLinkageEditor.this.d_dataCo2Msg, FdsOutputLinkageEditor.this.d_dataO2Msg, FdsOutputLinkageEditor.this.d_dataSootVisMsg, FdsOutputLinkageEditor.this.d_dataFedMsg);
            }
        }
    }

    private static class MiscEditor
    extends EditorPanel {
        private static final long serialVersionUID = 1L;
        private final WrappedComp<guiMultiStateCheckBox> d_ckShowVis;
        private final WrappedComp<guiMultiStateCheckBox> d_autoSnapshots;
        private final ValueField<UnitDouble> d_ssInterval;
        private final ValueField<Double> d_extractEdgeError;
        private final ValueField<Double> d_extractFaceError;
        private final WrappedComp<guiMultiStateCheckBox> d_enableVehicleLateralMovement;
        private final ValueField<UnitDouble> d_attrDefIdleTime;
        private final ValueField<UnitDouble> d_occTargetResolveTime;
        private final ValueField<UnitDouble> d_gotoOccSearchDt;

        public MiscEditor(EditSimParamsDlg dlg) {
            ILabelGenerator labels = EditSimParamsDlg.getLabels(dlg);
            this.d_ckShowVis = labels.checkbox(SimParams.SHOW_RUNTIME_VIS, false);
            this.d_autoSnapshots = EditSimParamsDlg.getLabels(dlg).checkbox(SimParams.DT_SNAPSHOT, Intl.intl("Save Restart Files"), "");
            this.d_ssInterval = ValueFields.udFld(DoubleVR.above(0.0, false), (Unit)SI.SECOND);
            WrappedComp<guiLabel> ssIntervalLbl = labels.lbl(SimParams.DT_SNAPSHOT);
            LinkStatus.link((AbstractButton)this.d_autoSnapshots.comp, ssIntervalLbl, this.d_ssInterval);
            WrappedComp<guiLabel> curveLbl = labels.lbl(SimParams.EDGE_ERROR);
            this.d_extractEdgeError = ValueFields.doubleFld(DoubleVR.above(0.0, false));
            WrappedComp<guiLabel> faceLbl = labels.lbl(SimParams.FACE_ERROR);
            this.d_extractFaceError = ValueFields.doubleFld(DoubleVR.above(0.0, false));
            WrappedComp<guiLabel> labAttrDefIdleTime = labels.lbl(SimParams.ATTRACTOR_DEFAULT_IDLE_TIME);
            this.d_attrDefIdleTime = ValueFields.udFld(DoubleVR.above(0.0, true), (Unit)SI.SECOND);
            WrappedComp<guiLabel> labGotoOccSearchDt = labels.lbl(SimParams.OCC_TARGET_CONFLICT_RESOLVE_TIME);
            this.d_occTargetResolveTime = ValueFields.udFld(DoubleVR.above(0.0, true), (Unit)SI.SECOND);
            WrappedComp<guiLabel> labGotoOccSearchDT = labels.lbl(SimParams.DYNAMIC_TARGET_SEARCH_DT);
            this.d_gotoOccSearchDt = ValueFields.udFld(DoubleVR.above(0.0, true), (Unit)SI.SECOND);
            this.d_enableVehicleLateralMovement = labels.checkbox(SimParams.ENABLE_VEHICLE_LATERAL_MOVEMENT_VIS, false);
            GridBagHelper gb = new GridBagHelper(this, true);
            if (MerlinApp.isDev()) {
                gb.addRow(this.d_ckShowVis, 0);
            }
            gb.addRow(this.d_autoSnapshots, 0);
            gb.addIdentRow(ssIntervalLbl, this.d_ssInterval, 0);
            gb.addTitle(Intl.intl("Generating Model Elements"));
            gb.indent();
            gb.addRow(curveLbl, this.d_extractEdgeError, 0);
            gb.addRow(faceLbl, this.d_extractFaceError, 0);
            gb.unindent();
            gb.addTitle(Intl.intl("Behavior"));
            gb.addIdentRow(labAttrDefIdleTime, this.d_attrDefIdleTime, 0);
            gb.addIdentRow(labGotoOccSearchDt, this.d_occTargetResolveTime, 0);
            gb.addIdentRow(labGotoOccSearchDT, this.d_gotoOccSearchDt, 0);
            gb.addTitle(Intl.intl("Experimental"));
            gb.indent();
            gb.addRow(this.d_enableVehicleLateralMovement, 0);
            gb.unindent();
            gb.finalizeRows();
            GridBagUtil.addGlue(this);
        }

        @Override
        public void load(SimParams sp) {
            ((guiMultiStateCheckBox)this.d_ckShowVis.comp).setSelected(sp.get(SimParams.SHOW_RUNTIME_VIS));
            UnitDouble ssint = sp.get(SimParams.DT_SNAPSHOT);
            if (ssint.getValueNoUnit() > 0.0) {
                ((guiMultiStateCheckBox)this.d_autoSnapshots.comp).setSelected(true);
                this.d_ssInterval.setValue(ssint);
            } else {
                ((guiMultiStateCheckBox)this.d_autoSnapshots.comp).setSelected(false);
                this.d_ssInterval.setValue(new UnitDouble(60.0, SI.SECOND));
            }
            this.d_extractEdgeError.setValue(sp.get(SimParams.EDGE_ERROR));
            this.d_extractFaceError.setValue(sp.get(SimParams.FACE_ERROR));
            ((guiMultiStateCheckBox)this.d_enableVehicleLateralMovement.comp).setSelected(sp.get(SimParams.ENABLE_VEHICLE_LATERAL_MOVEMENT_VIS));
            this.d_attrDefIdleTime.setValue(sp.get(SimParams.ATTRACTOR_DEFAULT_IDLE_TIME));
            this.d_occTargetResolveTime.setValue(sp.get(SimParams.OCC_TARGET_CONFLICT_RESOLVE_TIME));
            this.d_gotoOccSearchDt.setValue(sp.get(SimParams.DYNAMIC_TARGET_SEARCH_DT));
        }

        @Override
        public void store(SimParams sp) {
            sp.set(SimParams.SHOW_RUNTIME_VIS, ((guiMultiStateCheckBox)this.d_ckShowVis.comp).isSelected());
            sp.set(SimParams.DT_SNAPSHOT, ((guiMultiStateCheckBox)this.d_autoSnapshots.comp).isSelected() ? (UnitDouble)this.d_ssInterval.getValue() : new UnitDouble(0.0, SI.SECOND));
            sp.set(SimParams.EDGE_ERROR, (Double)this.d_extractEdgeError.getValue());
            sp.set(SimParams.FACE_ERROR, (Double)this.d_extractFaceError.getValue());
            sp.set(SimParams.ENABLE_VEHICLE_LATERAL_MOVEMENT_VIS, ((guiMultiStateCheckBox)this.d_enableVehicleLateralMovement.comp).isSelected());
            sp.set(SimParams.ATTRACTOR_DEFAULT_IDLE_TIME, (UnitDouble)this.d_attrDefIdleTime.getValue());
            sp.set(SimParams.OCC_TARGET_CONFLICT_RESOLVE_TIME, (UnitDouble)this.d_occTargetResolveTime.getValue());
            sp.set(SimParams.DYNAMIC_TARGET_SEARCH_DT, (UnitDouble)this.d_gotoOccSearchDt.getValue());
        }
    }

    private static abstract class EditorPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;

        private EditorPanel() {
        }

        public abstract void load(SimParams var1);

        public abstract void store(SimParams var1);
    }
}

