/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.value;

import inferno.sim.occsource.AUCOccSourceFlowrate;
import inferno.sim.occsource.IOccSourceFlowrate;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import merlin.Intl;
import merlin.data.property.Function1dProp;
import merlin.data.value.ConstFunction1d;
import merlin.data.value.IFunction1d;
import merlin.data.value.ImpulseFunction1d;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.PlotData;

public class PiecewiseFunction1d
implements IFunction1d,
Serializable {
    static final long serialVersionUID = 1L;
    public final Entry[] entries;

    public PiecewiseFunction1d(Entry ... entries) {
        this.entries = entries;
    }

    public static PiecewiseFunction1d newFunction(Unit xType, Unit yType, double ... entries) {
        assert (entries.length % 2 == 0);
        Entry[] oentries = new Entry[entries.length / 2];
        int m = 0;
        while (m < entries.length) {
            int ix = m / 2;
            double x = entries[m++];
            double y = entries[m++];
            oentries[ix] = new Entry(new UnitDouble(x, xType), new UnitDouble(y, yType));
        }
        return new PiecewiseFunction1d(oentries);
    }

    public static PiecewiseFunction1d newFunction(Unit xType, Unit yType, List<Double> entries) {
        assert (entries.size() % 2 == 0);
        Entry[] oentries = new Entry[entries.size() / 2];
        int m = 0;
        while (m < entries.size()) {
            int ix = m / 2;
            double x = entries.get(m++);
            double y = entries.get(m++);
            oentries[ix] = new Entry(new UnitDouble(x, xType), new UnitDouble(y, yType));
        }
        return new PiecewiseFunction1d(oentries);
    }

    public static PiecewiseFunction1d newFunction(UnitDouble ... entries) {
        assert (entries.length % 2 == 0);
        Entry[] oentries = new Entry[entries.length / 2];
        int m = 0;
        while (m < entries.length) {
            int ix = m / 2;
            UnitDouble x = entries[m++];
            UnitDouble y = entries[m++];
            oentries[ix] = new Entry(x, y);
        }
        return new PiecewiseFunction1d(oentries);
    }

    public static PiecewiseFunction1d newFunction(PlotData data) {
        return PiecewiseFunction1d.newFunction(data.ux, data.uy, data.xyValues);
    }

    @Override
    public PiecewiseFunction1d toPiecewise(Function1dProp prop) {
        return this;
    }

    @Override
    public ConstFunction1d toConstant(Function1dProp prop) {
        return new ConstFunction1d(this.entries[0].y);
    }

    @Override
    public ImpulseFunction1d toImpulse(Function1dProp prop) {
        Unit yUnit = SIUS.unit(prop.y.unitType);
        return new ImpulseFunction1d(new UnitDouble(0.0, yUnit), Collections.emptyList());
    }

    public int hashCode() {
        return 0x923498F ^ Arrays.hashCode(this.entries);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof PiecewiseFunction1d && Arrays.equals(((PiecewiseFunction1d)obj).entries, this.entries);
    }

    @Override
    public inferno.data2.value.PiecewiseFunction1d toInfernoFunction(Unit xUnit, Unit yUnit) {
        PiecewiseFunction1d mfunc = this;
        double[] x = new double[mfunc.entries.length];
        double[] y = new double[mfunc.entries.length];
        for (int m = 0; m < mfunc.entries.length; ++m) {
            x[m] = mfunc.entries[m].x.get(xUnit);
            y[m] = mfunc.entries[m].y.get(yUnit);
        }
        return new inferno.data2.value.PiecewiseFunction1d(x, y, false);
    }

    @Override
    public IOccSourceFlowrate toInfernoOccSourceFlowrate(long occSourceSeed) {
        return new AUCOccSourceFlowrate(this.toInfernoFunction(SI.SECOND, Unit.ONE.divide(SI.SECOND)));
    }

    @Override
    public String format(UnaryOperator<Unit> getDisplayUnit) {
        return Intl.intl("From Table");
    }

    public static class Entry
    implements Serializable,
    Comparable<Entry> {
        static final long serialVersionUID = 1L;
        public final UnitDouble x;
        public final UnitDouble y;

        public Entry(UnitDouble x, UnitDouble y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Entry && ((Entry)obj).x.equals(this.x) && ((Entry)obj).y.equals(this.y);
        }

        public int hashCode() {
            return 0x73F213A8 ^ Objects.hash(this.x, this.y);
        }

        @Override
        public int compareTo(Entry o) {
            return this.x.compareTo(o.x);
        }
    }
}

