/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.value;

import inferno.sim.occsource.IOccSourceFlowrate;
import java.util.ArrayList;
import java.util.function.UnaryOperator;
import merlin.data.property.Function1dProp;
import merlin.data.value.ConstFunction1d;
import merlin.data.value.ImpulseFunction1d;
import merlin.data.value.PiecewiseFunction1d;
import merlin.data.value.RandomizedImpulseFunction1d;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;

public interface IFunction1d {
    public PiecewiseFunction1d toPiecewise(Function1dProp var1);

    public ConstFunction1d toConstant(Function1dProp var1);

    public ImpulseFunction1d toImpulse(Function1dProp var1);

    default public RandomizedImpulseFunction1d toRandomizedImpulse(Function1dProp prop) {
        ImpulseFunction1d impulse = this.toImpulse(prop);
        ArrayList<RandomizedImpulseFunction1d.Interval> intervals = new ArrayList<RandomizedImpulseFunction1d.Interval>(impulse.entries.size());
        for (ImpulseFunction1d.Pulse pulse : impulse.entries) {
            intervals.add(new RandomizedImpulseFunction1d.Interval(pulse.x, pulse.duration, pulse.y));
        }
        return new RandomizedImpulseFunction1d(RandomizedImpulseFunction1d.Distribution.UNIFORM, intervals);
    }

    public String format(UnaryOperator<Unit> var1);

    public inferno.data2.value.IFunction1d toInfernoFunction(Unit var1, Unit var2);

    public IOccSourceFlowrate toInfernoOccSourceFlowrate(long var1);

    default public UnitDouble integrate(Function1dProp fprop, UnitDouble xmin, UnitDouble xmax) {
        Unit xUnit = SIUS.unit(fprop.x.unitType);
        Unit yUnit = SIUS.unit(fprop.y.unitType);
        return this.integrate(xUnit, yUnit, xmin, xmax);
    }

    default public UnitDouble integrate(Unit xUnit, Unit yUnit, UnitDouble xmin, UnitDouble xmax) {
        Unit resultUnit = yUnit.multiply(xUnit);
        inferno.data2.value.IFunction1d ifunc = this.toInfernoFunction(xUnit, yUnit);
        if (ifunc == null) {
            return new UnitDouble(0.0, resultUnit);
        }
        double result = ifunc.getAUC(xmin.get(xUnit), xmax.get(xUnit));
        return new UnitDouble(result, resultUnit);
    }

    default public int getMaxNumOccs(long occSourceSeed, UnitDouble maxTime) {
        IOccSourceFlowrate fr = this.toInfernoOccSourceFlowrate(occSourceSeed);
        return fr.getMaxCount(maxTime.get(SI.SECOND));
    }
}

