/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.tag;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.agents.ProfileProps;
import merlin.data.property.PropertyDefs;
import merlin.data.tag.Tag;
import merlin.data.tag.TagsComp;
import merlin.util.Dependencies;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.framework.UndoFramework;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypedProp;

public class TagsUtil {
    public static Set<String> tagsAsStrings(Set<Tag> tags) {
        return tags.stream().map(tag -> tag.getName()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Tag> getExistingTags(Set<String> tagIds, MerlinData md, Consumer<String> unconverted) {
        return TagsUtil.getTagsCustom(tagIds, md, (existingTags, lowTagStr) -> {
            Tag existing = (Tag)existingTags.get(lowTagStr);
            if (existing == null) {
                unconverted.accept((String)lowTagStr);
            }
            return existing;
        });
    }

    public static Set<Tag> getOrCreateTags(Set<String> tagIds, MerlinData md) {
        LinkedIdentityHashSet newTags = new LinkedIdentityHashSet();
        Set<Tag> result = TagsUtil.getTagsCustom(tagIds, md, (existingTags, lowTagStr) -> {
            if (existingTags.containsKey(lowTagStr)) {
                return (Tag)existingTags.get(lowTagStr);
            }
            Tag newTag = new Tag((String)lowTagStr);
            newTags.add(newTag);
            return newTag;
        });
        if (!newTags.isEmpty()) {
            Undo undo = Undo.global();
            Objects.requireNonNull(undo);
            UndoFramework.InsertOp op = new UndoFramework.InsertOp((UndoFramework)undo, (IDomainObject)md.tags, newTags, md.tags.getMembers().size());
            Undo.insertEntry(md, op.perform());
        }
        return result;
    }

    private static Set<Tag> getTagsCustom(Set<String> tagIds, MerlinData md, BiFunction<Map<String, Tag>, String, Tag> convertTag) {
        TagsComp root = md.tags;
        Map<String, Tag> existingTags = root.flatten(Tag.class).stream().collect(Collectors.toMap(tag -> tag.getName().toLowerCase(), tag -> tag));
        return tagIds.stream().map(String::toLowerCase).map(stag -> (Tag)convertTag.apply(existingTags, (String)stag)).filter(tag -> tag != null).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static <T extends IMerlinObj> DepCallback<MerlinData, T, Set<Tag>, Tag> getTagCallback(TypedProp<Set<Tag>> tagsProp) {
        return Dependencies.newDependencyInSet(tagsProp, DLink.WEAK, Tag.class, Predicates.alwaysTrue());
    }

    public static <SrcT extends IMerlinObj> ProfileProps.UnaryProp<Set<Tag>> newTagsProp(PropertyDefs<SrcT> set) {
        return TagsUtil.buildTagsProp(set).attrFinish();
    }

    public static <SrcT extends IMerlinObj> PropertyDefsFramework.AttributeBuilder<Set<Tag>, ProfileProps.UnaryProp<Set<Tag>>> buildTagsProp(PropertyDefs<SrcT> set) {
        return set.storeAsPlainOldData(MerlinData.TAGS).attrDependency(prop -> TagsUtil.getTagCallback(prop));
    }
}

