/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.scenario;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.montecarlo.MonteCarlo;
import merlin.data.property.PropertyDefs;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioRoot;
import merlin.data.scenario.SimOutputDir;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.framework.property.CompositeProp;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ScenarioUtil {
    public static final Comparator<IDisplayProp<?>> PROP_SORTER = (o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
    public static final Comparator<Scenario> SCENARIO_SORTER = (o1, o2) -> {
        if (o1.isDefault()) {
            return -1;
        }
        if (o2.isDefault()) {
            return 1;
        }
        String n1 = (String)o1.get(Scenario.NAME);
        String n2 = (String)o2.get(Scenario.NAME);
        return n1.compareToIgnoreCase(n2);
    };

    public static List<IDisplayProp<?>> sortAvailableDisplayProps(Set<IDisplayProp<?>> props) {
        ArrayList allProps = new ArrayList(props);
        allProps.sort(PROP_SORTER);
        return allProps;
    }

    public static List<IDisplayProp<?>> getSortedAvailableDisplayProps(IMerlinObj obj) {
        return ScenarioUtil.sortAvailableDisplayProps(ScenarioUtil.getSupportedScenarioProps(obj, PropertyDefs.ScenarioProps.DISPLAY));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isLabelActiveOverride(MerlinData md, IMerlinObj obj, Object prop) {
        IMerlinObj iMerlinObj;
        boolean locallyOverriden;
        Scenario active = md.scenarios.getActive();
        if (active.isDefault()) return false;
        if (obj == null) {
            return false;
        }
        if (active.isOverridden(obj, prop)) return true;
        if (prop instanceof CompositeProp) {
            CompositeProp cprop = (CompositeProp)prop;
            if (cprop.props.stream().anyMatch(wrappedProp -> ScenarioUtil.isLabelActiveOverride(md, obj, wrappedProp))) {
                return true;
            }
        }
        boolean bl = locallyOverriden = false;
        if (locallyOverriden) {
            return true;
        }
        if (!obj.isComposite()) return false;
        Iterator<? extends IMerlinObj> iterator = obj.getChildren().iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!ScenarioUtil.isLabelActiveOverride(md, iMerlinObj = iterator.next(), prop));
        return true;
    }

    public static boolean isLabelActiveOverride(MerlinData md, Collection<? extends IMerlinObj> objs, Collection<?> props) {
        if (md.scenarios.getActive().isDefault()) {
            return false;
        }
        for (IMerlinObj obj : MerlinUtil.flatten(objs, IMerlinObj.class)) {
            if (!ScenarioUtil.getScenariosSupported(obj)) continue;
            for (Object prop : props) {
                if (!ScenarioUtil.isLabelActiveOverride(md, obj, prop)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMixedOverrides(MixedOverrideState state, Collection<Object> props) {
        if (props == null) {
            return false;
        }
        return !state.mixed().isEmpty() && ScenarioUtil.toStorage(props.stream().filter(p -> p instanceof IDisplayProp).map(p -> (IDisplayProp)p)).anyMatch(p -> state.mixed().contains(p));
    }

    private static Map<Object, CompositeProp> getWrappedProps(Collection<? extends IDisplayProp<?>> supportedDisplayProps) {
        LinkedHashMap<Object, CompositeProp> wrappedProps = new LinkedHashMap<Object, CompositeProp>();
        ArrayDeque propStack = new ArrayDeque(supportedDisplayProps);
        while (!propStack.isEmpty()) {
            Object prop = propStack.removeFirst();
            if (!(prop instanceof CompositeProp)) continue;
            CompositeProp cprop = (CompositeProp)prop;
            cprop.props.forEach(wrapped -> wrappedProps.put(wrapped, cprop));
            propStack.addAll(cprop.props);
        }
        return wrappedProps;
    }

    public static Stream<? extends IDisplayProp<?>> toStorage(Stream<? extends IDisplayProp<?>> stream) {
        return stream.flatMap(prop -> {
            Stream<IDisplayProp> stream;
            if (prop instanceof CompositeProp) {
                CompositeProp cprop = (CompositeProp)prop;
                stream = ScenarioUtil.toStorage(cprop.props.stream());
            } else {
                stream = Stream.of(prop);
            }
            return stream;
        });
    }

    public static Set<IDisplayProp<?>> toStorage(Collection<? extends IDisplayProp<?>> objs) {
        return ScenarioUtil.toStorage(objs.stream()).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    public static Set<IDisplayProp<?>> getSupportedScenarioProps(IMerlinObj obj, PropertyDefs.ScenarioProps filter) {
        return obj.getSupportedScenarioProps(filter);
    }

    public static boolean getScenariosSupported(Object obj) {
        IMerlinObj celem;
        return obj instanceof IMerlinObj && ScenarioUtil.getScenariosSupported(celem = (IMerlinObj)obj);
    }

    public static boolean getScenariosSupported(IMerlinObj obj) {
        return obj.getScenariosSupported();
    }

    public static Optional<IDisplayProp<?>> asScenarioProp(Object prop) {
        IDisplayProp nprop;
        return prop instanceof IDisplayProp && (nprop = (IDisplayProp)prop).testMarker(MerlinData.SCENARIO_MARKER) ? Optional.of(nprop) : Optional.empty();
    }

    public static Set<IDisplayProp<?>> getSupportedScenarioProps(Collection<? extends IMerlinObj> objs, PropertyDefs.ScenarioProps filter) {
        Collection<IMerlinObj> flattenedObjs = MerlinUtil.flatten(objs, IMerlinObj.class);
        return flattenedObjs.stream().flatMap(obj -> ScenarioUtil.getSupportedScenarioProps(obj, filter).stream()).collect(Collectors.toSet());
    }

    public static MixedOverrideState getScenarioOverrideState(Scenario scenario, Collection<? extends IMerlinObj> objs) {
        if (scenario.isDefault()) {
            return MixedOverrideState.EMPTY;
        }
        LinkedIdentityHashSet overriddenProps = new LinkedIdentityHashSet();
        LinkedIdentityHashSet nonOverriddenProps = new LinkedIdentityHashSet();
        for (IMerlinObj obj : MerlinUtil.flatten(objs, IMerlinObj.class)) {
            for (IDisplayProp<?> prop : ScenarioUtil.getSupportedScenarioProps(obj, PropertyDefs.ScenarioProps.STORAGE)) {
                if (scenario.isOverridden(obj, prop)) {
                    overriddenProps.add(prop);
                    continue;
                }
                nonOverriddenProps.add(prop);
            }
        }
        LinkedIdentityHashSet alwaysOverriddenProps = new LinkedIdentityHashSet(overriddenProps);
        alwaysOverriddenProps.removeAll(nonOverriddenProps);
        LinkedIdentityHashSet mixedProps = new LinkedIdentityHashSet(nonOverriddenProps);
        mixedProps.retainAll(overriddenProps);
        return new MixedOverrideState(alwaysOverriddenProps, mixedProps);
    }

    public static Set<? extends IDisplayProp<?>> getRelatedStorageProps(Collection<? extends IMerlinObj> objs, Collection<? extends IDisplayProp<?>> storageProps) {
        IdentityHashMap allWrappedProps = new IdentityHashMap();
        for (IMerlinObj obj : MerlinUtil.flatten(objs, IMerlinObj.class)) {
            Set<IDisplayProp<?>> dispProps = ScenarioUtil.getSupportedScenarioProps(obj, PropertyDefs.ScenarioProps.DISPLAY);
            Map<Object, CompositeProp> wrappedProps = ScenarioUtil.getWrappedProps(dispProps);
            for (Map.Entry<Object, CompositeProp> entry : wrappedProps.entrySet()) {
                allWrappedProps.computeIfAbsent(entry.getKey(), k -> new ArrayList()).add(entry.getValue());
            }
        }
        LinkedIdentityHashSet result = new LinkedIdentityHashSet();
        IdentityHashSet visitedComposites = new IdentityHashSet();
        for (IDisplayProp<?> prop : storageProps) {
            List wrappers = (List)allWrappedProps.get(prop);
            if (wrappers == null) {
                result.add(prop);
                continue;
            }
            ArrayDeque open = new ArrayDeque(wrappers);
            while (!open.isEmpty()) {
                CompositeProp cprop = (CompositeProp)open.removeFirst();
                List parents = allWrappedProps.getOrDefault(cprop, List.of());
                if (parents.isEmpty()) {
                    if (!visitedComposites.add(cprop)) continue;
                    ScenarioUtil.toStorage(Stream.of(cprop)).forEach(result::add);
                    continue;
                }
                open.addAll(parents);
            }
        }
        return result;
    }

    public static void applyScenarioOverrideState(MerlinData md, Scenario scenario, Collection<? extends IMerlinObj> objs, MixedOverrideState storageState) {
        if (scenario.isDefault()) {
            return;
        }
        try (MerlinData.WriteLock lock = md.lockWrite();){
            Collection<IMerlinObj> modObjs = MerlinUtil.flatten(objs, IMerlinObj.class);
            ArrayList<Pair<IMerlinObj, Set>> modVals = new ArrayList<Pair<IMerlinObj, Set>>(modObjs.size());
            for (IMerlinObj obj : modObjs) {
                Set<IDisplayProp<?>> supportedOverrides = ScenarioUtil.getSupportedScenarioProps(obj, PropertyDefs.ScenarioProps.STORAGE);
                Set newScenarioOverrides = Stream.concat(md.scenarios.streamActiveOverrides(obj).filter(prop -> storageState.mixed().contains(prop)), storageState.overrides().stream().filter(supportedOverrides::contains)).collect(Collectors.toCollection(LinkedIdentityHashSet::new));
                LinkedIdentityHashSet existingOverrides = scenario.streamCustomProps(obj).collect(Collectors.toCollection(LinkedIdentityHashSet::new));
                if (existingOverrides.equals(newScenarioOverrides)) continue;
                modVals.add(new Pair<IMerlinObj, Set>(obj, newScenarioOverrides));
            }
            if (modVals.isEmpty()) {
                return;
            }
            List<String> categoryNames = theUtil.map(modVals, p -> EntryPointFactory.get((IMerlinObj)p.v1).getCategoryName(md, (IMerlinObj)p.v1));
            String actionName = theUtil.isUniform(categoryNames) ? String.format(Intl.intl("Edit Scenario Setup for %s"), categoryNames.iterator().next()) : Intl.intl("Edit Scenario Setup");
            Undo.begin(actionName);
            modVals.stream().forEach(p -> md.scenarios.setOverrides(md, (IMerlinObj)p.v1, Map.of(scenario, (Set)p.v2)));
            Undo.end(md);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TError extends Throwable, TError2 extends Throwable> void forEachScenarioActivated(MerlinData md, Collection<Scenario> scenarios, boolean updateTopology, ScenarioConsumer<TError, TError2> consumer) throws TError, TError2 {
        Scenario previouslyActive;
        try (MerlinData.ReadLock lock = md.lockRead();){
            previouslyActive = md.scenarios.getActive();
        }
        try {
            int i = 0;
            for (Scenario scenario : scenarios) {
                md.ui(() -> {
                    try (MerlinData.WriteLock lock = md.lockWrite();){
                        md.scenarios.setActive(scenario);
                        if (updateTopology) {
                            md.updateTopology();
                        }
                    }
                });
                if (!consumer.accept(scenario, i, scenarios.size(), scenario == previouslyActive)) {
                    break;
                }
                ++i;
            }
        }
        finally {
            md.ui(() -> {
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    md.scenarios.setActive(previouslyActive);
                    if (updateTopology) {
                        md.updateTopology();
                    }
                }
            });
        }
    }

    public static String scenarioDirectoryName(String scenarioName) {
        return FilenameManager.formatFilename(scenarioName);
    }

    public static Predicate<String> getValidScenarioNamePredicate() {
        return name -> FilenameManager.formatFilename(name).equals(name) && !name.equals(FilenameManager.formatFilename(Scenario.DEFAULT_NAME));
    }

    public static SimOutputDir getOutputDir(String pthFileName, String scenarioName, int scenariosInModel, int variationIndex, int variationCount) throws IOException {
        return new SimOutputDir(pthFileName, scenarioName.trim(), scenariosInModel, variationIndex, variationCount);
    }

    public static SimOutputDir getOutputDir(MerlinData md, Scenario scenario, int variationIndex) throws IOException {
        return new SimOutputDir(md.filename, scenario.getName().trim(), md.scenarios.flatten(Scenario.class).size(), variationIndex, ScenarioUtil.getVariationCount(md, scenario));
    }

    public static String formatScenarioAndVariation(String scenario, int variationIndex, int variationCount) {
        if (variationCount <= 1) {
            return scenario;
        }
        return String.format(Intl.intl("%1$s - Variation %2$d"), scenario, variationIndex + 1);
    }

    public static int getVariationCount(MerlinData md, Scenario scenario) {
        return (Integer)md.scenarios.getScenarioValue(scenario, md.monteCarlo, MonteCarlo.VARIATION_COUNT).orElseGet(() -> new ScenarioRoot.ScenarioValue<Integer>(false, (Integer)MonteCarlo.VARIATION_COUNT.defVal)).value();
    }

    public static Stream<ScenarioVariationKey> streamVariations(MerlinData md) {
        return ScenarioUtil.streamVariations(md, md.scenarios.flatten(Scenario.class));
    }

    public static Stream<ScenarioVariationKey> streamVariations(MerlinData md, Collection<Scenario> scenarios) {
        return scenarios.stream().sorted(SCENARIO_SORTER).flatMap(scenario -> {
            int variationCount = ScenarioUtil.getVariationCount(md, scenario);
            return IntStream.range(0, variationCount).mapToObj(variationIndex -> new ScenarioVariationKey((Scenario)scenario, variationIndex, variationCount));
        });
    }

    public record MixedOverrideState(Set<IDisplayProp<?>> overrides, Set<IDisplayProp<?>> mixed) {
        public static final MixedOverrideState EMPTY = new MixedOverrideState(Collections.emptySet(), Collections.emptySet());

        public MixedOverrideState {
            assert (MixedOverrideState.isSequenced(overrides));
            assert (MixedOverrideState.isSequenced(mixed));
        }

        private static boolean isSequenced(Set<IDisplayProp<?>> set) {
            return set.isEmpty() || set instanceof SequencedSet || set instanceof LinkedIdentityHashSet;
        }

        public MixedOverrideState toDisplay(Collection<? extends IDisplayProp<?>> supportedDisplayProps) {
            Map<Object, CompositeProp> wrappedProps = ScenarioUtil.getWrappedProps(supportedDisplayProps);
            if (wrappedProps.isEmpty()) {
                return this;
            }
            Function<Set, Set> toDisplay = set -> {
                assert (set.stream().filter(prop -> wrappedProps.containsKey(prop)).map(prop -> (CompositeProp)wrappedProps.get(prop)).allMatch(cprop -> set.containsAll(cprop.props)));
                return set.stream().map(prop -> {
                    CompositeProp cprop = (CompositeProp)wrappedProps.get(prop);
                    return cprop != null ? cprop : prop;
                }).collect(Collectors.toCollection(() -> new LinkedIdentityHashSet()));
            };
            return new MixedOverrideState(toDisplay.apply(this.overrides), toDisplay.apply(this.mixed));
        }

        public MixedOverrideState toStorage() {
            return new MixedOverrideState(ScenarioUtil.toStorage(this.overrides), ScenarioUtil.toStorage(this.mixed));
        }
    }

    @FunctionalInterface
    public static interface ScenarioConsumer<TError extends Throwable, TError2 extends Throwable> {
        public boolean accept(Scenario var1, int var2, int var3, boolean var4) throws TError, TError2;
    }

    public record ScenarioVariationKey(Scenario scenario, int variationIndex, int variationCount) {
        @Override
        public int hashCode() {
            return Objects.hash(this.scenario.getName(), this.variationIndex);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof ScenarioVariationKey) {
                ScenarioVariationKey key = (ScenarioVariationKey)other;
                return this.scenario == key.scenario && this.variationIndex == key.variationIndex;
            }
            return false;
        }

        @Override
        public String toString() {
            return ScenarioUtil.formatScenarioAndVariation(this.scenario.getName(), this.variationIndex, this.variationCount);
        }
    }
}

