/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.scenario;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import merlin.Intl;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.egress.scripting.ChangeProfileProp;
import merlin.data.property.DisplayProps;
import merlin.data.property.PropertyDefs;
import merlin.data.scenario.ScenarioUtil;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepCallback;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.gui.ColorIcon;
import thunderheadeng.gui.framework.UndoFramework;
import thunderheadeng.gui.framework.property.DisplayProp;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropValue;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;
import thunderheadeng.util.theUtil;

public class Scenario
extends NamedMerlinObj
implements ICyclicSurrogate,
IDirectDependent<MerlinData> {
    private static final long serialVersionUID = 1L;
    public static final PropertyDefs<Scenario> PROPS = PropertyDefs.defsInheritPropsOnly(Scenario.class, PropertyDefs.legacy(null), NamedMerlinObj.PROPS);
    public static final String DEFAULT_NAME = Intl.intl("Default");
    public static final int BAR_HEIGHT = 16;
    public static final int BAR_WIDTH = 4;
    static final TypedProp<Boolean> IS_DEFAULT = TypedProps.build((Object)"Scenario.IS_DEFAULT", false).attrStoreAsPlainOldData(PROPS).attrGetter(obj -> obj.d_isDefault, Stream.empty()).attrSetter((prop, obj, val) -> {
        if (obj.d_isDefault == val) {
            return;
        }
        obj.d_isDefault = val;
        obj.changedEvt(prop);
    }, null).attrCloneValue((obj, val) -> false).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<String> DESCRIPTION = (DisplayProp)DisplayProps.build((Object)"DESCRIPTION", "", Intl.intl("Description"), "").attrStoreAsPlainOldData(PROPS).attrGetter(Scenario::getDescription, Stream.empty()).attrSetter(Scenario::setDescription, null).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Color> PROP_COLOR = (DisplayProp)DisplayProps.build((Object)"Scenario.COLOR", Color.class, Color.ORANGE, Intl.intl("Color"), "").attrStoreAsPlainOldData(PROPS).attrGetter(Scenario::getColor, Stream.empty()).attrSetter(Scenario::setColor, null).attrSurrogateEquals(null).attrFinish();
    public static final DisplayProp<Color> SEARCH_COLOR = PROPS.storeAsReadOnly(MerlinData.SEARCH_COLOR).attrGetter(service -> service.get(PROP_COLOR), PROP_COLOR).attrFinish();
    static final TypedProp<Map<IMerlinObj, Map<Object, Object>>> OBJ_VALUES = TypedProps.build("OBJ_VALUES", theUtil.makeGeneric(Map.class), Collections.emptyMap()).attrStoreAsMutable(PROPS).attrCloneValue((obj, value) -> {
        if (obj.d_isDefault) {
            return new LinkedIdentityHashMap();
        }
        return Scenario.cloneObjValues(value);
    }).attrRestoreValue((obj, value) -> Scenario.cloneObjValues(value)).attrGetter(obj -> obj.d_objValues, Stream.empty()).attrSetter((prop, obj, values) -> {
        if (obj.d_objValues.equals(values)) {
            return;
        }
        obj.d_objValues = values;
        obj.changedEvt(prop);
    }, (prop, obj, values) -> {
        obj.d_objValues = values;
    }).attrDependency(prop -> Scenario.createObjValuesDepCallback()).attrSurrogateEquals(null).attrFinish();
    private boolean d_isDefault = false;
    private String d_description = "";
    private Color d_color = Color.ORANGE;
    @SkipDep
    private Map<IMerlinObj, Map<Object, Object>> d_objValues = new LinkedIdentityHashMap<IMerlinObj, Map<Object, Object>>();

    private static DepCallback<MerlinData, Scenario, Map<IMerlinObj, Map<Object, Object>>, IMerlinObj> createObjValuesDepCallback() {
        return new DepCallback<MerlinData, Scenario, Map<IMerlinObj, Map<Object, Object>>, IMerlinObj>(DLink.WEAK, IMerlinObj.class, (md, scenario, val) -> val.keySet().stream(), (Predicate)null, new DepCallback.IReplaceDep<MerlinData, Scenario, Map<IMerlinObj, Map<Object, Object>>, IMerlinObj>(){

            @Override
            public Map<IMerlinObj, Map<Object, Object>> get(MerlinData mediator, Scenario src) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void insertUndoEntry(MerlinData mediator, Scenario src, IMerlinObj ref) {
                Map prevVals = src.d_objValues.getOrDefault(ref, Collections.emptyMap());
                if (prevVals.isEmpty()) {
                    assert (false);
                    return;
                }
                Runnable undo = () -> {
                    src.d_objValues.put(ref, prevVals);
                    src.changedEvt(OBJ_VALUES);
                };
                Runnable redo = () -> src.clearObjValues(ref);
                Undo.insertEntry(mediator, new Undo.CustomOp(undo, redo));
            }

            @Override
            public void set(MerlinData mediator, Scenario src, Map<IMerlinObj, Map<Object, Object>> val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Map<IMerlinObj, Map<Object, Object>> replace(MerlinData md, Scenario src, Map<IMerlinObj, Map<Object, Object>> val, IMerlinObj old, IMerlinObj replacement) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void replaceDependency(MerlinData md, Scenario src, IMerlinObj old, IMerlinObj replacement) {
                src.clearObjValues(old);
            }
        });
    }

    protected Scenario() {
        this(DEFAULT_NAME);
        this.d_isDefault = true;
        this.d_color = Color.DARK_GRAY;
    }

    public Scenario(String name) {
        super(name.trim());
        this.d_color = theUtil.newMidrangeColor();
    }

    public Icon newDecaratorIcon() {
        return this.isDefault() ? new ColorIcon(new Color(0, 0, 0, 0), 4, 16, 0) : new ColorIcon(this.getColor(), 4, 16, 0);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        if (!this.isDefault() && this.d_color == null) {
            this.d_color = theUtil.newMidrangeColor();
        }
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0177)) {
            Object prevKey = Scenario.key(ChangeProfileProp.getPre177LegacyValueKey());
            this.d_objValues.entrySet().stream().filter(e -> e.getKey() instanceof ChangeProfileProp && ((Map)e.getValue()).containsKey(prevKey)).map(e -> new Pair<ChangeProfileProp, Map>((ChangeProfileProp)e.getKey(), (Map)e.getValue())).forEach(e -> {
                Object prevVal = ((Map)e.v2).remove(prevKey);
                Object newKey = Scenario.key(((ChangeProfileProp)e.v1).getProp());
                ((Map)e.v2).put(newKey, prevVal);
            });
            Collection<IDisplayProp<?>> desiredOrder = EgressBlockage.COMP_DISPLAY_PROP.props;
            LinkedHashMap<Object, Integer> desiredOrderMap = new LinkedHashMap<Object, Integer>();
            for (IDisplayProp<?> prop : desiredOrder) {
                desiredOrderMap.put(Scenario.key(prop.asProp()), desiredOrderMap.size());
            }
            this.d_objValues.entrySet().stream().filter(e -> e.getKey() instanceof EgressBlockage).map(e -> new Pair<EgressBlockage, Map>((EgressBlockage)e.getKey(), (Map)e.getValue())).forEach(e -> {
                List entries = ((Map)e.v2).entrySet().stream().map(e2 -> new Pair(e2.getKey(), e2.getValue())).collect(Collectors.toCollection(() -> new ArrayList()));
                entries.sort((e1, e2) -> Integer.compare(desiredOrderMap.getOrDefault(e1.v1, -1), desiredOrderMap.getOrDefault(e2.v1, -1)));
                ((Map)e.v2).clear();
                entries.forEach(p -> ((Map)e.v2).put(p.v1, p.v2));
            });
        }
    }

    private static Object key(IDisplayProp<?> prop) {
        return Scenario.key(prop.asProp());
    }

    private static Object key(TypedProp<?> prop) {
        return prop.key;
    }

    private static Object key(Object prop) {
        Object object;
        if (prop instanceof IDisplayProp) {
            IDisplayProp dprop = (IDisplayProp)prop;
            object = Scenario.key(dprop);
        } else if (prop instanceof TypedProp) {
            TypedProp tprop = (TypedProp)prop;
            object = Scenario.key(tprop);
        } else {
            object = prop;
        }
        return object;
    }

    @Override
    public Scenario clone() {
        return (Scenario)super.clone();
    }

    static Map<IMerlinObj, Map<Object, Object>> cloneObjValues(Map<IMerlinObj, Map<Object, Object>> values) {
        LinkedIdentityHashMap<IMerlinObj, Map<Object, Object>> newValues = new LinkedIdentityHashMap<IMerlinObj, Map<Object, Object>>(values);
        newValues.replaceAll((key, map) -> new LinkedHashMap(map));
        return newValues;
    }

    @Override
    public boolean getScenariosSupported() {
        return false;
    }

    @Override
    public boolean isSetNameSupported() {
        return super.isSetNameSupported() && !this.isDefault();
    }

    protected <T> boolean setObjValue(IMerlinObj obj, IDisplayProp<T> prop, T value) {
        return this.setObjValueImpl(obj, Scenario.key(prop), value);
    }

    private <T> boolean setObjValueImpl(IMerlinObj obj, Object key, T value) {
        Map objVals = this.d_objValues.computeIfAbsent(obj, o -> new LinkedHashMap());
        boolean modified = objVals.isEmpty();
        T old = objVals.put(key, value);
        boolean bl = modified = modified || !Objects.equals(old, value);
        if (modified) {
            this.changedEvt(OBJ_VALUES);
        }
        return modified;
    }

    protected <T> boolean clearObjValue(IMerlinObj obj, IDisplayProp<T> prop) {
        return this.clearObjValues(obj, Collections.singleton(prop));
    }

    protected boolean clearObjValues(IMerlinObj obj, Set<? extends IDisplayProp<?>> props) {
        if (props.isEmpty()) {
            return false;
        }
        Map<Object, Object> objVals = this.d_objValues.get(obj);
        if (objVals == null) {
            return false;
        }
        if (objVals.keySet().removeAll(theUtil.map(props, Scenario::key))) {
            if (objVals.isEmpty()) {
                this.d_objValues.remove(obj);
            }
            this.changedEvt(OBJ_VALUES);
            return true;
        }
        return false;
    }

    protected boolean clearObjValues(IMerlinObj obj) {
        if (this.d_objValues.remove(obj) != null) {
            this.changedEvt(OBJ_VALUES);
            return true;
        }
        return false;
    }

    protected <T> boolean isObjValueDefined(IMerlinObj obj, Object prop) {
        return this.d_objValues.getOrDefault(obj, Collections.emptyMap()).containsKey(Scenario.key(prop));
    }

    public boolean isOverridden(IMerlinObj obj, Object prop) {
        return this.isObjValueDefined(obj, prop);
    }

    public boolean isOverridden(IMerlinObj obj) {
        return this.d_objValues.containsKey(obj);
    }

    public <T> PropValue<T> getObjValue(IMerlinObj obj, IDisplayProp<T> prop) {
        Map<Object, Object> vals = this.d_objValues.get(obj);
        if (vals == null) {
            return PropValue.unsupported();
        }
        Object key = Scenario.key(prop);
        if (vals.containsKey(key)) {
            return PropValue.of(vals.get(key));
        }
        return PropValue.unsupported();
    }

    protected <T> void clearAllObjValues() {
        boolean modified = !this.d_objValues.isEmpty();
        this.d_objValues.clear();
        if (modified) {
            this.changedEvt(OBJ_VALUES);
        }
    }

    public final boolean isDefault() {
        return this.d_isDefault;
    }

    @Override
    public PropertyDefs<? extends IMerlinObj> getAllLocalProperties() {
        return PROPS;
    }

    public void setDescription(String desc) {
        if (this.d_description.equals(desc)) {
            return;
        }
        this.d_description = desc;
        this.changedEvt(DESCRIPTION);
    }

    public String getDescription() {
        return this.d_description;
    }

    public void setColor(Color c) {
        if (this.d_color.equals(c)) {
            return;
        }
        this.d_color = c;
        this.changedEvt(PROP_COLOR);
    }

    public Color getColor() {
        return this.d_color;
    }

    public Set<IMerlinObj> getCustomizedObjects() {
        return Collections.unmodifiableSet(this.d_objValues.keySet());
    }

    public Stream<? extends IDisplayProp<?>> streamCustomProps(IMerlinObj obj) {
        Map vals = this.d_objValues.getOrDefault(obj, Collections.emptyMap());
        if (vals.isEmpty()) {
            return Stream.empty();
        }
        return vals.keySet().stream().map(key -> this.getPropForKey(obj, key)).filter(prop -> prop != null);
    }

    private IDisplayProp<?> getPropForKey(IMerlinObj obj, Object key) {
        TypedProp<?> prop = obj.getAllLocalProperties().getProp(key);
        if (prop == null) {
            return null;
        }
        return ScenarioUtil.asScenarioProp(prop).orElse(null);
    }

    public Stream<CustomizedVal> streamCustomVals(IMerlinObj obj) {
        Map vals = this.d_objValues.getOrDefault(obj, Collections.emptyMap());
        if (vals.isEmpty()) {
            return Stream.empty();
        }
        return vals.entrySet().stream().map(entry -> {
            Object val = entry.getValue();
            IDisplayProp<?> prop = this.getPropForKey(obj, entry.getKey());
            return prop != null ? new CustomizedVal(prop, val) : null;
        }).filter(pair -> pair != null);
    }

    @Override
    public void takeDepSnapshot(DepList<MerlinData> deps) {
        super.takeDepSnapshot(deps);
        for (Map.Entry<IMerlinObj, Map<Object, Object>> entry : this.d_objValues.entrySet()) {
            IMerlinObj obj = entry.getKey();
            Map<Object, Object> values = entry.getValue();
            PropertyDefs<? extends IMerlinObj> props = obj.getAllLocalProperties();
            for (Map.Entry<Object, Object> valEntry : values.entrySet()) {
                Object val = valEntry.getValue();
                IDisplayProp<?> prop = this.getPropForKey(obj, valEntry.getKey());
                if (prop == null) continue;
                props.streamDependencies(obj, prop.asProp()).forEach(dep -> this.takeDepSnapshot(deps, obj, prop, (DepCallback)dep, val));
            }
        }
    }

    private <SrcT extends IMerlinObj, ValT, RefT> void takeDepSnapshot(DepList<MerlinData> deps, SrcT source, IDisplayProp<ValT> prop, DepCallback<MerlinData, SrcT, ValT, RefT> dep, ValT scenarioVal) {
        DepCallback.ReplaceDep<MerlinData, IMerlinObj, Object, Object> replDep = null;
        if (dep.replDep() != null) {
            DepCallback.ReplaceDependencyVal<MerlinData, IMerlinObj, Object, Object> replace = dep.replDep()::replace;
            replDep = new DepCallback.ReplaceDep<MerlinData, IMerlinObj, Object, Object>((md, src) -> {
                PropValue val = this.getObjValue((IMerlinObj)src, prop);
                assert (val.isSupported());
                return val.orElse(null);
            }, (md, src, ref) -> Undo.insertEntry(md, new ScenarioPropRestore<IMerlinObj, Object>(this, (IMerlinObj)src, prop, scenarioVal)), (md, src, newVal) -> this.setObjValue((IMerlinObj)src, prop, (Object)newVal), replace);
        }
        DepCallback<MerlinData, SrcT, ValT, RefT> wrappedDep = new DepCallback<MerlinData, SrcT, ValT, RefT>(dep.link(), dep.refType(), dep.streamRefs(), dep.getReplFilter(), replDep);
        deps.add(source, scenarioVal, wrappedDep);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private record ScenarioPropRestore<SrcT extends IMerlinObj, ValT>(Scenario scenario, SrcT src, IDisplayProp<ValT> prop, ValT restoreVal) implements UndoFramework.UndoOp
    {
        @Override
        public boolean isMajor() {
            return true;
        }

        @Override
        public UndoFramework.UndoOp perform() {
            PropValue<ValT> newRestoreVal = this.scenario.getObjValue((IMerlinObj)this.src, this.prop);
            assert (newRestoreVal.isSupported());
            this.scenario.setObjValue((IMerlinObj)this.src, this.prop, this.restoreVal);
            return new ScenarioPropRestore<SrcT, Object>(this.scenario, this.src, this.prop, newRestoreVal.orElse(this.prop.asProp().defVal));
        }
    }

    public record CustomizedVal<T>(IDisplayProp<T> prop, T val) {
    }
}

