/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.property;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import merlin.MerlinApp;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import thunderheadeng.gui.framework.UndoFramework;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.gui.framework.property.PropertyDefsFramework;
import thunderheadeng.io.TeciLogging;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.theUtil;

public class PropertyDefs<ObjT extends IMerlinObj>
extends PropertyDefsFramework<MerlinData, ObjT> {
    private static final Logger LOGGER = Logger.getLogger(PropertyDefs.class.getSimpleName());
    private static final Callback CALLBACK = new Callback();

    public static <ObjT extends IMerlinObj> PropertyDefs<ObjT> defsRoot(Class<ObjT> objType, PropertyDefsFramework.IStorage<? super ObjT> storage) {
        return new PropertyDefs<ObjT>(objType, storage);
    }

    public static <ObjT extends IMerlinObj> PropertyDefs<ObjT> defsInheritStorageAndProps(Class<ObjT> objType, Consumer<ObjT> initLocalStorage, PropertyDefs<? super ObjT> inherited) {
        return PropertyDefs.defsInheritStorageAndProps(objType, initLocalStorage, inherited, Predicates.alwaysTrue());
    }

    public static <ObjT extends IMerlinObj> PropertyDefs<ObjT> defsInheritStorageAndProps(Class<ObjT> objType, Consumer<ObjT> initLocalStorage, PropertyDefs<? super ObjT> inherited, Predicate<? super TypedProp<?>> inheritedPropFilter) {
        return new PropertyDefs<ObjT>(objType, initLocalStorage, inherited, inheritedPropFilter);
    }

    public static <ObjT extends IMerlinObj> PropertyDefs<ObjT> defsInheritPropsOnly(Class<ObjT> objType, PropertyDefsFramework.IStorage<? super ObjT> storage, PropertyDefs<? super ObjT> inherited) {
        return PropertyDefs.defsInheritPropsOnly(objType, storage, inherited, Predicates.alwaysTrue());
    }

    public static <ObjT extends IMerlinObj> PropertyDefs<ObjT> defsInheritPropsOnly(Class<ObjT> objType, PropertyDefsFramework.IStorage<? super ObjT> storage, PropertyDefs<? super ObjT> inherited, Predicate<? super TypedProp<?>> inheritedFilter) {
        return PropertyDefs.defsInheritPropsOnlyMultiple(objType, storage, List.of(inherited), inheritedFilter);
    }

    public static <ObjT extends IMerlinObj> PropertyDefs<ObjT> defsInheritPropsOnlyMultiple(Class<ObjT> objType, PropertyDefsFramework.IStorage<? super ObjT> storage, Collection<PropertyDefs<? super ObjT>> inherited, Predicate<? super TypedProp<?>> inheritedFilter) {
        return new PropertyDefs<ObjT>(objType, storage, inherited, inheritedFilter);
    }

    private PropertyDefs(Class<ObjT> objType, PropertyDefsFramework.IStorage<? super ObjT> storage) {
        super(CALLBACK, objType, storage);
    }

    private PropertyDefs(Class<ObjT> objType, Consumer<ObjT> initLocalStorage, PropertyDefs<? super ObjT> inherited, Predicate<? super TypedProp<?>> inheritedFilter) {
        super(CALLBACK, objType, initLocalStorage, inherited, inheritedFilter);
    }

    private PropertyDefs(Class<ObjT> objType, PropertyDefsFramework.IStorage<? super ObjT> storage, Collection<? extends PropertyDefs<? super ObjT>> inherited, Predicate<? super TypedProp<?>> inheritedFilter) {
        super(CALLBACK, objType, storage, inherited, inheritedFilter);
    }

    public <ValT> PropertyDefs<ObjT> attrDefaults(Class<ValT> valType, Consumer<? super PropertyDefsFramework.DefaultAttributes<ValT>> modify) {
        super.attrDefaults(valType, modify);
        return this;
    }

    public boolean contains(TypedProp<?> prop) {
        return this.has(prop);
    }

    public SequencedSet<IDisplayProp<?>> getScenarioProps(ScenarioProps filter) {
        Class dpClazz = theUtil.makeGeneric(IDisplayProp.class);
        SequencedSet<TypedProp<?>> marked = this.getMarkedProps(MerlinData.SCENARIO_MARKER, filter.markedFilter);
        return theUtil.filter(marked, dpClazz);
    }

    @Override
    public <T, PropT extends TypedProp<T>> boolean isSetSupported(PropT prop) {
        return super.isSetSupported(prop);
    }

    @Override
    public <T, PropT extends TypedProp<T>> PropertyDefsFramework.ICloneValue<ObjT, T> getAttrCloneValue(PropT prop) {
        return super.getAttrCloneValue(prop);
    }

    private static class Callback
    implements PropertyDefsFramework.ICallback<MerlinData, IMerlinObj> {
        private final Map<String, TypedProp<?>> d_scenarioPropNames = new HashMap();
        private final HashSet<UnorderedPair<TypedProp<?>, TypedProp<?>>> d_warnedDuplicateScenarioNames = new HashSet();

        private Callback() {
        }

        @Override
        public Class<IMerlinObj> getObjType() {
            return IMerlinObj.class;
        }

        @Override
        public UndoFramework.UndoOp getUndoRestoreProp(MerlinData md, IMerlinObj obj, Collection<? extends TypedProp<?>> props) {
            return Undo.getRestorePropOp(md, obj, props);
        }

        @Override
        public UndoFramework.UndoOp getUndoRestoreAll(MerlinData md, IMerlinObj obj) {
            return Undo.getRestoreAllOp(md, obj);
        }

        @Override
        public <T> T getObjValue(IMerlinObj obj, TypedProp<T> prop) {
            return obj.get(prop);
        }

        @Override
        public <T> void setObjValue(IMerlinObj obj, TypedProp<T> prop, T value) {
            obj.set(prop, value);
        }

        @Override
        public void propAdded(PropertyDefsFramework<MerlinData, ? extends IMerlinObj> props, TypedProp<?> prop) {
            try {
                Set<Object> markers = props.getMarkers(prop);
                if (markers.contains(MerlinData.SCENARIO_MARKER)) {
                    if (prop instanceof IDisplayProp) {
                        TypedProp<?> prevProp;
                        IDisplayProp dp = (IDisplayProp)((Object)prop);
                        if (MerlinApp.isDev() && (prevProp = this.d_scenarioPropNames.put(dp.getDisplayName(), prop)) != null && prevProp != prop && this.d_warnedDuplicateScenarioNames.add(new UnorderedPair(prevProp, prop))) {
                            LOGGER.log(Level.WARNING, () -> String.format("Property name %1$s is associated with both %2$s and %3$s.", dp.getDisplayName(), prevProp.key, prop.key));
                        }
                    } else assert (false) : String.format("%s: Scenario property <%s> constructed as wrong type. Expected=%s, Found=%s", props, prop.key, IDisplayProp.class.getName(), prop.getClass().getName());
                }
            }
            catch (AssertionError e) {
                throw e;
            }
            catch (Throwable t) {
                TeciLogging.log(LOGGER, t);
            }
        }
    }

    public static enum ScenarioProps {
        ALL(PropertyDefsFramework.Marked.ALL),
        DISPLAY(PropertyDefsFramework.Marked.NON_WRAPPED),
        STORAGE(PropertyDefsFramework.Marked.NON_WRAPPING);

        public final PropertyDefsFramework.Marked markedFilter;

        private ScenarioProps(PropertyDefsFramework.Marked markedFilter) {
            this.markedFilter = markedFilter;
        }
    }
}

