/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.property;

import java.awt.Component;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.data.value.IFunction1d;
import merlin.gui.value.Function1dEditorFactory;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.framework.property.IDisplayProp;
import thunderheadeng.gui.framework.property.IPropComparisonEditorSupplier;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.TypedProp;

public class Function1dProp
extends TypedProp<IFunction1d>
implements IDisplayProp<IFunction1d> {
    public final String desc;
    public final String longDesc;
    public final String displayName;
    public final String groupName;
    public final Integration integration;
    public final Var x;
    public final Var y;
    public PredefFunction[] predef;
    public UnitDouble[] bounds;
    public final EnumSet<Function1dEditorFactory.Type> editorTypes;

    public Function1dProp(Object key, String groupName, IFunction1d defVal, String desc, String longDesc, String displayName, Integration integration, Var x, Var y, EnumSet<Function1dEditorFactory.Type> editorTypes, Set<Object> markers, PredefFunction ... predef) {
        this(key, groupName, defVal, desc, longDesc, displayName, integration, x, y, new UnitDouble[]{null, null, null, null}, editorTypes, markers, predef);
    }

    public Function1dProp(Object key, String groupName, IFunction1d defVal, String desc, String longDesc, String displayName, Integration integration, Var x, Var y, UnitDouble[] bounds, EnumSet<Function1dEditorFactory.Type> editorTypes, Set<Object> markers, PredefFunction ... predef) {
        super(key, IFunction1d.class, defVal, markers);
        this.desc = desc;
        this.groupName = groupName;
        this.longDesc = longDesc;
        this.displayName = displayName;
        this.integration = integration;
        this.x = x;
        this.y = y;
        this.predef = predef;
        this.bounds = bounds;
        this.editorTypes = editorTypes;
    }

    @Override
    public String getGroupDisplayName() {
        return this.groupName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDisplayDesc() {
        return this.longDesc;
    }

    @Override
    public IDisplayProp.ValEditorSupplier<IFunction1d> getValEditorSupplier() {
        return (md, inline) -> Function1dEditorFactory.nullable(this, inline, "", null, () -> (IFunction1d)this.defVal, this.editorTypes);
    }

    @Override
    public String formatValue(Object src, IFunction1d value) {
        if (value == null) {
            return Intl.intl("<undefined>");
        }
        Optional<PredefFunction> pre = Stream.of(this.predef).filter(p -> p.func != null && p.func.equals(value)).findFirst();
        if (pre.isPresent()) {
            return pre.get().shortDesc;
        }
        return value.format(MerlinUtil.getDisplayUnitSupplier(new int[0]));
    }

    public Function1dProp asProp() {
        return this;
    }

    @Override
    public <MedT extends Mediator, ObjT extends IDomainObject<MedT>> IPropComparisonEditorSupplier<MedT, ObjT, IFunction1d> getComparisonEditorSupplier() {
        return null;
    }

    public static class Integration {
        public final String desc;
        public final Function<MerlinData, UnitDouble> getRange;

        public Integration(String desc, Function<MerlinData, UnitDouble> getRange) {
            this.desc = desc;
            this.getRange = getRange;
        }
    }

    public static class Var {
        public final String desc;
        public final String deltaDesc;
        public final int unitType;
        public final Predicate<UnitDouble> filter;

        public Var(String desc, int unitType) {
            this(desc, unitType, Filters.acceptAll());
        }

        public Var(String desc, int unitType, Predicate<UnitDouble> filter) {
            this(desc, desc, unitType, filter);
        }

        public Var(String desc, String deltaDesc, int unitType, Predicate<UnitDouble> filter) {
            this.desc = desc;
            this.deltaDesc = deltaDesc;
            this.unitType = unitType;
            this.filter = filter;
        }
    }

    public static class PredefFunction {
        public final String shortDesc;
        public final String longDesc;
        public final Function<Component, IFunction1d> getFunction;
        public final IFunction1d func;

        public PredefFunction(String shortDesc, String longDesc, Function<Component, IFunction1d> getFunction) {
            this.shortDesc = shortDesc;
            this.longDesc = longDesc;
            this.getFunction = getFunction;
            this.func = null;
        }

        public PredefFunction(String shortDesc, String longDesc, IFunction1d func) {
            this.shortDesc = shortDesc;
            this.longDesc = longDesc;
            this.getFunction = c -> func;
            this.func = func;
        }
    }
}

