/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.montecarlo;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import merlin.data.MerlinData;
import merlin.data.scenario.Scenario;
import merlin.data.scenario.ScenarioUtil;
import merlin.data.scenario.SimOutputDir;

public record SimulationInputList(LinkedHashMap<String, ScenarioDescription> runningScenarios, LinkedHashMap<String, ScenarioDescription> availableScenarios) {
    public SimulationInputList(MerlinData md, Collection<Scenario> scenarios, Path rootDir, Map<ScenarioUtil.ScenarioVariationKey, SimOutputDir> outputDirs) throws IOException {
        this(SimulationInputList.buildDescriptions(md, scenarios, rootDir, outputDirs), SimulationInputList.buildDescriptions(md, md.scenarios.flatten(Scenario.class), rootDir, outputDirs));
    }

    private static LinkedHashMap<String, ScenarioDescription> buildDescriptions(MerlinData md, Collection<Scenario> scenarios, Path rootDir, Map<ScenarioUtil.ScenarioVariationKey, SimOutputDir> outputDirs) throws IOException {
        try {
            ArrayList<Scenario> sortedScenarios = new ArrayList<Scenario>(scenarios);
            sortedScenarios.sort(ScenarioUtil.SCENARIO_SORTER);
            LinkedHashMap<String, ScenarioDescription> scenarioDescriptions = new LinkedHashMap<String, ScenarioDescription>(sortedScenarios.size());
            for (Scenario scenario : sortedScenarios) {
                int variationCount = ScenarioUtil.getVariationCount(md, scenario);
                ArrayList<VariationDescription> variationDescriptions = new ArrayList<VariationDescription>(variationCount);
                for (int i = 0; i < variationCount; ++i) {
                    SimOutputDir outDir = outputDirs.get(new ScenarioUtil.ScenarioVariationKey(scenario, i, variationCount));
                    String inputFile = rootDir.relativize(outDir.current.getEquivalentPthFile()).toString();
                    String resultsFile = rootDir.relativize(outDir.current.getResultsFile()).toString();
                    variationDescriptions.add(new VariationDescription(inputFile, resultsFile));
                }
                scenarioDescriptions.put(scenario.getName(), new ScenarioDescription(variationDescriptions));
            }
            return scenarioDescriptions;
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    public Stream<VariationDescription> streamRunningVariations() {
        return this.runningScenarios.values().stream().flatMap(scenario -> scenario.variations().stream());
    }

    public record VariationDescription(String inputFile, String resultsFile) {
    }

    public record ScenarioDescription(List<VariationDescription> variations) {
    }
}

